/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDeferredTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateScope;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexLinkage;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.index.IIndexBindingConstants;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.index.composite.CompositeScope;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.NamedNodeCollector;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMArrayType;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFileLocalScope;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMPointerType;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMQualifierType;
import org.eclipse.core.runtime.CoreException;

public abstract class PDOMLinkage
extends PDOMNamedNode
implements IIndexLinkage,
IIndexBindingConstants {
    private static final int ID_OFFSET = 12;
    private static final int NEXT_OFFSET = 16;
    private static final int INDEX_OFFSET = 20;
    protected static final int RECORD_SIZE = 24;
    protected static final int LINKAGE = 0;

    public PDOMLinkage(PDOM pdom, int record) {
        super(pdom, record);
    }

    protected PDOMLinkage(PDOM pdom, String languageId, char[] name) throws CoreException {
        super(pdom, null, name);
        Database db = pdom.getDB();
        db.putInt(this.record + 12, db.newString(languageId).getRecord());
        pdom.insertLinkage(this);
    }

    protected int getRecordSize() {
        return 24;
    }

    public int getNodeType() {
        return 0;
    }

    public static IString getId(PDOM pdom, int record) throws CoreException {
        Database db = pdom.getDB();
        int namerec = db.getInt(record + 12);
        return db.getString(namerec);
    }

    public static int getNextLinkageRecord(PDOM pdom, int record) throws CoreException {
        return pdom.getDB().getInt(record + 16);
    }

    public void setNext(int nextrec) throws CoreException {
        this.pdom.getDB().putInt(this.record + 16, nextrec);
    }

    public BTree getIndex() throws CoreException {
        return new BTree(this.pdom.getDB(), this.record + 20, this.getIndexComparator());
    }

    public void accept(final IPDOMVisitor visitor) throws CoreException {
        if (visitor instanceof IBTreeVisitor) {
            this.getIndex().accept((IBTreeVisitor)((Object)visitor));
        } else {
            this.getIndex().accept(new IBTreeVisitor(){

                public int compare(int record) throws CoreException {
                    return 0;
                }

                public boolean visit(int record) throws CoreException {
                    PDOMBinding binding = PDOMLinkage.this.pdom.getBinding(record);
                    if (binding != null) {
                        if (visitor.visit(binding)) {
                            binding.accept(visitor);
                        }
                        visitor.leave(binding);
                    }
                    return true;
                }
            });
        }
    }

    public ILinkage getLinkage() throws CoreException {
        return this;
    }

    public final void addChild(PDOMNode child) throws CoreException {
        this.getIndex().insert(child.getRecord());
    }

    public PDOMNode getNode(int record) throws CoreException {
        switch (PDOMNode.getNodeType(this.pdom, record)) {
            case 1: {
                return new PDOMPointerType(this.pdom, record);
            }
            case 2: {
                return new PDOMArrayType(this.pdom, record);
            }
            case 3: {
                return new PDOMQualifierType(this.pdom, record);
            }
            case 4: {
                return new PDOMFileLocalScope(this.pdom, record);
            }
        }
        return null;
    }

    public PDOMNode addType(PDOMNode parent, IType type) throws CoreException {
        if (type instanceof IPointerType) {
            return new PDOMPointerType(this.pdom, parent, (IPointerType)type);
        }
        if (type instanceof IArrayType) {
            return new PDOMArrayType(this.pdom, parent, (IArrayType)type);
        }
        if (type instanceof IQualifierType) {
            return new PDOMQualifierType(this.pdom, parent, (IQualifierType)type);
        }
        return null;
    }

    public abstract IBTreeComparator getIndexComparator();

    public abstract PDOMBinding addBinding(IASTName var1) throws CoreException;

    public abstract PDOMBinding addBinding(IBinding var1) throws CoreException;

    public abstract PDOMBinding adaptBinding(IBinding var1) throws CoreException;

    public final PDOMBinding resolveBinding(IASTName name) throws CoreException {
        IBinding binding = name.resolveBinding();
        if (binding != null) {
            return this.adaptBinding(binding);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PDOMNode getAdaptedParent(IBinding binding, boolean createFileLocalScope, boolean addParent) throws CoreException {
        try {
            void var4_8;
            Object var4_4 = null;
            if (binding instanceof ICPPTemplateInstance) {
                ICPPTemplateDefinition iCPPTemplateDefinition = ((ICPPTemplateInstance)binding).getTemplateDefinition();
            } else {
                IName name;
                IScope scope = binding.getScope();
                if (scope == null) {
                    IBinding spec;
                    IIndexBinding ib;
                    if (binding instanceof ICPPDeferredTemplateInstance) {
                        ICPPDeferredTemplateInstance deferred = (ICPPDeferredTemplateInstance)binding;
                        ICPPTemplateDefinition template = deferred.getTemplateDefinition();
                        scope = template.getScope();
                    }
                    IIndexBinding iIndexBinding = ib = binding instanceof IIndexBinding ? (IIndexBinding)binding : null;
                    if (ib == null && binding instanceof ICPPSpecialization && (spec = ((ICPPSpecialization)binding).getSpecializedBinding()) instanceof IIndexBinding) {
                        ib = (IIndexBinding)spec;
                    }
                    if (ib == null) return null;
                    if (!ib.isFileLocal()) return this;
                    return null;
                }
                if (scope instanceof IIndexScope) {
                    if (!(scope instanceof CompositeScope)) return this.adaptBinding(((IIndexScope)scope).getScopeBinding());
                    return this.adaptBinding(((CompositeScope)scope).getRawScopeBinding());
                }
                if (scope instanceof ICPPTemplateScope && !(binding instanceof ICPPTemplateParameter) && !(binding instanceof ICPPTemplateInstance) && (scope = scope.getParent()) == null) {
                    return null;
                }
                if (scope instanceof ICPPNamespaceScope && (name = scope.getScopeName()) != null && name.toCharArray().length == 0) {
                    return null;
                }
                IASTNode scopeNode = ASTInternal.getPhysicalNodeOfScope(scope);
                if (scopeNode instanceof IASTCompoundStatement) {
                    return null;
                }
                if (scopeNode instanceof IASTTranslationUnit) {
                    if (!this.isFileLocalBinding(binding)) return this;
                    IASTTranslationUnit tu = (IASTTranslationUnit)scopeNode;
                    return this.findFileLocalScope(tu.getFilePath(), createFileLocalScope);
                }
                if (scope instanceof ICPPClassScope) {
                    ICPPClassType iCPPClassType = ((ICPPClassScope)scope).getClassType();
                } else {
                    IName scopeName = scope.getScopeName();
                    if (scopeName instanceof IASTName) {
                        IBinding iBinding = ((IASTName)scopeName).resolveBinding();
                    }
                }
            }
            if (var4_8 == null) return null;
            if (var4_8 == binding) return null;
            PDOMBinding scopePDOMBinding = null;
            scopePDOMBinding = addParent ? this.addBinding((IBinding)var4_8) : this.adaptBinding((IBinding)var4_8);
            if (scopePDOMBinding == null) return null;
            return scopePDOMBinding;
        }
        catch (DOMException dOMException) {
            throw new CoreException(Util.createStatus(dOMException));
        }
    }

    protected abstract boolean isFileLocalBinding(IBinding var1) throws DOMException;

    public abstract int getBindingType(IBinding var1);

    public void onCreateName(PDOMName pdomName, IASTName name) throws CoreException {
        IASTDeclSpecifier ds;
        IASTNode parentNode = name.getParent();
        if (parentNode instanceof IASTDeclSpecifier && (ds = (IASTDeclSpecifier)parentNode).getStorageClass() == 1 && pdomName.getEnclosingDefinitionRecord() != 0) {
            pdomName.setIsBaseSpecifier(true);
        }
    }

    public void onDeleteName(PDOMName nextName) throws CoreException {
    }

    protected final PDOMFileLocalScope findFileLocalScope(String fileName, boolean create) throws CoreException {
        char[] fname = fileName.toCharArray();
        int fnamestart = PDOMLinkage.findFileNameStart(fname);
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        buf.append(fname, fnamestart, fname.length - fnamestart);
        buf.append(':');
        buf.append(fileName.hashCode());
        buf.append('}');
        fname = buf.toString().toCharArray();
        final PDOMFileLocalScope[] fls = new PDOMFileLocalScope[1];
        NamedNodeCollector collector = new NamedNodeCollector(this, fname){

            public boolean addNode(PDOMNamedNode node) {
                if (node instanceof PDOMFileLocalScope) {
                    fls[0] = (PDOMFileLocalScope)node;
                    return false;
                }
                return true;
            }
        };
        this.getIndex().accept(collector);
        if (fls[0] == null && create) {
            fls[0] = new PDOMFileLocalScope(this.pdom, this, fname);
            this.addChild(fls[0]);
        }
        return fls[0];
    }

    private static int findFileNameStart(char[] fname) {
        int i = fname.length - 2;
        while (i >= 0) {
            switch (fname[i]) {
                case '/': 
                case '\\': {
                    return i + 1;
                }
            }
            --i;
        }
        return 0;
    }
}

