/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCAnnotation;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCFunctionType;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCParameter;
import org.eclipse.core.runtime.CoreException;

class PDOMCFunction
extends PDOMBinding
implements IFunction {
    public static final int NUM_PARAMS = 24;
    public static final int FIRST_PARAM = 28;
    private static final int FUNCTION_TYPE = 32;
    private static final int ANNOTATIONS = 36;
    public static final int RECORD_SIZE = 37;

    public PDOMCFunction(PDOM pdom, PDOMNode parent, IFunction function) throws CoreException {
        super(pdom, parent, function.getNameCharArray());
        try {
            PDOMNode typeNode;
            IFunctionType ft = function.getType();
            if (ft != null && (typeNode = this.getLinkageImpl().addType(this, ft)) != null) {
                pdom.getDB().putInt(this.record + 32, typeNode.getRecord());
            }
            IParameter[] params = function.getParameters();
            pdom.getDB().putInt(this.record + 24, params.length);
            int i = 0;
            while (i < params.length) {
                this.setFirstParameter(new PDOMCParameter(pdom, (PDOMNode)this, params[i]));
                ++i;
            }
            pdom.getDB().putByte(this.record + 36, PDOMCAnnotation.encodeAnnotation(function));
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    public PDOMCParameter getFirstParameter() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 28);
        return rec != 0 ? new PDOMCParameter(this.pdom, rec) : null;
    }

    public void setFirstParameter(PDOMCParameter param) throws CoreException {
        if (param != null) {
            param.setNextParameter(this.getFirstParameter());
        }
        int rec = param != null ? param.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 28, rec);
    }

    public PDOMCFunction(PDOM pdom, int record) {
        super(pdom, record);
    }

    protected int getRecordSize() {
        return 37;
    }

    public int getNodeType() {
        return 6;
    }

    public IFunctionType getType() throws DOMException {
        try {
            int offset = this.pdom.getDB().getInt(this.record + 32);
            return offset == 0 ? null : new PDOMCFunctionType(this.pdom, offset);
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
            return null;
        }
    }

    public boolean isStatic() throws DOMException {
        return this.getBit(this.getByte(this.record + 36), 4);
    }

    public boolean isExtern() throws DOMException {
        return this.getBit(this.getByte(this.record + 36), 1);
    }

    public IParameter[] getParameters() throws DOMException {
        try {
            int n = this.pdom.getDB().getInt(this.record + 24);
            IParameter[] params = new IParameter[n];
            PDOMCParameter param = this.getFirstParameter();
            while (param != null) {
                params[--n] = param;
                param = param.getNextParameter();
            }
            return params;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IParameter[0];
        }
    }

    public boolean isAuto() throws DOMException {
        return false;
    }

    public boolean isRegister() throws DOMException {
        return false;
    }

    public boolean isInline() throws DOMException {
        return this.getBit(this.getByte(this.record + 36), 2);
    }

    public boolean takesVarArgs() throws DOMException {
        return this.getBit(this.getByte(this.record + 36), 5);
    }

    public IScope getFunctionScope() throws DOMException {
        return null;
    }
}

