/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCAnnotation;
import org.eclipse.core.runtime.CoreException;

class PDOMCVariable
extends PDOMBinding
implements IVariable {
    private static final int TYPE_OFFSET = 24;
    private static final int ANNOTATIONS = 28;
    protected static final int RECORD_SIZE = 29;

    public PDOMCVariable(PDOM pdom, PDOMNode parent, IVariable variable) throws CoreException {
        super(pdom, parent, variable.getNameCharArray());
        try {
            Database db = pdom.getDB();
            PDOMNode typeNode = parent.getLinkageImpl().addType(this, variable.getType());
            if (typeNode != null) {
                db.putInt(this.record + 24, typeNode.getRecord());
            }
            pdom.getDB().putByte(this.record + 28, PDOMCAnnotation.encodeAnnotation(variable));
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    public PDOMCVariable(PDOM pdom, int record) {
        super(pdom, record);
    }

    protected int getRecordSize() {
        return 29;
    }

    public int getNodeType() {
        return 5;
    }

    public IType getType() throws DOMException {
        try {
            int typeRec = this.pdom.getDB().getInt(this.record + 24);
            return (IType)((Object)this.getLinkageImpl().getNode(typeRec));
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public boolean isStatic() throws DOMException {
        return this.getBit(this.getByte(this.record + 28), 4);
    }

    public boolean isExtern() throws DOMException {
        return this.getBit(this.getByte(this.record + 28), 1);
    }

    public boolean isAuto() throws DOMException {
        return this.getBit(this.getByte(this.record + 28), 0);
    }

    public boolean isRegister() throws DOMException {
        return this.getBit(this.getByte(this.record + 28), 3);
    }
}

