/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDelegateCreator;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotation;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunction;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPMethod
extends PDOMCPPFunction
implements ICPPMethod,
ICPPDelegateCreator {
    protected static final int ANNOTATION1 = 41;
    protected static final int RECORD_SIZE = 42;
    private static final int CV_OFFSET = 4;

    public PDOMCPPMethod(PDOM pdom, PDOMNode parent, ICPPMethod method) throws CoreException {
        super(pdom, parent, method, true);
        Database db = pdom.getDB();
        try {
            byte annotation = 0;
            annotation = (byte)(annotation | PDOMCPPAnnotation.encodeExtraAnnotation(method));
            db.putByte(this.record + 41, annotation);
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    public PDOMCPPMethod(PDOM pdom, int record) {
        super(pdom, record);
    }

    protected int getRecordSize() {
        return 42;
    }

    public int getNodeType() {
        return 9;
    }

    public boolean isVirtual() throws DOMException {
        return this.getBit(this.getByte(this.record + 41), 0);
    }

    public boolean isDestructor() throws DOMException {
        return this.getBit(this.getByte(this.record + 41), 1);
    }

    public boolean isMutable() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isImplicit() {
        return this.getBit(this.getByte(this.record + 41), 2);
    }

    public IScope getFunctionScope() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isExtern() throws DOMException {
        return false;
    }

    public boolean isAuto() throws DOMException {
        return false;
    }

    public boolean isRegister() throws DOMException {
        return false;
    }

    public int getVisibility() throws DOMException {
        return PDOMCPPAnnotation.getVisibility(this.getByte(this.record + 40));
    }

    public ICPPClassType getClassOwner() throws DOMException {
        try {
            return (ICPPClassType)((Object)this.getParentNode());
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public Object clone() {
        throw new PDOMNotImplementedError();
    }

    public boolean isConst() {
        return this.getBit(this.getByte(this.record + 41), 4);
    }

    public boolean isVolatile() {
        return this.getBit(this.getByte(this.record + 41), 5);
    }

    public ICPPDelegate createDelegate(IASTName name) {
        return new CPPMethod.CPPMethodDelegate(name, this);
    }
}

