/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDelegateCreator;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotation;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPVariable
extends PDOMCPPBinding
implements ICPPVariable,
ICPPDelegateCreator {
    private static final int TYPE_OFFSET = 24;
    protected static final int ANNOTATIONS = 28;
    protected static final int RECORD_SIZE = 29;

    public PDOMCPPVariable(PDOM pdom, PDOMNode parent, ICPPVariable variable) throws CoreException {
        super(pdom, parent, variable.getNameCharArray());
        try {
            Database db = pdom.getDB();
            PDOMNode typeNode = parent.getLinkageImpl().addType(this, variable.getType());
            if (typeNode != null) {
                db.putInt(this.record + 24, typeNode.getRecord());
            }
            db.putByte(this.record + 28, this.encodeFlags(variable));
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    protected byte encodeFlags(ICPPVariable variable) throws DOMException {
        return PDOMCPPAnnotation.encodeAnnotation(variable);
    }

    public PDOMCPPVariable(PDOM pdom, int record) {
        super(pdom, record);
    }

    protected int getRecordSize() {
        return 29;
    }

    public int getNodeType() {
        return 5;
    }

    public boolean isMutable() throws DOMException {
        return false;
    }

    public IType getType() throws DOMException {
        try {
            int typeRec = this.pdom.getDB().getInt(this.record + 24);
            return (IType)((Object)this.getLinkageImpl().getNode(typeRec));
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public boolean isAuto() throws DOMException {
        return this.getBit(this.getByte(this.record + 28), 0);
    }

    public boolean isExtern() throws DOMException {
        return this.getBit(this.getByte(this.record + 28), 1);
    }

    public boolean isRegister() throws DOMException {
        return this.getBit(this.getByte(this.record + 28), 3);
    }

    public boolean isStatic() throws DOMException {
        return this.getBit(this.getByte(this.record + 28), 4);
    }

    public ICPPDelegate createDelegate(IASTName name) {
        return new CPPVariable.CPPVariableDelegate(name, this);
    }
}

