/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.net.URI;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.CContentTypes;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.pdom.ITodoTaskUpdater;
import org.eclipse.cdt.internal.core.pdom.IndexerProgress;
import org.eclipse.cdt.internal.core.pdom.PDOMWriter;
import org.eclipse.cdt.internal.core.pdom.db.ChunkCache;
import org.eclipse.cdt.internal.core.pdom.indexer.AbstractPDOMIndexer;
import org.eclipse.cdt.internal.core.pdom.indexer.Messages;
import org.eclipse.cdt.internal.core.pdom.indexer.TodoTaskUpdater;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;

public abstract class PDOMIndexerTask
extends PDOMWriter
implements IPDOMIndexerTask {
    private static final Object NO_CONTEXT = new Object();
    private static final int MAX_ERRORS = 500;
    private static final String TRUE = "true";
    private AbstractPDOMIndexer fIndexer;
    protected Map fContextMap = new HashMap();
    private List fFilesUpFront = new ArrayList();
    private String fDummyFileName;
    private URI fDummyFileURI;
    private int fUpdateFlags = 1;
    private boolean fAllFilesProvided = true;

    protected PDOMIndexerTask(AbstractPDOMIndexer indexer) {
        this.fIndexer = indexer;
        this.setShowActivity(PDOMIndexerTask.checkDebugOption("org.eclipse.cdt.core/debug/indexer/activity", TRUE));
        this.setShowProblems(PDOMIndexerTask.checkDebugOption("org.eclipse.cdt.core/debug/indexer/problems", TRUE));
        if (this.checkProperty("skipReferences")) {
            this.setSkipReferences(SKIP_ALL_REFERENCES);
        } else if (this.checkProperty("skipTypeReferences")) {
            this.setSkipReferences(SKIP_TYPE_REFERENCES);
        }
    }

    public final IPDOMIndexer getIndexer() {
        return this.fIndexer;
    }

    public final ICProject getProject() {
        return this.fIndexer.getProject();
    }

    public final IndexerProgress getProgressInformation() {
        return super.getProgressInformation();
    }

    public void setUpateFlags(int flags) {
        this.fUpdateFlags = flags;
    }

    public final boolean updateAll() {
        return (this.fUpdateFlags & 1) != 0;
    }

    public final boolean updateChangedTimestamps() {
        return (this.fUpdateFlags & 2) != 0;
    }

    public final boolean updateChangedConfiguration() {
        return (this.fUpdateFlags & 4) != 0;
    }

    public final void setParseUpFront() {
        this.fFilesUpFront.addAll(Arrays.asList(this.fIndexer.getFilesToParseUpFront()));
    }

    public final void setAllFilesProvided(boolean allFiles) {
        this.fAllFilesProvided = allFiles;
    }

    public final boolean getAllFilesProvided() {
        return this.fAllFilesProvided;
    }

    public static boolean checkDebugOption(String option, String value) {
        String trace = Platform.getDebugOption((String)option);
        boolean internallyActivated = Boolean.getBoolean(option);
        return internallyActivated || trace != null && trace.equalsIgnoreCase(value);
    }

    protected final boolean getIndexAllFiles() {
        return this.checkProperty("indexAllFiles");
    }

    private boolean checkProperty(String key) {
        return TRUE.equals(this.getIndexer().getProperty(key));
    }

    private IASTTranslationUnit createAST(ITranslationUnit tu, IScannerInfo scannerInfo, int options, IProgressMonitor pm) throws CoreException {
        IPath path = tu.getLocation();
        if (path == null) {
            return null;
        }
        ILanguage language = tu.getLanguage();
        if (!(language instanceof AbstractLanguage)) {
            return null;
        }
        CodeReader codeReader = tu.getCodeReader();
        if (codeReader == null) {
            return null;
        }
        return this.createAST((AbstractLanguage)language, codeReader, scannerInfo, options, pm);
    }

    protected abstract IASTTranslationUnit createAST(AbstractLanguage var1, CodeReader var2, IScannerInfo var3, int var4, IProgressMonitor var5) throws CoreException;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseTUs(IWritableIndex index, int readlockCount, Collection sources, Collection headers, IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            this.internalParseTUs(index, readlockCount, sources, headers, monitor);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            index.flush();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        index.flush();
    }

    private void internalParseTUs(IWritableIndex index, int readlockCount, Collection sources, Collection headers, IProgressMonitor monitor) throws CoreException, InterruptedException {
        IIndexFileLocation ifl;
        ITranslationUnit tu;
        TodoTaskUpdater taskUpdater = new TodoTaskUpdater();
        int options = 2;
        if (this.checkProperty("skipReferences")) {
            options |= 1;
        }
        Iterator iter = this.fFilesUpFront.iterator();
        while (iter.hasNext()) {
            String upfront = (String)iter.next();
            this.parseUpFront(upfront, options, index, readlockCount, taskUpdater, monitor);
        }
        iter = sources.iterator();
        while (iter.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            tu = (ITranslationUnit)iter.next();
            ifl = IndexLocationFactory.getIFL(tu);
            if (!this.needToUpdate(ifl, 0)) continue;
            this.parseTU(ifl, tu, options, index, readlockCount, taskUpdater, monitor);
        }
        iter = headers.iterator();
        while (iter.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            tu = (ITranslationUnit)iter.next();
            ifl = IndexLocationFactory.getIFL(tu);
            if (!this.needToUpdate(ifl, 0)) {
                iter.remove();
                continue;
            }
            ITranslationUnit context = this.findContext(index, ifl);
            if (context == null) continue;
            this.parseTU(ifl, context, options, index, readlockCount, taskUpdater, monitor);
        }
        if (this.getIndexAllFiles()) {
            iter = headers.iterator();
            while (iter.hasNext()) {
                if (monitor.isCanceled()) {
                    return;
                }
                tu = (ITranslationUnit)iter.next();
                ifl = IndexLocationFactory.getIFL(tu);
                if (!this.needToUpdate(ifl, 0)) {
                    iter.remove();
                    continue;
                }
                this.parseTU(ifl, tu, options, index, readlockCount, taskUpdater, monitor);
            }
        }
    }

    protected final boolean isOutdated(ITranslationUnit tu, IIndexFile indexFile) throws CoreException {
        if (indexFile == null) {
            return true;
        }
        IResource res = tu.getResource();
        if (res != null) {
            return indexFile == null || res.getLocalTimeStamp() != indexFile.getTimestamp();
        }
        return false;
    }

    private void parseTU(IIndexFileLocation originator, ITranslationUnit tu, int options, IWritableIndex index, int readlockCount, ITodoTaskUpdater taskUpdater, IProgressMonitor pm) throws CoreException, InterruptedException {
        IPath path = tu.getPath();
        try {
            IScannerInfo scanner = tu.getScannerInfo(this.getIndexAllFiles());
            if (scanner == null) {
                this.updateInfo(0, 0, -1);
            } else {
                int configHash = PDOMIndexerTask.computeHashCode(scanner);
                if (this.needToUpdate(originator, configHash)) {
                    if (this.fShowActivity) {
                        System.out.println("Indexer: parsing " + path.toOSString());
                    }
                    pm.subTask(MessageFormat.format(Messages.PDOMIndexerTask_parsingFileTask, path.lastSegment(), path.removeLastSegments(1).toString()));
                    long start = System.currentTimeMillis();
                    IASTTranslationUnit ast = this.createAST(tu, scanner, options, pm);
                    this.fStatistics.fParsingTime = (int)((long)this.fStatistics.fParsingTime + (System.currentTimeMillis() - start));
                    if (ast != null) {
                        this.addSymbols(ast, index, readlockCount, false, configHash, taskUpdater, pm);
                    }
                }
            }
        }
        catch (CoreException e) {
            this.swallowError(path, e);
        }
        catch (RuntimeException e) {
            this.swallowError(path, e);
        }
        catch (Error e) {
            this.swallowError(path, e);
        }
    }

    private void parseUpFront(String file, int options, IWritableIndex index, int readlockCount, ITodoTaskUpdater taskUpdater, IProgressMonitor pm) throws CoreException, InterruptedException {
        if ((file = file.trim()).length() == 0) {
            return;
        }
        Path path = new Path(file);
        try {
            ILanguage l;
            if (this.fShowActivity) {
                System.out.println("Indexer: parsing " + file + " up front");
            }
            pm.subTask(MessageFormat.format(Messages.PDOMIndexerTask_parsingFileTask, path.lastSegment(), path.removeLastSegments(1).toString()));
            long start = System.currentTimeMillis();
            IASTTranslationUnit ast = null;
            IProject project = this.getProject().getProject();
            IContentType ct = CContentTypes.getContentType(project, file);
            if (ct != null && (l = LanguageManager.getInstance().getLanguage(ct)) instanceof AbstractLanguage) {
                AbstractLanguage lang = (AbstractLanguage)l;
                IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project);
                IScannerInfo scanInfo = provider != null ? provider.getScannerInformation((IResource)project) : new ScannerInfo();
                String code = "#include \"" + file + "\"\n";
                if (this.fDummyFileName == null) {
                    this.fDummyFileName = project.getLocation().append("___").toString();
                    this.fDummyFileURI = this.findLocation(this.fDummyFileName).getURI();
                }
                CodeReader codeReader = new CodeReader(this.fDummyFileName, code.toCharArray());
                ast = this.createAST(lang, codeReader, scanInfo, options, pm);
            }
            this.fStatistics.fParsingTime = (int)((long)this.fStatistics.fParsingTime + (System.currentTimeMillis() - start));
            if (ast != null) {
                this.addSymbols(ast, index, readlockCount, false, 0, taskUpdater, pm);
                this.updateInfo(-1, 1, 0);
            }
        }
        catch (CoreException e) {
            this.swallowError((IPath)path, e);
        }
        catch (RuntimeException e) {
            this.swallowError((IPath)path, e);
        }
        catch (Error e) {
            this.swallowError((IPath)path, e);
        }
    }

    protected boolean needToUpdate(IIndexFileLocation fileLoc, int configHash) throws CoreException {
        return this.fDummyFileURI == null || !this.fDummyFileURI.equals(fileLoc.getURI());
    }

    private void swallowError(IPath file, Throwable e) throws CoreException {
        if (e instanceof CoreException) {
            CCorePlugin.log(((CoreException)e).getStatus());
        } else {
            IStatus status = CCorePlugin.createStatus(MessageFormat.format(Messages.PDOMIndexerTask_errorWhileParsing, file), e);
            CCorePlugin.log(status);
        }
        if (++this.fStatistics.fErrorCount > 500) {
            throw new CoreException(CCorePlugin.createStatus(MessageFormat.format(Messages.PDOMIndexerTask_tooManyIndexProblems, this.getIndexer().getProject().getElementName())));
        }
    }

    private ITranslationUnit findContext(IIndex index, IIndexFileLocation location) {
        Object cachedContext = this.fContextMap.get(location);
        if (cachedContext != null) {
            return cachedContext == NO_CONTEXT ? null : (ITranslationUnit)cachedContext;
        }
        this.fContextMap.put(location, NO_CONTEXT);
        try {
            ICProject project = this.getIndexer().getProject();
            IIndexFile pdomFile = index.getFile(location);
            if (pdomFile != null) {
                IIndexInclude contextInclude = pdomFile.getParsedInContext();
                if (contextInclude != null) {
                    IIndexFileLocation loc = contextInclude.getIncludedByLocation();
                    ITranslationUnit context = this.getSourceUnit(project, loc);
                    if (context == null) {
                        context = this.findContext(index, loc);
                    }
                    if (context != null) {
                        this.fContextMap.put(location, context);
                        return context;
                    }
                }
                IIndexInclude[] includedBy = index.findIncludedBy(pdomFile, 0);
                int i = includedBy.length - 1;
                while (i >= 0) {
                    IIndexFileLocation loc = includedBy[i].getIncludedByLocation();
                    ITranslationUnit context = this.getSourceUnit(project, loc);
                    if (context == null) {
                        context = this.findContext(index, loc);
                    }
                    if (context != null) {
                        this.fContextMap.put(location, context);
                        return context;
                    }
                    --i;
                }
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    private ITranslationUnit getSourceUnit(ICProject project, IIndexFileLocation location) throws CoreException {
        ITranslationUnit tu = CoreModelUtil.findTranslationUnitForLocation(location, this.getIndexer().getProject());
        if (tu != null && tu.isSourceUnit()) {
            return tu;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeTU(IWritableIndex index, ITranslationUnit tu, int readlocks) throws CoreException, InterruptedException {
        index.acquireWriteLock(readlocks);
        try {
            IIndexFragmentFile file = (IIndexFragmentFile)index.getFile(IndexLocationFactory.getIFL(tu));
            if (file != null) {
                index.clearFile(file, null);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            index.releaseWriteLock(readlocks);
            throw throwable;
        }
        {
            Object var5_7 = null;
            index.releaseWriteLock(readlocks);
            return;
        }
    }

    protected void traceEnd(long start, IWritableIndex index) {
        if (PDOMIndexerTask.checkDebugOption("org.eclipse.cdt.core/debug/indexer/statistics", TRUE)) {
            IndexerProgress info = this.getProgressInformation();
            String name = this.getClass().getName();
            name = name.substring(name.lastIndexOf(46) + 1);
            System.out.println(String.valueOf(name) + " " + this.getProject().getElementName() + " (" + info.fCompletedSources + " sources, " + info.fCompletedHeaders + " headers)");
            boolean allFiles = this.getIndexAllFiles();
            boolean skipRefs = this.checkProperty("skipReferences");
            boolean skipTypeRefs = skipRefs || this.checkProperty("skipTypeReferences");
            System.out.println(String.valueOf(name) + " Options: " + "parseAllFiles=" + allFiles + ",skipReferences=" + skipRefs + ", skipTypeReferences=" + skipTypeRefs + ".");
            System.out.println(String.valueOf(name) + " Timings: " + (System.currentTimeMillis() - start) + " total, " + this.fStatistics.fParsingTime + " parser, " + this.fStatistics.fResolutionTime + " resolution, " + this.fStatistics.fAddToIndexTime + " index update.");
            System.out.println(String.valueOf(name) + " Errors: " + this.fStatistics.fUnresolvedIncludes + " unresolved includes, " + this.fStatistics.fErrorCount + " unexpected errors.");
            int sum = this.fStatistics.fDeclarationCount + this.fStatistics.fReferenceCount + this.fStatistics.fProblemBindingCount;
            double problemPct = sum == 0 ? 0.0 : (double)this.fStatistics.fProblemBindingCount / (double)sum;
            NumberFormat nf = NumberFormat.getPercentInstance();
            nf.setMaximumFractionDigits(2);
            nf.setMinimumFractionDigits(2);
            System.out.println(String.valueOf(name) + " Result: " + this.fStatistics.fDeclarationCount + " declarations, " + this.fStatistics.fReferenceCount + " references, " + this.fStatistics.fProblemBindingCount + "(" + nf.format(problemPct) + ") problems.");
            if (index != null) {
                long hits;
                long misses = index.getCacheMisses();
                long tries = misses + (hits = index.getCacheHits());
                double missPct = tries == 0L ? 0.0 : (double)misses / (double)tries;
                nf.setMinimumFractionDigits(4);
                nf.setMaximumFractionDigits(4);
                System.out.println(String.valueOf(name) + " Cache[" + ChunkCache.getSharedInstance().getMaxSize() / 1024L / 1024L + "mb]: " + hits + " hits, " + misses + "(" + nf.format(missPct) + ") misses.");
            }
        }
    }

    protected long getLastModified(IIndexFileLocation location) throws CoreException {
        IResource res;
        String fullPath = location.getFullPath();
        if (fullPath != null && (res = ResourcesPlugin.getWorkspace().getRoot().findMember(fullPath)) != null) {
            return res.getLocalTimeStamp();
        }
        return super.getLastModified(location);
    }

    protected static int computeHashCode(IScannerInfo scannerInfo) {
        String[] a;
        int result = 0;
        Map macros = scannerInfo.getDefinedSymbols();
        if (macros != null) {
            Iterator i = macros.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                result = PDOMIndexerTask.addToHashcode(result, key);
                if (value == null || value.length() <= 0) continue;
                result = PDOMIndexerTask.addToHashcode(result, value);
            }
        }
        if ((a = scannerInfo.getIncludePaths()) != null) {
            int i = 0;
            while (i < a.length) {
                result = PDOMIndexerTask.addToHashcode(result, a[i]);
                ++i;
            }
        }
        if (scannerInfo instanceof IExtendedScannerInfo) {
            IExtendedScannerInfo esi = (IExtendedScannerInfo)scannerInfo;
            a = esi.getIncludeFiles();
            if (a != null) {
                int i = 0;
                while (i < a.length) {
                    result = PDOMIndexerTask.addToHashcode(result, a[i]);
                    ++i;
                }
            }
            if ((a = esi.getLocalIncludePath()) != null) {
                int i = 0;
                while (i < a.length) {
                    result = PDOMIndexerTask.addToHashcode(result, a[i]);
                    ++i;
                }
            }
            if ((a = esi.getMacroFiles()) != null) {
                int i = 0;
                while (i < a.length) {
                    result = PDOMIndexerTask.addToHashcode(result, a[i]);
                    ++i;
                }
            }
        }
        return result;
    }

    private static int addToHashcode(int result, String key) {
        return result * 31 + key.hashCode();
    }

    protected ICProject getCProject() {
        return this.fIndexer.project;
    }
}

