/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.internal.core.pdom.ITodoTaskUpdater;
import org.eclipse.cdt.internal.core.pdom.indexer.Messages;
import org.eclipse.cdt.internal.core.pdom.indexer.TodoTaskParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class TodoTaskUpdater
implements ITodoTaskUpdater {
    private static final IMarker[] EMPTY_MARKER_ARRAY = new IMarker[0];
    private static final String SOURCE_ID = "CDT";
    private static final String[] TASK_MARKER_ATTRIBUTE_NAMES = new String[]{"message", "priority", "charStart", "charEnd", "lineNumber", "userEditable", "sourceId"};
    private final TodoTaskParser taskParser;

    public TodoTaskUpdater() {
        String value = CCorePlugin.getOption("org.eclipse.cdt.core.taskTags");
        if (value == null) {
            value = "TODO";
        }
        String[] tags = this.split(value, ",");
        char[][] taskTags = new char[tags.length][];
        int i = 0;
        while (i < tags.length) {
            taskTags[i] = tags[i].toCharArray();
            ++i;
        }
        value = CCorePlugin.getOption("org.eclipse.cdt.core.taskPriorities");
        if (value == null) {
            value = "normal";
        }
        String[] priorities = this.split(value, ",");
        int[] taskPriorities = new int[taskTags.length];
        int i2 = 0;
        while (i2 < taskPriorities.length) {
            String priority;
            String string = priority = i2 < priorities.length ? priorities[i2] : "normal";
            taskPriorities[i2] = "high".equals(priority) ? 2 : ("low".equals(priority) ? 0 : 1);
            ++i2;
        }
        value = CCorePlugin.getOption("org.eclipse.cdt.core.taskCaseSensitive");
        if (value == null) {
            value = "false";
        }
        boolean isTaskCaseSensitive = Boolean.valueOf(value);
        this.taskParser = new TodoTaskParser(taskTags, taskPriorities, isTaskCaseSensitive);
    }

    public void updateTasks(IASTComment[] comments, IIndexFileLocation[] fileLocations) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < fileLocations.length) {
            IFile file;
            IIndexFileLocation indexFileLocation = fileLocations[i];
            String filepath = indexFileLocation.getFullPath();
            if (filepath != null && (file = workspaceRoot.getFile((IPath)new Path(filepath))) != null && TodoTaskUpdater.getTasksFor((IResource)file).length != 0) {
                TodoTaskUpdater.removeTasksFor((IResource)file);
            }
            ++i;
        }
        if (comments.length == 0) {
            return;
        }
        TodoTaskParser.Task[] tasks = this.taskParser.parse(comments);
        String location = null;
        IFile[] files = null;
        int i2 = 0;
        while (i2 < tasks.length) {
            TodoTaskParser.Task task = tasks[i2];
            if (!task.getFileLocation().equals(location)) {
                location = task.getFileLocation();
                files = workspaceRoot.findFilesForLocation((IPath)new Path(location));
            }
            int j = 0;
            while (j < files.length) {
                try {
                    this.applyTask(task, (IResource)files[j]);
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
                ++j;
            }
            ++i2;
        }
    }

    private void applyTask(TodoTaskParser.Task task, IResource resource) throws CoreException {
        IMarker marker = resource.createMarker("org.eclipse.cdt.core.task");
        String description = NLS.bind((String)Messages.TodoTaskUpdater_taskFormat, (Object)task.getTag(), (Object)task.getMessage());
        marker.setAttributes(TASK_MARKER_ATTRIBUTE_NAMES, new Object[]{description, new Integer(task.getPriority()), new Integer(task.getStart()), new Integer(task.getEnd()), new Integer(task.getLineNumber()), Boolean.FALSE, SOURCE_ID});
    }

    private static IMarker[] getTasksFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                return resource.findMarkers("org.eclipse.cdt.core.task", false, 2);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return EMPTY_MARKER_ARRAY;
    }

    private static void removeTasksFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.eclipse.cdt.core.task", false, 2);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    private String[] split(String value, String delimiters) {
        StringTokenizer tokenizer = new StringTokenizer(value, delimiters);
        int size = tokenizer.countTokens();
        String[] tokens = new String[size];
        int i = 0;
        while (i < size) {
            tokens[i] = tokenizer.nextToken();
            ++i;
        }
        return tokens;
    }
}

