/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer.full;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.internal.core.dom.SavedCodeReaderFactory;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexManager;
import org.eclipse.cdt.internal.core.pdom.indexer.PDOMIndexerTask;
import org.eclipse.cdt.internal.core.pdom.indexer.full.PDOMFullIndexer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

class PDOMFullIndexerTask
extends PDOMIndexerTask {
    private static final Object REQUIRED = new Object();
    private static final Object MISSING = new Object();
    private static final Object SKIP = new Object();
    private static final Object REQUIRED_IF_CONFIG_CHANGED = new Object();
    private List fChanged = new LinkedList();
    private List fRemoved = new ArrayList();
    private IWritableIndex fIndex = null;
    private Map filePathsToParse = new HashMap();
    private Map fIflCache = new HashMap();

    public PDOMFullIndexerTask(PDOMFullIndexer indexer, ITranslationUnit[] added, ITranslationUnit[] changed, ITranslationUnit[] removed) {
        super(indexer);
        this.fChanged.addAll(Arrays.asList(added));
        this.fChanged.addAll(Arrays.asList(changed));
        this.fRemoved.addAll(Arrays.asList(removed));
        this.updateInfo(0, 0, this.fChanged.size() + this.fRemoved.size());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        try {
            Object var8_8;
            ITranslationUnit tu;
            boolean filterFiles = !this.getIndexAllFiles() && this.getAllFilesProvided();
            ArrayList<ITranslationUnit> headers = new ArrayList<ITranslationUnit>();
            List sources = this.fChanged;
            Iterator iter = this.fChanged.iterator();
            while (iter.hasNext()) {
                tu = (ITranslationUnit)iter.next();
                if (tu.isSourceUnit()) {
                    if (!filterFiles || !CoreModel.isScannerInformationEmpty(tu.getResource())) continue;
                    iter.remove();
                    this.updateInfo(0, 0, -1);
                    continue;
                }
                headers.add(tu);
                iter.remove();
            }
            this.setupIndex();
            this.registerTUsInReaderFactory(sources);
            this.registerTUsInReaderFactory(headers);
            Iterator i = this.fRemoved.iterator();
            while (i.hasNext()) {
                if (monitor.isCanceled()) {
                    return;
                }
                tu = (ITranslationUnit)i.next();
                this.removeTU(this.fIndex, tu, 0);
                if (tu.isSourceUnit()) {
                    this.updateInfo(1, 0, 0);
                    continue;
                }
                this.updateInfo(0, 1, -1);
            }
            this.fIndex.acquireReadLock();
            try {
                this.parseTUs(this.fIndex, 1, sources, headers, monitor);
                var8_8 = null;
                this.fIndex.releaseReadLock();
            }
            catch (Throwable throwable) {
                var8_8 = null;
                this.fIndex.releaseReadLock();
                throw throwable;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
        this.traceEnd(start, this.fIndex);
    }

    private void setupIndex() throws CoreException {
        SavedCodeReaderFactory.getInstance().getCodeReaderCache().flush();
        this.fIndex = ((IWritableIndexManager)CCorePlugin.getIndexManager()).getWritableIndex(this.getProject());
        this.fIndex.resetCacheCounters();
    }

    private void registerTUsInReaderFactory(Collection sources) throws CoreException {
        int removed = 0;
        this.filePathsToParse = new HashMap();
        Iterator iter = sources.iterator();
        while (iter.hasNext()) {
            ITranslationUnit tu = (ITranslationUnit)iter.next();
            IIndexFileLocation ifl = IndexLocationFactory.getIFL(tu);
            if (this.updateAll()) {
                this.filePathsToParse.put(ifl, REQUIRED);
            } else if (this.updateChangedTimestamps() && this.isOutdated(tu, this.fIndex.getFile(ifl))) {
                this.filePathsToParse.put(ifl, REQUIRED);
            } else if (this.updateChangedConfiguration()) {
                this.filePathsToParse.put(ifl, REQUIRED_IF_CONFIG_CHANGED);
            } else {
                iter.remove();
                ++removed;
                continue;
            }
            this.updateInfo(0, 0, -removed);
        }
    }

    protected IIndexFileLocation findLocation(String absolutePath) {
        IIndexFileLocation result = (IIndexFileLocation)this.fIflCache.get(absolutePath);
        if (result == null) {
            result = IndexLocationFactory.getIFLExpensive(this.getCProject(), absolutePath);
            this.fIflCache.put(absolutePath, result);
        }
        return result;
    }

    protected IASTTranslationUnit createAST(AbstractLanguage lang, CodeReader codeReader, IScannerInfo scanInfo, int options, IProgressMonitor pm) throws CoreException {
        SavedCodeReaderFactory codeReaderFactory = SavedCodeReaderFactory.getInstance();
        IASTTranslationUnit ast = lang.getASTTranslationUnit(codeReader, scanInfo, codeReaderFactory, null, options, ParserUtil.getParserLogService());
        if (pm.isCanceled()) {
            return null;
        }
        return ast;
    }

    public boolean needToUpdate(IIndexFileLocation location, int confighash) throws CoreException {
        if (super.needToUpdate(location, confighash)) {
            IIndexFile file;
            Object required = this.filePathsToParse.get(location);
            if (required == null) {
                required = MISSING;
                this.filePathsToParse.put(location, required);
            } else if (confighash != 0 && required == REQUIRED_IF_CONFIG_CHANGED && (file = this.fIndex.getFile(location)) != null) {
                int oldConfig = file.getScannerConfigurationHashcode();
                if (oldConfig == 0 || oldConfig == confighash) {
                    required = SKIP;
                    this.updateInfo(0, 0, -1);
                } else {
                    required = REQUIRED;
                }
                this.filePathsToParse.put(location, required);
            }
            return required != SKIP;
        }
        return false;
    }

    protected boolean postAddToIndex(IIndexFileLocation location, IIndexFile file) throws CoreException {
        Object required = this.filePathsToParse.get(location);
        this.filePathsToParse.put(location, SKIP);
        return required == REQUIRED;
    }
}

