/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import org.eclipse.cdt.core.envvar.IEnvironmentContributor;
import org.eclipse.cdt.core.settings.model.ICBuildSetting;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICOutputEntry;
import org.eclipse.cdt.core.settings.model.ICSettingContainer;
import org.eclipse.cdt.core.settings.model.extension.CBuildData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultBuildData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescriptionCache;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.ICachedData;
import org.eclipse.cdt.utils.envvar.StorableEnvironment;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class CBuildSettingCache
extends CDefaultBuildData
implements ICBuildSetting,
ICachedData {
    private CConfigurationDescriptionCache fCfgCache;
    private StorableEnvironment fEnvironment;
    private StorableEnvironment fResolvedEnvironment;
    private ICOutputEntry[] fProjOutputEntries;
    private ICOutputEntry[] fResolvedOutputEntries;

    CBuildSettingCache(CBuildData base, CConfigurationDescriptionCache cfgCache) {
        super(base.getId(), base);
        this.fCfgCache = cfgCache;
        this.fCfgCache.addBuildSetting(this);
    }

    void initEnvironmentCache() {
        this.fEnvironment = new StorableEnvironment(EnvironmentVariableManager.getDefault().getVariables(this.fCfgCache, false), true);
    }

    public StorableEnvironment getCachedEnvironment() {
        return this.fEnvironment;
    }

    public StorableEnvironment getResolvedEnvironment() {
        if (this.fResolvedEnvironment == null) {
            this.fResolvedEnvironment = new StorableEnvironment(EnvironmentVariableManager.getDefault().getVariables(this.fCfgCache, true), true);
        }
        return this.fResolvedEnvironment;
    }

    public ICConfigurationDescription getConfiguration() {
        return this.fCfgCache;
    }

    public ICSettingContainer getParent() {
        return this.fCfgCache;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void setBuilderCWD(IPath path) {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    public void setErrorParserIDs(String[] ids) {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    public void setName(String name) {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    public void setOutputDirectories(ICOutputEntry[] entries) {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    public IEnvironmentContributor getBuildEnvironmentContributor() {
        return this.fCfgCache.getConfigurationData().getBuildData().getBuildEnvironmentContributor();
    }

    public ICOutputEntry[] getResolvedOutputDirectories() {
        if (this.fResolvedOutputEntries == null) {
            ICOutputEntry[] entries = this.getOutputDirectories();
            return CDataUtil.resolveEntries(entries, this.getConfiguration());
        }
        return this.fResolvedOutputEntries;
    }

    public ICOutputEntry[] getOutputDirectories() {
        this.initOutputEntries();
        return (ICOutputEntry[])this.fProjOutputEntries.clone();
    }

    private void initOutputEntries() {
        if (this.fProjOutputEntries == null) {
            IProject project = this.getProject();
            this.fProjOutputEntries = CDataUtil.adjustEntries(this.fOutputEntries, true, project);
        }
    }

    private IProject getProject() {
        ICConfigurationDescription cfg = this.getConfiguration();
        return cfg.isPreferenceConfiguration() ? null : cfg.getProjectDescription().getProject();
    }
}

