/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSettingContainer;
import org.eclipse.cdt.core.settings.model.ICSettingObject;
import org.eclipse.cdt.core.settings.model.extension.CDataObject;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescription;
import org.eclipse.cdt.internal.core.settings.model.ICDataProxyContainer;
import org.eclipse.cdt.internal.core.settings.model.ICachedData;
import org.eclipse.core.resources.IProject;

public abstract class CDataProxy
implements ICSettingObject {
    protected ICDataProxyContainer fParent;
    private CDataObject fData;
    private int fFlags;
    private CConfigurationDescription fConfiguration;
    private String fId;
    private static final int F_RESCAN = 1;

    CDataProxy(CDataObject data, ICDataProxyContainer parent, CConfigurationDescription cfg) {
        this.fData = data;
        if (this.fData != null) {
            this.fId = this.fData.getId();
        }
        this.fParent = parent;
        this.fConfiguration = cfg;
    }

    public ICSettingContainer getParent() {
        return this.fParent;
    }

    protected void setRescan(boolean rescan) {
        if (this.isRescan() == rescan) {
            return;
        }
        if (rescan) {
            this.addFlags(1);
        } else {
            this.clearFlags(1);
        }
    }

    protected boolean isRescan() {
        return this.checkFlags(1);
    }

    private boolean checkFlags(int flags) {
        return (this.fFlags & flags) == flags;
    }

    private void addFlags(int flags) {
        this.fFlags |= flags;
    }

    private void clearFlags(int flags) {
        this.fFlags &= ~flags;
    }

    protected CDataObject getData(boolean write) {
        this.checkUpdate(write);
        return this.fData;
    }

    protected CDataObject doGetData() {
        return this.fData;
    }

    protected boolean containsWritableData() {
        return !(this.fData instanceof ICachedData);
    }

    void setData(CDataObject data) {
        this.fId = data.getId();
        this.fData = data;
    }

    void internalSetId(String id) {
        this.fId = id;
    }

    void doClearData() {
        this.fData = null;
        this.setRescan(true);
    }

    protected void checkUpdate(boolean write) {
        if (write && !this.containsWritableData() || this.isRescan()) {
            this.fParent.updateChild(this, write);
        }
    }

    void remove() {
        this.fData = null;
        this.fParent = null;
    }

    public boolean isValid() {
        this.checkUpdate(false);
        return this.fData != null ? this.fData.isValid() : false;
    }

    public ICConfigurationDescription getConfiguration() {
        return this.fConfiguration;
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        CDataObject data = this.getData(false);
        return data != null ? data.getName() : null;
    }

    void setConfiguration(CConfigurationDescription cfg) {
        this.fConfiguration = cfg;
    }

    public boolean isReadOnly() {
        return false;
    }

    protected IProject getProject() {
        ICConfigurationDescription cfg = this.getConfiguration();
        if (cfg == null) {
            return null;
        }
        ICProjectDescription projDes = cfg.getProjectDescription();
        if (projDes == null) {
            return null;
        }
        return projDes.getProject();
    }
}

