/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.ICSettingsStorage;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.InternalXmlStorageElement;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CStorage
implements ICSettingsStorage {
    private static final String MODULE_ELEMENT_NAME = "storageModule";
    private static final String MODULE_ID_ATTRIBUTE = "moduleId";
    Element fElement;
    private Map fStorageElementMap = new HashMap();
    private boolean fChildrenInited;
    private boolean fIsReadOnly;
    private boolean fIsDirty;

    public CStorage(Element element, boolean isReadOnly) {
        this.fElement = element;
        this.fIsReadOnly = isReadOnly;
    }

    public CStorage(InternalXmlStorageElement element) {
        this.fElement = element.fElement;
        this.fIsReadOnly = element.isReadOnly();
        element.storageCreated(this);
    }

    public boolean isReadOnly() {
        return this.fIsReadOnly;
    }

    private void initChildren() {
        if (this.fChildrenInited) {
            return;
        }
        this.fChildrenInited = true;
        NodeList children = this.fElement.getChildNodes();
        int size = children.getLength();
        int i = 0;
        while (i < size) {
            Element element;
            String moduleId;
            Node node = children.item(i);
            if (node.getNodeType() == 1 && MODULE_ELEMENT_NAME.equals(node.getNodeName()) && (moduleId = (element = (Element)node).getAttribute(MODULE_ID_ATTRIBUTE).trim()).length() != 0) {
                this.createAddStorageElement(moduleId, element);
            }
            ++i;
        }
    }

    private InternalXmlStorageElement createAddStorageElement(String id, Element element) {
        InternalXmlStorageElement se = CStorage.createStorageElement(element, this.fIsReadOnly);
        this.fStorageElementMap.put(id, se);
        return se;
    }

    public static InternalXmlStorageElement createStorageElement(Element el, boolean isReadOnly) {
        return new InternalXmlStorageElement(el, null, false, new String[]{MODULE_ID_ATTRIBUTE}, null, isReadOnly);
    }

    public boolean containsStorage(String id) throws CoreException {
        return this.getStorage(id, false) != null;
    }

    public ICStorageElement importStorage(String id, ICStorageElement el) throws UnsupportedOperationException {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        this.removeStorage(id);
        InternalXmlStorageElement xmlStEl = (InternalXmlStorageElement)el;
        Element xmlEl = xmlStEl.fElement;
        Document thisDoc = this.fElement.getOwnerDocument();
        Document otherDoc = xmlEl.getOwnerDocument();
        if (!thisDoc.equals(otherDoc)) {
            xmlEl = (Element)thisDoc.importNode(xmlEl, true);
        }
        Element newEl = thisDoc.createElement(MODULE_ELEMENT_NAME);
        NodeList nl = xmlEl.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node child = nl.item(i).cloneNode(true);
            newEl.appendChild(child);
            ++i;
        }
        xmlEl = newEl;
        xmlEl = (Element)this.fElement.appendChild(xmlEl);
        xmlEl.setAttribute(MODULE_ID_ATTRIBUTE, id);
        return this.createAddStorageElement(id, xmlEl);
    }

    public ICStorageElement getStorage(String id, boolean create) {
        this.initChildren();
        InternalXmlStorageElement se = (InternalXmlStorageElement)this.fStorageElementMap.get(id);
        if (se == null && create) {
            this.fIsDirty = true;
            Document doc = this.fElement.getOwnerDocument();
            Element child = doc.createElement(MODULE_ELEMENT_NAME);
            child.setAttribute(MODULE_ID_ATTRIBUTE, id);
            this.fElement.appendChild(child);
            se = this.createAddStorageElement(id, child);
        }
        return se;
    }

    public void removeStorage(String id) {
        this.initChildren();
        InternalXmlStorageElement se = (InternalXmlStorageElement)this.fStorageElementMap.remove(id);
        if (se != null) {
            if (this.fIsReadOnly) {
                throw ExceptionFactory.createIsReadOnlyException();
            }
            this.fIsDirty = true;
            this.fElement.removeChild(se.fElement);
            se.removed();
        }
    }

    public boolean isDirty() {
        if (this.fIsDirty) {
            return true;
        }
        Iterator iter = this.fStorageElementMap.values().iterator();
        while (iter.hasNext()) {
            InternalXmlStorageElement el = (InternalXmlStorageElement)iter.next();
            if (!el.isDirty()) continue;
            return true;
        }
        return false;
    }

    void setReadOnly(boolean readOnly) {
        this.fIsReadOnly = readOnly;
        Iterator iter = this.fStorageElementMap.values().iterator();
        while (iter.hasNext()) {
            InternalXmlStorageElement el = (InternalXmlStorageElement)iter.next();
            el.setReadOnly(readOnly);
        }
    }

    public void setDirty(boolean isDirty) {
        this.fIsDirty = isDirty;
        if (!this.fIsDirty) {
            Iterator iter = this.fStorageElementMap.values().iterator();
            while (iter.hasNext()) {
                InternalXmlStorageElement el = (InternalXmlStorageElement)iter.next();
                el.setDirty(false);
            }
        }
    }
}

