/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICDescriptionDelta;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescription;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.InternalXmlStorageElement;
import org.eclipse.cdt.internal.core.settings.model.SettingsContext;
import org.eclipse.cdt.internal.core.settings.model.SettingsModelMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class SetCProjectDescriptionOperation
extends CModelOperation {
    private CProjectDescription fSetDescription;
    private int fFlags;

    SetCProjectDescriptionOperation(ICProject cProject, CProjectDescription description, int flags) {
        super(cProject);
        this.fFlags = flags;
        this.fSetDescription = description;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws CModelException {
        ICElementDelta[] cElementDeltas;
        ICDescriptionDelta delta;
        boolean creating;
        CProjectDescriptionManager mngr = CProjectDescriptionManager.getInstance();
        ICProject cProject = (ICProject)this.getElementToProcess();
        IProject project = cProject.getProject();
        CProjectDescription fOldDescriptionCache = (CProjectDescription)mngr.getProjectDescription(project, false);
        CProjectDescriptionEvent event = mngr.createAboutToApplyEvent(this.fSetDescription, fOldDescriptionCache);
        mngr.notifyListeners(event);
        InternalXmlStorageElement el = null;
        try {
            el = mngr.copyElement((InternalXmlStorageElement)this.fSetDescription.getRootStorageElement(), false);
        }
        catch (CoreException coreException) {}
        boolean bl = creating = fOldDescriptionCache != null ? fOldDescriptionCache.isCdtProjectCreating() : true;
        if (creating) {
            creating = this.fSetDescription.isCdtProjectCreating();
        }
        if (!this.fSetDescription.isValid()) {
            if (!mngr.isEmptyCreatingDescriptionAllowed()) throw new CModelException(ExceptionFactory.createCoreException(String.valueOf(SettingsModelMessages.getString("CProjectDescriptionManager.17")) + project.getName()));
            if (!creating) {
                throw new CModelException(ExceptionFactory.createCoreException(String.valueOf(SettingsModelMessages.getString("CProjectDescriptionManager.17")) + project.getName()));
            }
        }
        CProjectDescription fNewDescriptionCache = new CProjectDescription(this.fSetDescription, true, el, creating);
        SettingsContext context = new SettingsContext(project);
        try {
            mngr.setDescriptionApplying(project, fNewDescriptionCache);
            fNewDescriptionCache.applyDatas(context);
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            mngr.clearDescriptionApplying(project);
            throw throwable;
        }
        {
            Object var10_13 = null;
            mngr.clearDescriptionApplying(project);
            delta = mngr.createDelta(fNewDescriptionCache, fOldDescriptionCache);
            mngr.checkRemovedConfigurations(delta);
            cElementDeltas = mngr.generateCElementDeltas(cProject, delta);
        }
        if (cElementDeltas.length > 0) {
            int i = 0;
            while (i < cElementDeltas.length) {
                this.addDelta(cElementDeltas[i]);
                ++i;
            }
        }
        mngr.setLoaddedDescription(project, fNewDescriptionCache, true);
        this.fSetDescription.switchToCachedAppliedData(fNewDescriptionCache);
        try {
            IProjectDescription eDes = context.getEclipseProjectDescription();
            if (mngr.checkHandleActiveCfgChange(fNewDescriptionCache, fOldDescriptionCache, eDes, (IProgressMonitor)new NullProgressMonitor())) {
                context.setEclipseProjectDescription(eDes);
            }
        }
        catch (CoreException e2) {
            CCorePlugin.log(e2);
        }
        event = mngr.createDataAppliedEvent(fNewDescriptionCache, fOldDescriptionCache, this.fSetDescription, delta);
        mngr.notifyListeners(event);
        cProject.close();
        try {
            ((InternalXmlStorageElement)fNewDescriptionCache.getRootStorageElement()).setReadOnly(true);
        }
        catch (CoreException coreException) {}
        fNewDescriptionCache.doneApplying();
        event = mngr.createAppliedEvent(fNewDescriptionCache, fOldDescriptionCache, this.fSetDescription, delta);
        mngr.notifyListeners(event);
        try {
            IWorkspaceRunnable toRun;
            if (!CProjectDescriptionManager.checkFlags(this.fFlags, 2)) {
                context.addWorkspaceRunnable(mngr.createDesSerializationRunnable(fNewDescriptionCache));
            }
            if ((toRun = context.createOperationRunnable()) == null) return;
            mngr.runWspModification(toRun, (IProgressMonitor)new NullProgressMonitor());
            return;
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
    }

    public boolean isReadOnly() {
        return false;
    }
}

