/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.envvar;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.utils.envvar.StorableEnvVar;

public class StorableEnvironment {
    public static final String ENVIRONMENT_ELEMENT_NAME = "environment";
    private static final String ATTRIBUTE_APPEND = "append";
    private static final boolean DEFAULT_APPEND = true;
    private HashMap fVariables;
    private boolean fIsDirty = false;
    private boolean fIsChanged = false;
    private boolean fIsReadOnly;
    private boolean fAppend = true;
    private boolean fAppendContributedEnv = true;

    private Map getMap() {
        if (this.fVariables == null) {
            this.fVariables = new HashMap();
        }
        return this.fVariables;
    }

    public StorableEnvironment(IEnvironmentVariable[] variables, boolean isReadOnly) {
        this.setVariales(variables);
        this.fIsReadOnly = isReadOnly;
    }

    public StorableEnvironment(boolean isReadOnly) {
        this.fIsReadOnly = isReadOnly;
    }

    public StorableEnvironment(StorableEnvironment env, boolean isReadOnly) {
        if (env.fVariables != null) {
            this.fVariables = (HashMap)env.fVariables.clone();
        }
        this.fAppend = env.fAppend;
        this.fIsReadOnly = isReadOnly;
        this.fIsDirty = env.isDirty();
    }

    public StorableEnvironment(ICStorageElement element, boolean isReadOnly) {
        this.load(element);
        this.fIsReadOnly = isReadOnly;
    }

    private void load(ICStorageElement element) {
        ICStorageElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            ICStorageElement node = children[i];
            if (node.getName().equals("variable")) {
                this.addVariable(new StorableEnvVar(node));
            }
            ++i;
        }
        String append = element.getAttribute(ATTRIBUTE_APPEND);
        this.fAppend = append != null ? Boolean.valueOf(element.getAttribute(ATTRIBUTE_APPEND)) : true;
        this.fIsDirty = false;
        this.fIsChanged = false;
    }

    public void serialize(ICStorageElement element) {
        element.setAttribute(ATTRIBUTE_APPEND, Boolean.valueOf(this.fAppend).toString());
        if (this.fVariables != null) {
            Iterator iter = this.fVariables.values().iterator();
            while (iter.hasNext()) {
                StorableEnvVar var = (StorableEnvVar)iter.next();
                ICStorageElement varEl = element.createChild("variable");
                var.serialize(varEl);
            }
        }
        this.fIsDirty = false;
    }

    private void addVariable(IEnvironmentVariable var) {
        String name = var.getName();
        if (name == null) {
            return;
        }
        EnvironmentVariableManager provider = EnvironmentVariableManager.getDefault();
        if (!provider.isVariableCaseSensitive()) {
            name = name.toUpperCase();
        }
        this.getMap().put(name, var);
    }

    public IEnvironmentVariable createVariable(String name, String value, int op, String delimiter) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        if (name == null || "".equals(name = name.trim())) {
            return null;
        }
        IEnvironmentVariable var = this.checkVariable(name, value, op, delimiter);
        if (var == null) {
            var = new StorableEnvVar(name, value, op, delimiter);
            this.addVariable(var);
            this.fIsDirty = true;
            this.fIsChanged = true;
        }
        return var;
    }

    public IEnvironmentVariable createVariable(String name) {
        return this.createVariable(name, null, 1, null);
    }

    public IEnvironmentVariable createVariable(String name, String value) {
        return this.createVariable(name, value, 1, null);
    }

    public IEnvironmentVariable createVariable(String name, String value, String delimiter) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        return this.createVariable(name, value, 1, delimiter);
    }

    public IEnvironmentVariable checkVariable(String name, String value, int op, String delimiter) {
        IEnvironmentVariable var = this.getVariable(name);
        if (var != null && this.checkStrings(var.getValue(), value) && var.getOperation() == op && this.checkStrings(var.getDelimiter(), delimiter)) {
            return var;
        }
        return null;
    }

    private boolean checkStrings(String str1, String str2) {
        if (str1 != null && str1.equals(str2)) {
            return true;
        }
        return str1 == str2;
    }

    public boolean isDirty() {
        return this.fIsDirty;
    }

    public void setDirty(boolean dirty) {
        this.fIsDirty = dirty;
    }

    public boolean isChanged() {
        return this.fIsChanged;
    }

    public void setChanged(boolean changed) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        this.fIsChanged = changed;
    }

    public IEnvironmentVariable getVariable(String name) {
        if (name == null || "".equals(name = name.trim())) {
            return null;
        }
        EnvironmentVariableManager provider = EnvironmentVariableManager.getDefault();
        if (!provider.isVariableCaseSensitive()) {
            name = name.toUpperCase();
        }
        return (IEnvironmentVariable)this.getMap().get(name);
    }

    public void setVariales(IEnvironmentVariable[] vars) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        if (vars == null || vars.length == 0) {
            this.deleteAll();
        } else {
            if (this.getMap().size() != 0) {
                Iterator iter = this.getMap().values().iterator();
                while (iter.hasNext()) {
                    IEnvironmentVariable v = (IEnvironmentVariable)iter.next();
                    int i = 0;
                    while (i < vars.length) {
                        if (v.getName().equals(vars[i].getName())) break;
                        ++i;
                    }
                    if (i != vars.length) continue;
                    this.deleteVariable(v.getName());
                }
            }
            this.createVriables(vars);
        }
    }

    public void createVriables(IEnvironmentVariable[] vars) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        int i = 0;
        while (i < vars.length) {
            this.createVariable(vars[i].getName(), vars[i].getValue(), vars[i].getOperation(), vars[i].getDelimiter());
            ++i;
        }
    }

    public IEnvironmentVariable[] getVariables() {
        Collection vars = this.getMap().values();
        return vars.toArray(new IEnvironmentVariable[vars.size()]);
    }

    public IEnvironmentVariable deleteVariable(String name) {
        IEnvironmentVariable var;
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        if (name == null || "".equals(name = name.trim())) {
            return null;
        }
        EnvironmentVariableManager provider = EnvironmentVariableManager.getDefault();
        if (!provider.isVariableCaseSensitive()) {
            name = name.toUpperCase();
        }
        if ((var = (IEnvironmentVariable)this.getMap().remove(name)) != null) {
            this.fIsDirty = true;
            this.fIsChanged = true;
        }
        return var;
    }

    public boolean deleteAll() {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        Map map = this.getMap();
        if (map.size() > 0) {
            this.fIsDirty = true;
            this.fIsChanged = true;
            map.clear();
            return true;
        }
        return false;
    }

    public boolean isReadOnly() {
        return this.fIsReadOnly;
    }

    public boolean appendEnvironment() {
        return this.fAppend;
    }

    public void setAppendEnvironment(boolean append) {
        this.fAppend = append;
    }

    public boolean appendContributedEnvironment() {
        return this.fAppendContributedEnv;
    }

    public void setAppendContributedEnvironment(boolean append) {
        this.fAppendContributedEnv = append;
    }

    public void restoreDefaults() {
        this.deleteAll();
        this.fAppend = true;
        this.fAppendContributedEnv = true;
    }
}

