/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.IFunctionInfo;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.core.browser.IndexTypeReference;
import org.eclipse.cdt.internal.core.browser.util.IndexModelUtil;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class IndexTypeInfo
implements ITypeInfo,
IFunctionInfo {
    private final String[] fqn;
    private final int elementType;
    private final IIndex index;
    private final String[] params;
    private final String returnType;
    private ITypeReference reference;

    public static IndexTypeInfo create(IIndex index, IIndexBinding binding) {
        String[] fqn;
        int elementType;
        try {
            elementType = IndexModelUtil.getElementType(binding);
            if (binding instanceof ICPPBinding) {
                fqn = ((ICPPBinding)((Object)binding)).getQualifiedName();
            } else if (binding instanceof IField) {
                IField field = (IField)((Object)binding);
                ICompositeType owner = field.getCompositeTypeOwner();
                fqn = new String[]{owner.getName(), field.getName()};
            } else {
                fqn = new String[]{binding.getName()};
            }
            if (binding instanceof IFunction) {
                IFunction function = (IFunction)((Object)binding);
                String[] paramTypes = IndexModelUtil.extractParameterTypes(function);
                String returnType = IndexModelUtil.extractReturnType(function);
                return new IndexTypeInfo(fqn, elementType, paramTypes, returnType, index);
            }
        }
        catch (DOMException dOMException) {
            throw new AssertionError();
        }
        return new IndexTypeInfo(fqn, elementType, index);
    }

    private IndexTypeInfo(String[] fqn, int elementType, IIndex index, String[] params, String returnType, ITypeReference reference) {
        Assert.isTrue((index != null ? 1 : 0) != 0);
        this.fqn = fqn;
        this.elementType = elementType;
        this.index = index;
        this.params = params;
        this.returnType = returnType;
        this.reference = reference;
    }

    public IndexTypeInfo(String[] fqn, int elementType, IIndex index) {
        this(fqn, elementType, index, null, null, null);
    }

    public IndexTypeInfo(String[] fqn, int elementType, String[] params, String returnType, IIndex index) {
        this(fqn, elementType, index, params, returnType, null);
    }

    public IndexTypeInfo(IndexTypeInfo rhs, ITypeReference ref) {
        this(rhs.fqn, rhs.elementType, rhs.index, rhs.params, rhs.returnType, ref);
    }

    public void addDerivedReference(ITypeReference location) {
        throw new PDOMNotImplementedError();
    }

    public void addReference(ITypeReference location) {
        throw new PDOMNotImplementedError();
    }

    public boolean canSubstituteFor(ITypeInfo info) {
        throw new PDOMNotImplementedError();
    }

    public boolean encloses(ITypeInfo info) {
        throw new PDOMNotImplementedError();
    }

    public boolean exists() {
        throw new PDOMNotImplementedError();
    }

    public int getCElementType() {
        return this.elementType;
    }

    public ITypeReference[] getDerivedReferences() {
        throw new PDOMNotImplementedError();
    }

    public ITypeInfo[] getEnclosedTypes() {
        throw new PDOMNotImplementedError();
    }

    public ITypeInfo[] getEnclosedTypes(int[] kinds) {
        throw new PDOMNotImplementedError();
    }

    public ITypeInfo getEnclosingNamespace(boolean includeGlobalNamespace) {
        throw new PDOMNotImplementedError();
    }

    public ICProject getEnclosingProject() {
        IProject project;
        if (this.getResolvedReference() != null && (project = this.reference.getProject()) != null) {
            return CCorePlugin.getDefault().getCoreModel().getCModel().getCProject(project.getName());
        }
        return null;
    }

    public ITypeInfo getEnclosingType() {
        return null;
    }

    public ITypeInfo getEnclosingType(int[] kinds) {
        throw new PDOMNotImplementedError();
    }

    public String getName() {
        return this.fqn[this.fqn.length - 1];
    }

    public IQualifiedTypeName getQualifiedTypeName() {
        return new QualifiedTypeName(this.fqn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ITypeReference getResolvedReference() {
        if (this.reference != null) return this.reference;
        try {
            block10: {
                try {
                    this.index.acquireReadLock();
                    char[][] cfqn = new char[this.fqn.length][];
                    int i = 0;
                    while (i < this.fqn.length) {
                        cfqn[i] = this.fqn[i].toCharArray();
                        ++i;
                    }
                    IIndexBinding[] ibs = this.index.findBindings(cfqn, new IndexFilter(){

                        public boolean acceptBinding(IBinding binding) {
                            boolean sameType = IndexModelUtil.bindingHasCElementType(binding, new int[]{IndexTypeInfo.this.elementType});
                            if (sameType && binding instanceof IFunction && IndexTypeInfo.this.params != null) {
                                try {
                                    Object[] otherParams = IndexModelUtil.extractParameterTypes((IFunction)binding);
                                    return Arrays.equals(IndexTypeInfo.this.params, otherParams);
                                }
                                catch (DOMException exc) {
                                    CCorePlugin.log(exc);
                                }
                            }
                            return sameType;
                        }
                    }, (IProgressMonitor)new NullProgressMonitor());
                    if (ibs.length <= 0) break block10;
                    IIndexName[] names = this.index.findNames(ibs[0], 2);
                    if (names.length == 0) {
                        names = this.index.findNames(ibs[0], 1);
                    }
                    int i2 = 0;
                    while (i2 < names.length) {
                        this.reference = this.createReference(ibs[0], names[i2]);
                        if (this.reference == null) {
                            ++i2;
                            continue;
                        }
                        break;
                    }
                }
                catch (CoreException ce) {
                    CCorePlugin.log(ce);
                }
                catch (InterruptedException ie) {
                    CCorePlugin.log(ie);
                }
            }
            Object var5_10 = null;
            this.index.releaseReadLock();
            return this.reference;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.index.releaseReadLock();
            throw throwable;
        }
    }

    private IndexTypeReference createReference(IIndexBinding binding, IIndexName indexName) throws CoreException {
        IIndexFileLocation ifl = indexName.getFile().getLocation();
        String fullPath = ifl.getFullPath();
        if (fullPath != null) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fullPath));
            if (file != null) {
                return new IndexTypeReference((IBinding)binding, (IResource)file, file.getProject(), indexName.getNodeOffset(), indexName.getNodeLength());
            }
        } else {
            IPath path = URIUtil.toPath((URI)ifl.getURI());
            if (path != null) {
                return new IndexTypeReference((IBinding)binding, path, null, indexName.getNodeOffset(), indexName.getNodeLength());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ITypeReference[] getReferences() {
        ArrayList<IndexTypeReference> references = new ArrayList<IndexTypeReference>();
        try {
            try {
                int i;
                IIndexBinding[] ibs;
                this.index.acquireReadLock();
                char[][] cfqn = new char[this.fqn.length][];
                int i2 = 0;
                while (true) {
                    if (i2 >= this.fqn.length) {
                        ibs = this.index.findBindings(cfqn, new IndexFilter(){

                            public boolean acceptBinding(IBinding binding) {
                                boolean sameType = IndexModelUtil.bindingHasCElementType(binding, new int[]{IndexTypeInfo.this.elementType});
                                if (sameType && binding instanceof IFunction && IndexTypeInfo.this.params != null) {
                                    try {
                                        Object[] otherParams = IndexModelUtil.extractParameterTypes((IFunction)binding);
                                        return Arrays.equals(IndexTypeInfo.this.params, otherParams);
                                    }
                                    catch (DOMException exc) {
                                        CCorePlugin.log(exc);
                                    }
                                }
                                return sameType;
                            }
                        }, (IProgressMonitor)new NullProgressMonitor());
                        i = 0;
                        break;
                    }
                    cfqn[i2] = this.fqn[i2].toCharArray();
                    ++i2;
                }
                block7: while (i < ibs.length) {
                    IIndexBinding binding = ibs[i];
                    IIndexName[] names = this.index.findNames(binding, 2);
                    if (names.length == 0) {
                        names = this.index.findNames(ibs[0], 1);
                    }
                    int j = 0;
                    while (true) {
                        if (j >= names.length) {
                            ++i;
                            continue block7;
                        }
                        IIndexName indexName = names[j];
                        IndexTypeReference ref = this.createReference(binding, indexName);
                        if (ref != null) {
                            references.add(ref);
                        }
                        ++j;
                    }
                }
            }
            catch (CoreException ce) {
                CCorePlugin.log(ce);
            }
            catch (InterruptedException ie) {
                CCorePlugin.log(ie);
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            this.index.releaseReadLock();
            throw throwable;
        }
        {
            Object var10_15 = null;
            this.index.releaseReadLock();
            return references.toArray(new IndexTypeReference[references.size()]);
        }
    }

    public ITypeInfo getRootNamespace(boolean includeGlobalNamespace) {
        throw new PDOMNotImplementedError();
    }

    public ITypeInfo[] getSubTypes() {
        throw new PDOMNotImplementedError();
    }

    public ASTAccessVisibility getSuperTypeAccess(ITypeInfo subType) {
        throw new PDOMNotImplementedError();
    }

    public ITypeInfo[] getSuperTypes() {
        throw new PDOMNotImplementedError();
    }

    public boolean hasEnclosedTypes() {
        throw new PDOMNotImplementedError();
    }

    public boolean hasSubTypes() {
        throw new PDOMNotImplementedError();
    }

    public boolean hasSuperTypes() {
        throw new PDOMNotImplementedError();
    }

    public boolean isClass() {
        throw new PDOMNotImplementedError();
    }

    public boolean isEnclosed(ITypeInfo info) {
        throw new PDOMNotImplementedError();
    }

    public boolean isEnclosed(ITypeSearchScope scope) {
        throw new PDOMNotImplementedError();
    }

    public boolean isEnclosedType() {
        throw new PDOMNotImplementedError();
    }

    public boolean isEnclosingType() {
        throw new PDOMNotImplementedError();
    }

    public boolean isReferenced(ITypeSearchScope scope) {
        throw new PDOMNotImplementedError();
    }

    public boolean isUndefinedType() {
        throw new PDOMNotImplementedError();
    }

    public void setCElementType(int type) {
        throw new PDOMNotImplementedError();
    }

    public int compareTo(Object arg0) {
        throw new PDOMNotImplementedError();
    }

    public String[] getParameters() {
        return this.params;
    }

    public String getReturnType() {
        return this.returnType;
    }
}

