/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;

public class CodeReader {
    public static final String SYSTEM_DEFAULT_ENCODING = System.getProperty("file.encoding");
    private static final String NF = "<text>";
    private static final char[] NOFILE = "<text>".toCharArray();
    private static final int MAX_FILE_SIZE = Integer.MAX_VALUE;
    public final char[] buffer;
    public final char[] filename;

    public CodeReader(String filename, char[] buffer) {
        this.filename = filename.toCharArray();
        this.buffer = buffer;
    }

    public CodeReader(char[] buffer) {
        this(NF, buffer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CodeReader(String filename) throws IOException {
        this.filename = filename.toCharArray();
        FileInputStream stream = new FileInputStream(filename);
        try {
            this.buffer = this.load(SYSTEM_DEFAULT_ENCODING, stream);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            stream.close();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        stream.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CodeReader(String filename, String charSet) throws IOException {
        this.filename = filename.toCharArray();
        FileInputStream stream = new FileInputStream(filename);
        try {
            this.buffer = this.load(charSet, stream);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            stream.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        stream.close();
    }

    public CodeReader(String filename, InputStream stream) throws IOException {
        this(filename, SYSTEM_DEFAULT_ENCODING, stream);
    }

    /*
     * Exception decompiling
     */
    public CodeReader(String fileName, String charSet, InputStream stream) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 74->78)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private char[] load(String charSet, FileInputStream stream) throws IOException {
        char[] buff;
        String encoding = Charset.isSupported(charSet) ? charSet : SYSTEM_DEFAULT_ENCODING;
        FileChannel channel = stream.getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)Math.min(channel.size(), Integer.MAX_VALUE));
        channel.read(byteBuffer);
        byteBuffer.flip();
        CharBuffer charBuffer = Charset.forName(encoding).decode(byteBuffer);
        if (charBuffer.hasArray() && charBuffer.arrayOffset() == 0 && (buff = charBuffer.array()).length == charBuffer.remaining()) {
            return buff;
        }
        buff = new char[charBuffer.remaining()];
        charBuffer.get(buff);
        return buff;
    }

    protected char[] xload(FileInputStream stream) throws IOException {
        FileChannel channel = stream.getChannel();
        MappedByteBuffer map = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        CharBuffer charBuffer = Charset.forName(SYSTEM_DEFAULT_ENCODING).decode(map);
        if (charBuffer.hasArray()) {
            return charBuffer.array();
        }
        char[] buff = new char[charBuffer.length()];
        charBuffer.get(buff);
        return buff;
    }

    public boolean isFile() {
        return !CharArrayUtils.equals(this.filename, NOFILE);
    }

    public String toString() {
        return this.getPath();
    }

    public String getPath() {
        return new String(this.filename);
    }
}

