/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IIncludeFileEntry;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IMacroFileEntry;
import org.eclipse.cdt.core.model.IOutputEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.resources.IPathEntryVariableManager;
import org.eclipse.cdt.core.settings.model.CExternalSetting;
import org.eclipse.cdt.core.settings.model.CIncludeFileEntry;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.CLibraryFileEntry;
import org.eclipse.cdt.core.settings.model.CMacroEntry;
import org.eclipse.cdt.core.settings.model.CMacroFileEntry;
import org.eclipse.cdt.core.settings.model.COutputEntry;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICExclusionPatternPathEntry;
import org.eclipse.cdt.core.settings.model.ICExternalSetting;
import org.eclipse.cdt.core.settings.model.ICIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICOutputEntry;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CBuildData;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CFileData;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.EntryNameKey;
import org.eclipse.cdt.core.settings.model.util.IKindBasedInfo;
import org.eclipse.cdt.core.settings.model.util.IPathSettingsContainerVisitor;
import org.eclipse.cdt.core.settings.model.util.KindBasedStore;
import org.eclipse.cdt.core.settings.model.util.PathEntryResolveInfo;
import org.eclipse.cdt.core.settings.model.util.PathEntryResolveInfoElement;
import org.eclipse.cdt.core.settings.model.util.PathSettingsContainer;
import org.eclipse.cdt.core.settings.model.util.UtilMessages;
import org.eclipse.cdt.internal.core.CdtVarPathEntryVariableManager;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.cdtvariables.CoreVariableSubstitutor;
import org.eclipse.cdt.internal.core.cdtvariables.DefaultVariableContextInfo;
import org.eclipse.cdt.internal.core.model.APathEntry;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.PathEntry;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescriptionCache;
import org.eclipse.cdt.internal.core.settings.model.IInternalCCfgInfo;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.cdt.utils.cdtvariables.SupplierBasedCdtVariableSubstitutor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PathEntryTranslator {
    public static final int OP_ADD = 1;
    public static final int OP_REMOVE = 2;
    public static final int OP_REPLACE = 3;
    public static final int INCLUDE_BUILT_INS = 1;
    public static final int INCLUDE_USER = 2;
    public static final int INCLUDE_ALL = 3;
    static String PATH_ENTRY = "pathentry";
    static String ATTRIBUTE_KIND = "kind";
    static String ATTRIBUTE_PATH = "path";
    static String ATTRIBUTE_BASE_PATH = "base-path";
    static String ATTRIBUTE_BASE_REF = "base-ref";
    static String ATTRIBUTE_EXPORTED = "exported";
    static String ATTRIBUTE_SOURCEPATH = "sourcepath";
    static String ATTRIBUTE_ROOTPATH = "roopath";
    static String ATTRIBUTE_PREFIXMAPPING = "prefixmapping";
    static String ATTRIBUTE_EXCLUDING = "excluding";
    static String ATTRIBUTE_INCLUDE = "include";
    static String ATTRIBUTE_INCLUDE_FILE = "include-file";
    static String ATTRIBUTE_LIBRARY = "library";
    static String ATTRIBUTE_SYSTEM = "system";
    static String ATTRIBUTE_NAME = "name";
    static String ATTRIBUTE_VALUE = "value";
    static String ATTRIBUTE_MACRO_FILE = "macro-file";
    static String VALUE_TRUE = "true";
    static final IPathEntry[] NO_PATHENTRIES = new IPathEntry[0];
    private static final char[] SPEC_CHARS = new char[]{'*', '?'};
    private PathSettingsContainer fRcDataHolder;
    private IProject fProject;
    private CConfigurationData fCfgData;
    private PathSettingsContainer fTranslatedFilters;
    private Map fResourceMap = new HashMap();
    private IWorkspaceRoot fRoot = ResourcesPlugin.getWorkspace().getRoot();

    private static ICLanguageSettingEntry createLangEntry(ResolvedEntry entry) {
        PathEntryValueInfo value = entry.getResolvedValue();
        int flags = 16;
        if (entry.isReadOnly()) {
            flags |= 2;
        }
        if (entry.isBuiltIn()) {
            flags |= 1;
        }
        switch (entry.fEntry.getEntryKind()) {
            case 1: {
                ILibraryEntry libEntry = (ILibraryEntry)entry.fEntry;
                IPath path = value.getFullPath();
                if (path != null) {
                    flags |= 8;
                } else {
                    path = value.getLocation();
                }
                if (path == null) break;
                return new CLibraryFileEntry(value.getName(), flags, libEntry.getSourceAttachmentPath(), libEntry.getSourceAttachmentRootPath(), libEntry.getSourceAttachmentPrefixMapping());
            }
            case 16: {
                IPath path = value.getFullPath();
                if (path != null) {
                    flags |= 8;
                } else {
                    path = value.getLocation();
                }
                if (path == null) break;
                return new CIncludePathEntry(value.getName(), flags);
            }
            case 64: {
                String name = value.getName();
                if (name.length() == 0) break;
                String mValue = value.getValue();
                return new CMacroEntry(name, mValue, flags);
            }
            case 256: {
                IPath path = value.getFullPath();
                if (path != null) {
                    flags |= 8;
                } else {
                    path = value.getLocation();
                }
                if (path == null) break;
                return new CIncludeFileEntry(value.getName(), flags);
            }
            case 512: {
                IPath path = value.getFullPath();
                if (path != null) {
                    flags |= 8;
                } else {
                    path = value.getLocation();
                }
                if (path == null) break;
                return new CMacroFileEntry(value.getName(), flags);
            }
        }
        return null;
    }

    private static String resolveAll(String value, ICConfigurationDescription cfg) {
        try {
            return CCorePlugin.getDefault().getCdtVariableManager().resolveValue(value, "", " ", cfg);
        }
        catch (CdtVariableException e) {
            CCorePlugin.log((Throwable)((Object)e));
            return value;
        }
    }

    private static String resolveKeepingPathEntryFars(String value, ICConfigurationDescription cfg) {
        try {
            VarSubstitutor substitutor = new VarSubstitutor(cfg);
            return CdtVariableResolver.resolveToString(value, substitutor);
        }
        catch (CdtVariableException e) {
            CCorePlugin.log((Throwable)((Object)e));
            return value;
        }
    }

    private static int lsKindToPeKind(int kind) {
        switch (kind) {
            case 2: {
                return 256;
            }
            case 1: {
                return 16;
            }
            case 4: {
                return 64;
            }
            case 8: {
                return 512;
            }
            case 16: {
                return 0;
            }
            case 32: {
                return 1;
            }
            case 64: {
                return 128;
            }
            case 128: {
                return 8;
            }
        }
        return 0;
    }

    private static LangEntryInfo createLangEntryInfo(ResolvedEntry entry) {
        ICLanguageSettingEntry le = PathEntryTranslator.createLangEntry(entry);
        if (le != null) {
            return new LangEntryInfo(le, entry);
        }
        return null;
    }

    private static boolean areEntriesReadOnly(PathEntryResolveInfoElement el) {
        switch (el.getRawEntry().getEntryKind()) {
            case 1: 
            case 8: 
            case 16: 
            case 64: 
            case 128: 
            case 256: 
            case 512: {
                return false;
            }
        }
        return true;
    }

    private IPath getEntryFullPath(IPathEntry entry) {
        IPath path = entry.getPath();
        if (path == null) {
            return this.fProject.getFullPath();
        }
        if (path.isAbsolute()) {
            return path;
        }
        return this.fProject.getFullPath().append(path);
    }

    private IPath[] obtainFilters(IPathEntry entry) {
        switch (entry.getEntryKind()) {
            case 8: 
            case 16: 
            case 64: 
            case 128: 
            case 256: {
                return ((APathEntry)entry).getExclusionPatterns();
            }
        }
        return new IPath[0];
    }

    public PathEntryTranslator(IProject project, CConfigurationData data) {
        this.fProject = project;
        this.fCfgData = data;
        this.fRcDataHolder = PathEntryTranslator.createRcDataHolder(data);
        this.fTranslatedFilters = PathSettingsContainer.createRootContainer();
        this.fTranslatedFilters.setValue(new ResourceInfo[]{new ResourceInfo((IResource)this.fRoot, true)});
    }

    private static PathSettingsContainer createRcDataHolder(CConfigurationData data) {
        return CDataUtil.createRcDataHolder(data);
    }

    public ReferenceSettingsInfo applyPathEntries(PathEntryResolveInfo info, int op) {
        ResolvedEntry[] rEntries = this.getResolvedEntries(info);
        return this.addPathEntries(rEntries, op);
    }

    private RcDesInfo getRcDesInfo(PathSettingsContainer cr, ResourceInfo rcInfo) {
        IResource rc = rcInfo.fRc;
        IPath projPath = rc.getProjectRelativePath();
        PathSettingsContainer child = cr.getChildContainer(projPath, true, true);
        RcDesInfo rcDes = (RcDesInfo)child.getValue();
        if (rcDes == null) {
            rcDes = new RcDesInfo(rcInfo);
            child.setValue(rcDes);
        }
        return rcDes;
    }

    private ReferenceSettingsInfo addPathEntries(ResolvedEntry[] rEntries, int op) {
        ICExternalSetting[] extSettings;
        PathSettingsContainer cr = PathSettingsContainer.createRootContainer();
        cr.setValue(new RcDesInfo(new ResourceInfo((IResource)this.fProject, true)));
        ArrayList<IPathEntry> srcList = new ArrayList<IPathEntry>();
        ArrayList<IPathEntry> outList = new ArrayList<IPathEntry>();
        ArrayList<ResolvedEntry> projList = new ArrayList<ResolvedEntry>();
        ArrayList<ResolvedEntry> exportSettingsList = new ArrayList<ResolvedEntry>();
        ICSourceEntry[] srcEntries = null;
        ICOutputEntry[] outEntries = null;
        int i = 0;
        while (i < rEntries.length) {
            ResolvedEntry rEntry = rEntries[i];
            if (!rEntry.isReadOnly()) {
                if (this.toLanguageEntryKind(rEntry.fEntry.getEntryKind()) == 0) {
                    switch (rEntry.fEntry.getEntryKind()) {
                        case 8: {
                            srcList.add(rEntry.fEntry);
                            break;
                        }
                        case 128: {
                            outList.add(rEntry.fEntry);
                            break;
                        }
                        case 4: {
                            projList.add(rEntry);
                        }
                    }
                } else {
                    if (rEntry.getEntry().isExported()) {
                        exportSettingsList.add(rEntry);
                    }
                    ResourceInfo rcInfo = rEntry.getResourceInfo();
                    RcDesInfo rcDes = this.getRcDesInfo(cr, rcInfo);
                    rcDes.fResolvedEntries.add(rEntry);
                    ResourceInfo[] fInfos = rEntry.getFilterInfos();
                    int k = 0;
                    while (k < fInfos.length) {
                        this.getRcDesInfo(cr, fInfos[k]);
                        ++k;
                    }
                }
            }
            ++i;
        }
        if (srcList.size() != 0) {
            srcEntries = PathEntryTranslator.toCSourceEntries(srcList);
        }
        if (outList.size() != 0) {
            outEntries = PathEntryTranslator.toCOutputEntries(outList);
        }
        this.propagateValues(cr, new ArrayList(0));
        this.applyOutputEntries(outEntries, op);
        this.applySourceEntries(srcEntries, op);
        this.applyLangSettings(cr, op);
        IPath[] refProjPaths = new IPath[projList.size()];
        int i2 = 0;
        while (i2 < refProjPaths.length) {
            ResolvedEntry e = (ResolvedEntry)projList.get(i2);
            refProjPaths[i2] = e.getResourceInfo().fRc.getFullPath();
            ++i2;
        }
        if (exportSettingsList.size() != 0) {
            extSettings = new ICExternalSetting[1];
            ArrayList<ICLanguageSettingEntry> list = new ArrayList<ICLanguageSettingEntry>(exportSettingsList.size());
            int i3 = 0;
            while (i3 < exportSettingsList.size()) {
                ResolvedEntry re = (ResolvedEntry)exportSettingsList.get(i3);
                ICLanguageSettingEntry le = PathEntryTranslator.createLangEntry(re);
                if (le != null) {
                    list.add(le);
                }
                ++i3;
            }
            ICSettingEntry[] expEntries = list.toArray(new ICLanguageSettingEntry[list.size()]);
            extSettings[0] = new CExternalSetting(null, null, null, expEntries);
        } else {
            extSettings = new ICExternalSetting[]{};
        }
        return new ReferenceSettingsInfo(refProjPaths, extSettings);
    }

    private static ICSourceEntry[] toCSourceEntries(List list) {
        ICSourceEntry[] entries = new ICSourceEntry[list.size()];
        int i = 0;
        while (i < entries.length) {
            entries[i] = PathEntryTranslator.toCSourceEntry((ISourceEntry)list.get(i), true);
            ++i;
        }
        return entries;
    }

    private static ICOutputEntry[] toCOutputEntries(List list) {
        ICOutputEntry[] entries = new ICOutputEntry[list.size()];
        int i = 0;
        while (i < entries.length) {
            entries[i] = PathEntryTranslator.toCOutputEntry((IOutputEntry)list.get(i), true);
            ++i;
        }
        return entries;
    }

    private static ICSourceEntry toCSourceEntry(ISourceEntry entry, boolean makeProjRelative) {
        IPath path = entry.getPath();
        if (makeProjRelative && path.isAbsolute()) {
            path = path.removeFirstSegments(1);
        }
        return new CSourceEntry(path, entry.getExclusionPatterns(), 24);
    }

    private static ICOutputEntry toCOutputEntry(IOutputEntry entry, boolean makeProjRelative) {
        IPath path = entry.getPath();
        if (makeProjRelative && path.isAbsolute()) {
            path = path.removeFirstSegments(1);
        }
        return new COutputEntry(path, entry.getExclusionPatterns(), 24);
    }

    private static ICSettingEntry[] replaceUserEntries(ICSettingEntry[] oldEntries, ICSettingEntry[] newUsrEntries) {
        ICSettingEntry entry;
        int i;
        LinkedHashSet<ICSettingEntry> set = new LinkedHashSet<ICSettingEntry>();
        Class<?> componentType = null;
        if (newUsrEntries != null) {
            i = 0;
            while (i < newUsrEntries.length) {
                entry = newUsrEntries[i];
                if (!entry.isBuiltIn() && !entry.isReadOnly()) {
                    set.add(entry);
                }
                ++i;
            }
            componentType = newUsrEntries.getClass().getComponentType();
        }
        if (oldEntries != null) {
            i = 0;
            while (i < oldEntries.length) {
                entry = oldEntries[i];
                if (entry.isBuiltIn() || entry.isReadOnly()) {
                    set.add(entry);
                }
                ++i;
            }
            if (componentType == null) {
                componentType = oldEntries.getClass().getComponentType();
            }
        }
        if (componentType != null) {
            ICSettingEntry[] result = (ICSettingEntry[])Array.newInstance(componentType, set.size());
            set.toArray(result);
            return result;
        }
        return null;
    }

    private void applySourceEntries(ICSourceEntry[] entries, int op) {
        ICSettingEntry[] oldEntries = this.fCfgData.getSourceEntries();
        oldEntries = (ICSourceEntry[])CDataUtil.makeRelative(this.fProject, (ICExclusionPatternPathEntry[])oldEntries, true);
        entries = (ICSourceEntry[])CDataUtil.makeRelative(this.fProject, entries, true);
        entries = (ICSourceEntry[])PathEntryTranslator.replaceUserEntries(oldEntries, entries);
        switch (op) {
            case 1: {
                if (entries == null || entries.length == 0) break;
                LinkedHashSet<ICSettingEntry> set = new LinkedHashSet<ICSettingEntry>();
                set.addAll(Arrays.asList(oldEntries));
                set.addAll(Arrays.asList(entries));
                this.fCfgData.setSourceEntries(set.toArray(new ICSourceEntry[set.size()]));
                break;
            }
            case 2: {
                if (entries == null || entries.length == 0) break;
                HashSet<ICSettingEntry> set = new HashSet<ICSettingEntry>();
                set.addAll(Arrays.asList(oldEntries));
                set.removeAll(Arrays.asList(entries));
                this.fCfgData.setSourceEntries(set.toArray(new ICSourceEntry[set.size()]));
                break;
            }
            default: {
                if (entries != null) {
                    this.fCfgData.setSourceEntries(entries);
                    break;
                }
                this.fCfgData.setSourceEntries(new ICSourceEntry[0]);
            }
        }
    }

    private void applyOutputEntries(ICOutputEntry[] entries, int op) {
        CBuildData bData = this.fCfgData.getBuildData();
        if (bData == null) {
            CCorePlugin.log(UtilMessages.getString("PathEntryTranslator.2"));
            return;
        }
        ICSettingEntry[] oldEntries = bData.getOutputDirectories();
        oldEntries = (ICOutputEntry[])CDataUtil.makeRelative(this.fProject, (ICExclusionPatternPathEntry[])oldEntries, true);
        entries = (ICOutputEntry[])CDataUtil.makeRelative(this.fProject, entries, true);
        entries = (ICOutputEntry[])PathEntryTranslator.replaceUserEntries(oldEntries, entries);
        switch (op) {
            case 1: {
                if (entries == null || entries.length == 0) break;
                LinkedHashSet<ICSettingEntry> set = new LinkedHashSet<ICSettingEntry>();
                set.addAll(Arrays.asList(oldEntries));
                set.addAll(Arrays.asList(entries));
                bData.setOutputDirectories(set.toArray(new ICOutputEntry[set.size()]));
                break;
            }
            case 2: {
                if (entries == null || entries.length == 0) break;
                HashSet<ICSettingEntry> set = new HashSet<ICSettingEntry>();
                set.addAll(Arrays.asList(oldEntries));
                set.removeAll(Arrays.asList(entries));
                bData.setOutputDirectories(set.toArray(new ICOutputEntry[set.size()]));
                break;
            }
            default: {
                if (entries != null) {
                    bData.setOutputDirectories(entries);
                    break;
                }
                bData.setOutputDirectories(new ICOutputEntry[0]);
            }
        }
    }

    private void applyLangSettings(PathSettingsContainer cr, int op) {
        PathSettingsContainer[] crs = cr.getChildren(true);
        int i = 0;
        while (i < crs.length) {
            PathSettingsContainer cur = crs[i];
            RcDesInfo desInfo = (RcDesInfo)cur.getValue();
            try {
                CResourceData rcData = this.getResourceData(cur.getPath(), true, true);
                this.applyEntries(rcData, desInfo, op);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
            ++i;
        }
        CResourceData[] rcDatas = this.getResourceDatas();
        int i2 = 0;
        while (i2 < rcDatas.length) {
            CResourceData rcData = rcDatas[i2];
            PathSettingsContainer c = cr.getChildContainer(rcData.getPath(), false, false);
            if (!cr.getPath().makeRelative().equals((Object)rcData.getPath().makeRelative())) {
                RcDesInfo desInfo = (RcDesInfo)c.getValue();
                this.applyEntries(rcData, desInfo, op);
            }
            ++i2;
        }
    }

    private CResourceData[] getResourceDatas() {
        PathSettingsContainer[] crs = this.fRcDataHolder.getChildren(true);
        ArrayList<Object> list = new ArrayList<Object>(crs.length);
        int i = 0;
        while (i < crs.length) {
            list.add(crs[i].getValue());
            ++i;
        }
        return list.toArray(new CResourceData[list.size()]);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private CResourceData getResourceData(IPath path, boolean create, boolean exactPath) throws CoreException {
        block4: {
            block5: {
                rcDataH = this.fRcDataHolder.getChildContainer(path, false, exactPath);
                if (rcDataH != null) {
                    return (CResourceData)rcDataH.getValue();
                }
                if (!create) break block4;
                rcInfo = this.findResourceInfo((IContainer)this.fProject, path, true);
                base = this.getResourceData(path, false, false);
                if (rcInfo.fRc.getType() != 1) ** GOTO lbl17
                if (base.getType() == 8) {
                    newRcData /* !! */  = this.fCfgData.createFileData(path, (CFileData)base);
                } else {
                    folderData = (CFolderData)base;
                    lDatas = folderData.getLanguageDatas();
                    baseLData = CDataUtil.findLanguagDataForFile(rcInfo.fRc.getFullPath().lastSegment(), this.fProject, lDatas);
                    newRcData /* !! */  = this.fCfgData.createFileData(path, folderData, baseLData);
                }
                break block5;
lbl-1000:
                // 1 sources

                {
                    base = this.getResourceData(base.getPath().removeLastSegments(1), false, false);
lbl17:
                    // 2 sources

                    ** while (base.getType() == 8)
                }
lbl18:
                // 1 sources

                newRcData /* !! */  = this.fCfgData.createFolderData(path, (CFolderData)base);
            }
            this.fRcDataHolder.getChildContainer(path, true, true).setValue(newRcData /* !! */ );
            return newRcData /* !! */ ;
        }
        return null;
    }

    private void applyEntries(CResourceData data, RcDesInfo info, int op) {
        CLanguageData[] cLanguageDataArray;
        if (data.getType() == 8) {
            CLanguageData[] cLanguageDataArray2 = new CLanguageData[1];
            cLanguageDataArray = cLanguageDataArray2;
            cLanguageDataArray2[0] = ((CFileData)data).getLanguageData();
        } else {
            cLanguageDataArray = ((CFolderData)data).getLanguageDatas();
        }
        CLanguageData[] lDatas = cLanguageDataArray;
        int i = 0;
        while (i < lDatas.length) {
            CLanguageData lData = lDatas[i];
            if (lData != null) {
                this.applyEntries(lData, info, op);
            }
            ++i;
        }
    }

    private void applyEntries(CLanguageData lData, RcDesInfo info, int op) {
        int[] kinds = KindBasedStore.getLanguageEntryKinds();
        int supported = lData.getSupportedEntryKinds();
        int i = 0;
        while (i < kinds.length) {
            int kind = kinds[i];
            if ((supported & kind) != 0) {
                ICSettingEntry[] opEntries = info.getEntries(kind);
                ICSettingEntry[] oldEntries = lData.getEntries(kind);
                opEntries = (ICLanguageSettingEntry[])PathEntryTranslator.replaceUserEntries(oldEntries, opEntries);
                if (op == 3) {
                    oldEntries = null;
                }
                ICLanguageSettingEntry[] result = this.composeNewEntries((ICLanguageSettingEntry[])oldEntries, (ICLanguageSettingEntry[])opEntries, op);
                lData.setEntries(kind, result);
            }
            ++i;
        }
    }

    private ICLanguageSettingEntry[] composeNewEntries(ICLanguageSettingEntry[] oldEntries, ICLanguageSettingEntry[] newEntries, int op) {
        ICLanguageSettingEntry[] result;
        switch (op) {
            case 1: {
                HashSet<ICLanguageSettingEntry> oldSet = new HashSet<ICLanguageSettingEntry>(Arrays.asList(oldEntries));
                HashSet<ICLanguageSettingEntry> newSet = new HashSet<ICLanguageSettingEntry>(Arrays.asList(newEntries));
                newSet.removeAll(oldSet);
                if (newSet.size() == 0) {
                    result = oldEntries;
                    break;
                }
                result = new ICLanguageSettingEntry[oldEntries.length + newSet.size()];
                newSet.toArray(result);
                System.arraycopy(oldEntries, 0, result, newSet.size(), oldEntries.length);
                break;
            }
            case 2: {
                HashSet<ICLanguageSettingEntry> oldSet = new HashSet<ICLanguageSettingEntry>(Arrays.asList(oldEntries));
                HashSet<ICLanguageSettingEntry> newSet = new HashSet<ICLanguageSettingEntry>(Arrays.asList(newEntries));
                oldSet.removeAll(newSet);
                if (oldSet.size() == 0) {
                    result = new ICLanguageSettingEntry[]{};
                    break;
                }
                result = new ICLanguageSettingEntry[oldSet.size()];
                oldSet.toArray(result);
                break;
            }
            default: {
                result = newEntries;
            }
        }
        return result;
    }

    private PathEntryKyndStore sort(ResolvedEntry[] rEntries, PathEntryKyndStore store) {
        if (store == null) {
            store = new PathEntryKyndStore();
        }
        int i = 0;
        while (i < rEntries.length) {
            ResolvedEntry rEntry = rEntries[i];
            ArrayList<ResolvedEntry> list = (ArrayList<ResolvedEntry>)store.get(rEntry.fEntry.getEntryKind());
            if (list == null) {
                list = new ArrayList<ResolvedEntry>();
                store.put(rEntry.fEntry.getEntryKind(), list);
            }
            list.add(rEntry);
            ++i;
        }
        return store;
    }

    public ReferenceSettingsInfo applyPathEntries(IPathEntry[] usrEntries, IPathEntry[] sysEntries, int op) {
        ResolvedEntry[] rEntries = this.getResolvedEntries(usrEntries, sysEntries);
        return this.addPathEntries(rEntries, op);
    }

    private void propagateValues(PathSettingsContainer cr, List langEntryInfoList) {
        RcDesInfo rcDes = (RcDesInfo)cr.getValue();
        if (rcDes != null) {
            List rEntries = rcDes.fResolvedEntries;
            ArrayList<LangEntryInfo> curLanfInfos = new ArrayList<LangEntryInfo>(rEntries.size() + langEntryInfoList.size());
            Iterator iter = rEntries.iterator();
            while (iter.hasNext()) {
                ResolvedEntry re = (ResolvedEntry)iter.next();
                LangEntryInfo li = PathEntryTranslator.createLangEntryInfo(re);
                if (li == null) continue;
                curLanfInfos.add(li);
            }
            curLanfInfos.addAll(langEntryInfoList);
            langEntryInfoList = curLanfInfos;
        }
        Iterator iter = langEntryInfoList.iterator();
        while (iter.hasNext()) {
            LangEntryInfo li = (LangEntryInfo)iter.next();
            rcDes.add(li);
        }
        PathSettingsContainer[] directChildren = cr.getDirectChildren();
        int i = 0;
        while (i < directChildren.length) {
            this.filterAndPropagate(directChildren[i], langEntryInfoList);
            ++i;
        }
    }

    private void filterAndPropagate(PathSettingsContainer cr, List list) {
        list = new ArrayList(list);
        IPath path = cr.getPath();
        Iterator iter = list.iterator();
        block0: while (iter.hasNext()) {
            LangEntryInfo li = (LangEntryInfo)iter.next();
            ResolvedEntry re = li.fResolvedEntry;
            ResourceInfo[] filters = re.getFilterInfos();
            int i = 0;
            while (i < filters.length) {
                IResource rc = filters[i].fRc;
                IPath projPath = rc.getProjectRelativePath();
                if (projPath.isPrefixOf(path.makeRelative())) {
                    iter.remove();
                    continue block0;
                }
                ++i;
            }
        }
        this.propagateValues(cr, list);
    }

    private int toLanguageEntryKind(int peKind) {
        switch (peKind) {
            case 1: {
                return 32;
            }
            case 16: {
                return 1;
            }
            case 64: {
                return 4;
            }
            case 256: {
                return 2;
            }
            case 512: {
                return 8;
            }
        }
        return 0;
    }

    private static int peKindToSettingKind(int peKind) {
        switch (peKind) {
            case 1: {
                return 32;
            }
            case 8: {
                return 128;
            }
            case 16: {
                return 1;
            }
            case 64: {
                return 4;
            }
            case 128: {
                return 64;
            }
            case 256: {
                return 2;
            }
            case 512: {
                return 8;
            }
        }
        return 0;
    }

    private ResolvedEntry[] getResolvedEntries(PathEntryResolveInfo info) {
        PathEntryResolveInfoElement[] els = info.getElements();
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < els.length) {
            this.getResolvedEntries(els[i], list);
            ++i;
        }
        return list.toArray(new ResolvedEntry[list.size()]);
    }

    private List getResolvedEntries(PathEntryResolveInfoElement el, List list) {
        ResolvedEntry resolvedE;
        if (list == null) {
            list = new ArrayList<ResolvedEntry>();
        }
        IPathEntry[] rpEntries = el.getResolvedEntries();
        IPathEntry rawEntry = el.getRawEntry();
        if (rawEntry.getEntryKind() == 4 && (resolvedE = this.createResolvedEntry(rawEntry, el)) != null) {
            list.add(resolvedE);
        }
        int i = 0;
        while (i < rpEntries.length) {
            IPathEntry rpEntry = rpEntries[i];
            resolvedE = this.createResolvedEntry(rpEntry, el);
            if (resolvedE != null) {
                list.add(resolvedE);
            }
            ++i;
        }
        return list;
    }

    private ResolvedEntry createResolvedEntry(IPathEntry entry, PathEntryResolveInfoElement el) {
        switch (entry.getEntryKind()) {
            case 32: {
                return null;
            }
        }
        return new ResolvedEntry(entry, el);
    }

    private ResolvedEntry[] getResolvedEntries(IPathEntry[] usrEntries, IPathEntry[] sysEntries) {
        int i;
        int length;
        int n = length = usrEntries != null ? usrEntries.length : 0;
        if (sysEntries != null) {
            length += sysEntries.length;
        }
        ResolvedEntry[] rEntries = new ResolvedEntry[length];
        int num = 0;
        if (usrEntries != null) {
            i = 0;
            while (i < usrEntries.length) {
                rEntries[num++] = new ResolvedEntry(usrEntries[i], false);
                ++i;
            }
        }
        if (sysEntries != null) {
            i = 0;
            while (i < sysEntries.length) {
                rEntries[num++] = new ResolvedEntry(sysEntries[i], true);
                ++i;
            }
        }
        return rEntries;
    }

    private ResourceInfo[] resolveFilter(IContainer container, IPath path) {
        ResourceInfo[] result;
        IPath containerFullPath = container.getFullPath();
        IPath fullPath = containerFullPath.append(path);
        PathSettingsContainer cr = this.fTranslatedFilters.getChildContainer(fullPath, false, false);
        ResourceInfo[] baseInfos = (ResourceInfo[])cr.getValue();
        if (!baseInfos[0].fExists) {
            ResourceInfo inexistent = new ResourceInfo((IResource)container.getFolder(path), false);
            result = new ResourceInfo[]{inexistent};
        } else {
            IPath baseTranslatedPath = cr.getPath();
            if (baseTranslatedPath.equals((Object)fullPath)) {
                result = baseInfos;
            } else if (containerFullPath.isPrefixOf(baseTranslatedPath)) {
                IPath filterToTranslate = fullPath.removeFirstSegments(baseTranslatedPath.segmentCount());
                result = this.performTranslation(baseTranslatedPath, baseInfos, filterToTranslate);
            } else {
                throw new IllegalStateException();
            }
        }
        return result;
    }

    private ResourceInfo[] performTranslation(IPath basePath, ResourceInfo[] baseInfos, IPath filter) {
        ResourceInfo[] result;
        int segCount = filter.segmentCount();
        int i = 0;
        while (i < segCount) {
            if (!baseInfos[0].fExists) break;
            String seg = filter.segment(0);
            baseInfos = this.performTranslation(basePath, baseInfos, seg);
            basePath = basePath.append(seg);
            filter = filter.removeFirstSegments(1);
            ++i;
        }
        if (i < segCount) {
            result = new ResourceInfo[baseInfos.length];
            int k = 0;
            while (k < baseInfos.length) {
                ResourceInfo baseInfo = baseInfos[k];
                IFolder rc = (IFolder)baseInfo.fRc;
                rc = rc.getFolder(filter);
                result[k] = new ResourceInfo((IResource)rc, false);
                ++k;
            }
        } else {
            result = baseInfos;
        }
        return result;
    }

    private ResourceInfo[] performTranslation(IPath basePath, ResourceInfo[] baseInfos, String seg) {
        IPath filterFullPath = basePath.append(seg);
        boolean needsParsing = this.hasSpecChars(seg);
        ArrayList<ResourceInfo> list = new ArrayList<ResourceInfo>();
        char[] segChars = seg.toCharArray();
        int i = 0;
        while (i < baseInfos.length) {
            ResourceInfo baseInfo = baseInfos[i];
            IResource baseRc = baseInfo.fRc;
            if (baseRc.getType() != 1) {
                IContainer baseCr = (IContainer)baseRc;
                IResource rc = baseCr.findMember(seg);
                if (rc != null) {
                    ResourceInfo rcInfo = new ResourceInfo(rc, true);
                    this.addRcInfoToMap(rcInfo);
                    list.add(rcInfo);
                } else if (needsParsing) {
                    try {
                        IResource[] children = baseCr.members();
                        int k = 0;
                        while (k < children.length) {
                            if (CoreModelUtil.match(segChars, children[i].getName().toCharArray(), true)) {
                                ResourceInfo rcInfo = new ResourceInfo(children[i], true);
                                this.addRcInfoToMap(rcInfo);
                                list.add(rcInfo);
                            }
                            ++k;
                        }
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                }
            }
            ++i;
        }
        if (list.size() == 0) {
            IFolder f = this.fRoot.getFolder(filterFullPath);
            ResourceInfo rcInfo = new ResourceInfo((IResource)f, false);
            this.addRcInfoToMap(rcInfo);
            list.add(rcInfo);
        }
        ResourceInfo[] result = new ResourceInfo[list.size()];
        list.toArray(result);
        this.addResolvedFilterToMap(filterFullPath, result, false);
        return result;
    }

    private boolean hasSpecChars(String str) {
        int i = 0;
        while (i < SPEC_CHARS.length) {
            if (str.indexOf(SPEC_CHARS[i]) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void addResolvedFilterToMap(IPath fullFilterPath, ResourceInfo[] resolved, boolean check) {
        PathSettingsContainer cr;
        if (check) {
            cr = this.fTranslatedFilters.getChildContainer(fullFilterPath, false, false);
            ResourceInfo[] infos = (ResourceInfo[])cr.getValue();
            if (!infos[0].fExists) {
                return;
            }
        }
        cr = this.fTranslatedFilters.getChildContainer(fullFilterPath, true, true);
        cr.setValue(resolved);
    }

    private ResourceInfo findResourceInfo(IContainer container, IPath relPath, boolean folderIfNotExist) {
        IPath fullPath = container.getFullPath().append(relPath);
        ResourceInfo rcInfo = (ResourceInfo)this.fResourceMap.get(fullPath);
        if (rcInfo == null) {
            Object rc = container.findMember(relPath);
            boolean exists = true;
            if (rc == null) {
                exists = false;
                rc = container.getType() == 8 && relPath.segmentCount() == 1 ? this.fRoot.getProject(relPath.segment(0)) : (folderIfNotExist ? container.getFolder(relPath) : container.getFile(relPath));
            }
            rcInfo = new ResourceInfo((IResource)rc, exists);
            this.addRcInfoToMap(rcInfo);
        }
        return rcInfo;
    }

    private void addRcInfoToMap(ResourceInfo rcInfo) {
        IPath fullPath = rcInfo.fRc.getFullPath();
        this.fResourceMap.put(fullPath, rcInfo);
        this.addResolvedFilterToMap(fullPath, new ResourceInfo[]{rcInfo}, true);
    }

    public static IPathEntry[] decodePathEntries(IProject project, ICStorageElement el) {
        ArrayList<IPathEntry> pathEntries = new ArrayList<IPathEntry>();
        ICStorageElement[] children = el.getChildren();
        int i = 0;
        while (i < children.length) {
            ICStorageElement child = children[i];
            if (child.getName().equals(PATH_ENTRY)) {
                try {
                    pathEntries.add(PathEntryTranslator.decodePathEntry(project, child));
                }
                catch (CModelException e) {
                    CCorePlugin.log((Throwable)((Object)e));
                }
            }
            ++i;
        }
        IPathEntry[] entries = new IPathEntry[pathEntries.size()];
        pathEntries.toArray(entries);
        return entries;
    }

    private static String getAttribute(ICStorageElement el, String attr) {
        String v = el.getAttribute(attr);
        if (v != null) {
            return v;
        }
        return "";
    }

    static IPathEntry decodePathEntry(IProject project, ICStorageElement element) throws CModelException {
        char[][] patterns;
        int patternCount;
        Path path;
        IPath projectPath = project.getFullPath();
        String kindAttr = PathEntryTranslator.getAttribute(element, ATTRIBUTE_KIND);
        int kind = PathEntry.kindFromString(kindAttr);
        boolean isExported = false;
        if (element.getAttribute(ATTRIBUTE_EXPORTED) != null) {
            isExported = element.getAttribute(ATTRIBUTE_EXPORTED).equals(VALUE_TRUE);
        }
        if (!(path = element.getAttribute(ATTRIBUTE_PATH) != null ? new Path(element.getAttribute(ATTRIBUTE_PATH)) : new Path("")).isAbsolute()) {
            path = projectPath.append((IPath)path);
        }
        Path basePath = new Path(PathEntryTranslator.getAttribute(element, ATTRIBUTE_BASE_PATH));
        Path baseRef = new Path(PathEntryTranslator.getAttribute(element, ATTRIBUTE_BASE_REF));
        String exclusion = PathEntryTranslator.getAttribute(element, ATTRIBUTE_EXCLUDING);
        IPath[] exclusionPatterns = APathEntry.NO_EXCLUSION_PATTERNS;
        if (exclusion != null && exclusion.length() > 0 && (patternCount = (patterns = CharOperation.splitOn('|', exclusion.toCharArray())).length) > 0) {
            exclusionPatterns = new IPath[patternCount];
            int j = 0;
            while (j < patterns.length) {
                exclusionPatterns[j] = new Path(new String(patterns[j]));
                ++j;
            }
        }
        switch (kind) {
            case 4: {
                return CoreModel.newProjectEntry((IPath)path, isExported);
            }
            case 1: {
                Path sourceAttachmentPrefixMapping;
                Path libraryPath = new Path(PathEntryTranslator.getAttribute(element, ATTRIBUTE_LIBRARY));
                Path sourceAttachmentPath = element.getAttribute(ATTRIBUTE_SOURCEPATH) != null ? new Path(element.getAttribute(ATTRIBUTE_SOURCEPATH)) : null;
                Path sourceAttachmentRootPath = element.getAttribute(ATTRIBUTE_ROOTPATH) != null ? new Path(element.getAttribute(ATTRIBUTE_ROOTPATH)) : null;
                Path path2 = sourceAttachmentPrefixMapping = element.getAttribute(ATTRIBUTE_PREFIXMAPPING) != null ? new Path(element.getAttribute(ATTRIBUTE_PREFIXMAPPING)) : null;
                if (baseRef != null && !baseRef.isEmpty()) {
                    return CoreModel.newLibraryRefEntry((IPath)path, (IPath)baseRef, (IPath)libraryPath);
                }
                return CoreModel.newLibraryEntry((IPath)path, (IPath)basePath, (IPath)libraryPath, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath, (IPath)sourceAttachmentPrefixMapping, isExported);
            }
            case 8: {
                String projSegment = path.segment(0);
                if (projSegment != null && projSegment.equals(project.getName())) {
                    return CoreModel.newSourceEntry((IPath)path, exclusionPatterns);
                }
                return CoreModel.newProjectEntry((IPath)path, isExported);
            }
            case 128: {
                return CoreModel.newOutputEntry((IPath)path, exclusionPatterns);
            }
            case 16: {
                Path includePath = new Path(PathEntryTranslator.getAttribute(element, ATTRIBUTE_INCLUDE));
                boolean isSystemInclude = false;
                if (element.getAttribute(ATTRIBUTE_SYSTEM) != null) {
                    isSystemInclude = PathEntryTranslator.getAttribute(element, ATTRIBUTE_SYSTEM).equals(VALUE_TRUE);
                }
                if (baseRef != null && !baseRef.isEmpty()) {
                    return CoreModel.newIncludeRefEntry((IPath)path, (IPath)baseRef, (IPath)includePath);
                }
                return CoreModel.newIncludeEntry((IPath)path, (IPath)basePath, (IPath)includePath, isSystemInclude, exclusionPatterns, isExported);
            }
            case 256: {
                Path includeFilePath = new Path(PathEntryTranslator.getAttribute(element, ATTRIBUTE_INCLUDE_FILE));
                return CoreModel.newIncludeFileEntry((IPath)path, (IPath)basePath, (IPath)baseRef, (IPath)includeFilePath, exclusionPatterns, isExported);
            }
            case 64: {
                String macroName = PathEntryTranslator.getAttribute(element, ATTRIBUTE_NAME);
                String macroValue = PathEntryTranslator.getAttribute(element, ATTRIBUTE_VALUE);
                if (baseRef != null && !baseRef.isEmpty()) {
                    return CoreModel.newMacroRefEntry((IPath)path, (IPath)baseRef, macroName);
                }
                return CoreModel.newMacroEntry((IPath)path, macroName, macroValue, exclusionPatterns, isExported);
            }
            case 512: {
                Path macroFilePath = new Path(PathEntryTranslator.getAttribute(element, ATTRIBUTE_MACRO_FILE));
                return CoreModel.newMacroFileEntry((IPath)path, (IPath)basePath, (IPath)baseRef, (IPath)macroFilePath, exclusionPatterns, isExported);
            }
            case 32: {
                Path id = new Path(PathEntryTranslator.getAttribute(element, ATTRIBUTE_PATH));
                return CoreModel.newContainerEntry((IPath)id, isExported);
            }
        }
        CModelStatus status = new CModelStatus(4, "PathEntry: unknown kind (" + kindAttr + ")");
        throw new CModelException(status);
    }

    private static CConfigurationData getCfgData(ICConfigurationDescription cfgDes) {
        return cfgDes instanceof CConfigurationDescriptionCache ? (CConfigurationData)((Object)cfgDes) : ((IInternalCCfgInfo)((Object)cfgDes)).getConfigurationData(false);
    }

    private static void addOutputEntries(PathEntryCollector cr, CConfigurationData data) {
        ICExclusionPatternPathEntry[] oEntries;
        CBuildData bData = data.getBuildData();
        if (bData != null && (oEntries = bData.getOutputDirectories()) != null && oEntries.length != 0) {
            cr.setSourceOutputEntries(64, oEntries);
        }
    }

    public static PathEntryCollector collectEntries(IProject project, ICConfigurationDescription des) {
        ICConfigurationDescription[] iCConfigurationDescriptionArray;
        CConfigurationData data = PathEntryTranslator.getCfgData(des);
        ReferenceSettingsInfo refInfo = new ReferenceSettingsInfo(des);
        if (des.isPreferenceConfiguration()) {
            ICConfigurationDescription[] iCConfigurationDescriptionArray2 = new ICConfigurationDescription[1];
            iCConfigurationDescriptionArray = iCConfigurationDescriptionArray2;
            iCConfigurationDescriptionArray2[0] = des;
        } else {
            iCConfigurationDescriptionArray = des.getProjectDescription().getConfigurations();
        }
        ICConfigurationDescription[] allCfgs = iCConfigurationDescriptionArray;
        CConfigurationData[] allDatas = new CConfigurationData[allCfgs.length];
        int i = 0;
        while (i < allCfgs.length) {
            allDatas[i] = PathEntryTranslator.getCfgData(allCfgs[i]);
            ++i;
        }
        final PathEntryCollector cr = new PathEntryCollector(project);
        PathSettingsContainer rcDatas = PathEntryTranslator.createRcDataHolder(data);
        ICExclusionPatternPathEntry[] sEntries = data.getSourceEntries();
        if (sEntries != null && sEntries.length != 0) {
            cr.setSourceOutputEntries(128, sEntries);
        }
        int i2 = 0;
        while (i2 < allDatas.length) {
            PathEntryTranslator.addOutputEntries(cr, allDatas[i2]);
            ++i2;
        }
        final HashSet<ICSettingEntry> exportedSettings = new HashSet<ICSettingEntry>();
        if (refInfo != null) {
            cr.setRefProjects(refInfo.getReferencedProjectsPaths());
            ICExternalSetting[] settings = refInfo.getExternalSettings();
            int i3 = 0;
            while (i3 < settings.length) {
                exportedSettings.addAll(Arrays.asList(settings[i3].getEntries()));
                ++i3;
            }
        }
        final int[] kinds = KindBasedStore.getLanguageEntryKinds();
        rcDatas.accept(new IPathSettingsContainerVisitor(){

            public boolean visit(PathSettingsContainer container) {
                CResourceData data = (CResourceData)container.getValue();
                PathEntryCollector child = cr.createChild(container.getPath());
                int i = 0;
                while (i < kinds.length) {
                    ArrayList list = new ArrayList();
                    if (PathEntryTranslator.collectEntries(kinds[i], data, list)) {
                        ICLanguageSettingEntry[] entries = list.toArray(new ICLanguageSettingEntry[list.size()]);
                        child.setEntries(kinds[i], entries, exportedSettings);
                    }
                    ++i;
                }
                return true;
            }
        });
        return cr;
    }

    private static boolean collectEntries(int kind, CResourceData data, List list) {
        if (data.getType() == 4) {
            return PathEntryTranslator.collectEntries(kind, (CFolderData)data, list);
        }
        return PathEntryTranslator.collectEntries(kind, (CFileData)data, list);
    }

    private static boolean collectEntries(int kind, CFolderData data, List list) {
        CLanguageData[] lDatas = data.getLanguageDatas();
        boolean supported = false;
        if (lDatas != null && lDatas.length != 0) {
            int i = 0;
            while (i < lDatas.length) {
                if (PathEntryTranslator.collectEntries(kind, lDatas[i], list)) {
                    supported = true;
                }
                ++i;
            }
        }
        return supported;
    }

    private static boolean collectEntries(int kind, CFileData data, List list) {
        CLanguageData lData = data.getLanguageData();
        if (lData != null) {
            return PathEntryTranslator.collectEntries(kind, lData, list);
        }
        return false;
    }

    private static boolean collectEntries(int kind, CLanguageData lData, List list) {
        if ((kind & lData.getSupportedEntryKinds()) != 0) {
            ICLanguageSettingEntry[] entries = lData.getEntries(kind);
            if (entries != null && entries.length != 0) {
                list.addAll(Arrays.asList(entries));
            }
            return true;
        }
        return false;
    }

    public static IPathEntry[] getPathEntries(IProject project, ICConfigurationDescription cfg, int flags) {
        PathEntryCollector cr = PathEntryTranslator.collectEntries(project, cfg);
        return cr.getEntries(flags, cfg);
    }

    private static class LangEntryInfo {
        ICLanguageSettingEntry fLangEntry;
        ResolvedEntry fResolvedEntry;

        public LangEntryInfo(ICLanguageSettingEntry lEntry, ResolvedEntry re) {
            this.fLangEntry = lEntry;
            this.fResolvedEntry = re;
        }
    }

    public static class PathEntryCollector {
        private PathSettingsContainer fStorage;
        private KindBasedStore fStore;
        private KindBasedStore fNameKeyMapStore;
        private LinkedHashMap fRefProjMap;
        private IProject fProject;

        private PathEntryCollector(IProject project) {
            this.fStorage = PathSettingsContainer.createRootContainer();
            this.fStorage.setValue(this);
            this.fStore = new KindBasedStore(false);
            this.fNameKeyMapStore = new KindBasedStore(false);
            this.fProject = project;
        }

        private PathEntryCollector(PathSettingsContainer container, KindBasedStore store, IProject project) {
            this.fStorage = container;
            this.fStore = store;
            this.fNameKeyMapStore = new KindBasedStore(false);
            this.fProject = project;
        }

        public void setSourceOutputEntries(int kind, ICExclusionPatternPathEntry[] entries) {
            LinkedHashMap map = this.getEntriesMap(kind, true);
            LinkedHashMap nameKeyMap = this.getEntriesNameKeyMap(kind, true);
            int i = 0;
            while (i < entries.length) {
                ICExclusionPatternPathEntry entry = entries[i];
                EntryNameKey nameKey = new EntryNameKey(entry = CDataUtil.makeAbsolute(this.fProject, entry, true));
                PathEntryComposer old = (PathEntryComposer)nameKeyMap.get(nameKey);
                if (old != null) {
                    entry = CDataUtil.addRemoveExclusionsToEntry(entry, ((ICExclusionPatternPathEntry)old.fLangEntry).getExclusionPatterns(), true);
                }
                PathEntryComposer newComposer = new PathEntryComposer(entry, this.fProject);
                map.put(entry, newComposer);
                nameKeyMap.put(nameKey, newComposer);
                ++i;
            }
        }

        public void setRefProjects(IPath[] paths) {
            if (paths == null || paths.length == 0) {
                this.fRefProjMap = null;
            } else {
                this.fRefProjMap = new LinkedHashMap();
                int i = 0;
                while (i < paths.length) {
                    PathEntryComposer cs = new PathEntryComposer(paths[i], this.fProject);
                    IPath path = cs.getPath();
                    this.fRefProjMap.put(path, cs);
                    ++i;
                }
            }
        }

        public PathEntryCollector createChild(IPath path) {
            if (path.segmentCount() == 0) {
                return this;
            }
            PathEntryCollector cr = (PathEntryCollector)this.fStorage.getChildContainer(path, false, false).getValue();
            if (cr != this) {
                IPath basePath = cr.getPath();
                path = path.removeFirstSegments(basePath.segmentCount());
                return cr.createChild(path);
            }
            PathSettingsContainer newContainer = this.fStorage.getChildContainer(path, true, true);
            KindBasedStore cloneStore = (KindBasedStore)this.fStore.clone();
            IKindBasedInfo[] info = cloneStore.getContents();
            int i = 0;
            while (i < info.length) {
                LinkedHashMap map = (LinkedHashMap)info[i].getInfo();
                if (map != null) {
                    info[i].setInfo((LinkedHashMap)map.clone());
                }
                ++i;
            }
            PathEntryCollector newCr = new PathEntryCollector(newContainer, cloneStore, this.fProject);
            newContainer.setValue(newCr);
            return newCr;
        }

        public IPath getPath() {
            return this.fStorage.getPath();
        }

        public void setEntries(int kind, ICLanguageSettingEntry[] entries, Set exportedEntries) {
            IPath path = this.getPath();
            HashSet parentSet = this.getEntriesSetCopy(kind);
            HashSet removedParentSet = (HashSet)parentSet.clone();
            HashSet<ICLanguageSettingEntry> addedThisSet = new HashSet<ICLanguageSettingEntry>(Arrays.asList(entries));
            removedParentSet.removeAll(addedThisSet);
            addedThisSet.removeAll(parentSet);
            if (removedParentSet.size() != 0) {
                PathEntryCollector parent = this.getParent();
                IPath parentPath = parent.getPath();
                int segsToRemove = parentPath.segmentCount();
                if (segsToRemove > path.segmentCount()) {
                    segsToRemove = path.segmentCount() - 1;
                }
                if (segsToRemove < 0) {
                    segsToRemove = 0;
                }
                IPath filterPath = path.removeFirstSegments(segsToRemove);
                if (parent != null) {
                    parent.addFilter(kind, filterPath, removedParentSet);
                }
                LinkedHashMap map = this.getEntriesMap(kind, true);
                Iterator iter = removedParentSet.iterator();
                while (iter.hasNext()) {
                    map.remove(iter.next());
                }
            }
            if (addedThisSet.size() != 0) {
                LinkedHashMap map = this.getEntriesMap(kind, true);
                IPath fullPath = this.fProject.getFullPath().append(path);
                int i = 0;
                while (i < entries.length) {
                    if (addedThisSet.remove(entries[i])) {
                        ICLanguageSettingEntry entry = entries[i];
                        map.put(entry, new PathEntryComposer(fullPath, entry, exportedEntries.contains(entry), this.fProject));
                    }
                    ++i;
                }
            }
        }

        private LinkedHashMap getEntriesMap(int kind, boolean create) {
            LinkedHashMap map = (LinkedHashMap)this.fStore.get(kind);
            if (map == null && create) {
                map = new LinkedHashMap();
                this.fStore.put(kind, map);
            }
            return map;
        }

        private LinkedHashMap getEntriesNameKeyMap(int kind, boolean create) {
            LinkedHashMap map = (LinkedHashMap)this.fNameKeyMapStore.get(kind);
            if (map == null && create) {
                map = new LinkedHashMap();
                this.fNameKeyMapStore.put(kind, map);
            }
            return map;
        }

        private void addFilter(int kind, IPath path, Set entriesSet) {
            if (entriesSet.size() == 0) {
                return;
            }
            Map map = (Map)this.fStore.get(kind);
            Iterator iter = entriesSet.iterator();
            while (iter.hasNext()) {
                PathEntryComposer cs = (PathEntryComposer)map.get(iter.next());
                cs.addFilter(path);
            }
        }

        public PathEntryCollector getParent() {
            if (this.fStorage.isRoot()) {
                return null;
            }
            PathSettingsContainer cr = this.fStorage.getParentContainer();
            return (PathEntryCollector)cr.getValue();
        }

        private HashSet getEntriesSetCopy(int kind) {
            LinkedHashMap map = this.getEntriesMap(kind, false);
            if (map != null) {
                return new HashSet(map.keySet());
            }
            return new HashSet(0);
        }

        private List getCollectedEntriesList(int kind) {
            ArrayList list = new ArrayList();
            HashSet set = new HashSet();
            this.fStorage.accept(new IPathSettingsContainerVisitor(this, kind, list, set){
                final /* synthetic */ PathEntryCollector this$1;
                private final /* synthetic */ int val$kind;
                private final /* synthetic */ List val$list;
                private final /* synthetic */ Set val$set;
                {
                    this.this$1 = pathEntryCollector;
                    this.val$kind = n;
                    this.val$list = list;
                    this.val$set = set;
                }

                public boolean visit(PathSettingsContainer container) {
                    PathEntryCollector clr = (PathEntryCollector)container.getValue();
                    PathEntryCollector.access$0(clr, this.val$kind, this.val$list, this.val$set);
                    return true;
                }
            });
            return list;
        }

        private void getLocalCollectedEntries(int kind, List list, Set addedEntries) {
            LinkedHashMap map = this.getEntriesMap(kind, false);
            if (map == null) {
                return;
            }
            Iterator iter = map.values().iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!addedEntries.add(o)) continue;
                list.add(o);
            }
        }

        public List getEntries(int peKind, List list, int flags, ICConfigurationDescription cfg) {
            if (list == null) {
                list = new ArrayList<IPathEntry>();
            }
            int sKind = PathEntryTranslator.peKindToSettingKind(peKind);
            ArrayList composerList = null;
            if (sKind != 0) {
                composerList = this.getCollectedEntriesList(sKind);
            } else if (peKind == 4 && this.fRefProjMap != null && this.fRefProjMap.size() != 0) {
                composerList = new ArrayList(this.fRefProjMap.values());
            }
            if (composerList != null) {
                PathEntryKyndStore store = new PathEntryKyndStore();
                Iterator iter = composerList.iterator();
                while (iter.hasNext()) {
                    ICSettingEntry entry;
                    PathEntryComposer cs = (PathEntryComposer)iter.next();
                    if (!PathEntryCollector.checkFilter(cs, entry = cs.getSettingEntry(), flags)) continue;
                    IPathEntry pe = null;
                    if (PathEntryCollector.isBuiltIn(entry) && cs.getPath().segmentCount() > 1) {
                        String name = entry.getName();
                        HashMap<String, IPathEntry> map = (HashMap<String, IPathEntry>)store.get(peKind);
                        if (map == null) {
                            map = new HashMap<String, IPathEntry>();
                            store.put(peKind, map);
                        }
                        if (!map.containsKey(name) && (pe = cs.toPathEntry(cfg, false)) != null) {
                            map.put(name, pe);
                        }
                    } else {
                        pe = cs.toPathEntry(cfg, true);
                    }
                    if (pe == null) continue;
                    list.add(pe);
                }
            }
            return list;
        }

        private static boolean checkFilter(PathEntryComposer cs, ICSettingEntry entry, int flags) {
            boolean builtIn = PathEntryCollector.isBuiltIn(entry);
            if ((flags & 1) != 0 && builtIn) {
                return true;
            }
            return (flags & 2) != 0 && !builtIn;
        }

        private static boolean isBuiltIn(ICSettingEntry entry) {
            return entry != null ? entry.isBuiltIn() || entry.isReadOnly() : false;
        }

        public List getEntries(List list, int flags, ICConfigurationDescription cfg) {
            if (list == null) {
                list = new ArrayList();
            }
            int[] peKinds = PathEntryKyndStore.getSupportedKinds();
            int i = 0;
            while (i < peKinds.length) {
                this.getEntries(peKinds[i], list, flags, cfg);
                ++i;
            }
            return list;
        }

        public IPathEntry[] getEntries(int flags, ICConfigurationDescription cfg) {
            List list = this.getEntries(null, flags, cfg);
            IPathEntry[] entries = list.toArray(new IPathEntry[list.size()]);
            return entries;
        }

        static /* synthetic */ void access$0(PathEntryCollector pathEntryCollector, int n, List list, Set set) {
            pathEntryCollector.getLocalCollectedEntries(n, list, set);
        }
    }

    private static class PathEntryComposer {
        private IPath fPath;
        private ICSettingEntry fLangEntry;
        private Set fFiltersSet;
        private boolean fIsExported;
        private IProject fProject;

        PathEntryComposer(String projName, IProject project) {
            this(new Path(projName).makeAbsolute(), project);
        }

        PathEntryComposer(IPath path, IProject project) {
            this.fPath = PathEntryComposer.toProjectPath(path);
            this.fProject = project;
        }

        private static IPath toProjectPath(IPath path) {
            if (path.segmentCount() > 1) {
                path = new Path(path.segment(0));
            }
            return path.makeAbsolute();
        }

        PathEntryComposer(ICExclusionPatternPathEntry entry, IProject project) {
            this.fPath = new Path(entry.getValue());
            this.fLangEntry = entry;
            this.fProject = project;
            IPath[] exclusions = entry.getExclusionPatterns();
            if (exclusions.length != 0) {
                this.fFiltersSet = new HashSet(exclusions.length);
                this.fFiltersSet.addAll(Arrays.asList(entry.getExclusionPatterns()));
            }
        }

        PathEntryComposer(IPath path, ICLanguageSettingEntry entry, boolean exported, IProject project) {
            this.fPath = path;
            this.fLangEntry = entry;
            this.fIsExported = exported;
            this.fProject = project;
        }

        public void addFilter(IPath path) {
            if (this.fFiltersSet == null) {
                this.fFiltersSet = new HashSet();
            }
            this.fFiltersSet.add(path);
        }

        public ICSettingEntry getSettingEntry() {
            return this.fLangEntry;
        }

        public IPath getPath() {
            return this.fPath;
        }

        public IPath[] getExclusionPatterns() {
            if (this.fFiltersSet != null) {
                return this.fFiltersSet.toArray(new IPath[this.fFiltersSet.size()]);
            }
            return new IPath[0];
        }

        private IPath[] getEntryPath(ICSettingEntry entry, ICConfigurationDescription cfg) {
            return this.valueToEntryPath(entry.getName(), (entry.getFlags() & 8) != 0, cfg);
        }

        private IPath[] valueToEntryPath(String value, boolean isWsp, ICConfigurationDescription cfg) {
            String pathVarValue = PathEntryTranslator.resolveKeepingPathEntryFars(value, cfg);
            String resolvedValue = PathEntryTranslator.resolveAll(value, cfg);
            Path resolvedPath = new Path(resolvedValue);
            Path pathVarPath = new Path(pathVarValue);
            IPath[] result = new IPath[2];
            if (isWsp) {
                if (!resolvedPath.isAbsolute()) {
                    result[0] = this.fProject.getFullPath().makeRelative();
                    result[1] = pathVarPath;
                } else if (resolvedPath.segmentCount() != 0) {
                    String projName = resolvedPath.segment(0);
                    IPath valuePath = resolvedPath.removeFirstSegments(1).makeRelative();
                    if (pathVarPath.segmentCount() != 0) {
                        String resolvedProjName = projName;
                        String varProjName = pathVarPath.segment(0);
                        IPath resolvedProjPath = CCorePlugin.getDefault().getPathEntryVariableManager().resolvePath((IPath)new Path(varProjName));
                        if (resolvedProjPath.segmentCount() == 1 && resolvedProjName.equals(resolvedProjPath.segment(0))) {
                            projName = varProjName;
                            valuePath = pathVarPath.removeFirstSegments(1).makeRelative();
                        }
                    }
                    result[0] = new Path(projName);
                    result[1] = valuePath;
                }
            } else {
                IPath location;
                if (!resolvedPath.isAbsolute() && (location = this.fProject.getLocation()) != null) {
                    pathVarPath = location.append((IPath)pathVarPath);
                }
                result[1] = pathVarPath;
            }
            return result;
        }

        public IPathEntry toPathEntry(ICConfigurationDescription cfg, boolean keepPathInfo) {
            IPath path;
            IPath iPath = path = keepPathInfo ? this.fPath : this.fProject.getFullPath();
            if (this.fLangEntry != null) {
                switch (this.fLangEntry.getKind()) {
                    case 2: {
                        IPath[] paths = this.getEntryPath(this.fLangEntry, cfg);
                        return CoreModel.newIncludeFileEntry(path, null, paths[0], paths[1], this.getExclusionPatterns(), this.fIsExported);
                    }
                    case 1: {
                        IPath[] paths = this.getEntryPath(this.fLangEntry, cfg);
                        ICIncludePathEntry ipe = (ICIncludePathEntry)this.fLangEntry;
                        return CoreModel.newIncludeEntry(path, paths[0], paths[1], !ipe.isLocal(), this.getExclusionPatterns(), this.fIsExported);
                    }
                    case 4: {
                        return CoreModel.newMacroEntry(path, this.fLangEntry.getName(), this.fLangEntry.getValue(), this.getExclusionPatterns(), this.fIsExported);
                    }
                    case 8: {
                        IPath[] paths = this.getEntryPath(this.fLangEntry, cfg);
                        return CoreModel.newMacroFileEntry(path, paths[0], null, paths[1], this.getExclusionPatterns(), this.fIsExported);
                    }
                    case 16: {
                        return null;
                    }
                    case 32: {
                        IPath[] paths = this.getEntryPath(this.fLangEntry, cfg);
                        return CoreModel.newLibraryEntry(path, paths[0], paths[1], null, null, null, this.fIsExported);
                    }
                    case 64: {
                        return CoreModel.newOutputEntry(this.fPath, this.getExclusionPatterns());
                    }
                    case 128: {
                        return CoreModel.newSourceEntry(this.fPath, this.getExclusionPatterns());
                    }
                }
                return null;
            }
            if (this.fPath != null) {
                return CoreModel.newProjectEntry(this.fPath, this.fIsExported);
            }
            return null;
        }
    }

    private static class PathEntryKyndStore {
        private static final int INDEX_CDT_LIBRARY = 0;
        private static final int INDEX_CDT_PROJECT = 1;
        private static final int INDEX_CDT_SOURCE = 2;
        private static final int INDEX_CDT_INCLUDE = 3;
        private static final int INDEX_CDT_CONTAINER = 4;
        private static final int INDEX_CDT_MACRO = 5;
        private static final int INDEX_CDT_OUTPUT = 6;
        private static final int INDEX_CDT_INCLUDE_FILE = 7;
        private static final int INDEX_CDT_MACRO_FILE = 8;
        private static final int STORAGE_SIZE = 9;
        private static final int[] ENTRY_KINDS = new int[]{1, 4, 8, 16, 32, 64, 128, 256, 512};
        private Object[] fEntryStorage = new Object[9];

        private PathEntryKyndStore() {
        }

        private int kindToIndex(int kind) {
            switch (kind) {
                case 1: {
                    return 0;
                }
                case 4: {
                    return 1;
                }
                case 8: {
                    return 2;
                }
                case 16: {
                    return 3;
                }
                case 32: {
                    return 4;
                }
                case 64: {
                    return 5;
                }
                case 128: {
                    return 6;
                }
                case 256: {
                    return 7;
                }
                case 512: {
                    return 8;
                }
            }
            throw new IllegalArgumentException(UtilMessages.getString("PathEntryTranslator.0"));
        }

        public static int[] getSupportedKinds() {
            return (int[])ENTRY_KINDS.clone();
        }

        private int indexToKind(int index) {
            switch (index) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 4;
                }
                case 2: {
                    return 8;
                }
                case 3: {
                    return 16;
                }
                case 4: {
                    return 32;
                }
                case 5: {
                    return 64;
                }
                case 6: {
                    return 128;
                }
                case 7: {
                    return 256;
                }
                case 8: {
                    return 512;
                }
            }
            throw new IllegalArgumentException(UtilMessages.getString("PathEntryTranslator.1"));
        }

        public Object get(int kind) {
            return this.fEntryStorage[this.kindToIndex(kind)];
        }

        public Object put(int kind, Object object) {
            int index = this.kindToIndex(kind);
            Object old = this.fEntryStorage[index];
            this.fEntryStorage[index] = object;
            return old;
        }

        public IKindBasedInfo[] getContents() {
            IKindBasedInfo[] infos = new IKindBasedInfo[9];
            int i = 0;
            while (i < 9) {
                infos[i] = new KindBasedInfo(i, false);
                ++i;
            }
            return infos;
        }

        public IKindBasedInfo getInfo(int kind) {
            return new KindBasedInfo(kind, true);
        }

        public void clear() {
            int i = 0;
            while (i < 9) {
                this.fEntryStorage[i] = null;
                ++i;
            }
        }

        private class KindBasedInfo
        implements IKindBasedInfo {
            int fIdex;
            int fKind;

            KindBasedInfo(int num, boolean isKind) {
                if (isKind) {
                    this.fIdex = PathEntryKyndStore.this.kindToIndex(num);
                    this.fKind = num;
                } else {
                    this.fIdex = num;
                    this.fKind = PathEntryKyndStore.this.indexToKind(num);
                }
            }

            public Object getInfo() {
                return PathEntryKyndStore.this.fEntryStorage[this.fIdex];
            }

            public int getKind() {
                return this.fKind;
            }

            public Object setInfo(Object newInfo) {
                Object old = PathEntryKyndStore.this.fEntryStorage[this.fIdex];
                ((PathEntryKyndStore)PathEntryKyndStore.this).fEntryStorage[this.fIdex] = newInfo;
                return old;
            }
        }
    }

    private class PathEntryValueInfo {
        private ResourceInfo fResourceInfo;
        private IPath fLocation;
        private String fName;
        private String fValue;
        private ResolvedEntry fResolvedEntry;

        private PathEntryValueInfo(ResolvedEntry rEntry) {
            this.fResolvedEntry = rEntry;
            this.init();
        }

        public IPath getFullPath() {
            if (this.fResourceInfo != null) {
                return this.fResourceInfo.fRc.getFullPath();
            }
            return null;
        }

        public IPath getLocation() {
            if (this.fResourceInfo != null) {
                return this.fResourceInfo.fRc.getLocation();
            }
            return this.fLocation;
        }

        public String getName() {
            if (this.fName != null) {
                return this.fName;
            }
            return "";
        }

        public String getValue() {
            if (this.fValue != null) {
                return this.fValue;
            }
            return "";
        }

        /*
         * Enabled aggressive block sorting
         */
        private void init() {
            IPathEntry entry = this.fResolvedEntry.fEntry;
            int peKind = entry.getEntryKind();
            IPath basePath = null;
            IPath valuePath = null;
            boolean isFile = false;
            boolean calcPath = false;
            switch (peKind) {
                case 64: {
                    IMacroEntry me = (IMacroEntry)entry;
                    this.fName = me.getMacroName();
                    this.fValue = me.getMacroValue();
                    break;
                }
                case 1: {
                    isFile = true;
                    calcPath = true;
                    ILibraryEntry le = (ILibraryEntry)entry;
                    basePath = le.getBasePath();
                    valuePath = le.getLibraryPath();
                    break;
                }
                case 16: {
                    isFile = false;
                    calcPath = true;
                    IIncludeEntry ie = (IIncludeEntry)entry;
                    basePath = ie.getBasePath();
                    valuePath = ie.getIncludePath();
                    break;
                }
                case 256: {
                    isFile = true;
                    calcPath = true;
                    IIncludeFileEntry ife = (IIncludeFileEntry)entry;
                    basePath = ife.getBasePath();
                    valuePath = ife.getIncludeFilePath();
                    break;
                }
                case 512: {
                    isFile = true;
                    calcPath = true;
                    IMacroFileEntry mfe = (IMacroFileEntry)entry;
                    basePath = mfe.getBasePath();
                    valuePath = mfe.getMacroFilePath();
                    break;
                }
                case 4: 
                case 8: 
                case 32: 
                case 128: {
                    this.fResourceInfo = this.fResolvedEntry.getResourceInfo();
                    break;
                }
            }
            if (!calcPath) return;
            IPath unresolvedBase = basePath;
            IPath unresolvedValue = valuePath;
            IPathEntryVariableManager mngr = CCorePlugin.getDefault().getPathEntryVariableManager();
            basePath = mngr.resolvePath(basePath);
            valuePath = mngr.resolvePath(valuePath);
            this.fValue = this.fName = unresolvedBase.isEmpty() ? unresolvedValue.toString() : unresolvedBase.append(unresolvedValue).toString();
            if (!basePath.isEmpty()) {
                IPath loc = basePath;
                if (!loc.isAbsolute()) {
                    ResourceInfo rcInfo = PathEntryTranslator.this.findResourceInfo((IContainer)PathEntryTranslator.this.fRoot, loc.append(valuePath), !isFile);
                    if (rcInfo.fExists) {
                        this.fResourceInfo = rcInfo;
                        this.fValue = this.fName = unresolvedBase.append(unresolvedValue).toString();
                        return;
                    }
                }
                this.fLocation = loc.append(valuePath);
                return;
            }
            if (!valuePath.isAbsolute()) {
                ResourceInfo rcInfo = this.fResolvedEntry.getResourceInfo();
                if (rcInfo.fExists) {
                    IPath location;
                    if (rcInfo.fRc.getType() == 1) {
                        rcInfo = PathEntryTranslator.this.findResourceInfo((IContainer)PathEntryTranslator.this.fRoot, rcInfo.fRc.getFullPath().removeLastSegments(1), true);
                    }
                    if ((location = rcInfo.fRc.getLocation()) != null && rcInfo.fRc.getType() != 1) {
                        this.fResourceInfo = rcInfo = PathEntryTranslator.this.findResourceInfo((IContainer)rcInfo.fRc, valuePath, !isFile);
                        return;
                    }
                }
            }
            this.fLocation = valuePath;
        }

        public boolean isWorkspacePath() {
            return this.fResourceInfo != null;
        }
    }

    private class RcDesInfo {
        ResourceInfo fRcInfo;
        List fResolvedEntries;
        KindBasedStore fLangEntries;

        private RcDesInfo(ResourceInfo rcInfo) {
            this.fRcInfo = rcInfo;
            this.fResolvedEntries = new ArrayList();
            this.fLangEntries = new KindBasedStore();
        }

        public ResolvedEntry[] getResolvedEntries() {
            return this.fResolvedEntries.toArray(new ResolvedEntry[this.fResolvedEntries.size()]);
        }

        public void add(LangEntryInfo info) {
            ArrayList<LangEntryInfo> list = (ArrayList<LangEntryInfo>)this.fLangEntries.get(info.fLangEntry.getKind());
            if (list == null) {
                list = new ArrayList<LangEntryInfo>();
                this.fLangEntries.put(info.fLangEntry.getKind(), list);
            }
            list.add(info);
        }

        public ICLanguageSettingEntry[] getEntries(int kind) {
            List list = (List)this.fLangEntries.get(kind);
            if (list != null) {
                ICLanguageSettingEntry[] entries = new ICLanguageSettingEntry[list.size()];
                int i = 0;
                while (i < entries.length) {
                    LangEntryInfo info = (LangEntryInfo)list.get(i);
                    entries[i] = info.fLangEntry;
                    ++i;
                }
                return entries;
            }
            return new ICLanguageSettingEntry[0];
        }
    }

    public static final class ReferenceSettingsInfo {
        private IPath[] fRefProjPaths;
        private ICExternalSetting[] fExtSettings;

        public ReferenceSettingsInfo(ICConfigurationDescription des) {
            this.fExtSettings = des.getExternalSettings();
            Map map = des.getReferenceInfo();
            this.fRefProjPaths = new IPath[map.size()];
            int num = 0;
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                String proj = (String)iter.next();
                this.fRefProjPaths[num++] = new Path(proj).makeAbsolute();
            }
        }

        public ReferenceSettingsInfo(IPath[] projPaths, ICExternalSetting[] extSettings) {
            if (projPaths != null) {
                this.fRefProjPaths = (IPath[])projPaths.clone();
            }
            if (extSettings != null) {
                this.fExtSettings = (ICExternalSetting[])extSettings.clone();
            }
        }

        public IPath[] getReferencedProjectsPaths() {
            if (this.fRefProjPaths != null) {
                return (IPath[])this.fRefProjPaths.clone();
            }
            return new IPath[0];
        }

        public Map getRefProjectsMap() {
            if (this.fRefProjPaths != null && this.fRefProjPaths.length != 0) {
                HashMap<String, String> map = new HashMap<String, String>(this.fRefProjPaths.length);
                int i = 0;
                while (i < this.fRefProjPaths.length) {
                    map.put(this.fRefProjPaths[i].segment(0), "");
                    ++i;
                }
                return map;
            }
            return new HashMap(0);
        }

        public ICExternalSetting[] getExternalSettings() {
            if (this.fExtSettings != null) {
                return (ICExternalSetting[])this.fExtSettings.clone();
            }
            return new ICExternalSetting[0];
        }
    }

    private class ResolvedEntry {
        private IPathEntry fEntry;
        private ResourceInfo fResourceInfo;
        private ResourceInfo[] fFilterInfos;
        private PathEntryValueInfo fResolvedValue;
        private PathEntryResolveInfoElement fResolveElement;
        private boolean fIsReadOnly;
        private boolean fIsBuiltIn;

        public ResolvedEntry(IPathEntry entry, PathEntryResolveInfoElement resolveElement) {
            this.fEntry = entry;
            this.fResolveElement = resolveElement;
            this.fIsBuiltIn = this.fIsReadOnly = PathEntryTranslator.areEntriesReadOnly(this.fResolveElement);
        }

        public ResolvedEntry(IPathEntry entry, boolean isReadOnly) {
            this.fEntry = entry;
            this.fIsReadOnly = isReadOnly;
        }

        public boolean isReadOnly() {
            return this.fIsReadOnly;
        }

        public boolean isBuiltIn() {
            return this.fIsBuiltIn;
        }

        public PathEntryResolveInfoElement getResolveInfoElement() {
            return this.fResolveElement;
        }

        public ResourceInfo getResourceInfo() {
            if (this.fResourceInfo == null) {
                this.fResourceInfo = PathEntryTranslator.this.findResourceInfo((IContainer)PathEntryTranslator.this.fRoot, PathEntryTranslator.this.getEntryFullPath(this.fEntry), true);
            }
            return this.fResourceInfo;
        }

        public ResourceInfo[] getFilterInfos() {
            if (this.fFilterInfos == null) {
                IPath[] paths = PathEntryTranslator.this.obtainFilters(this.fEntry);
                if (paths.length == 0) {
                    this.fFilterInfos = new ResourceInfo[0];
                } else {
                    ResourceInfo rcInfo = this.getResourceInfo();
                    if (rcInfo.fExists) {
                        if (rcInfo.fRc.getType() == 1) {
                            this.fFilterInfos = new ResourceInfo[0];
                        } else {
                            ArrayList<ResourceInfo> list = new ArrayList<ResourceInfo>();
                            int i = 0;
                            while (i < paths.length) {
                                list.addAll(Arrays.asList(this.processFilter((IContainer)rcInfo.fRc, paths[i])));
                                ++i;
                            }
                            this.fFilterInfos = new ResourceInfo[list.size()];
                            list.toArray(this.fFilterInfos);
                        }
                    } else {
                        this.fFilterInfos = new ResourceInfo[paths.length];
                        int i = 0;
                        while (i < paths.length) {
                            this.fFilterInfos[i] = this.processInexistingResourceFilter((IContainer)rcInfo.fRc, paths[i]);
                            ++i;
                        }
                    }
                }
            }
            return this.fFilterInfos;
        }

        private ResourceInfo[] processFilter(IContainer container, IPath path) {
            return PathEntryTranslator.this.resolveFilter(container, path);
        }

        private ResourceInfo processInexistingResourceFilter(IContainer container, IPath path) {
            IFolder f = container.getFolder(path);
            ResourceInfo rcInfo = new ResourceInfo((IResource)f, false);
            PathEntryTranslator.this.addRcInfoToMap(rcInfo);
            PathEntryTranslator.this.addResolvedFilterToMap(container.getFullPath(), new ResourceInfo[]{rcInfo}, true);
            return rcInfo;
        }

        public IPathEntry getEntry() {
            return this.fEntry;
        }

        public PathEntryValueInfo getResolvedValue() {
            if (this.fResolvedValue == null) {
                this.fResolvedValue = new PathEntryValueInfo(this);
            }
            return this.fResolvedValue;
        }
    }

    private class ResourceInfo {
        IResource fRc;
        boolean fExists;

        public ResourceInfo(IResource rc, boolean exists) {
            this.fRc = rc;
            this.fExists = exists;
        }
    }

    private static class VarSubstitutor
    extends CoreVariableSubstitutor {
        ICConfigurationDescription fCfg;
        ICdtVariableManager fMngr = CCorePlugin.getDefault().getCdtVariableManager();

        public VarSubstitutor(ICConfigurationDescription cfg) {
            super(new DefaultVariableContextInfo(3, cfg), "", " ");
            this.fCfg = cfg;
        }

        protected SupplierBasedCdtVariableSubstitutor.ResolvedMacro resolveMacro(ICdtVariable macro) throws CdtVariableException {
            if (!CdtVarPathEntryVariableManager.isPathEntryVariable(macro, this.fCfg, this.fMngr)) {
                return super.resolveMacro(macro);
            }
            return new SupplierBasedCdtVariableSubstitutor.ResolvedMacro((SupplierBasedCdtVariableSubstitutor)this, macro.getName(), CdtVariableResolver.createVariableReference(macro.getName()));
        }
    }
}

