/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.cdt.internal.core.PositionTracker;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;

class PositionTrackerChain
implements IDocumentListener {
    public static final int LINKED_LIST_SIZE = 64;
    public static final int LINKED_LIST_ENTRY_SIZE = 32;
    public static int MEMORY_SIZE = 96;
    private static final int MAX_DEPTH = 100;
    private static final long MAX_AGE = 86400000L;
    private LinkedList fTrackers = new LinkedList();
    private PositionTracker fActiveTracker;
    private IDocument fDocument;

    public PositionTrackerChain(long timestamp) {
        this.createCheckpoint(timestamp);
    }

    public int createCheckpoint(long timestamp) {
        while (this.fActiveTracker != null && this.fActiveTracker.getTimeStamp() >= timestamp) {
            this.fTrackers.removeLast();
            if (this.fTrackers.isEmpty()) {
                this.fActiveTracker = null;
                continue;
            }
            this.fActiveTracker = (PositionTracker)this.fTrackers.getLast();
            this.fActiveTracker.revive();
        }
        int retiredMemsize = 0;
        PositionTracker newTracker = new PositionTracker();
        newTracker.setTimeStamp(timestamp);
        this.fTrackers.add(newTracker);
        if (this.fActiveTracker != null) {
            this.fActiveTracker.retire(newTracker);
            retiredMemsize = this.fActiveTracker.getMemorySize() + 32;
        }
        this.fActiveTracker = newTracker;
        this.checkTrackerLimits();
        return retiredMemsize;
    }

    private void checkTrackerLimits() {
        while (this.fTrackers.size() >= 100) {
            this.fTrackers.removeFirst();
        }
        long minTimeStamp = this.fActiveTracker.getTimeStamp() - 86400000L;
        Iterator iter = this.fTrackers.iterator();
        while (iter.hasNext()) {
            PositionTracker tracker = (PositionTracker)iter.next();
            if (tracker.getRetiredTimeStamp() >= minTimeStamp) break;
            iter.remove();
        }
    }

    private void update(DocumentEvent event) {
        String text = event.getText();
        int insertLen = text != null ? text.length() : 0;
        this.update(event.getOffset(), event.getLength(), insertLen);
    }

    void update(int offset, int deleteLen, int insertLen) {
        if (insertLen > deleteLen) {
            this.fActiveTracker.insert(offset + deleteLen, insertLen - deleteLen);
        } else if (insertLen < deleteLen) {
            this.fActiveTracker.delete(offset + insertLen, deleteLen - insertLen);
        }
    }

    public PositionTracker findTrackerAtOrAfter(long timestamp) {
        PositionTracker candidate = null;
        ListIterator iter = this.fTrackers.listIterator(this.fTrackers.size());
        while (iter.hasPrevious()) {
            PositionTracker tracker = (PositionTracker)iter.previous();
            long trackerTimestamp = tracker.getTimeStamp();
            if (trackerTimestamp < timestamp) break;
            candidate = tracker;
        }
        return candidate;
    }

    public PositionTracker findTrackerAt(long timestamp) {
        ListIterator iter = this.fTrackers.listIterator(this.fTrackers.size());
        while (iter.hasPrevious()) {
            PositionTracker tracker = (PositionTracker)iter.previous();
            long trackerTimestamp = tracker.getTimeStamp();
            if (trackerTimestamp == timestamp) {
                return tracker;
            }
            if (trackerTimestamp >= timestamp) continue;
            return null;
        }
        return null;
    }

    public void dispose() {
        this.stopTracking();
        this.fTrackers = null;
        this.fActiveTracker = null;
    }

    public void startTracking(IDocument doc) {
        this.stopTracking();
        this.fDocument = doc;
        if (this.fDocument != null) {
            this.fDocument.addDocumentListener((IDocumentListener)this);
        }
    }

    public void stopTracking() {
        if (this.fDocument != null) {
            this.fDocument.removeDocumentListener((IDocumentListener)this);
            this.fDocument = null;
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this.update(event);
    }

    public void documentChanged(DocumentEvent event) {
    }

    public IDocument getCurrentDocument() {
        return this.fDocument;
    }

    public PositionTracker getActiveTracker() {
        return this.fActiveTracker;
    }

    public boolean isModified() {
        return this.fTrackers.size() > 1 || this.fActiveTracker.isModified();
    }

    public int getMemorySize() {
        int size = MEMORY_SIZE;
        Iterator iter = this.fTrackers.iterator();
        while (iter.hasNext()) {
            PositionTracker tracker = (PositionTracker)iter.next();
            size += 32;
            size += tracker.getMemorySize();
        }
        return size;
    }

    public int removeOldest() {
        int memdiff = 0;
        if (this.fTrackers.size() > 1) {
            PositionTracker tracker = (PositionTracker)this.fTrackers.removeFirst();
            memdiff = tracker.getMemorySize() + 32;
            tracker.clear();
        }
        return -memdiff;
    }

    public long getOldestRetirement() {
        if (this.fTrackers.size() > 1) {
            PositionTracker tracker = (PositionTracker)this.fTrackers.getFirst();
            return tracker.getRetiredTimeStamp();
        }
        return Long.MAX_VALUE;
    }
}

