/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.TypeReference;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.ext.CElementHandleFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class IndexTypeReference
extends TypeReference {
    private ICElement fCElement;

    public IndexTypeReference(IBinding binding, IPath path, IProject project, int offset, int length) {
        super(path, project, offset, length);
        this.fCElement = this.createCElement(binding);
    }

    public IndexTypeReference(IBinding binding, IResource resource, IProject project, int offset, int length) {
        super(resource, project, offset, length);
        this.fCElement = this.createCElement(binding);
    }

    private ICElement createCElement(IBinding binding) {
        ITranslationUnit tu = this.getTranslationUnit();
        if (tu != null) {
            long timestamp = tu.getResource() != null ? tu.getResource().getLocalTimeStamp() : 0L;
            Region region = new Region(this.getOffset(), this.getLength());
            try {
                return CElementHandleFactory.create(tu, binding, true, (IRegion)region, timestamp);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return null;
    }

    public ICElement[] getCElements() {
        if (this.fCElement != null) {
            return new ICElement[]{this.fCElement};
        }
        return super.getCElements();
    }
}

