/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import java.text.MessageFormat;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSemantics;
import org.eclipse.cdt.internal.core.parser.ParserMessages;
import org.eclipse.core.runtime.PlatformObject;

public class ProblemBinding
extends PlatformObject
implements IProblemBinding,
IType,
IScope,
IASTInternalScope {
    protected final int id;
    protected final char[] arg;
    protected IASTNode node;
    private String message = null;
    protected static final String PROBLEM_PATTERN = "BaseProblemFactory.problemPattern";
    protected static final String[] errorMessages = new String[14];

    static {
        ProblemBinding.errorMessages[0] = ParserMessages.getString("ASTProblemFactory.error.semantic.nameNotFound");
        ProblemBinding.errorMessages[3] = ParserMessages.getString("ASTProblemFactory.error.semantic.pst.ambiguousLookup");
        ProblemBinding.errorMessages[4] = ParserMessages.getString("ASTProblemFactory.error.semantic.pst.invalidType");
        ProblemBinding.errorMessages[5] = ParserMessages.getString("ASTProblemFactory.error.semantic.pst.circularInheritance");
        ProblemBinding.errorMessages[1] = ParserMessages.getString("ASTProblemFactory.error.semantic.pst.invalidOverload");
        ProblemBinding.errorMessages[2] = ParserMessages.getString("ASTProblemFactory.error.semantic.pst.invalidUsing");
        ProblemBinding.errorMessages[6] = ParserMessages.getString("ASTProblemFactory.error.semantic.dom.definitionNotFound");
        ProblemBinding.errorMessages[7] = ParserMessages.getString("ASTProblemFactory.error.semantic.dom.knrParameterDeclarationNotFound");
        ProblemBinding.errorMessages[8] = ParserMessages.getString("ASTProblemFactory.error.semantic.dom.labelStatementNotFound");
        ProblemBinding.errorMessages[10] = ParserMessages.getString("ASTProblemFactory.error.semantic.dom.invalidRedefinition");
        ProblemBinding.errorMessages[11] = ParserMessages.getString("ASTProblemFactory.error.semantic.dom.invalidRedeclaration");
        ProblemBinding.errorMessages[9] = ParserMessages.getString("ASTProblemFactory.error.semantic.dom.badScope");
        ProblemBinding.errorMessages[13] = ParserMessages.getString("ASTProblemFactory.error.semantic.dom.recursionInResolution");
        ProblemBinding.errorMessages[12] = ParserMessages.getString("ASTProblemFactory.error.semantic.dom.memberDeclNotFound");
    }

    public ProblemBinding(IASTNode node, int id, char[] arg) {
        this.id = id;
        this.arg = arg;
        this.node = node;
    }

    public IASTNode getASTNode() {
        return this.node;
    }

    public int getID() {
        return this.id;
    }

    public String getMessage() {
        String msg;
        if (this.message != null) {
            return this.message;
        }
        String string = msg = this.id >= 0 && this.id <= 14 ? errorMessages[this.id - 1] : "";
        if (this.arg != null) {
            msg = MessageFormat.format(msg, new String(this.arg));
        }
        return msg;
    }

    public String getName() {
        return "";
    }

    public char[] getNameCharArray() {
        return CPPSemantics.EMPTY_NAME_ARRAY;
    }

    public IScope getScope() throws DOMException {
        throw new DOMException(this);
    }

    public IASTNode getPhysicalNode() {
        return this.getASTNode();
    }

    public Object clone() {
        return this;
    }

    public IScope getParent() throws DOMException {
        throw new DOMException(this);
    }

    public IBinding[] find(String name) throws DOMException {
        throw new DOMException(this);
    }

    public IName getScopeName() {
        return null;
    }

    public void addName(IASTName name) throws DOMException {
        throw new DOMException(this);
    }

    public void removeBinding(IBinding binding) throws DOMException {
        throw new DOMException(this);
    }

    public IBinding getBinding(IASTName name, boolean resolve) throws DOMException {
        throw new DOMException(this);
    }

    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup) throws DOMException {
        throw new DOMException(this);
    }

    public void setFullyCached(boolean b) {
    }

    public boolean isFullyCached() throws DOMException {
        throw new DOMException(this);
    }

    public boolean isSameType(IType type) {
        return type == this;
    }

    public void flushCache() {
    }

    public String getFileName() {
        if (this.node != null) {
            return this.node.getContainingFilename();
        }
        return "";
    }

    public int getLineNumber() {
        if (this.node != null) {
            IASTFileLocation fileLoc = this.node.getFileLocation();
            return fileLoc.getStartingLineNumber();
        }
        return -1;
    }

    public void addBinding(IBinding binding) throws DOMException {
        throw new DOMException(this);
    }

    public ILinkage getLinkage() {
        return Linkage.NO_LINKAGE;
    }
}

