/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;

public class CPPASTName
extends CPPASTNode
implements IASTName,
IASTCompletionContext {
    private char[] name;
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private static final String EMPTY_STRING = "";
    static final int MAX_RESOLUTION_DEPTH = 5;
    private IBinding binding = null;
    private int fResolutionDepth = 0;
    static /* synthetic */ Class class$0;

    public CPPASTName(char[] name) {
        this.name = name;
    }

    public CPPASTName() {
        this.name = EMPTY_CHAR_ARRAY;
    }

    public IBinding resolveBinding() {
        if (this.binding == null) {
            this.binding = ++this.fResolutionDepth > 5 ? new RecursionResolvingBinding(this) : CPPVisitor.createBinding(this);
        }
        return this.binding;
    }

    public void incResolutionDepth() {
        if (this.binding == null && ++this.fResolutionDepth > 5) {
            this.binding = new RecursionResolvingBinding(this);
        }
    }

    public IASTCompletionContext getCompletionContext() {
        IASTNode node = this.getParent();
        while (node != null) {
            if (node instanceof IASTCompletionContext) {
                return (IASTCompletionContext)((Object)node);
            }
            node = node.getParent();
        }
        if (this.getLength() > 0) {
            return this;
        }
        return null;
    }

    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        if (this.getParent() instanceof IASTDeclarator) {
            Object[] bindings = CPPSemantics.findBindingsForContentAssist(n, isPrefix);
            int i = 0;
            while (i < bindings.length) {
                if (!(bindings[i] instanceof ICPPNamespace) && !(bindings[i] instanceof ICPPClassType)) {
                    bindings[i] = null;
                }
                ++i;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IBinding[])ArrayUtil.removeNulls(clazz, bindings);
        }
        return null;
    }

    public void setBinding(IBinding binding) {
        this.binding = binding;
        this.fResolutionDepth = 0;
    }

    public IBinding getBinding() {
        return this.binding;
    }

    public String toString() {
        if (this.name == EMPTY_CHAR_ARRAY) {
            return EMPTY_STRING;
        }
        return new String(this.name);
    }

    public char[] toCharArray() {
        return this.name;
    }

    public void setName(char[] name) {
        this.name = name;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitNames) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (action.shouldVisitNames) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public boolean isDeclaration() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            switch (role) {
                case 1: 
                case 3: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean isReference() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            switch (role) {
                case 1: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isDefinition() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            switch (role) {
                case 2: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    static final class RecursionResolvingBinding
    extends ProblemBinding {
        public RecursionResolvingBinding() {
            super(null, 14, CharArrayUtils.EMPTY);
        }

        public RecursionResolvingBinding(IASTName node) {
            super(node, 14, node.toCharArray());
        }
    }
}

