/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.IMacroCollector;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.ICodeReaderCache;
import org.eclipse.cdt.core.parser.IMacro;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.internal.core.parser.scanner2.IIndexBasedCodeReaderFactory;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectStyleMacro;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacro;
import org.eclipse.core.runtime.CoreException;

public class IndexBasedCodeReaderFactory
implements IIndexBasedCodeReaderFactory {
    private static final boolean CASE_SENSITIVE_FILES;
    private static final char[] EMPTY_CHARS;
    private final IIndex index;
    private Map fileInfoCache;
    private Map iflCache;
    private List usedMacros = new ArrayList();
    private Set fIncluded = new HashSet();
    private ICodeReaderFactory fFallBackFactory;
    private CallbackHandler fCallbackHandler;
    private final ICProject cproject;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.index.IndexBasedCodeReaderFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        CASE_SENSITIVE_FILES = !new File("a").equals(new File("A"));
        EMPTY_CHARS = new char[0];
    }

    public IndexBasedCodeReaderFactory(ICProject cproject, IIndex index) {
        this(cproject, index, new HashMap());
    }

    public IndexBasedCodeReaderFactory(ICProject cproject, IIndex index, ICodeReaderFactory fallbackFactory) {
        this(cproject, index, new HashMap(), fallbackFactory);
    }

    public IndexBasedCodeReaderFactory(ICProject cproject, IIndex index, Map iflCache) {
        this(cproject, index, iflCache, null);
    }

    public IndexBasedCodeReaderFactory(ICProject cproject, IIndex index, Map iflCache, ICodeReaderFactory fallbackFactory) {
        this.cproject = cproject;
        this.index = index;
        this.fileInfoCache = new HashMap();
        this.iflCache = iflCache;
        this.fFallBackFactory = fallbackFactory;
    }

    protected final Map getIFLCache() {
        return this.iflCache;
    }

    public int getUniqueIdentifier() {
        return 0;
    }

    public CodeReader createCodeReaderForTranslationUnit(String path) {
        return ParserUtil.createReader(path, null);
    }

    public CodeReader createCodeReaderForInclusion(IMacroCollector scanner, String path) {
        File location = new File(path);
        String canonicalPath = path;
        if (!location.exists()) {
            return null;
        }
        if (!CASE_SENSITIVE_FILES) {
            try {
                canonicalPath = location.getCanonicalPath();
            }
            catch (IOException iOException) {}
        }
        try {
            IIndexFileLocation incLocation = this.findLocation(canonicalPath);
            IndexFileInfo info = this.createInfo(incLocation, null);
            if (this.isIncluded(info)) {
                return new CodeReader(canonicalPath, EMPTY_CHARS);
            }
            if (info.fFile != null) {
                try {
                    LinkedHashSet infos = new LinkedHashSet();
                    this.getInfosForMacroDictionary(info, infos);
                    Iterator iter = infos.iterator();
                    while (iter.hasNext()) {
                        IndexFileInfo fi = (IndexFileInfo)iter.next();
                        if (fi.fMacros == null) {
                            if (!$assertionsDisabled && fi.fFile == null) {
                                throw new AssertionError();
                            }
                            IIndexMacro[] macros = fi.fFile.getMacros();
                            IMacro[] converted = new IMacro[macros.length];
                            int i = 0;
                            while (i < macros.length) {
                                IIndexMacro macro = macros[i];
                                converted[i] = ((PDOMMacro)macro).getMacro();
                                ++i;
                            }
                            fi.fMacros = converted;
                        }
                        int i = 0;
                        while (i < fi.fMacros.length) {
                            scanner.addDefinition(fi.fMacros[i]);
                            ++i;
                        }
                        this.usedMacros.add(fi.fMacros);
                        this.setIncluded(fi);
                    }
                    return new CodeReader(canonicalPath, EMPTY_CHARS);
                }
                catch (NeedToParseException needToParseException) {}
            }
            this.setIncluded(info);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        if (this.fFallBackFactory != null) {
            return this.fFallBackFactory.createCodeReaderForInclusion(scanner, canonicalPath);
        }
        return ParserUtil.createReader(canonicalPath, null);
    }

    public boolean hasFileBeenIncludedInCurrentTranslationUnit(String path) {
        IIndexFileLocation loc;
        IndexFileInfo info;
        String canonicalPath = path;
        if (!CASE_SENSITIVE_FILES) {
            try {
                File location = new File(path);
                canonicalPath = location.getCanonicalPath();
            }
            catch (IOException iOException) {}
        }
        return (info = (IndexFileInfo)this.fileInfoCache.get(loc = this.findLocation(canonicalPath))) != null && this.isIncluded(info);
    }

    private void setIncluded(IndexFileInfo info) {
        this.fIncluded.add(info);
    }

    private boolean isIncluded(IndexFileInfo info) {
        return this.fIncluded.contains(info);
    }

    private IndexFileInfo createInfo(IIndexFileLocation location, IIndexFile file) throws CoreException {
        IndexFileInfo info = (IndexFileInfo)this.fileInfoCache.get(location);
        if (info == null) {
            info = new IndexFileInfo();
            info.fFile = file == null ? this.index.getFile(location) : file;
            this.fileInfoCache.put(location, info);
        }
        return info;
    }

    private void getInfosForMacroDictionary(IndexFileInfo fileInfo, LinkedHashSet target) throws CoreException, NeedToParseException {
        if (this.isIncluded(fileInfo)) {
            return;
        }
        if (!target.add(fileInfo)) {
            return;
        }
        IIndexFile file = fileInfo.fFile;
        if (file == null || this.fCallbackHandler != null && this.fCallbackHandler.needToUpdate(fileInfo)) {
            throw new NeedToParseException();
        }
        IIndexInclude[] includeDirectives = file.getIncludes();
        int i = 0;
        while (i < includeDirectives.length) {
            IIndexFile includedFile = this.index.resolveInclude(includeDirectives[i]);
            if (includedFile != null) {
                IndexFileInfo nextInfo = this.createInfo(includedFile.getLocation(), includedFile);
                this.getInfosForMacroDictionary(nextInfo, target);
            }
            ++i;
        }
    }

    public void clearMacroAttachements() {
        Iterator i = this.usedMacros.iterator();
        while (i.hasNext()) {
            IMacro[] macros = (IMacro[])i.next();
            int j = 0;
            while (j < macros.length) {
                if (macros[j] instanceof ObjectStyleMacro) {
                    ((ObjectStyleMacro)macros[j]).attachment = null;
                }
                ++j;
            }
        }
        this.usedMacros.clear();
        this.fIncluded.clear();
    }

    public ICodeReaderCache getCodeReaderCache() {
        return null;
    }

    public IndexFileInfo createFileInfo(IIndexFileLocation location) throws CoreException {
        return this.createInfo(location, null);
    }

    public IIndexFileLocation findLocation(String absolutePath) {
        if (!this.iflCache.containsKey(absolutePath)) {
            this.iflCache.put(absolutePath, IndexLocationFactory.getIFLExpensive(this.cproject, absolutePath));
        }
        return (IIndexFileLocation)this.iflCache.get(absolutePath);
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.fCallbackHandler = callbackHandler;
    }

    public static interface CallbackHandler {
        public boolean needToUpdate(IndexFileInfo var1) throws CoreException;
    }

    public static class IndexFileInfo {
        public static final int NOT_REQUESTED = 0;
        public static final int REQUESTED_IF_CONFIG_CHANGED = 1;
        public static final int REQUESTED = 2;
        private IMacro[] fMacros = null;
        public IIndexFile fFile = null;
        public int fRequested = 0;

        private IndexFileInfo() {
        }

        public boolean hasCachedMacros() {
            return this.fMacros != null;
        }
    }

    private static class NeedToParseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private NeedToParseException() {
        }
    }
}

