/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.core.index.CIndex;
import org.eclipse.cdt.internal.core.index.EmptyCIndex;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexFragment;
import org.eclipse.cdt.internal.core.index.Messages;
import org.eclipse.cdt.internal.core.index.WritableCIndex;
import org.eclipse.cdt.internal.core.index.provider.IndexProviderManager;
import org.eclipse.cdt.internal.core.pdom.IPDOM;
import org.eclipse.cdt.internal.core.pdom.PDOMManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class IndexFactory {
    private static final int ADD_DEPENDENCIES = 1;
    private static final int ADD_DEPENDENT = 2;
    private static final int SKIP_PROVIDED = 4;
    private PDOMManager fPDOMManager;
    static /* synthetic */ Class class$0;

    public IndexFactory(PDOMManager manager) {
        this.fPDOMManager = manager;
    }

    public IIndex getIndex(ICProject[] projects, int options) throws CoreException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.ICProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        projects = (ICProject[])ArrayUtil.removeNulls(clazz, projects);
        boolean addDependencies = (options & 1) != 0;
        boolean addDependent = (options & 2) != 0;
        boolean skipProvided = (options & 4) != 0;
        HashMap map = new HashMap();
        Collection selectedProjects = this.getProjects(projects, addDependencies, addDependent, map, new Integer(1));
        LinkedHashMap fragments = new LinkedHashMap();
        Iterator iter = selectedProjects.iterator();
        while (iter.hasNext()) {
            ICProject cproject = (ICProject)iter.next();
            IPDOM pdom = this.fPDOMManager.getPDOM(cproject);
            if (pdom == null) continue;
            this.safeAddFragment(fragments, pdom);
            if (skipProvided) continue;
            this.safeAddProvidedFragments(cproject, fragments);
        }
        if (fragments.isEmpty()) {
            return EmptyCIndex.INSTANCE;
        }
        int primaryFragmentCount = fragments.size();
        if (!addDependencies) {
            projects = selectedProjects.toArray(new ICProject[selectedProjects.size()]);
            selectedProjects.clear();
            selectedProjects = this.getProjects(projects, true, false, map, new Integer(2));
            Iterator iter2 = selectedProjects.iterator();
            while (iter2.hasNext()) {
                ICProject cproject = (ICProject)iter2.next();
                IPDOM pdom = this.fPDOMManager.getPDOM(cproject);
                this.safeAddFragment(fragments, pdom);
                if (skipProvided) continue;
                this.safeAddProvidedFragments(cproject, fragments);
            }
        }
        Collection pdoms = ((HashMap)fragments).values();
        return new CIndex(pdoms.toArray(new IIndexFragment[pdoms.size()]), primaryFragmentCount);
    }

    public IWritableIndex getWritableIndex(ICProject project) throws CoreException {
        ICProject cproject;
        Collection<ICProject> selectedProjects = Collections.singleton(project);
        LinkedHashMap readOnlyFrag = new LinkedHashMap();
        LinkedHashMap fragments = new LinkedHashMap();
        Iterator<Object> iter = selectedProjects.iterator();
        while (iter.hasNext()) {
            cproject = (ICProject)iter.next();
            IWritableIndexFragment pdom = (IWritableIndexFragment)((Object)this.fPDOMManager.getPDOM(cproject));
            if (pdom == null) continue;
            this.safeAddFragment(fragments, pdom);
            this.safeAddProvidedFragments(cproject, readOnlyFrag);
        }
        selectedProjects = this.getProjects(new ICProject[]{project}, true, false, new HashMap(), new Integer(1));
        selectedProjects.remove(project);
        iter = selectedProjects.iterator();
        while (iter.hasNext()) {
            cproject = (ICProject)iter.next();
            this.safeAddFragment(readOnlyFrag, this.fPDOMManager.getPDOM(cproject));
        }
        if (fragments.isEmpty()) {
            throw new CoreException(CCorePlugin.createStatus(MessageFormat.format(Messages.IndexFactory_errorNoSuchPDOM0, project.getElementName())));
        }
        Collection pdoms = fragments.values();
        Collection roPdoms = readOnlyFrag.values();
        return new WritableCIndex(pdoms.toArray(new IWritableIndexFragment[pdoms.size()]), roPdoms.toArray(new IIndexFragment[roPdoms.size()]));
    }

    private Collection getProjects(ICProject[] projects, boolean addDependencies, boolean addDependent, HashMap map, Integer markWith) {
        ArrayList<IProject> projectsToSearch = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            ICProject cproject = projects[i];
            IProject project = cproject.getProject();
            this.checkAddProject(project, map, projectsToSearch, markWith);
            projectsToSearch.add(project);
            ++i;
        }
        if (addDependencies || addDependent) {
            i = 0;
            while (i < projectsToSearch.size()) {
                IProject project = (IProject)projectsToSearch.get(i);
                try {
                    int j;
                    IProject[] nextLevel;
                    if (addDependencies) {
                        nextLevel = project.getReferencedProjects();
                        j = 0;
                        while (j < nextLevel.length) {
                            this.checkAddProject(nextLevel[j], map, projectsToSearch, markWith);
                            ++j;
                        }
                    }
                    if (addDependent) {
                        nextLevel = project.getReferencingProjects();
                        j = 0;
                        while (j < nextLevel.length) {
                            this.checkAddProject(nextLevel[j], map, projectsToSearch, markWith);
                            ++j;
                        }
                    }
                }
                catch (CoreException coreException) {
                    map.put(project, new Integer(0));
                }
                ++i;
            }
        }
        CoreModel cm = CoreModel.getDefault();
        ArrayList<ICProject> result = new ArrayList<ICProject>();
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            ICProject cproject;
            Map.Entry entry = iter.next();
            if (entry.getValue() != markWith || (cproject = cm.create((IProject)entry.getKey())) == null) continue;
            result.add(cproject);
        }
        return result;
    }

    private void checkAddProject(IProject project, HashMap map, List projectsToSearch, Integer markWith) {
        if (map.get(project) == null) {
            if (project.isOpen()) {
                map.put(project, markWith);
                projectsToSearch.add(project);
            } else {
                map.put(project, new Integer(0));
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void safeAddFragment(Map id2fragment, IIndexFragment fragment) {
        if (fragment == null) return;
        try {
            fragment.acquireReadLock();
            try {
                String id = fragment.getProperty("org.eclipse.cdt.internal.core.index.fragment.id");
                id2fragment.put(id, fragment);
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                fragment.releaseReadLock();
                throw throwable;
            }
            {
                Object var4_8 = null;
                fragment.releaseReadLock();
                return;
            }
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
            return;
        }
        catch (InterruptedException ie) {
            CCorePlugin.log(ie);
        }
    }

    private void safeAddProvidedFragments(ICProject cproject, Map fragments) {
        ICProjectDescription pd = CoreModel.getDefault().getProjectDescription(cproject.getProject(), false);
        if (pd != null) {
            IndexProviderManager ipm = CCoreInternals.getPDOMManager().getIndexProviderManager();
            ICConfigurationDescription cfg = pd.getDefaultSettingConfiguration();
            try {
                IIndexFragment[] pFragments = ipm.getProvidedIndexFragments(cfg);
                int i = 0;
                while (i < pFragments.length) {
                    this.safeAddFragment(fragments, pFragments[i]);
                    ++i;
                }
            }
            catch (CoreException ce) {
                CCorePlugin.log(ce);
            }
        }
    }
}

