/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.dom.ast.ASTSignatureUtil;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTFieldDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointer;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.c.ICASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.c.ICASTPointer;
import org.eclipse.cdt.core.dom.ast.c.ICASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionTryBlockDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPointerToMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplatedTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTypenameExpression;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPASTPointer;
import org.eclipse.cdt.core.parser.Keywords;

public class ASTStringUtil {
    private static final String COMMA_SPACE = ", ";
    private static final String[] EMPTY_STRING_ARRAY;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.model.ASTStringUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        EMPTY_STRING_ARRAY = new String[0];
    }

    public static String getQualifiedName(IASTName name) {
        return ASTStringUtil.appendQualifiedNameString(new StringBuffer(), name).toString();
    }

    public static String getSimpleName(IASTName name) {
        return ASTStringUtil.appendSimpleNameString(new StringBuffer(), name).toString();
    }

    public static String getSignatureString(IASTDeclarator declarator) {
        return ASTStringUtil.trimRight(ASTStringUtil.appendSignatureString(new StringBuffer(), declarator)).toString();
    }

    public static String getSignatureString(IASTDeclSpecifier declSpecifier, IASTDeclarator declarator) {
        StringBuffer buffer = new StringBuffer();
        ASTStringUtil.appendDeclarationString(buffer, declSpecifier, declarator, true);
        return ASTStringUtil.trimRight(buffer).toString();
    }

    public static String getTypeString(IASTDeclSpecifier declSpecifier, IASTDeclarator declarator) {
        StringBuffer buffer = new StringBuffer();
        ASTStringUtil.appendDeclarationString(buffer, declSpecifier, declarator, false);
        return ASTStringUtil.trimRight(buffer).toString();
    }

    public static String[] getParameterSignatureArray(IASTFunctionDeclarator functionDeclarator) {
        if (functionDeclarator instanceof IASTStandardFunctionDeclarator) {
            IASTStandardFunctionDeclarator standardFunctionDecl = (IASTStandardFunctionDeclarator)functionDeclarator;
            IASTParameterDeclaration[] parameters = standardFunctionDecl.getParameters();
            boolean takesVarArgs = standardFunctionDecl.takesVarArgs();
            String[] parameterStrings = new String[parameters.length + (takesVarArgs ? 1 : 0)];
            int i = 0;
            while (i < parameters.length) {
                parameterStrings[i] = ASTStringUtil.getParameterSignatureString(parameters[i]);
                ++i;
            }
            if (takesVarArgs) {
                parameterStrings[i] = new String(Keywords.cpELLIPSIS);
            }
            return parameterStrings;
        }
        if (functionDeclarator instanceof ICASTKnRFunctionDeclarator) {
            ICASTKnRFunctionDeclarator knrDeclarator = (ICASTKnRFunctionDeclarator)functionDeclarator;
            IASTName[] names = knrDeclarator.getParameterNames();
            String[] result = new String[names.length];
            int i = 0;
            while (i < names.length) {
                IASTDeclarator declaratorForParameterName;
                if (names[i] != null && (declaratorForParameterName = knrDeclarator.getDeclaratorForParameterName(names[i])) != null) {
                    result[i] = ASTStringUtil.getSignatureString(declaratorForParameterName);
                }
                ++i;
            }
            return result;
        }
        return EMPTY_STRING_ARRAY;
    }

    public static String[] getTemplateParameterArray(ICPPASTTemplateParameter[] templateParams) {
        String[] parameterTypes = new String[templateParams.length];
        int i = 0;
        while (i < templateParams.length) {
            StringBuffer paramType = new StringBuffer();
            ICPPASTTemplateParameter parameter = templateParams[i];
            ASTStringUtil.appendTemplateParameterString(paramType, parameter);
            parameterTypes[i] = ASTStringUtil.trimRight(paramType).toString();
            ++i;
        }
        return parameterTypes;
    }

    private static String getParameterSignatureString(IASTParameterDeclaration parameterDeclaration) {
        return ASTStringUtil.trimRight(ASTStringUtil.appendParameterDeclarationString(new StringBuffer(), parameterDeclaration)).toString();
    }

    private static StringBuffer appendSignatureString(StringBuffer buffer, IASTDeclarator declarator) {
        IASTNode node = declarator.getParent();
        while (node instanceof IASTDeclarator) {
            declarator = (IASTDeclarator)node;
            node = node.getParent();
        }
        IASTDeclSpecifier declSpec = node instanceof IASTParameterDeclaration ? ((IASTParameterDeclaration)node).getDeclSpecifier() : (node instanceof IASTSimpleDeclaration ? ((IASTSimpleDeclaration)node).getDeclSpecifier() : (node instanceof IASTFunctionDefinition ? ((IASTFunctionDefinition)node).getDeclSpecifier() : (node instanceof IASTTypeId ? ((IASTTypeId)node).getDeclSpecifier() : null)));
        return ASTStringUtil.appendDeclarationString(buffer, declSpec, declarator, true);
    }

    private static StringBuffer appendDeclarationString(StringBuffer buffer, IASTDeclSpecifier declSpecifier, IASTDeclarator declarator, boolean addParams) {
        if (declSpecifier != null) {
            ASTStringUtil.appendDeclSpecifierString(buffer, declSpecifier);
            ASTStringUtil.trimRight(buffer);
        }
        ASTStringUtil.appendDeclaratorString(buffer, declarator, addParams);
        return buffer;
    }

    private static StringBuffer appendDeclaratorString(StringBuffer buffer, IASTDeclarator declarator, boolean addParams) {
        IASTFieldDeclarator fieldDeclarator;
        IASTExpression bitFieldSize;
        IASTDeclarator nestedDeclarator;
        if (declarator == null) {
            return buffer;
        }
        ASTStringUtil.appendPointerOperatorsString(buffer, declarator.getPointerOperators());
        if (declarator instanceof IASTArrayDeclarator) {
            ASTStringUtil.appendArrayQualifiersString(buffer, (IASTArrayDeclarator)declarator);
        }
        if ((nestedDeclarator = declarator.getNestedDeclarator()) != null) {
            StringBuffer tmp = new StringBuffer();
            ASTStringUtil.appendDeclaratorString(tmp, nestedDeclarator, addParams);
            ASTStringUtil.trimRight(tmp);
            int tmpLength = tmp.length();
            if (tmpLength > 0) {
                if (tmp.charAt(0) != Keywords.cpLPAREN[0] || tmp.charAt(tmpLength - 1) != Keywords.cpRPAREN[0]) {
                    buffer.append(Keywords.cpLPAREN);
                    buffer.append(tmp);
                    buffer.append(Keywords.cpRPAREN);
                } else {
                    buffer.append(tmp);
                }
            }
        }
        if (!addParams) {
            return buffer;
        }
        if (declarator instanceof IASTFunctionDeclarator) {
            IASTFunctionDeclarator functionDecl = (IASTFunctionDeclarator)declarator;
            ASTStringUtil.appendParameterSignatureString(buffer, functionDecl);
            if (declarator instanceof ICPPASTFunctionDeclarator) {
                IASTTypeId[] exceptionTypeIds;
                ICPPASTFunctionDeclarator cppFunctionDecl = (ICPPASTFunctionDeclarator)declarator;
                if (cppFunctionDecl.isConst()) {
                    buffer.append("const").append(' ');
                }
                if (cppFunctionDecl.isVolatile()) {
                    buffer.append("volatile").append(' ');
                }
                if (cppFunctionDecl.isPureVirtual()) {
                    buffer.append("=0 ");
                }
                if ((exceptionTypeIds = cppFunctionDecl.getExceptionSpecification()).length > 0) {
                    buffer.append("throw").append(' ');
                    int i = 0;
                    while (i < exceptionTypeIds.length) {
                        if (i > 0) {
                            buffer.append(COMMA_SPACE);
                        }
                        ASTStringUtil.appendTypeIdString(buffer, exceptionTypeIds[i]);
                        ++i;
                    }
                }
                if (declarator instanceof ICPPASTFunctionTryBlockDeclarator && !$assertionsDisabled) {
                    throw new AssertionError((Object)("TODO: handle " + declarator.getClass().getName()));
                }
            }
        } else if (declarator instanceof IASTFieldDeclarator && (bitFieldSize = (fieldDeclarator = (IASTFieldDeclarator)declarator).getBitFieldSize()) != null) {
            buffer.append(Keywords.cpCOLON);
            ASTStringUtil.appendExpressionString(buffer, bitFieldSize);
        }
        return buffer;
    }

    private static StringBuffer appendInitializerString(StringBuffer buffer, IASTInitializer initializer) {
        if (initializer instanceof IASTInitializerExpression) {
            IASTInitializerExpression initializerExpression = (IASTInitializerExpression)initializer;
            buffer.append(Keywords.cpASSIGN);
            ASTStringUtil.appendExpressionString(buffer, initializerExpression.getExpression());
        } else if (initializer instanceof IASTInitializerList) {
            IASTInitializerList initializerList = (IASTInitializerList)initializer;
            IASTInitializer[] initializers = initializerList.getInitializers();
            buffer.append(Keywords.cpASSIGN);
            buffer.append(Keywords.cpLBRACE);
            int i = 0;
            while (i < initializers.length) {
                if (i > 0) {
                    buffer.append(COMMA_SPACE);
                }
                ASTStringUtil.appendInitializerString(buffer, initializers[i]);
                ++i;
            }
            ASTStringUtil.trimRight(buffer);
            buffer.append(Keywords.cpRBRACE);
        } else if (!(initializer instanceof ICASTDesignatedInitializer)) {
            if (initializer instanceof ICPPASTConstructorInitializer) {
                ICPPASTConstructorInitializer constructorInitializer = (ICPPASTConstructorInitializer)initializer;
                IASTExpression expression = constructorInitializer.getExpression();
                buffer.append(Keywords.cpLPAREN);
                ASTStringUtil.appendExpressionString(buffer, expression);
                ASTStringUtil.trimRight(buffer);
                buffer.append(Keywords.cpRPAREN);
            } else if (initializer != null && !$assertionsDisabled) {
                throw new AssertionError((Object)("TODO: handle " + initializer.getClass().getName()));
            }
        }
        return buffer;
    }

    private static StringBuffer appendTypeIdString(StringBuffer buffer, IASTTypeId typeId) {
        ASTStringUtil.appendDeclSpecifierString(buffer, typeId.getDeclSpecifier());
        ASTStringUtil.appendDeclaratorString(buffer, typeId.getAbstractDeclarator(), true);
        return buffer;
    }

    private static StringBuffer trimRight(StringBuffer buffer) {
        int length = buffer.length();
        while (length > 0 && buffer.charAt(length - 1) == ' ') {
            --length;
        }
        buffer.setLength(length);
        return buffer;
    }

    private static StringBuffer appendArrayQualifiersString(StringBuffer buffer, IASTArrayDeclarator declarator) {
        IASTArrayModifier[] modifiers = declarator.getArrayModifiers();
        int i = 0;
        while (i < modifiers.length) {
            buffer.append(Keywords.cpLBRACKET).append(Keywords.cpRBRACKET);
            ++i;
        }
        return buffer;
    }

    private static StringBuffer appendPointerOperatorsString(StringBuffer buffer, IASTPointerOperator[] pointerOperators) {
        int i = 0;
        while (i < pointerOperators.length) {
            IASTPointerOperator pointerOperator = pointerOperators[i];
            if (pointerOperator instanceof IASTPointer) {
                IGPPASTPointer gppPointer;
                IASTPointer pointer = (IASTPointer)pointerOperator;
                if (pointer instanceof ICPPASTPointerToMember) {
                    ICPPASTPointerToMember pointerToMember = (ICPPASTPointerToMember)pointer;
                    ASTStringUtil.appendQualifiedNameString(buffer, pointerToMember.getName());
                }
                buffer.append(Keywords.cpSTAR);
                if (pointer.isConst()) {
                    buffer.append(' ').append("const");
                }
                if (pointer.isVolatile()) {
                    buffer.append(' ').append("volatile");
                }
                if (pointerOperator instanceof ICASTPointer) {
                    ICASTPointer cPointer = (ICASTPointer)pointerOperator;
                    if (cPointer.isRestrict()) {
                        buffer.append(' ').append("restrict");
                    }
                } else if (pointerOperator instanceof IGPPASTPointer && (gppPointer = (IGPPASTPointer)pointerOperator).isRestrict()) {
                    buffer.append(' ').append("restrict");
                }
            } else if (pointerOperator instanceof ICPPASTReferenceOperator) {
                buffer.append(Keywords.cpAMPER);
            }
            ++i;
        }
        return buffer;
    }

    private static StringBuffer appendParameterSignatureString(StringBuffer buffer, IASTFunctionDeclarator functionDeclarator) {
        if (functionDeclarator instanceof IASTStandardFunctionDeclarator) {
            IASTStandardFunctionDeclarator standardFunctionDecl = (IASTStandardFunctionDeclarator)functionDeclarator;
            IASTParameterDeclaration[] parameters = standardFunctionDecl.getParameters();
            boolean takesVarArgs = standardFunctionDecl.takesVarArgs();
            buffer.append(Keywords.cpLPAREN);
            int i = 0;
            while (i < parameters.length) {
                if (i > 0) {
                    buffer.append(COMMA_SPACE);
                }
                ASTStringUtil.appendParameterDeclarationString(buffer, parameters[i]);
                ++i;
            }
            if (takesVarArgs) {
                if (parameters.length > 0) {
                    buffer.append(COMMA_SPACE);
                }
                buffer.append(Keywords.cpELLIPSIS);
            }
            ASTStringUtil.trimRight(buffer);
            buffer.append(Keywords.cpRPAREN);
        } else if (functionDeclarator instanceof ICASTKnRFunctionDeclarator) {
            ICASTKnRFunctionDeclarator knrDeclarator = (ICASTKnRFunctionDeclarator)functionDeclarator;
            IASTName[] names = knrDeclarator.getParameterNames();
            int i = 0;
            while (i < names.length) {
                IASTDeclarator declaratorForParameterName;
                if (i > 0) {
                    buffer.append(COMMA_SPACE);
                }
                if (names[i] != null && (declaratorForParameterName = knrDeclarator.getDeclaratorForParameterName(names[i])) != null) {
                    ASTStringUtil.appendSignatureString(buffer, declaratorForParameterName);
                }
                ++i;
            }
        }
        return buffer;
    }

    private static StringBuffer appendParameterDeclarationString(StringBuffer buffer, IASTParameterDeclaration parameter) {
        IASTDeclarator declarator;
        IASTDeclSpecifier declSpecifier = parameter.getDeclSpecifier();
        if (declSpecifier != null) {
            ASTStringUtil.appendDeclSpecifierString(buffer, declSpecifier);
            ASTStringUtil.trimRight(buffer);
        }
        if ((declarator = parameter.getDeclarator()) != null) {
            ASTStringUtil.appendDeclaratorString(buffer, declarator, true);
            ASTStringUtil.appendInitializerString(buffer, declarator.getInitializer());
        }
        return buffer;
    }

    private static StringBuffer appendDeclSpecifierString(StringBuffer buffer, IASTDeclSpecifier declSpecifier) {
        if (declSpecifier.isConst()) {
            buffer.append("const").append(' ');
        }
        if (declSpecifier.isVolatile()) {
            buffer.append("volatile").append(' ');
        }
        if (declSpecifier instanceof ICASTDeclSpecifier) {
            ICASTDeclSpecifier cDeclSpec = (ICASTDeclSpecifier)declSpecifier;
            if (cDeclSpec.isRestrict()) {
                buffer.append("restrict").append(' ');
            }
        } else if (declSpecifier instanceof ICPPASTDeclSpecifier) {
            IGPPASTDeclSpecifier gppDeclSpec;
            ICPPASTDeclSpecifier cppDeclSpec = (ICPPASTDeclSpecifier)declSpecifier;
            if (cppDeclSpec.isFriend()) {
                buffer.append("friend").append(' ');
            }
            if (cppDeclSpec.isVirtual()) {
                buffer.append("virtual").append(' ');
            }
            if (cppDeclSpec.isExplicit()) {
                buffer.append("explicit").append(' ');
            }
            if (declSpecifier instanceof IGPPASTDeclSpecifier && (gppDeclSpec = (IGPPASTDeclSpecifier)declSpecifier).isRestrict()) {
                buffer.append("restrict").append(' ');
            }
        }
        if (declSpecifier instanceof IASTCompositeTypeSpecifier) {
            IASTCompositeTypeSpecifier compositeTypeSpec = (IASTCompositeTypeSpecifier)declSpecifier;
            int key = compositeTypeSpec.getKey();
            switch (key) {
                case 1: {
                    buffer.append("struct").append(' ');
                    break;
                }
                case 2: {
                    buffer.append("union").append(' ');
                    break;
                }
                case 3: {
                    buffer.append("class").append(' ');
                }
            }
            ASTStringUtil.appendQualifiedNameString(buffer, compositeTypeSpec.getName());
        } else if (declSpecifier instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier elaboratedTypeSpec = (IASTElaboratedTypeSpecifier)declSpecifier;
            switch (elaboratedTypeSpec.getKind()) {
                case 0: {
                    buffer.append("enum").append(' ');
                    break;
                }
                case 1: {
                    buffer.append("struct").append(' ');
                    break;
                }
                case 2: {
                    buffer.append("union").append(' ');
                    break;
                }
                case 3: {
                    buffer.append("class").append(' ');
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            ASTStringUtil.appendQualifiedNameString(buffer, elaboratedTypeSpec.getName());
        } else if (declSpecifier instanceof IASTEnumerationSpecifier) {
            IASTEnumerationSpecifier enumerationSpec = (IASTEnumerationSpecifier)declSpecifier;
            buffer.append("enum").append(' ');
            ASTStringUtil.appendQualifiedNameString(buffer, enumerationSpec.getName());
        } else if (declSpecifier instanceof IASTSimpleDeclSpecifier) {
            IASTSimpleDeclSpecifier simpleDeclSpec = (IASTSimpleDeclSpecifier)declSpecifier;
            if (simpleDeclSpec.isSigned()) {
                buffer.append("signed").append(' ');
            }
            if (simpleDeclSpec.isUnsigned()) {
                buffer.append("unsigned").append(' ');
            }
            if (simpleDeclSpec.isShort()) {
                buffer.append("short").append(' ');
            }
            if (simpleDeclSpec.isLong()) {
                buffer.append("long").append(' ');
            }
            if (simpleDeclSpec instanceof ICASTSimpleDeclSpecifier) {
                ICASTSimpleDeclSpecifier cSimpleDeclSpec = (ICASTSimpleDeclSpecifier)simpleDeclSpec;
                if (cSimpleDeclSpec.isLongLong()) {
                    buffer.append("long long").append(' ');
                }
                if (cSimpleDeclSpec.isComplex()) {
                    buffer.append("_Complex").append(' ');
                }
                if (cSimpleDeclSpec.isImaginary()) {
                    buffer.append("_Imaginary").append(' ');
                }
                switch (simpleDeclSpec.getType()) {
                    case 6: {
                        buffer.append("_Bool").append(' ');
                    }
                }
            }
            switch (simpleDeclSpec.getType()) {
                case 1: {
                    buffer.append("void").append(' ');
                    break;
                }
                case 2: {
                    buffer.append("char").append(' ');
                    break;
                }
                case 3: {
                    buffer.append("int").append(' ');
                    break;
                }
                case 4: {
                    buffer.append("float").append(' ');
                    break;
                }
                case 5: {
                    buffer.append("double").append(' ');
                    break;
                }
                case 6: {
                    buffer.append("bool").append(' ');
                    break;
                }
                case 7: {
                    buffer.append("wchar_t").append(' ');
                }
            }
        } else if (declSpecifier instanceof IASTNamedTypeSpecifier) {
            IASTNamedTypeSpecifier namedTypeSpec = (IASTNamedTypeSpecifier)declSpecifier;
            ASTStringUtil.appendQualifiedNameString(buffer, namedTypeSpec.getName());
        }
        return buffer;
    }

    private static StringBuffer appendQualifiedNameString(StringBuffer buffer, IASTName name) {
        return ASTStringUtil.appendNameString(buffer, name, true);
    }

    private static StringBuffer appendSimpleNameString(StringBuffer buffer, IASTName name) {
        return ASTStringUtil.appendNameString(buffer, name, false);
    }

    private static StringBuffer appendNameString(StringBuffer buffer, IASTName name, boolean qualified) {
        if (name instanceof ICPPASTQualifiedName) {
            ICPPASTQualifiedName qualifiedName = (ICPPASTQualifiedName)name;
            if (qualified) {
                IASTName[] names = qualifiedName.getNames();
                int i = 0;
                while (i < names.length) {
                    if (i > 0) {
                        buffer.append(Keywords.cpCOLONCOLON);
                    }
                    ASTStringUtil.appendQualifiedNameString(buffer, names[i]);
                    ++i;
                }
            } else {
                buffer.append(qualifiedName.getLastName());
            }
        } else if (name instanceof ICPPASTTemplateId) {
            ICPPASTTemplateId templateId = (ICPPASTTemplateId)name;
            ASTStringUtil.appendQualifiedNameString(buffer, templateId.getTemplateName());
            IASTNode[] templateArguments = templateId.getTemplateArguments();
            buffer.append(Keywords.cpLT);
            int i = 0;
            while (i < templateArguments.length) {
                IASTNode argument;
                if (i > 0) {
                    buffer.append(Keywords.cpCOMMA);
                }
                if ((argument = templateArguments[i]) instanceof IASTTypeId) {
                    ASTStringUtil.appendTypeIdString(buffer, (IASTTypeId)argument);
                } else if (argument instanceof IASTExpression) {
                    IASTExpression expression = (IASTExpression)argument;
                    ASTStringUtil.appendExpressionString(buffer, expression);
                }
                ASTStringUtil.trimRight(buffer);
                ++i;
            }
            buffer.append(Keywords.cpGT);
        } else if (name != null) {
            buffer.append(name.toCharArray());
        }
        return buffer;
    }

    private static StringBuffer appendExpressionString(StringBuffer buffer, IASTExpression expression) {
        if (expression instanceof IASTIdExpression) {
            IASTIdExpression idExpression = (IASTIdExpression)expression;
            ASTStringUtil.appendQualifiedNameString(buffer, idExpression.getName());
        } else if (expression instanceof IASTExpressionList) {
            IASTExpressionList expressionList = (IASTExpressionList)expression;
            IASTExpression[] expressions = expressionList.getExpressions();
            int i = 0;
            while (i < expressions.length) {
                if (i > 0) {
                    buffer.append(COMMA_SPACE);
                }
                ASTStringUtil.appendExpressionString(buffer, expressions[i]);
                ++i;
            }
        } else if (expression instanceof ICPPASTTypenameExpression) {
            ICPPASTTypenameExpression typenameExpression = (ICPPASTTypenameExpression)expression;
            buffer.append("typename").append(' ');
            ASTStringUtil.appendQualifiedNameString(buffer, typenameExpression.getName());
            IASTExpression initialValue = typenameExpression.getInitialValue();
            if (initialValue != null) {
                buffer.append(Keywords.cpASSIGN);
                ASTStringUtil.appendExpressionString(buffer, initialValue);
            }
        } else if (expression instanceof IASTLiteralExpression) {
            buffer.append(ASTSignatureUtil.getExpressionString(expression));
        } else if (expression != null) {
            buffer.append(ASTSignatureUtil.getExpressionString(expression));
        }
        return buffer;
    }

    private static StringBuffer appendTemplateParameterString(StringBuffer buffer, ICPPASTTemplateParameter parameter) {
        if (parameter instanceof ICPPASTParameterDeclaration) {
            ASTStringUtil.appendParameterDeclarationString(buffer, (ICPPASTParameterDeclaration)parameter);
        } else if (parameter instanceof ICPPASTSimpleTypeTemplateParameter) {
            ICPPASTSimpleTypeTemplateParameter simpletypeParameter = (ICPPASTSimpleTypeTemplateParameter)parameter;
            IASTName name = simpletypeParameter.getName();
            if (name != null) {
                ASTStringUtil.appendSimpleNameString(buffer, name);
            } else {
                int type = simpletypeParameter.getParameterType();
                switch (type) {
                    case 1: {
                        buffer.append("class");
                        break;
                    }
                    case 2: {
                        buffer.append("typename");
                    }
                }
            }
        } else if (parameter instanceof ICPPASTTemplatedTypeTemplateParameter) {
            ICPPASTTemplatedTypeTemplateParameter templatedTypeParameter = (ICPPASTTemplatedTypeTemplateParameter)parameter;
            ICPPASTTemplateParameter[] subParameters = templatedTypeParameter.getTemplateParameters();
            buffer.append("template").append(Keywords.cpLT);
            int i = 0;
            while (i < subParameters.length) {
                ICPPASTTemplateParameter templateParameter = subParameters[i];
                if (i > 0) {
                    buffer.append(COMMA_SPACE);
                }
                ASTStringUtil.appendTemplateParameterString(buffer, templateParameter);
                ++i;
            }
            ASTStringUtil.trimRight(buffer);
            buffer.append(Keywords.cpGT);
        }
        return buffer;
    }
}

