/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.parser.AbstractParserLogService;
import org.eclipse.cdt.internal.core.model.IDebugLogConstants;
import org.eclipse.cdt.internal.core.model.Util;

public class ParserLogService
extends AbstractParserLogService {
    final IDebugLogConstants.DebugLogConstant topic;
    final boolean fIsTracing;
    final boolean fIsTracingExceptions;

    public ParserLogService(IDebugLogConstants.DebugLogConstant constant) {
        this.topic = constant;
        if (CCorePlugin.getDefault() == null) {
            this.fIsTracingExceptions = false;
            this.fIsTracing = false;
        } else {
            this.fIsTracingExceptions = Util.PARSER_EXCEPTIONS;
            this.fIsTracing = Util.isActive(this.topic);
        }
    }

    public void traceLog(String message) {
        Util.debugLog(message, this.topic);
    }

    public void errorLog(String message) {
        Util.log(message, ICLogConstants.CDT);
    }

    public boolean isTracing() {
        if (CCorePlugin.getDefault() == null) {
            return false;
        }
        return CCorePlugin.getDefault().isDebugging() && Util.isActive(this.topic);
    }

    public boolean isTracingExceptions() {
        return this.fIsTracingExceptions;
    }
}

