/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;

public class FindBinding {
    public static PDOMBinding findBinding(BTree btree, final PDOM pdom, final char[] name, final int[] constants) throws CoreException {
        final PDOMBinding[] result = new PDOMBinding[1];
        btree.accept(new IBTreeVisitor(){

            public int compare(int record) throws CoreException {
                IString nm1 = PDOMNamedNode.getDBName(pdom, record);
                return nm1.compareCompatibleWithIgnoreCase(name);
            }

            public boolean visit(int record) throws CoreException {
                PDOMNamedNode nnode = (PDOMNamedNode)PDOMNode.getLinkage(pdom, record).getNode(record);
                if (nnode.hasName(name)) {
                    int constant = nnode.getNodeType();
                    int i = 0;
                    while (i < constants.length) {
                        if (constant == constants[i]) {
                            result[0] = (PDOMBinding)nnode;
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                return false;
            }
        });
        return result[0];
    }

    public static PDOMBinding findBinding(IPDOMNode node, PDOM pdom, final char[] name, final int[] constants) {
        final PDOMBinding[] result = new PDOMBinding[1];
        try {
            node.accept(new IPDOMVisitor(){

                public boolean visit(IPDOMNode node) throws CoreException {
                    PDOMNamedNode nnode;
                    if (node instanceof PDOMNamedNode && (nnode = (PDOMNamedNode)node).hasName(name)) {
                        int constant = nnode.getNodeType();
                        int i = 0;
                        while (i < constants.length) {
                            if (constant == constants[i]) {
                                result[0] = (PDOMBinding)node;
                                throw new CoreException(Status.OK_STATUS);
                            }
                            ++i;
                        }
                    }
                    return false;
                }

                public void leave(IPDOMNode node) throws CoreException {
                }
            });
        }
        catch (CoreException ce) {
            if (ce.getStatus().getCode() == 0) {
                return result[0];
            }
            CCorePlugin.log(ce);
        }
        return null;
    }

    public static class DefaultBindingBTreeComparator
    implements IBTreeComparator {
        protected PDOM pdom;

        public DefaultBindingBTreeComparator(PDOM pdom) {
            this.pdom = pdom;
        }

        public int compare(int record1, int record2) throws CoreException {
            IString nm2;
            IString nm1 = PDOMNamedNode.getDBName(this.pdom, record1);
            int cmp = nm1.compareCompatibleWithIgnoreCase(nm2 = PDOMNamedNode.getDBName(this.pdom, record2));
            if (cmp == 0) {
                int t2;
                int t1 = PDOMNode.getNodeType(this.pdom, record1);
                return t1 < (t2 = PDOMNode.getNodeType(this.pdom, record2)) ? -1 : (t1 > t2 ? 1 : 0);
            }
            return cmp;
        }
    }

    public static class NestedBindingsBTreeComparator
    extends DefaultBindingBTreeComparator
    implements IBTreeComparator {
        protected PDOMLinkage linkage;

        public NestedBindingsBTreeComparator(PDOMLinkage linkage) {
            super(linkage.pdom);
            this.linkage = linkage;
        }

        public int compare(int record1, int record2) throws CoreException {
            int cmp = super.compare(record1, record2);
            if (cmp == 0) {
                if (record1 < record2) {
                    return -1;
                }
                if (record1 > record2) {
                    return 1;
                }
            }
            return cmp;
        }
    }
}

