/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.runtime.CoreException;

class PDOMCParameter
extends PDOMNamedNode
implements IParameter,
IIndexFragmentBinding {
    private static final int NEXT_PARAM = 12;
    private static final int TYPE = 16;
    public static final int RECORD_SIZE = 20;

    public PDOMCParameter(PDOM pdom, int record) {
        super(pdom, record);
    }

    public PDOMCParameter(PDOM pdom, PDOMNode parent, IParameter param) throws CoreException {
        super(pdom, parent, param.getNameCharArray());
        Database db = pdom.getDB();
        db.putInt(this.record + 12, 0);
        try {
            if (!(param instanceof IProblemBinding)) {
                IType type = param.getType();
                while (type instanceof ITypedef) {
                    type = ((ITypedef)type).getType();
                }
                if (type != null) {
                    PDOMNode typeNode = this.getLinkageImpl().addType(this, type);
                    db.putInt(this.record + 16, typeNode != null ? typeNode.getRecord() : 0);
                }
            }
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    protected int getRecordSize() {
        return 20;
    }

    public int getNodeType() {
        return 12;
    }

    public void setNextParameter(PDOMCParameter nextParam) throws CoreException {
        int rec = nextParam != null ? nextParam.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 12, rec);
    }

    public PDOMCParameter getNextParameter() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 12);
        return rec != 0 ? new PDOMCParameter(this.pdom, rec) : null;
    }

    public IASTInitializer getDefaultValue() {
        return null;
    }

    public IType getType() {
        try {
            PDOMLinkage linkage = this.getLinkageImpl();
            PDOMNode node = linkage.getNode(this.pdom.getDB().getInt(this.record + 16));
            return node instanceof IType ? (IType)((Object)node) : null;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public boolean isAuto() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isExtern() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isRegister() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isStatic() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public String getName() {
        return new String(this.getNameCharArray());
    }

    public IScope getScope() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public char[] getNameCharArray() {
        try {
            return super.getNameCharArray();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new char[0];
        }
    }

    public IIndexFragment getFragment() {
        return this.pdom;
    }

    public boolean hasDefinition() throws CoreException {
        return true;
    }

    public boolean hasDeclaration() throws CoreException {
        return true;
    }

    public int compareTo(Object arg0) {
        throw new PDOMNotImplementedError();
    }

    public boolean isFileLocal() throws CoreException {
        return true;
    }

    public String[] getQualifiedName() {
        throw new PDOMNotImplementedError();
    }

    public char[][] getQualifiedNameCharArray() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isGloballyQualified() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public int getBindingConstant() {
        return this.getNodeType();
    }

    public void delete(PDOMLinkage linkage) throws CoreException {
        linkage.deleteType(this.getType(), this.record);
        PDOMCParameter next = this.getNextParameter();
        if (next != null) {
            next.delete(linkage);
        }
        super.delete(linkage);
    }
}

