/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPEnumeration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDelegateCreator;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMASTAdapter;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPEnumerator;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPEnumeration
extends PDOMCPPBinding
implements IEnumeration,
IIndexType,
ICPPBinding,
ICPPDelegateCreator {
    private static final int FIRST_ENUMERATOR = 24;
    protected static final int RECORD_SIZE = 28;

    public PDOMCPPEnumeration(PDOM pdom, PDOMNode parent, IEnumeration enumeration) throws CoreException {
        super(pdom, parent, enumeration.getNameCharArray());
    }

    public PDOMCPPEnumeration(PDOM pdom, int record) {
        super(pdom, record);
    }

    protected int getRecordSize() {
        return 28;
    }

    public int getNodeType() {
        return 14;
    }

    public IEnumerator[] getEnumerators() throws DOMException {
        try {
            ArrayList<PDOMCPPEnumerator> enums = new ArrayList<PDOMCPPEnumerator>();
            PDOMCPPEnumerator enumerator = this.getFirstEnumerator();
            while (enumerator != null) {
                enums.add(enumerator);
                enumerator = enumerator.getNextEnumerator();
            }
            IEnumerator[] enumerators = enums.toArray(new IEnumerator[enums.size()]);
            int n = enumerators.length;
            int i = 0;
            while (i < n / 2) {
                IEnumerator tmp = enumerators[i];
                enumerators[i] = enumerators[n - 1 - i];
                enumerators[n - 1 - i] = tmp;
                ++i;
            }
            return enumerators;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IEnumerator[0];
        }
    }

    private PDOMCPPEnumerator getFirstEnumerator() throws CoreException {
        int value = this.pdom.getDB().getInt(this.record + 24);
        return value != 0 ? new PDOMCPPEnumerator(this.pdom, value) : null;
    }

    public void addEnumerator(PDOMCPPEnumerator enumerator) throws CoreException {
        PDOMCPPEnumerator first = this.getFirstEnumerator();
        enumerator.setNextEnumerator(first);
        this.pdom.getDB().putInt(this.record + 24, enumerator.getRecord());
    }

    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        try {
            if (type instanceof IEnumeration) {
                ICPPBinding etype;
                if (type instanceof ICPPBinding) {
                    etype = (ICPPBinding)((Object)type);
                    etype = (ICPPBinding)PDOMASTAdapter.getAdapterIfAnonymous(etype);
                    char[][] qname = etype.getQualifiedNameCharArray();
                    return this.hasQualifiedName(qname, qname.length - 1);
                }
                if (type instanceof PDOMCPPEnumeration) {
                    etype = (PDOMCPPEnumeration)type;
                    char[][] qname = ((PDOMCPPBinding)etype).getQualifiedNameCharArray();
                    return this.hasQualifiedName(qname, qname.length - 1);
                }
            }
        }
        catch (DOMException e) {
            CCorePlugin.log(e);
        }
        return false;
    }

    public Object clone() {
        throw new PDOMNotImplementedError();
    }

    public ICPPDelegate createDelegate(IASTName name) {
        return new CPPEnumeration.CPPEnumerationDelegate(name, this);
    }
}

