/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexFragment;
import org.eclipse.cdt.internal.core.index.IWritableIndexManager;
import org.eclipse.cdt.internal.core.pdom.IndexerProgress;
import org.eclipse.cdt.internal.core.pdom.PDOMManager;
import org.eclipse.cdt.internal.core.pdom.WritablePDOM;
import org.eclipse.cdt.internal.core.pdom.indexer.Messages;
import org.eclipse.cdt.internal.core.pdom.indexer.PDOMIndexerTask;
import org.eclipse.cdt.internal.core.pdom.indexer.TodoTaskUpdater;
import org.eclipse.cdt.internal.core.pdom.indexer.TranslationUnitCollector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class PDOMRebuildTask
implements IPDOMIndexerTask {
    protected static final String TRUE = String.valueOf(true);
    protected static final ITranslationUnit[] NO_TUS = new ITranslationUnit[0];
    private final IPDOMIndexer fIndexer;
    private final IndexerProgress fProgress;
    private volatile IPDOMIndexerTask fDelegate;

    public PDOMRebuildTask(IPDOMIndexer indexer) {
        this.fIndexer = indexer;
        this.fProgress = this.createProgress();
    }

    private IndexerProgress createProgress() {
        IndexerProgress progress = new IndexerProgress();
        progress.fTimeEstimate = 1000;
        return progress;
    }

    public IPDOMIndexer getIndexer() {
        return this.fIndexer;
    }

    public void run(IProgressMonitor monitor) {
        monitor.subTask(NLS.bind((String)Messages.PDOMIndexerTask_collectingFilesTask, (Object)this.fIndexer.getProject().getElementName()));
        ICProject project = this.fIndexer.getProject();
        if (project.getProject().isOpen()) {
            try {
                this.clearIndex(project);
                if (!"org.eclipse.cdt.core.nullindexer".equals(this.fIndexer.getID())) {
                    this.createDelegate(project, monitor);
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.fDelegate != null) {
            this.fDelegate.run(monitor);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void clearIndex(ICProject project) throws CoreException, InterruptedException {
        IWritableIndex index = ((IWritableIndexManager)CCorePlugin.getIndexManager()).getWritableIndex(project);
        index.acquireWriteLock(0);
        try {
            index.clear();
            IWritableIndexFragment wf = index.getPrimaryWritableFragment();
            if (wf instanceof WritablePDOM) {
                PDOMManager.writeProjectPDOMProperties((WritablePDOM)wf, project.getProject());
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            index.releaseWriteLock(0);
            throw throwable;
        }
        {
            Object var4_6 = null;
            index.releaseWriteLock(0);
        }
        TodoTaskUpdater.removeTasksFor((IResource)project.getProject());
    }

    private synchronized void createDelegate(ICProject project, IProgressMonitor monitor) throws CoreException {
        boolean allFiles = TRUE.equals(this.fIndexer.getProperty("indexAllFiles"));
        ArrayList sources = new ArrayList();
        ArrayList headers = allFiles ? sources : null;
        TranslationUnitCollector collector = new TranslationUnitCollector(sources, headers, allFiles, monitor);
        project.accept(collector);
        ITranslationUnit[] tus = sources.toArray(new ITranslationUnit[sources.size()]);
        this.fDelegate = this.fIndexer.createTask(tus, NO_TUS, NO_TUS);
        if (this.fDelegate instanceof PDOMIndexerTask) {
            PDOMIndexerTask delegate = (PDOMIndexerTask)this.fDelegate;
            delegate.setUpateFlags(1);
            delegate.setParseUpFront();
            delegate.setAllFilesProvided(allFiles);
        }
    }

    public synchronized IndexerProgress getProgressInformation() {
        return this.fDelegate != null ? this.fDelegate.getProgressInformation() : this.fProgress;
    }
}

