/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.ICdtVariablesContributor;
import org.eclipse.cdt.core.settings.model.CConfigurationStatus;
import org.eclipse.cdt.core.settings.model.ICBuildSetting;
import org.eclipse.cdt.core.settings.model.ICConfigExtensionReference;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICExternalSetting;
import org.eclipse.cdt.core.settings.model.ICFileDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.ICTargetPlatformSetting;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.core.settings.model.extension.CBuildData;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CDataObject;
import org.eclipse.cdt.core.settings.model.extension.CFileData;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.core.settings.model.extension.CTargetPlatformData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.PathSettingsContainer;
import org.eclipse.cdt.internal.core.settings.model.CBuildSetting;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescriptionCache;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationSpecSettings;
import org.eclipse.cdt.internal.core.settings.model.CDataProxy;
import org.eclipse.cdt.internal.core.settings.model.CDataProxyContainer;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsManager;
import org.eclipse.cdt.internal.core.settings.model.CFileDescription;
import org.eclipse.cdt.internal.core.settings.model.CFolderDescription;
import org.eclipse.cdt.internal.core.settings.model.CLanguageSetting;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescription;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.CTargetPlatformSetting;
import org.eclipse.cdt.internal.core.settings.model.CfgProxyCache;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.ICDataProxyContainer;
import org.eclipse.cdt.internal.core.settings.model.ICDataScope;
import org.eclipse.cdt.internal.core.settings.model.IInternalCCfgInfo;
import org.eclipse.cdt.internal.core.settings.model.IProxyFactory;
import org.eclipse.cdt.internal.core.settings.model.IProxyProvider;
import org.eclipse.cdt.internal.core.settings.model.InternalXmlStorageElement;
import org.eclipse.cdt.internal.core.settings.model.PathEntryConfigurationDataProvider;
import org.eclipse.cdt.internal.core.settings.model.ProviderBasedRcDesHolder;
import org.eclipse.cdt.internal.core.settings.model.ProxyProvider;
import org.eclipse.cdt.internal.core.settings.model.ResourceDescriptionHolder;
import org.eclipse.cdt.internal.core.settings.model.SettingsModelMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;

public class CConfigurationDescription
extends CDataProxyContainer
implements ICConfigurationDescription,
IProxyFactory,
IInternalCCfgInfo {
    private CfgProxyCache fCache;
    private PathSettingsContainer fPathContainer;
    private ResourceDescriptionHolder fRcHolder;
    private CConfigurationSpecSettings fCfgSpecSettings;
    private CConfigurationDescriptionCache fCfgCache;
    private boolean fIsPreference = false;

    CConfigurationDescription(CConfigurationData data, ICDataProxyContainer cr) throws CoreException {
        this(data, null, cr);
    }

    CConfigurationDescription(CConfigurationData data, String buildSystemId, ICDataProxyContainer cr) throws CoreException {
        super(data, cr, null);
        if (!(cr instanceof ICProjectDescription)) {
            this.fIsPreference = true;
        }
        if (data instanceof CConfigurationDescriptionCache) {
            this.fCfgCache = (CConfigurationDescriptionCache)data;
        }
        this.setConfiguration(this);
        if (buildSystemId != null) {
            this.getSpecSettings().setBuildSystemId(buildSystemId);
        }
    }

    CConfigurationDescription(String id, String name, ICConfigurationDescription base, CProjectDescription projectDes) throws CoreException {
        super(null, projectDes, null);
        this.setConfiguration(this);
        this.internalSetId(id);
        CConfigurationSpecSettings baseSettings = ((CConfigurationDescription)base).getSpecSettings();
        InternalXmlStorageElement baseRootEl = (InternalXmlStorageElement)baseSettings.getRootStorageElement();
        InternalXmlStorageElement newRootEl = CProjectDescriptionManager.getInstance().copyConfigurationElement(baseRootEl, id, false);
        ICStorageElement parentEl = baseRootEl.getParent();
        newRootEl = (InternalXmlStorageElement)parentEl.importChild(newRootEl);
        this.fCfgSpecSettings = new CConfigurationSpecSettings((ICConfigurationDescription)this, baseSettings, (ICStorageElement)newRootEl);
        this.fCfgSpecSettings.setId(id);
        this.fCfgSpecSettings.setName(name);
        this.fCfgSpecSettings.serializeId();
        CConfigurationData baseData = ((IInternalCCfgInfo)((Object)base)).getConfigurationData(false);
        if (baseData instanceof CConfigurationDescriptionCache) {
            baseData = ((CConfigurationDescriptionCache)baseData).getConfigurationData();
        }
        this.setData(CProjectDescriptionManager.getInstance().createData(this, base, baseData, false, null));
    }

    CConfigurationDescription(String id, String name, ICStorageElement el, CProjectDescription projectDes) throws CoreException {
        super(null, projectDes, null);
        this.setConfiguration(this);
        ICStorageElement storage = CProjectDescriptionManager.getInstance().createStorage(projectDes, id);
        this.fCfgSpecSettings = new CConfigurationSpecSettings((ICConfigurationDescription)this, storage, el);
        this.fCfgSpecSettings.setId(id);
        this.fCfgSpecSettings.setName(name);
        this.fCfgSpecSettings.setBuildSystemId("org.eclipse.cdt.core.defaultConfigDataProvider");
        CProjectDescriptionManager mngr = CProjectDescriptionManager.getInstance();
        CConfigurationData data = mngr.createDefaultConfigData(projectDes.getProject(), id, name, PathEntryConfigurationDataProvider.getDataFactory());
        this.setData(data);
        this.fCfgSpecSettings.reconsileExtensionSettings(false);
    }

    CConfigurationDescription(String id, String name, String bsId, ICStorageElement el, ICDataProxyContainer cr) throws CoreException {
        super(null, cr, null);
        this.fIsPreference = true;
        this.setConfiguration(this);
        this.fCfgSpecSettings = new CConfigurationSpecSettings((ICConfigurationDescription)this, el);
        this.fCfgSpecSettings.setId(id);
        this.fCfgSpecSettings.setName(name);
        this.fCfgSpecSettings.setBuildSystemId(bsId);
        this.setData(CProjectDescriptionManager.getInstance().loadData(this, null));
    }

    void doWritable() throws CoreException {
        if (!this.containsWritableData()) {
            CConfigurationData data = this.getConfigurationData(false);
            CConfigurationDescriptionCache cache = (CConfigurationDescriptionCache)data;
            data = cache.getConfigurationData();
            this.setData(CProjectDescriptionManager.getInstance().createData(this, cache, data, true, null));
        }
    }

    public String getId() {
        String id = super.getId();
        if (id == null) {
            try {
                id = this.getSpecSettings().getId();
            }
            catch (CoreException coreException) {}
        }
        return id;
    }

    public String getName() {
        String name = super.getName();
        if (name == null) {
            try {
                name = this.getSpecSettings().getName();
            }
            catch (CoreException coreException) {}
        }
        return name;
    }

    public String getDescription() {
        CConfigurationData data = this.getConfigurationData(false);
        return data.getDescription();
    }

    public CConfigurationData getConfigurationData(boolean write) {
        CConfigurationData data = (CConfigurationData)this.getData(write);
        if (data == null) {
            throw new IllegalStateException();
        }
        return data;
    }

    public ICProjectDescription getProjectDescription() {
        if (this.fIsPreference) {
            return null;
        }
        return (ICProjectDescription)this.getParent();
    }

    public ICResourceDescription[] getResourceDescriptions(int kind) {
        return this.getRcHolder().getResourceDescriptions(kind);
    }

    public ICFolderDescription getRootFolderDescription() {
        return (ICFolderDescription)this.getRcHolder().getCurrentResourceDescription();
    }

    public boolean isActive() {
        if (this.fIsPreference) {
            return false;
        }
        return this.getProjectDescription().getActiveConfiguration() == this;
    }

    public void setActive() throws WriteAccessException {
        if (this.fIsPreference) {
            return;
        }
        this.getProjectDescription().setActiveConfiguration(this);
    }

    public void removeResourceDescription(ICResourceDescription des) throws CoreException {
        CConfigurationData data = this.getConfigurationData(true);
        IPath path = des.getPath();
        this.getRcHolder().removeResurceDescription(path);
        data.removeResourceData((CResourceData)((CDataProxy)((Object)des)).getData(false));
    }

    public final int getType() {
        return 2;
    }

    public CDataProxy createProxy(CDataObject data) {
        switch (data.getType()) {
            case 4: {
                return new CFolderDescription((CFolderData)data, this);
            }
            case 8: {
                return new CFileDescription((CFileData)data, this);
            }
            case 32: {
                return new CTargetPlatformSetting((CTargetPlatformData)data, this);
            }
            case 64: {
                return new CBuildSetting((CBuildData)data, this);
            }
        }
        return null;
    }

    protected IProxyProvider createChildProxyProvider() {
        ICDataScope scope = new ICDataScope(){

            public CDataObject[] getChildren() {
                CConfigurationData data = CConfigurationDescription.this.getConfigurationData(false);
                ArrayList<CDataObject> list = new ArrayList<CDataObject>();
                CResourceData[] rcDatas = data.getResourceDatas();
                int i = 0;
                while (i < rcDatas.length) {
                    list.add(rcDatas[i]);
                    ++i;
                }
                CTargetPlatformData tpData = data.getTargetPlatformData();
                list.add(tpData);
                CBuildData buildData = data.getBuildData();
                list.add(buildData);
                return list.toArray(new CDataObject[list.size()]);
            }

            public boolean isStatic() {
                return !CConfigurationDescription.this.containsWritableData();
            }
        };
        CfgProxyCache cache = this.getCfgProxyCache();
        return new ProxyProvider(scope, cache, this);
    }

    protected ResourceDescriptionHolder createHolder(CFolderDescription des) {
        PathSettingsContainer container = des.getPathContainer();
        if (container == null) {
            container = this.getPathContainer().getChildContainer(des.getPath(), true, true);
            des.setPathContainer(container);
        }
        return new ProviderBasedRcDesHolder(this.getChildrenProxyProvider(), container, false);
    }

    protected ResourceDescriptionHolder createHolder(CFileDescription des) {
        PathSettingsContainer container = des.getPathContainer();
        if (container == null) {
            container = this.getPathContainer().getChildContainer(des.getPath(), true, true);
            des.setPathContainer(container);
        }
        return new ProviderBasedRcDesHolder(this.getChildrenProxyProvider(), container, false);
    }

    private CfgProxyCache getCfgProxyCache() {
        if (this.fCache == null) {
            this.fCache = new CfgProxyCache(this.getPathContainer());
        }
        return this.fCache;
    }

    private PathSettingsContainer getPathContainer() {
        if (this.fPathContainer == null) {
            this.fPathContainer = PathSettingsContainer.createRootContainer();
        }
        return this.fPathContainer;
    }

    private ResourceDescriptionHolder getRcHolder() {
        if (this.fRcHolder == null) {
            this.fRcHolder = new ProviderBasedRcDesHolder(this.getChildrenProxyProvider(), this.getPathContainer(), true);
        }
        return this.fRcHolder;
    }

    public ICResourceDescription getResourceDescription(IPath path, boolean exactPath) {
        return this.getRcHolder().getResourceDescription(path, exactPath);
    }

    public void setDescription(String des) throws WriteAccessException {
        this.getConfigurationData(true).setDescription(des);
    }

    public ICResourceDescription[] getResourceDescriptions() {
        return this.getResourceDescriptions(12);
    }

    public ICStorageElement getStorage(String id, boolean create) throws CoreException {
        return this.getSpecSettings().getStorage(id, create);
    }

    public void removeStorage(String id) throws CoreException {
        this.getSpecSettings().removeStorage(id);
    }

    public boolean containsStorage(String id) throws CoreException {
        return this.getSpecSettings().containsStorage(id);
    }

    public CConfigurationSpecSettings getSpecSettings() throws CoreException {
        if (this.fCfgSpecSettings == null) {
            if (this.fCfgCache != null) {
                if (this.fCfgCache.isInitializing()) {
                    this.fCfgSpecSettings = this.fCfgCache.getSpecSettings();
                } else {
                    this.fCfgSpecSettings = new CConfigurationSpecSettings((ICConfigurationDescription)this, this.fCfgCache.getSpecSettings());
                    this.fCfgCache = null;
                }
            } else {
                this.fCfgSpecSettings = new CConfigurationSpecSettings((ICConfigurationDescription)this, null);
            }
        } else if (this.fCfgSpecSettings.getConfigurarion() != this && !this.fCfgCache.isInitializing()) {
            this.fCfgSpecSettings = new CConfigurationSpecSettings((ICConfigurationDescription)this, this.fCfgCache.getSpecSettings());
            this.fCfgCache = null;
        }
        return this.fCfgSpecSettings;
    }

    public String getBuildSystemId() {
        try {
            return this.getSpecSettings().getBuildSystemId();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public CConfigurationData getConfigurationData() {
        CConfigurationData data = this.getConfigurationData(true);
        if (data instanceof CConfigurationDescriptionCache) {
            data = ((CConfigurationDescriptionCache)data).getConfigurationData();
        }
        return data;
    }

    public void setConfigurationData(String buildSystemId, CConfigurationData data) throws WriteAccessException {
        String oldId = this.getId();
        this.setData(data);
        if (!this.fIsPreference) {
            ((CProjectDescription)this.getProjectDescription()).updateMap(this, oldId);
        }
        try {
            CConfigurationSpecSettings settings = this.getSpecSettings();
            settings.setId(data.getId());
            settings.setName(data.getName());
            settings.setBuildSystemId(buildSystemId);
        }
        catch (CoreException coreException) {}
    }

    public boolean isModified() {
        try {
            CConfigurationSpecSettings settings = this.getSpecSettings();
            if (settings.isModified()) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return !(this.getConfigurationData(false) instanceof CConfigurationDescriptionCache);
    }

    void removeConfiguration() {
        try {
            this.getSpecSettings().removeConfiguration();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        ((CProjectDescription)this.getProjectDescription()).configurationRemoved(this);
        this.remove();
    }

    public ICFileDescription createFileDescription(IPath path, ICResourceDescription base) throws CoreException, WriteAccessException {
        CConfigurationData data = this.getConfigurationData(true);
        CResourceData baseRcData = (CResourceData)((CDataProxy)((Object)base)).getData(true);
        CFileData createdData = null;
        if (base instanceof ICFileDescription) {
            createdData = data.createFileData(path, (CFileData)baseRcData);
        } else {
            ICFolderDescription baseFo = (ICFolderDescription)base;
            String fileName = path.lastSegment();
            CLanguageSetting baseLang = (CLanguageSetting)baseFo.getLanguageSettingForFile(fileName);
            CLanguageData baseLangData = baseLang != null ? (CLanguageData)baseLang.getData(false) : null;
            createdData = data.createFileData(path, (CFolderData)baseRcData, baseLangData);
        }
        if (createdData == null) {
            throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CConfigurationDescription.0"));
        }
        CDataProxy proxy = this.getChildrenProxyProvider().getProxy(createdData);
        if (!(proxy instanceof ICFileDescription)) {
            throw ExceptionFactory.createCoreException(String.valueOf(SettingsModelMessages.getString("CConfigurationDescription.1")) + proxy.getClass().getName());
        }
        return (ICFileDescription)((Object)proxy);
    }

    public ICFolderDescription createFolderDescription(IPath path, ICFolderDescription base) throws CoreException, WriteAccessException {
        CFolderData baseRcData;
        CConfigurationData data = this.getConfigurationData(true);
        CFolderData createdData = data.createFolderData(path, baseRcData = (CFolderData)((CDataProxy)((Object)base)).getData(true));
        if (createdData == null) {
            throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CConfigurationDescription.2"));
        }
        CDataProxy proxy = this.getChildrenProxyProvider().getProxy(createdData);
        if (!(proxy instanceof ICFolderDescription)) {
            throw ExceptionFactory.createCoreException(String.valueOf(SettingsModelMessages.getString("CConfigurationDescription.3")) + proxy.getClass().getName());
        }
        return (ICFolderDescription)((Object)proxy);
    }

    public ICTargetPlatformSetting getTargetPlatformSetting() {
        CConfigurationData data = this.getConfigurationData(false);
        return (ICTargetPlatformSetting)((Object)this.getChildrenProxyProvider().getProxy(data.getTargetPlatformData()));
    }

    public ICFileDescription[] getFileDescriptions() {
        return (ICFileDescription[])this.getRcHolder().getResourceDescriptions(8);
    }

    public ICFolderDescription[] getFolderDescriptions() {
        return (ICFolderDescription[])this.getRcHolder().getResourceDescriptions(4);
    }

    public ICSourceEntry[] getSourceEntries() {
        CConfigurationData data = this.getConfigurationData(false);
        ICSourceEntry[] srcEntries = data.getSourceEntries();
        IProject proj = this.fIsPreference ? null : this.getProjectDescription().getProject();
        return CDataUtil.adjustEntries(srcEntries, true, proj);
    }

    public void setSourceEntries(ICSourceEntry[] entries) throws CoreException {
        IProject project;
        CConfigurationData data = this.getConfigurationData(true);
        IProject iProject = project = this.fIsPreference ? null : this.getProjectDescription().getProject();
        if (entries != null) {
            entries = CDataUtil.adjustEntries(entries, false, project);
        }
        data.setSourceEntries(entries);
        if (entries == null) {
            CExternalSettingsManager.getInstance().restoreSourceEntryDefaults(this);
        }
    }

    public Map getReferenceInfo() {
        try {
            CConfigurationSpecSettings specs = this.getSpecSettings();
            return specs.getReferenceInfo();
        }
        catch (CoreException coreException) {
            return new HashMap(0);
        }
    }

    public void setReferenceInfo(Map refs) {
        try {
            CConfigurationSpecSettings specs = this.getSpecSettings();
            specs.setReferenceInfo(refs);
        }
        catch (CoreException coreException) {}
    }

    public ICExternalSetting createExternalSetting(String[] languageIDs, String[] contentTypeIDs, String[] extensions, ICSettingEntry[] entries) {
        try {
            return this.getSpecSettings().createExternalSetting(languageIDs, contentTypeIDs, extensions, entries);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public ICExternalSetting[] getExternalSettings() {
        try {
            return this.getSpecSettings().getExternalSettings();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public void removeExternalSetting(ICExternalSetting setting) {
        try {
            this.getSpecSettings().removeExternalSetting(setting);
        }
        catch (CoreException coreException) {}
    }

    public void removeExternalSettings() {
        try {
            this.getSpecSettings().removeExternalSettings();
        }
        catch (CoreException coreException) {}
    }

    public ICBuildSetting getBuildSetting() {
        CConfigurationData data = this.getConfigurationData(false);
        return (ICBuildSetting)((Object)this.getChildrenProxyProvider().getProxy(data.getBuildData()));
    }

    public void setSessionProperty(QualifiedName name, Object value) {
        try {
            this.getSpecSettings().setSettionProperty(name, value);
        }
        catch (CoreException coreException) {}
    }

    public Object getSessionProperty(QualifiedName name) {
        try {
            return this.getSpecSettings().getSettionProperty(name);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public ICdtVariablesContributor getBuildVariablesContributor() {
        CConfigurationData data = this.getConfigurationData(false);
        return data.getBuildVariablesContributor();
    }

    public void setName(String name) {
        if (name.equals(this.getName())) {
            return;
        }
        this.getConfigurationData(true).setName(name);
        try {
            this.getSpecSettings().setName(name);
        }
        catch (CoreException coreException) {}
    }

    public ICConfigExtensionReference create(String extensionPoint, String extension) throws CoreException {
        return this.getSpecSettings().create(extensionPoint, extension);
    }

    public ICConfigExtensionReference[] get(String extensionPointID) {
        try {
            return this.getSpecSettings().get(extensionPointID);
        }
        catch (CoreException coreException) {
            return new ICConfigExtensionReference[0];
        }
    }

    public void remove(ICConfigExtensionReference ext) throws CoreException {
        this.getSpecSettings().remove(ext);
    }

    public void remove(String extensionPoint) throws CoreException {
        this.getSpecSettings().remove(extensionPoint);
    }

    public boolean isPreferenceConfiguration() {
        return this.fIsPreference;
    }

    protected boolean containsWritableData() {
        if (super.containsWritableData()) {
            return true;
        }
        CConfigurationDescriptionCache data = (CConfigurationDescriptionCache)this.doGetData();
        return data.isInitializing();
    }

    public ICLanguageSetting getLanguageSettingForFile(IPath path, boolean ignoreExcludeStatus) {
        return CProjectDescriptionManager.getLanguageSettingForFile(this, path, ignoreExcludeStatus);
    }

    boolean isExcluded(IPath path) {
        IProject project = this.fIsPreference ? null : this.getProjectDescription().getProject();
        ICSourceEntry[] entries = this.getResolvedSourceEntries();
        if (project != null) {
            path = project.getFullPath().append(path);
        }
        return CDataUtil.isExcluded(path, entries);
    }

    void setExcluded(IPath path, boolean isFolder, boolean exclude) {
        if (this.isExcluded(path) == exclude) {
            return;
        }
        ICSourceEntry[] newEntries = this.getUpdatedSourceEntries(path, isFolder, exclude);
        if (newEntries != null) {
            try {
                this.setSourceEntries(newEntries);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
    }

    boolean canExclude(IPath path, boolean isFolder, boolean exclude) {
        if (this.isExcluded(path) == exclude) {
            return true;
        }
        return this.getUpdatedSourceEntries(path, isFolder, exclude) != null;
    }

    private ICSourceEntry[] getUpdatedSourceEntries(IPath path, boolean isFolder, boolean exclude) {
        ICConfigurationDescription roCfg;
        ICProjectDescription roDes;
        IProject project;
        IProject iProject = project = this.fIsPreference ? null : this.getProjectDescription().getProject();
        if (project != null) {
            path = project.getFullPath().append(path);
        }
        CConfigurationData data = this.getConfigurationData(false);
        ICSourceEntry[] newEntries = null;
        if (project != null && !(data instanceof CConfigurationDescriptionCache) && (roDes = CProjectDescriptionManager.getInstance().getProjectDescription(project, false)) != null && (roCfg = roDes.getConfigurationById(this.getId())) != null) {
            newEntries = roCfg.getResolvedSourceEntries();
            newEntries = CDataUtil.isExcluded(path, newEntries) != exclude ? (ICSourceEntry[])null : roCfg.getSourceEntries();
        }
        if (newEntries == null) {
            try {
                newEntries = CDataUtil.setExcluded(path, isFolder, exclude, this.getResolvedSourceEntries(), false);
                if (CDataUtil.isEqual(newEntries, this.getResolvedSourceEntries())) {
                    newEntries = null;
                }
            }
            catch (CoreException coreException) {}
        }
        return newEntries;
    }

    public String[] getExternalSettingsProviderIds() {
        try {
            return this.getSpecSettings().getExternalSettingsProviderIds();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new String[0];
        }
    }

    public void setExternalSettingsProviderIds(String[] ids) {
        try {
            this.getSpecSettings().setExternalSettingsProviderIds(ids);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    public void updateExternalSettingsProviders(String[] ids) {
        try {
            this.getSpecSettings().updateExternalSettingsProviders(ids);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    public ICSourceEntry[] getResolvedSourceEntries() {
        ICSourceEntry[] entries = this.getSourceEntries();
        return CDataUtil.resolveEntries(entries, (ICConfigurationDescription)this);
    }

    public CConfigurationStatus getConfigurationStatus() {
        CConfigurationData data = this.getConfigurationData(false);
        CConfigurationStatus status = data.getStatus();
        return status != null ? status : CConfigurationStatus.CFG_STATUS_OK;
    }
}

