/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.List;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.ICSettingContainer;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultLanguageData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.CSettingEntryFactory;
import org.eclipse.cdt.core.settings.model.util.EntryStore;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescriptionCache;
import org.eclipse.cdt.internal.core.settings.model.CFileDescriptionCache;
import org.eclipse.cdt.internal.core.settings.model.CFolderDescriptionCache;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.ICachedData;
import org.eclipse.core.resources.IProject;

public class CLanguageSettingCache
extends CDefaultLanguageData
implements ICLanguageSetting,
ICachedData {
    private ICResourceDescription fParent;
    protected EntryStore fResolvedEntriesStore;
    private String[] fCachedExtensions;
    private boolean fContainsDiscoveredScannerInfo = true;

    public CLanguageSettingCache(CLanguageData base, CFolderDescriptionCache folderCache) {
        this.fId = base.getId();
        this.fParent = folderCache;
        this.copySettingsFrom(base);
    }

    public CLanguageSettingCache(CLanguageData base, CFileDescriptionCache fileCache) {
        this.fId = base.getId();
        this.fParent = fileCache;
        this.copySettingsFrom(base);
    }

    protected void copySettingsFrom(CLanguageData data) {
        super.copySettingsFrom(data);
        this.fContainsDiscoveredScannerInfo = data.containsDiscoveredScannerInfo();
    }

    public ICLanguageSettingEntry[] getResolvedSettingEntries(int kind) {
        ICLanguageSettingEntry[] entries = this.getSettingEntries(kind);
        if (entries.length != 0) {
            ICLanguageSettingEntry[] resolved;
            if (this.fResolvedEntriesStore == null) {
                this.fResolvedEntriesStore = new EntryStore();
            }
            if ((resolved = this.fResolvedEntriesStore.getEntries(kind)).length == 0) {
                resolved = CDataUtil.resolveEntries(entries, this.getConfiguration());
                this.fResolvedEntriesStore.storeEntries(kind, resolved);
            }
            entries = resolved;
        }
        return entries;
    }

    private IProject getProject() {
        return this.getConfiguration().getProjectDescription().getProject();
    }

    public String[] getSourceExtensions() {
        if (this.fCachedExtensions == null) {
            String[] typeIds = this.getSourceContentTypeIds();
            String[] exts = null;
            exts = typeIds != null && typeIds.length != 0 ? CDataUtil.getExtensionsFromContentTypes(this.getProject(), typeIds) : ((exts = super.getSourceExtensions()) != null && exts.length != 0 ? (String[])exts.clone() : CDefaultLanguageData.EMPTY_STRING_ARRAY);
            if (exts == null) {
                exts = CDefaultLanguageData.EMPTY_STRING_ARRAY;
            }
            this.fCachedExtensions = exts;
        }
        if (this.fCachedExtensions.length != 0) {
            return (String[])this.fCachedExtensions.clone();
        }
        return this.fCachedExtensions;
    }

    public ICLanguageSettingEntry[] getSettingEntries(int kind) {
        return this.fStore.getEntries(kind);
    }

    public List getSettingEntriesList(int kind) {
        return this.fStore.getEntriesList(kind);
    }

    public void setLanguageId(String id) {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    public void setName(String name) {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    public void setSettingEntries(int kind, List entriesList) {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    public void setEntries(int kind, ICLanguageSettingEntry[] entries) {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    public void setSettingEntries(int kind, ICLanguageSettingEntry[] entries) {
        throw ExceptionFactory.createIsReadOnlyException();
    }

    public boolean supportsEntryKind(int kind) {
        return (this.getSupportedEntryKinds() & kind) == kind;
    }

    public ICConfigurationDescription getConfiguration() {
        return this.fParent.getConfiguration();
    }

    public ICSettingContainer getParent() {
        return this.fParent;
    }

    public boolean isReadOnly() {
        return true;
    }

    protected ICLanguageSettingEntry[] processStoredEntries(ICLanguageSettingEntry[] entries, int op) {
        CConfigurationDescriptionCache cfgCache;
        CSettingEntryFactory factory;
        if (entries.length != 0 && (factory = (cfgCache = (CConfigurationDescriptionCache)this.getConfiguration()).getSettingsFactory()) != null) {
            int i = 0;
            while (i < entries.length) {
                entries[i] = factory.getLanguageSettingEntry(entries[i]);
                ++i;
            }
        }
        return entries;
    }

    public boolean containsDiscoveredScannerInfo() {
        return this.fContainsDiscoveredScannerInfo;
    }
}

