/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.ArrayList;
import org.eclipse.cdt.core.settings.model.ICFileDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.util.IPathSettingsContainerVisitor;
import org.eclipse.cdt.core.settings.model.util.PathSettingsContainer;
import org.eclipse.core.runtime.IPath;

public class ResourceDescriptionHolder {
    private PathSettingsContainer fPathSettingContainer;
    private boolean fIncludeCurrent;

    public ResourceDescriptionHolder(PathSettingsContainer pathContainer, boolean includeCurrent) {
        this.fPathSettingContainer = pathContainer;
        this.fIncludeCurrent = includeCurrent;
    }

    public ICResourceDescription getResourceDescription(IPath path, boolean exactPath) {
        PathSettingsContainer container = this.fPathSettingContainer.getChildContainer(path, false, exactPath);
        if (container != null) {
            return (ICResourceDescription)container.getValue();
        }
        return null;
    }

    public IPath getCurrentPath() {
        return this.fPathSettingContainer.getPath();
    }

    public void setCurrentPath(IPath path) {
        this.fPathSettingContainer.setPath(path, true);
    }

    public void addResourceDescription(IPath path, ICResourceDescription des) {
        PathSettingsContainer container = this.fPathSettingContainer.getChildContainer(path, true, true);
        container.setValue(des);
    }

    public ICResourceDescription[] getResourceDescriptions(final int kind) {
        final ArrayList list = new ArrayList();
        this.fPathSettingContainer.accept(new IPathSettingsContainerVisitor(){

            public boolean visit(PathSettingsContainer container) {
                ICResourceDescription des = (ICResourceDescription)container.getValue();
                if ((container != ResourceDescriptionHolder.this.fPathSettingContainer || ResourceDescriptionHolder.this.fIncludeCurrent) && (kind & des.getType()) == des.getType()) {
                    list.add(des);
                }
                return true;
            }
        });
        if (kind == 8) {
            return list.toArray(new ICFileDescription[list.size()]);
        }
        if (kind == 4) {
            return list.toArray(new ICFolderDescription[list.size()]);
        }
        return list.toArray(new ICResourceDescription[list.size()]);
    }

    public ICResourceDescription[] getResourceDescriptions() {
        final ArrayList list = new ArrayList();
        this.fPathSettingContainer.accept(new IPathSettingsContainerVisitor(){

            public boolean visit(PathSettingsContainer container) {
                list.add(container.getValue());
                return true;
            }
        });
        return list.toArray(new ICResourceDescription[list.size()]);
    }

    public void removeResurceDescription(IPath path) {
        this.fPathSettingContainer.removeChildContainer(path);
    }

    public ICResourceDescription getCurrentResourceDescription() {
        return (ICResourceDescription)this.fPathSettingContainer.getValue();
    }

    public ICResourceDescription[] getDirectChildren() {
        PathSettingsContainer[] dc = this.fPathSettingContainer.getDirectChildren();
        ICResourceDescription[] rcDess = new ICResourceDescription[dc.length];
        int i = 0;
        while (i < dc.length) {
            rcDess[i] = (ICResourceDescription)dc[i].getValue();
            ++i;
        }
        return rcDess;
    }

    public ICFolderDescription getParentFolderDescription() {
        PathSettingsContainer parent = this.fPathSettingContainer.getParentContainer();
        if (parent != null) {
            return (ICFolderDescription)parent.getValue();
        }
        return null;
    }

    public static IPath normalizePath(IPath path) {
        return path.makeRelative();
    }
}

