/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.formatter;

import java.util.HashMap;
import java.util.Map;

public class DefaultCodeFormatterOptions {
    public static final int TAB = 1;
    public static final int SPACE = 2;
    public static final int MIXED = 4;
    public int alignment_for_arguments_in_method_invocation;
    public int alignment_for_compact_if;
    public int alignment_for_conditional_expression;
    public int alignment_for_expressions_in_array_initializer;
    public int alignment_for_parameters_in_method_declaration;
    public String brace_position_for_array_initializer;
    public String brace_position_for_block;
    public String brace_position_for_block_in_case;
    public String brace_position_for_method_declaration;
    public String brace_position_for_type_declaration;
    public String brace_position_for_namespace_declaration;
    public String brace_position_for_switch;
    public int continuation_indentation;
    public int continuation_indentation_for_array_initializer;
    public boolean indent_statements_compare_to_block;
    public boolean indent_statements_compare_to_body;
    public boolean indent_body_declarations_compare_to_access_specifier;
    public boolean indent_access_specifier_compare_to_type_header;
    public boolean indent_body_declarations_compare_to_namespace_header;
    public boolean indent_breaks_compare_to_cases;
    public boolean indent_empty_lines;
    public boolean indent_switchstatements_compare_to_cases;
    public boolean indent_switchstatements_compare_to_switch;
    public int indentation_size;
    public boolean insert_new_line_after_opening_brace_in_array_initializer;
    public boolean insert_new_line_at_end_of_file_if_missing;
    public boolean insert_new_line_before_closing_brace_in_array_initializer;
    public boolean insert_new_line_before_else_in_if_statement;
    public boolean insert_new_line_before_while_in_do_statement;
    public boolean insert_new_line_in_empty_block;
    public boolean insert_space_after_closing_brace_in_block;
    public boolean insert_space_after_colon_in_case;
    public boolean insert_space_after_colon_in_conditional;
    public boolean insert_space_after_comma_in_array_initializer;
    public boolean insert_space_after_comma_in_method_invocation_arguments;
    public boolean insert_space_after_comma_in_method_declaration_parameters;
    public boolean insert_space_after_opening_brace_in_array_initializer;
    public boolean insert_space_after_opening_paren_in_for;
    public boolean insert_space_after_opening_paren_in_if;
    public boolean insert_space_after_opening_paren_in_method_declaration;
    public boolean insert_space_after_opening_paren_in_method_invocation;
    public boolean insert_space_after_opening_paren_in_switch;
    public boolean insert_space_after_opening_paren_in_while;
    public boolean insert_space_after_question_in_conditional;
    public boolean insert_space_after_semicolon_in_for;
    public boolean insert_space_before_closing_brace_in_array_initializer;
    public boolean insert_space_before_closing_paren_in_for;
    public boolean insert_space_before_closing_paren_in_if;
    public boolean insert_space_before_closing_paren_in_method_declaration;
    public boolean insert_space_before_closing_paren_in_method_invocation;
    public boolean insert_space_before_closing_paren_in_switch;
    public boolean insert_space_before_closing_paren_in_while;
    public boolean insert_space_before_colon_in_case;
    public boolean insert_space_before_colon_in_conditional;
    public boolean insert_space_before_colon_in_default;
    public boolean insert_space_before_comma_in_array_initializer;
    public boolean insert_space_before_comma_in_method_invocation_arguments;
    public boolean insert_space_before_comma_in_method_declaration_parameters;
    public boolean insert_space_before_opening_brace_in_array_initializer;
    public boolean insert_space_before_opening_brace_in_block;
    public boolean insert_space_before_opening_brace_in_method_declaration;
    public boolean insert_space_before_opening_brace_in_type_declaration;
    public boolean insert_space_before_opening_brace_in_namespace_declaration;
    public boolean insert_space_before_opening_paren_in_for;
    public boolean insert_space_before_opening_paren_in_if;
    public boolean insert_space_before_opening_paren_in_method_invocation;
    public boolean insert_space_before_opening_paren_in_method_declaration;
    public boolean insert_space_before_opening_paren_in_switch;
    public boolean insert_space_before_opening_brace_in_switch;
    public boolean insert_space_before_opening_paren_in_while;
    public boolean insert_space_before_question_in_conditional;
    public boolean insert_space_before_semicolon;
    public boolean insert_space_before_semicolon_in_for;
    public boolean insert_space_between_empty_braces_in_array_initializer;
    public boolean insert_space_between_empty_parens_in_method_declaration;
    public boolean compact_else_if;
    public boolean keep_guardian_clause_on_one_line;
    public boolean keep_else_statement_on_same_line;
    public boolean keep_empty_array_initializer_on_one_line;
    public boolean keep_simple_if_on_one_line;
    public boolean keep_then_statement_on_same_line;
    public int number_of_empty_lines_to_preserve;
    public boolean put_empty_statement_on_new_line;
    public int tab_size;
    public int page_width;
    public int tab_char = 1;
    public boolean use_tabs_only_for_leading_indentations;
    public int initial_indentation_level;
    public String line_separator;

    public static DefaultCodeFormatterOptions getDefaultSettings() {
        DefaultCodeFormatterOptions options = new DefaultCodeFormatterOptions();
        options.setDefaultSettings();
        return options;
    }

    public static DefaultCodeFormatterOptions getKandRSettings() {
        DefaultCodeFormatterOptions options = new DefaultCodeFormatterOptions();
        options.setKandRSettings();
        return options;
    }

    public static DefaultCodeFormatterOptions getAllmanSettings() {
        DefaultCodeFormatterOptions options = new DefaultCodeFormatterOptions();
        options.setAllmanSettings();
        return options;
    }

    public static DefaultCodeFormatterOptions getGNUSettings() {
        DefaultCodeFormatterOptions options = new DefaultCodeFormatterOptions();
        options.setGNUSettings();
        return options;
    }

    public static DefaultCodeFormatterOptions getWhitesmithsSettings() {
        DefaultCodeFormatterOptions options = new DefaultCodeFormatterOptions();
        options.setWhitesmitsSettings();
        return options;
    }

    private DefaultCodeFormatterOptions() {
    }

    public DefaultCodeFormatterOptions(Map settings) {
        this.setDefaultSettings();
        if (settings == null) {
            return;
        }
        this.set(settings);
    }

    private String getAlignment(int alignment) {
        return Integer.toString(alignment);
    }

    public Map getMap() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.eclipse.cdt.core.formatter.alignment_for_arguments_in_method_invocation", this.getAlignment(this.alignment_for_arguments_in_method_invocation));
        options.put("org.eclipse.cdt.core.formatter.alignment_for_conditional_expression", this.getAlignment(this.alignment_for_conditional_expression));
        options.put("org.eclipse.cdt.core.formatter.alignment_for_expressions_in_array_initializer", this.getAlignment(this.alignment_for_expressions_in_array_initializer));
        options.put("org.eclipse.cdt.core.formatter.alignment_for_parameters_in_method_declaration", this.getAlignment(this.alignment_for_parameters_in_method_declaration));
        options.put("org.eclipse.cdt.core.formatter.brace_position_for_array_initializer", this.brace_position_for_array_initializer);
        options.put("org.eclipse.cdt.core.formatter.brace_position_for_block", this.brace_position_for_block);
        options.put("org.eclipse.cdt.core.formatter.brace_position_for_block_in_case", this.brace_position_for_block_in_case);
        options.put("org.eclipse.cdt.core.formatter.brace_position_for_method_declaration", this.brace_position_for_method_declaration);
        options.put("org.eclipse.cdt.core.formatter.brace_position_for_type_declaration", this.brace_position_for_type_declaration);
        options.put("org.eclipse.cdt.core.formatter.brace_position_for_switch", this.brace_position_for_switch);
        options.put("org.eclipse.cdt.core.formatter.brace_position_for_namespace_declaration", this.brace_position_for_namespace_declaration);
        options.put("org.eclipse.cdt.core.formatter.continuation_indentation", Integer.toString(this.continuation_indentation));
        options.put("org.eclipse.cdt.core.formatter.continuation_indentation_for_array_initializer", Integer.toString(this.continuation_indentation_for_array_initializer));
        options.put("org.eclipse.cdt.core.formatter.indent_statements_compare_to_block", this.indent_statements_compare_to_block ? "true" : "false");
        options.put("org.eclipse.cdt.core.formatter.indent_statements_compare_to_body", this.indent_statements_compare_to_body ? "true" : "false");
        options.put("org.eclipse.cdt.core.formatter.indent_body_declarations_compare_to_access_specifier", this.indent_body_declarations_compare_to_access_specifier ? "true" : "false");
        options.put("org.eclipse.cdt.core.formatter.indent_access_specifier_compare_to_type_header", this.indent_access_specifier_compare_to_type_header ? "true" : "false");
        options.put("org.eclipse.cdt.core.formatter.indent_body_declarations_compare_to_namespace_header", this.indent_body_declarations_compare_to_namespace_header ? "true" : "false");
        options.put("org.eclipse.cdt.core.formatter.indent_breaks_compare_to_cases", this.indent_breaks_compare_to_cases ? "true" : "false");
        options.put("org.eclipse.cdt.core.formatter.indent_empty_lines", this.indent_empty_lines ? "true" : "false");
        options.put("org.eclipse.cdt.core.formatter.indent_switchstatements_compare_to_cases", this.indent_switchstatements_compare_to_cases ? "true" : "false");
        options.put("org.eclipse.cdt.core.formatter.indent_switchstatements_compare_to_switch", this.indent_switchstatements_compare_to_switch ? "true" : "false");
        options.put("org.eclipse.cdt.core.formatter.indentation.size", Integer.toString(this.indentation_size));
        options.put("org.eclipse.cdt.core.formatter.insert_new_line_after_opening_brace_in_array_initializer", this.insert_new_line_after_opening_brace_in_array_initializer ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_new_line_at_end_of_file_if_missing", this.insert_new_line_at_end_of_file_if_missing ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_new_line_before_closing_brace_in_array_initializer", this.insert_new_line_before_closing_brace_in_array_initializer ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_new_line_before_else_in_if_statement", this.insert_new_line_before_else_in_if_statement ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_new_line_before_while_in_do_statement", this.insert_new_line_before_while_in_do_statement ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_new_line_in_empty_block", this.insert_new_line_in_empty_block ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_after_closing_brace_in_block", this.insert_space_after_closing_brace_in_block ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_after_colon_in_case", this.insert_space_after_colon_in_case ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_after_colon_in_conditional", this.insert_space_after_colon_in_conditional ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_after_comma_in_array_initializer", this.insert_space_after_comma_in_array_initializer ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_after_comma_in_method_invocation_arguments", this.insert_space_after_comma_in_method_invocation_arguments ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_after_comma_in_method_declaration_parameters", this.insert_space_after_comma_in_method_declaration_parameters ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_after_opening_brace_in_array_initializer", this.insert_space_after_opening_brace_in_array_initializer ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_for", this.insert_space_after_opening_paren_in_for ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_if", this.insert_space_after_opening_paren_in_if ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_method_declaration", this.insert_space_after_opening_paren_in_method_declaration ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_method_invocation", this.insert_space_after_opening_paren_in_method_invocation ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_switch", this.insert_space_after_opening_paren_in_switch ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_while", this.insert_space_after_opening_paren_in_while ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_after_question_in_conditional", this.insert_space_after_question_in_conditional ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_after_semicolon_in_for", this.insert_space_after_semicolon_in_for ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_closing_brace_in_array_initializer", this.insert_space_before_closing_brace_in_array_initializer ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_for", this.insert_space_before_closing_paren_in_for ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_if", this.insert_space_before_closing_paren_in_if ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_method_declaration", this.insert_space_before_closing_paren_in_method_declaration ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_method_invocation", this.insert_space_before_closing_paren_in_method_invocation ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_switch", this.insert_space_before_closing_paren_in_switch ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_while", this.insert_space_before_closing_paren_in_while ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_colon_in_case", this.insert_space_before_colon_in_case ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_colon_in_conditional", this.insert_space_before_colon_in_conditional ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_colon_in_default", this.insert_space_before_colon_in_default ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_comma_in_array_initializer", this.insert_space_before_comma_in_array_initializer ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_comma_in_method_invocation_arguments", this.insert_space_before_comma_in_method_invocation_arguments ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_comma_in_method_declaration_parameters", this.insert_space_before_comma_in_method_declaration_parameters ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_opening_brace_in_array_initializer", this.insert_space_before_opening_brace_in_array_initializer ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_opening_brace_in_block", this.insert_space_before_opening_brace_in_block ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_opening_brace_in_method_declaration", this.insert_space_before_opening_brace_in_method_declaration ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_opening_brace_in_type_declaration", this.insert_space_before_opening_brace_in_type_declaration ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_opening_brace_in_namespace_declaration", this.insert_space_before_opening_brace_in_namespace_declaration ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_for", this.insert_space_before_opening_paren_in_for ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_if", this.insert_space_before_opening_paren_in_if ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_method_invocation", this.insert_space_before_opening_paren_in_method_invocation ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_method_declaration", this.insert_space_before_opening_paren_in_method_declaration ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_switch", this.insert_space_before_opening_paren_in_switch ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_opening_brace_in_switch", this.insert_space_before_opening_brace_in_switch ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_while", this.insert_space_before_opening_paren_in_while ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_question_in_conditional", this.insert_space_before_question_in_conditional ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_semicolon", this.insert_space_before_semicolon ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_before_semicolon_in_for", this.insert_space_before_semicolon_in_for ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_between_empty_braces_in_array_initializer", this.insert_space_between_empty_braces_in_array_initializer ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.insert_space_between_empty_parens_in_method_declaration", this.insert_space_between_empty_parens_in_method_declaration ? "insert" : "do not insert");
        options.put("org.eclipse.cdt.core.formatter.compact_else_if", this.compact_else_if ? "true" : "false");
        options.put("org.eclipse.cdt.core.formatter.format_guardian_clause_on_one_line", this.keep_guardian_clause_on_one_line ? "true" : "false");
        options.put("org.eclipse.cdt.core.formatter.keep_else_statement_on_same_line", this.keep_else_statement_on_same_line ? "true" : "false");
        options.put("org.eclipse.cdt.core.formatter.keep_empty_array_initializer_on_one_line", this.keep_empty_array_initializer_on_one_line ? "true" : "false");
        options.put("org.eclipse.cdt.core.formatter.keep_imple_if_on_one_line", this.keep_simple_if_on_one_line ? "true" : "false");
        options.put("org.eclipse.cdt.core.formatter.keep_then_statement_on_same_line", this.keep_then_statement_on_same_line ? "true" : "false");
        options.put("org.eclipse.cdt.core.formatter.number_of_empty_lines_to_preserve", Integer.toString(this.number_of_empty_lines_to_preserve));
        options.put("org.eclipse.cdt.core.formatter.put_empty_statement_on_new_line", this.put_empty_statement_on_new_line ? "true" : "false");
        options.put("org.eclipse.cdt.core.formatter.lineSplit", Integer.toString(this.page_width));
        switch (this.tab_char) {
            case 2: {
                options.put("org.eclipse.cdt.core.formatter.tabulation.char", "space");
                break;
            }
            case 1: {
                options.put("org.eclipse.cdt.core.formatter.tabulation.char", "tab");
                break;
            }
            case 4: {
                options.put("org.eclipse.cdt.core.formatter.tabulation.char", "mixed");
            }
        }
        options.put("org.eclipse.cdt.core.formatter.tabulation.size", Integer.toString(this.tab_size));
        options.put("org.eclipse.cdt.core.formatter.use_tabs_only_for_leading_indentations", this.use_tabs_only_for_leading_indentations ? "true" : "false");
        return options;
    }

    public void set(Map settings) {
        Object useTabOption;
        Object pageWidthOption;
        Object useTabsOnlyForLeadingIndentationsOption;
        Object tabSizeOption;
        Object putEmptyStatementOnNewLineOption;
        Object numberOfEmptyLinesToPreserveOption;
        Object keepThenStatementOnSameLineOption;
        Object keepSimpleIfOnOneLineOption;
        Object keepElseStatementOnSameLineOption;
        Object keepGuardianClauseOnOneLineOption;
        Object compactElseIfOption;
        Object insertSpaceBetweenEmptyParensInMethodDeclarationOption;
        Object insertSpaceBeforeSemicolonInForOption;
        Object insertSpaceBeforeSemicolonOption;
        Object insertSpaceBeforeQuestionInConditionalOption;
        Object insertSpaceBeforeOpeningParenInWhileOption;
        Object insertSpaceBeforeOpeningBraceInSwitchOption;
        Object insertSpaceBeforeOpeningParenInSwitchOption;
        Object insertSpaceBeforeOpeningParenInMethodDeclarationOption;
        Object insertSpaceBeforeOpeningParenInMethodInvocationOption;
        Object insertSpaceBeforeOpeningParenInIfOption;
        Object insertSpaceBeforeOpeningParenInForOption;
        Object insertSpaceBeforeOpeningBraceInNamespaceDeclarationOption;
        Object insertSpaceBeforeOpeningBraceInTypeDeclarationOption;
        Object insertSpaceBeforeOpeningBraceInMethodDeclarationOption;
        Object insertSpaceBeforeOpeningBraceInBlockOption;
        Object insertSpaceBeforeCommaInMethodDeclarationParametersOption;
        Object insertSpaceBeforeCommaInMethodInvocationArgumentsOption;
        Object insertSpaceBeforeColonInDefaultOption;
        Object insertSpaceBeforeColonInConditionalOption;
        Object insertSpaceBeforeColonInCaseOption;
        Object insertSpaceBeforeClosingParenInWhileOption;
        Object insertSpaceBeforeClosingParenInSwitchOption;
        Object insertSpaceBeforeClosingParenInMethodInvocationOption;
        Object insertSpaceBeforeClosingParenInMethodDeclarationOption;
        Object insertSpaceBeforeClosingParenInIfOption;
        Object insertSpaceBeforeClosingParenInForOption;
        Object insertSpaceAfterSemicolonInForOption;
        Object insertSpaceAfterQuestionInConditionalOption;
        Object insertSpaceAfterOpeningParenInWhileOption;
        Object insertSpaceAfterOpeningParenInSwitchOption;
        Object insertSpaceAfterOpeningParenInMethodInvocationOption;
        Object insertSpaceAfterOpeningParenInMethodDeclarationOption;
        Object insertSpaceAfterOpeningParenInIfOption;
        Object insertSpaceAfterOpeningParenInForOption;
        Object insertSpaceAfterOpeningBraceInArrayInitializerOption;
        Object insertSpaceAfterCommaInMethodDeclarationParametersOption;
        Object insertSpaceAfterCommaInMethodInvocationArgumentsOption;
        Object insertSpaceAfterCommaInArrayInitializerOption;
        Object insertSpaceAfterColonInConditionalOption;
        Object insertSpaceAfterColonInCaseOption;
        Object insertSpaceAfterClosingBraceInBlockOption;
        Object insertNewLineInEmptyBlockOption;
        Object insertNewLineBeforeWhileInDoStatementOption;
        Object insertNewLineBeforeElseInIfStatementOption;
        Object insertNewLineBeforeClosingBraceInArrayInitializerOption;
        Object insertNewLineAtEndOfFileIfMissingOption;
        Object insertNewLineAfterOpeningBraceInArrayInitializerOption;
        Object indentationSizeOption;
        Object indentSwitchstatementsCompareToSwitchOption;
        Object indentSwitchstatementsCompareToCasesOption;
        Object indentEmptyLinesOption;
        Object indentBreaksCompareToCasesOption;
        Object indentBodyDeclarationsCompareToNamespaceHeaderOption;
        Object indentBodyDeclarationsCompareToAccessSpecifierOption;
        Object indentAccessSpecifierCompareToTypeHeaderOption;
        Object indentStatementsCompareToBodyOption;
        Object indentStatementsCompareToBlockOption;
        Object continuationIndentationForArrayInitializerOption;
        Object continuationIndentationOption;
        Object bracePositionForNamespaceDeclarationOption;
        Object bracePositionForTypeDeclarationOption;
        Object bracePositionForSwitchOption;
        Object bracePositionForMethodDeclarationOption;
        Object bracePositionForBlockInCaseOption;
        Object bracePositionForBlockOption;
        Object bracePositionForArrayInitializerOption;
        Object alignmentForParametersInMethodDeclarationOption;
        Object alignmentForExpressionsInArrayInitializerOption;
        Object alignmentForConditionalExpressionOption;
        Object alignmentForArgumentsInMethodInvocationOption = settings.get("org.eclipse.cdt.core.formatter.alignment_for_arguments_in_method_invocation");
        if (alignmentForArgumentsInMethodInvocationOption != null) {
            try {
                this.alignment_for_arguments_in_method_invocation = Integer.parseInt((String)alignmentForArgumentsInMethodInvocationOption);
            }
            catch (NumberFormatException numberFormatException) {
                this.alignment_for_arguments_in_method_invocation = 16;
            }
            catch (ClassCastException classCastException) {
                this.alignment_for_arguments_in_method_invocation = 16;
            }
        }
        if ((alignmentForConditionalExpressionOption = settings.get("org.eclipse.cdt.core.formatter.alignment_for_conditional_expression")) != null) {
            try {
                this.alignment_for_conditional_expression = Integer.parseInt((String)alignmentForConditionalExpressionOption);
            }
            catch (NumberFormatException numberFormatException) {
                this.alignment_for_conditional_expression = 48;
            }
            catch (ClassCastException classCastException) {
                this.alignment_for_conditional_expression = 48;
            }
        }
        if ((alignmentForExpressionsInArrayInitializerOption = settings.get("org.eclipse.cdt.core.formatter.alignment_for_expressions_in_array_initializer")) != null) {
            try {
                this.alignment_for_expressions_in_array_initializer = Integer.parseInt((String)alignmentForExpressionsInArrayInitializerOption);
            }
            catch (NumberFormatException numberFormatException) {
                this.alignment_for_expressions_in_array_initializer = 16;
            }
            catch (ClassCastException classCastException) {
                this.alignment_for_expressions_in_array_initializer = 16;
            }
        }
        if ((alignmentForParametersInMethodDeclarationOption = settings.get("org.eclipse.cdt.core.formatter.alignment_for_parameters_in_method_declaration")) != null) {
            try {
                this.alignment_for_parameters_in_method_declaration = Integer.parseInt((String)alignmentForParametersInMethodDeclarationOption);
            }
            catch (NumberFormatException numberFormatException) {
                this.alignment_for_parameters_in_method_declaration = 16;
            }
            catch (ClassCastException classCastException) {
                this.alignment_for_parameters_in_method_declaration = 16;
            }
        }
        if ((bracePositionForArrayInitializerOption = settings.get("org.eclipse.cdt.core.formatter.brace_position_for_array_initializer")) != null) {
            try {
                this.brace_position_for_array_initializer = (String)bracePositionForArrayInitializerOption;
            }
            catch (ClassCastException classCastException) {
                this.brace_position_for_array_initializer = "end_of_line";
            }
        }
        if ((bracePositionForBlockOption = settings.get("org.eclipse.cdt.core.formatter.brace_position_for_block")) != null) {
            try {
                this.brace_position_for_block = (String)bracePositionForBlockOption;
            }
            catch (ClassCastException classCastException) {
                this.brace_position_for_block = "end_of_line";
            }
        }
        if ((bracePositionForBlockInCaseOption = settings.get("org.eclipse.cdt.core.formatter.brace_position_for_block_in_case")) != null) {
            try {
                this.brace_position_for_block_in_case = (String)bracePositionForBlockInCaseOption;
            }
            catch (ClassCastException classCastException) {
                this.brace_position_for_block_in_case = "end_of_line";
            }
        }
        if ((bracePositionForMethodDeclarationOption = settings.get("org.eclipse.cdt.core.formatter.brace_position_for_method_declaration")) != null) {
            try {
                this.brace_position_for_method_declaration = (String)bracePositionForMethodDeclarationOption;
            }
            catch (ClassCastException classCastException) {
                this.brace_position_for_method_declaration = "end_of_line";
            }
        }
        if ((bracePositionForSwitchOption = settings.get("org.eclipse.cdt.core.formatter.brace_position_for_switch")) != null) {
            try {
                this.brace_position_for_switch = (String)bracePositionForSwitchOption;
            }
            catch (ClassCastException classCastException) {
                this.brace_position_for_switch = "end_of_line";
            }
        }
        if ((bracePositionForTypeDeclarationOption = settings.get("org.eclipse.cdt.core.formatter.brace_position_for_type_declaration")) != null) {
            try {
                this.brace_position_for_type_declaration = (String)bracePositionForTypeDeclarationOption;
            }
            catch (ClassCastException classCastException) {
                this.brace_position_for_type_declaration = "end_of_line";
            }
        }
        if ((bracePositionForNamespaceDeclarationOption = settings.get("org.eclipse.cdt.core.formatter.brace_position_for_namespace_declaration")) != null) {
            try {
                this.brace_position_for_namespace_declaration = (String)bracePositionForNamespaceDeclarationOption;
            }
            catch (ClassCastException classCastException) {
                this.brace_position_for_namespace_declaration = "end_of_line";
            }
        }
        if ((continuationIndentationOption = settings.get("org.eclipse.cdt.core.formatter.continuation_indentation")) != null) {
            try {
                this.continuation_indentation = Integer.parseInt((String)continuationIndentationOption);
            }
            catch (NumberFormatException numberFormatException) {
                this.continuation_indentation = 2;
            }
            catch (ClassCastException classCastException) {
                this.continuation_indentation = 2;
            }
        }
        if ((continuationIndentationForArrayInitializerOption = settings.get("org.eclipse.cdt.core.formatter.continuation_indentation_for_array_initializer")) != null) {
            try {
                this.continuation_indentation_for_array_initializer = Integer.parseInt((String)continuationIndentationForArrayInitializerOption);
            }
            catch (NumberFormatException numberFormatException) {
                this.continuation_indentation_for_array_initializer = 2;
            }
            catch (ClassCastException classCastException) {
                this.continuation_indentation_for_array_initializer = 2;
            }
        }
        if ((indentStatementsCompareToBlockOption = settings.get("org.eclipse.cdt.core.formatter.indent_statements_compare_to_block")) != null) {
            this.indent_statements_compare_to_block = "true".equals(indentStatementsCompareToBlockOption);
        }
        if ((indentStatementsCompareToBodyOption = settings.get("org.eclipse.cdt.core.formatter.indent_statements_compare_to_body")) != null) {
            this.indent_statements_compare_to_body = "true".equals(indentStatementsCompareToBodyOption);
        }
        if ((indentAccessSpecifierCompareToTypeHeaderOption = settings.get("org.eclipse.cdt.core.formatter.indent_access_specifier_compare_to_type_header")) != null) {
            this.indent_access_specifier_compare_to_type_header = "true".equals(indentAccessSpecifierCompareToTypeHeaderOption);
        }
        if ((indentBodyDeclarationsCompareToAccessSpecifierOption = settings.get("org.eclipse.cdt.core.formatter.indent_body_declarations_compare_to_access_specifier")) != null) {
            this.indent_body_declarations_compare_to_access_specifier = "true".equals(indentBodyDeclarationsCompareToAccessSpecifierOption);
        }
        if ((indentBodyDeclarationsCompareToNamespaceHeaderOption = settings.get("org.eclipse.cdt.core.formatter.indent_body_declarations_compare_to_namespace_header")) != null) {
            this.indent_body_declarations_compare_to_namespace_header = "true".equals(indentBodyDeclarationsCompareToNamespaceHeaderOption);
        }
        if ((indentBreaksCompareToCasesOption = settings.get("org.eclipse.cdt.core.formatter.indent_breaks_compare_to_cases")) != null) {
            this.indent_breaks_compare_to_cases = "true".equals(indentBreaksCompareToCasesOption);
        }
        if ((indentEmptyLinesOption = settings.get("org.eclipse.cdt.core.formatter.indent_empty_lines")) != null) {
            this.indent_empty_lines = "true".equals(indentEmptyLinesOption);
        }
        if ((indentSwitchstatementsCompareToCasesOption = settings.get("org.eclipse.cdt.core.formatter.indent_switchstatements_compare_to_cases")) != null) {
            this.indent_switchstatements_compare_to_cases = "true".equals(indentSwitchstatementsCompareToCasesOption);
        }
        if ((indentSwitchstatementsCompareToSwitchOption = settings.get("org.eclipse.cdt.core.formatter.indent_switchstatements_compare_to_switch")) != null) {
            this.indent_switchstatements_compare_to_switch = "true".equals(indentSwitchstatementsCompareToSwitchOption);
        }
        if ((indentationSizeOption = settings.get("org.eclipse.cdt.core.formatter.indentation.size")) != null) {
            try {
                this.indentation_size = Integer.parseInt((String)indentationSizeOption);
            }
            catch (NumberFormatException numberFormatException) {
                this.indentation_size = 4;
            }
            catch (ClassCastException classCastException) {
                this.indentation_size = 4;
            }
        }
        if ((insertNewLineAfterOpeningBraceInArrayInitializerOption = settings.get("org.eclipse.cdt.core.formatter.insert_new_line_after_opening_brace_in_array_initializer")) != null) {
            this.insert_new_line_after_opening_brace_in_array_initializer = "insert".equals(insertNewLineAfterOpeningBraceInArrayInitializerOption);
        }
        if ((insertNewLineAtEndOfFileIfMissingOption = settings.get("org.eclipse.cdt.core.formatter.insert_new_line_at_end_of_file_if_missing")) != null) {
            this.insert_new_line_at_end_of_file_if_missing = "insert".equals(insertNewLineAtEndOfFileIfMissingOption);
        }
        if ((insertNewLineBeforeClosingBraceInArrayInitializerOption = settings.get("org.eclipse.cdt.core.formatter.insert_new_line_before_closing_brace_in_array_initializer")) != null) {
            this.insert_new_line_before_closing_brace_in_array_initializer = "insert".equals(insertNewLineBeforeClosingBraceInArrayInitializerOption);
        }
        if ((insertNewLineBeforeElseInIfStatementOption = settings.get("org.eclipse.cdt.core.formatter.insert_new_line_before_else_in_if_statement")) != null) {
            this.insert_new_line_before_else_in_if_statement = "insert".equals(insertNewLineBeforeElseInIfStatementOption);
        }
        if ((insertNewLineBeforeWhileInDoStatementOption = settings.get("org.eclipse.cdt.core.formatter.insert_new_line_before_while_in_do_statement")) != null) {
            this.insert_new_line_before_while_in_do_statement = "insert".equals(insertNewLineBeforeWhileInDoStatementOption);
        }
        if ((insertNewLineInEmptyBlockOption = settings.get("org.eclipse.cdt.core.formatter.insert_new_line_in_empty_block")) != null) {
            this.insert_new_line_in_empty_block = "insert".equals(insertNewLineInEmptyBlockOption);
        }
        if ((insertSpaceAfterClosingBraceInBlockOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_after_closing_brace_in_block")) != null) {
            this.insert_space_after_closing_brace_in_block = "insert".equals(insertSpaceAfterClosingBraceInBlockOption);
        }
        if ((insertSpaceAfterColonInCaseOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_after_colon_in_case")) != null) {
            this.insert_space_after_colon_in_case = "insert".equals(insertSpaceAfterColonInCaseOption);
        }
        if ((insertSpaceAfterColonInConditionalOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_after_colon_in_conditional")) != null) {
            this.insert_space_after_colon_in_conditional = "insert".equals(insertSpaceAfterColonInConditionalOption);
        }
        if ((insertSpaceAfterCommaInArrayInitializerOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_after_comma_in_array_initializer")) != null) {
            this.insert_space_after_comma_in_array_initializer = "insert".equals(insertSpaceAfterCommaInArrayInitializerOption);
        }
        if ((insertSpaceAfterCommaInMethodInvocationArgumentsOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_after_comma_in_method_invocation_arguments")) != null) {
            this.insert_space_after_comma_in_method_invocation_arguments = "insert".equals(insertSpaceAfterCommaInMethodInvocationArgumentsOption);
        }
        if ((insertSpaceAfterCommaInMethodDeclarationParametersOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_after_comma_in_method_declaration_parameters")) != null) {
            this.insert_space_after_comma_in_method_declaration_parameters = "insert".equals(insertSpaceAfterCommaInMethodDeclarationParametersOption);
        }
        if ((insertSpaceAfterOpeningBraceInArrayInitializerOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_after_opening_brace_in_array_initializer")) != null) {
            this.insert_space_after_opening_brace_in_array_initializer = "insert".equals(insertSpaceAfterOpeningBraceInArrayInitializerOption);
        }
        if ((insertSpaceAfterOpeningParenInForOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_for")) != null) {
            this.insert_space_after_opening_paren_in_for = "insert".equals(insertSpaceAfterOpeningParenInForOption);
        }
        if ((insertSpaceAfterOpeningParenInIfOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_if")) != null) {
            this.insert_space_after_opening_paren_in_if = "insert".equals(insertSpaceAfterOpeningParenInIfOption);
        }
        if ((insertSpaceAfterOpeningParenInMethodDeclarationOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_method_declaration")) != null) {
            this.insert_space_after_opening_paren_in_method_declaration = "insert".equals(insertSpaceAfterOpeningParenInMethodDeclarationOption);
        }
        if ((insertSpaceAfterOpeningParenInMethodInvocationOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_method_invocation")) != null) {
            this.insert_space_after_opening_paren_in_method_invocation = "insert".equals(insertSpaceAfterOpeningParenInMethodInvocationOption);
        }
        if ((insertSpaceAfterOpeningParenInSwitchOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_switch")) != null) {
            this.insert_space_after_opening_paren_in_switch = "insert".equals(insertSpaceAfterOpeningParenInSwitchOption);
        }
        if ((insertSpaceAfterOpeningParenInWhileOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_while")) != null) {
            this.insert_space_after_opening_paren_in_while = "insert".equals(insertSpaceAfterOpeningParenInWhileOption);
        }
        if ((insertSpaceAfterQuestionInConditionalOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_after_question_in_conditional")) != null) {
            this.insert_space_after_question_in_conditional = "insert".equals(insertSpaceAfterQuestionInConditionalOption);
        }
        if ((insertSpaceAfterSemicolonInForOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_after_semicolon_in_for")) != null) {
            this.insert_space_after_semicolon_in_for = "insert".equals(insertSpaceAfterSemicolonInForOption);
        }
        if ((insertSpaceBeforeClosingParenInForOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_for")) != null) {
            this.insert_space_before_closing_paren_in_for = "insert".equals(insertSpaceBeforeClosingParenInForOption);
        }
        if ((insertSpaceBeforeClosingParenInIfOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_if")) != null) {
            this.insert_space_before_closing_paren_in_if = "insert".equals(insertSpaceBeforeClosingParenInIfOption);
        }
        if ((insertSpaceBeforeClosingParenInMethodDeclarationOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_method_declaration")) != null) {
            this.insert_space_before_closing_paren_in_method_declaration = "insert".equals(insertSpaceBeforeClosingParenInMethodDeclarationOption);
        }
        if ((insertSpaceBeforeClosingParenInMethodInvocationOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_method_invocation")) != null) {
            this.insert_space_before_closing_paren_in_method_invocation = "insert".equals(insertSpaceBeforeClosingParenInMethodInvocationOption);
        }
        if ((insertSpaceBeforeClosingParenInSwitchOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_switch")) != null) {
            this.insert_space_before_closing_paren_in_switch = "insert".equals(insertSpaceBeforeClosingParenInSwitchOption);
        }
        if ((insertSpaceBeforeClosingParenInWhileOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_while")) != null) {
            this.insert_space_before_closing_paren_in_while = "insert".equals(insertSpaceBeforeClosingParenInWhileOption);
        }
        if ((insertSpaceBeforeColonInCaseOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_colon_in_case")) != null) {
            this.insert_space_before_colon_in_case = "insert".equals(insertSpaceBeforeColonInCaseOption);
        }
        if ((insertSpaceBeforeColonInConditionalOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_colon_in_conditional")) != null) {
            this.insert_space_before_colon_in_conditional = "insert".equals(insertSpaceBeforeColonInConditionalOption);
        }
        if ((insertSpaceBeforeColonInDefaultOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_colon_in_default")) != null) {
            this.insert_space_before_colon_in_default = "insert".equals(insertSpaceBeforeColonInDefaultOption);
        }
        if ((insertSpaceBeforeCommaInMethodInvocationArgumentsOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_comma_in_method_invocation_arguments")) != null) {
            this.insert_space_before_comma_in_method_invocation_arguments = "insert".equals(insertSpaceBeforeCommaInMethodInvocationArgumentsOption);
        }
        if ((insertSpaceBeforeCommaInMethodDeclarationParametersOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_comma_in_method_declaration_parameters")) != null) {
            this.insert_space_before_comma_in_method_declaration_parameters = "insert".equals(insertSpaceBeforeCommaInMethodDeclarationParametersOption);
        }
        if ((insertSpaceBeforeOpeningBraceInBlockOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_opening_brace_in_block")) != null) {
            this.insert_space_before_opening_brace_in_block = "insert".equals(insertSpaceBeforeOpeningBraceInBlockOption);
        }
        if ((insertSpaceBeforeOpeningBraceInMethodDeclarationOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_opening_brace_in_method_declaration")) != null) {
            this.insert_space_before_opening_brace_in_method_declaration = "insert".equals(insertSpaceBeforeOpeningBraceInMethodDeclarationOption);
        }
        if ((insertSpaceBeforeOpeningBraceInTypeDeclarationOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_opening_brace_in_type_declaration")) != null) {
            this.insert_space_before_opening_brace_in_type_declaration = "insert".equals(insertSpaceBeforeOpeningBraceInTypeDeclarationOption);
        }
        if ((insertSpaceBeforeOpeningBraceInNamespaceDeclarationOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_opening_brace_in_namespace_declaration")) != null) {
            this.insert_space_before_opening_brace_in_namespace_declaration = "insert".equals(insertSpaceBeforeOpeningBraceInNamespaceDeclarationOption);
        }
        if ((insertSpaceBeforeOpeningParenInForOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_for")) != null) {
            this.insert_space_before_opening_paren_in_for = "insert".equals(insertSpaceBeforeOpeningParenInForOption);
        }
        if ((insertSpaceBeforeOpeningParenInIfOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_if")) != null) {
            this.insert_space_before_opening_paren_in_if = "insert".equals(insertSpaceBeforeOpeningParenInIfOption);
        }
        if ((insertSpaceBeforeOpeningParenInMethodInvocationOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_method_invocation")) != null) {
            this.insert_space_before_opening_paren_in_method_invocation = "insert".equals(insertSpaceBeforeOpeningParenInMethodInvocationOption);
        }
        if ((insertSpaceBeforeOpeningParenInMethodDeclarationOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_method_declaration")) != null) {
            this.insert_space_before_opening_paren_in_method_declaration = "insert".equals(insertSpaceBeforeOpeningParenInMethodDeclarationOption);
        }
        if ((insertSpaceBeforeOpeningParenInSwitchOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_switch")) != null) {
            this.insert_space_before_opening_paren_in_switch = "insert".equals(insertSpaceBeforeOpeningParenInSwitchOption);
        }
        if ((insertSpaceBeforeOpeningBraceInSwitchOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_opening_brace_in_switch")) != null) {
            this.insert_space_before_opening_brace_in_switch = "insert".equals(insertSpaceBeforeOpeningBraceInSwitchOption);
        }
        if ((insertSpaceBeforeOpeningParenInWhileOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_while")) != null) {
            this.insert_space_before_opening_paren_in_while = "insert".equals(insertSpaceBeforeOpeningParenInWhileOption);
        }
        if ((insertSpaceBeforeQuestionInConditionalOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_question_in_conditional")) != null) {
            this.insert_space_before_question_in_conditional = "insert".equals(insertSpaceBeforeQuestionInConditionalOption);
        }
        if ((insertSpaceBeforeSemicolonOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_semicolon")) != null) {
            this.insert_space_before_semicolon = "insert".equals(insertSpaceBeforeSemicolonOption);
        }
        if ((insertSpaceBeforeSemicolonInForOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_before_semicolon_in_for")) != null) {
            this.insert_space_before_semicolon_in_for = "insert".equals(insertSpaceBeforeSemicolonInForOption);
        }
        if ((insertSpaceBetweenEmptyParensInMethodDeclarationOption = settings.get("org.eclipse.cdt.core.formatter.insert_space_between_empty_parens_in_method_declaration")) != null) {
            this.insert_space_between_empty_parens_in_method_declaration = "insert".equals(insertSpaceBetweenEmptyParensInMethodDeclarationOption);
        }
        if ((compactElseIfOption = settings.get("org.eclipse.cdt.core.formatter.compact_else_if")) != null) {
            this.compact_else_if = "true".equals(compactElseIfOption);
        }
        if ((keepGuardianClauseOnOneLineOption = settings.get("org.eclipse.cdt.core.formatter.format_guardian_clause_on_one_line")) != null) {
            this.keep_guardian_clause_on_one_line = "true".equals(keepGuardianClauseOnOneLineOption);
        }
        if ((keepElseStatementOnSameLineOption = settings.get("org.eclipse.cdt.core.formatter.keep_else_statement_on_same_line")) != null) {
            this.keep_else_statement_on_same_line = "true".equals(keepElseStatementOnSameLineOption);
        }
        if ((keepSimpleIfOnOneLineOption = settings.get("org.eclipse.cdt.core.formatter.keep_imple_if_on_one_line")) != null) {
            this.keep_simple_if_on_one_line = "true".equals(keepSimpleIfOnOneLineOption);
        }
        if ((keepThenStatementOnSameLineOption = settings.get("org.eclipse.cdt.core.formatter.keep_then_statement_on_same_line")) != null) {
            this.keep_then_statement_on_same_line = "true".equals(keepThenStatementOnSameLineOption);
        }
        if ((numberOfEmptyLinesToPreserveOption = settings.get("org.eclipse.cdt.core.formatter.number_of_empty_lines_to_preserve")) != null) {
            try {
                this.number_of_empty_lines_to_preserve = Integer.parseInt((String)numberOfEmptyLinesToPreserveOption);
            }
            catch (NumberFormatException numberFormatException) {
                this.number_of_empty_lines_to_preserve = 0;
            }
            catch (ClassCastException classCastException) {
                this.number_of_empty_lines_to_preserve = 0;
            }
        }
        if ((putEmptyStatementOnNewLineOption = settings.get("org.eclipse.cdt.core.formatter.put_empty_statement_on_new_line")) != null) {
            this.put_empty_statement_on_new_line = "true".equals(putEmptyStatementOnNewLineOption);
        }
        if ((tabSizeOption = settings.get("org.eclipse.cdt.core.formatter.tabulation.size")) != null) {
            try {
                this.tab_size = Integer.parseInt((String)tabSizeOption);
            }
            catch (NumberFormatException numberFormatException) {
                this.tab_size = 4;
            }
            catch (ClassCastException classCastException) {
                this.tab_size = 4;
            }
        }
        if ((useTabsOnlyForLeadingIndentationsOption = settings.get("org.eclipse.cdt.core.formatter.use_tabs_only_for_leading_indentations")) != null) {
            this.use_tabs_only_for_leading_indentations = "true".equals(useTabsOnlyForLeadingIndentationsOption);
        }
        if ((pageWidthOption = settings.get("org.eclipse.cdt.core.formatter.lineSplit")) != null) {
            try {
                this.page_width = Integer.parseInt((String)pageWidthOption);
            }
            catch (NumberFormatException numberFormatException) {
                this.page_width = 80;
            }
            catch (ClassCastException classCastException) {
                this.page_width = 80;
            }
        }
        if ((useTabOption = settings.get("org.eclipse.cdt.core.formatter.tabulation.char")) != null) {
            this.tab_char = "tab".equals(useTabOption) ? 1 : ("space".equals(useTabOption) ? 2 : 4);
        }
    }

    public void setDefaultSettings() {
        this.alignment_for_arguments_in_method_invocation = 16;
        this.alignment_for_conditional_expression = 80;
        this.alignment_for_expressions_in_array_initializer = 16;
        this.alignment_for_parameters_in_method_declaration = 16;
        this.brace_position_for_array_initializer = "end_of_line";
        this.brace_position_for_block = "end_of_line";
        this.brace_position_for_block_in_case = "end_of_line";
        this.brace_position_for_method_declaration = "end_of_line";
        this.brace_position_for_type_declaration = "end_of_line";
        this.brace_position_for_namespace_declaration = "end_of_line";
        this.brace_position_for_switch = "end_of_line";
        this.continuation_indentation = 2;
        this.continuation_indentation_for_array_initializer = 2;
        this.indent_statements_compare_to_block = true;
        this.indent_statements_compare_to_body = true;
        this.indent_body_declarations_compare_to_namespace_header = false;
        this.indent_body_declarations_compare_to_access_specifier = true;
        this.indent_breaks_compare_to_cases = true;
        this.indent_empty_lines = false;
        this.indent_switchstatements_compare_to_cases = true;
        this.indent_switchstatements_compare_to_switch = false;
        this.indentation_size = 4;
        this.insert_new_line_after_opening_brace_in_array_initializer = false;
        this.insert_new_line_at_end_of_file_if_missing = false;
        this.insert_new_line_before_closing_brace_in_array_initializer = false;
        this.insert_new_line_before_else_in_if_statement = false;
        this.insert_new_line_before_while_in_do_statement = false;
        this.insert_new_line_in_empty_block = true;
        this.insert_space_after_closing_brace_in_block = true;
        this.insert_space_after_colon_in_case = true;
        this.insert_space_after_colon_in_conditional = true;
        this.insert_space_after_comma_in_array_initializer = true;
        this.insert_space_after_comma_in_method_invocation_arguments = true;
        this.insert_space_after_comma_in_method_declaration_parameters = true;
        this.insert_space_after_opening_brace_in_array_initializer = true;
        this.insert_space_after_opening_paren_in_for = false;
        this.insert_space_after_opening_paren_in_if = false;
        this.insert_space_after_opening_paren_in_method_declaration = false;
        this.insert_space_after_opening_paren_in_method_invocation = false;
        this.insert_space_after_opening_paren_in_switch = false;
        this.insert_space_after_opening_paren_in_while = false;
        this.insert_space_after_question_in_conditional = true;
        this.insert_space_after_semicolon_in_for = true;
        this.insert_space_before_closing_brace_in_array_initializer = true;
        this.insert_space_before_closing_paren_in_for = false;
        this.insert_space_before_closing_paren_in_if = false;
        this.insert_space_before_closing_paren_in_method_declaration = false;
        this.insert_space_before_closing_paren_in_method_invocation = false;
        this.insert_space_before_closing_paren_in_switch = false;
        this.insert_space_before_closing_paren_in_while = false;
        this.insert_space_before_colon_in_case = false;
        this.insert_space_before_colon_in_conditional = true;
        this.insert_space_before_colon_in_default = false;
        this.insert_space_before_comma_in_array_initializer = false;
        this.insert_space_before_comma_in_method_invocation_arguments = false;
        this.insert_space_before_comma_in_method_declaration_parameters = false;
        this.insert_space_before_opening_brace_in_array_initializer = true;
        this.insert_space_before_opening_brace_in_block = true;
        this.insert_space_before_opening_brace_in_method_declaration = true;
        this.insert_space_before_opening_brace_in_switch = true;
        this.insert_space_before_opening_brace_in_type_declaration = true;
        this.insert_space_before_opening_brace_in_namespace_declaration = true;
        this.insert_space_before_opening_paren_in_for = true;
        this.insert_space_before_opening_paren_in_if = true;
        this.insert_space_before_opening_paren_in_method_invocation = false;
        this.insert_space_before_opening_paren_in_method_declaration = false;
        this.insert_space_before_opening_paren_in_switch = true;
        this.insert_space_before_opening_paren_in_while = true;
        this.insert_space_before_question_in_conditional = true;
        this.insert_space_before_semicolon = false;
        this.insert_space_before_semicolon_in_for = false;
        this.insert_space_between_empty_braces_in_array_initializer = false;
        this.insert_space_between_empty_parens_in_method_declaration = false;
        this.compact_else_if = true;
        this.keep_guardian_clause_on_one_line = false;
        this.keep_else_statement_on_same_line = false;
        this.keep_empty_array_initializer_on_one_line = false;
        this.keep_simple_if_on_one_line = false;
        this.keep_then_statement_on_same_line = false;
        this.number_of_empty_lines_to_preserve = 1;
        this.put_empty_statement_on_new_line = true;
        this.tab_size = 4;
        this.page_width = 80;
        this.tab_char = 1;
        this.use_tabs_only_for_leading_indentations = false;
    }

    public void setKandRSettings() {
        this.setDefaultSettings();
    }

    public void setAllmanSettings() {
        this.setDefaultSettings();
        this.brace_position_for_array_initializer = "next_line";
        this.brace_position_for_block = "next_line";
        this.brace_position_for_block_in_case = "next_line";
        this.brace_position_for_method_declaration = "next_line";
        this.brace_position_for_type_declaration = "next_line";
        this.brace_position_for_namespace_declaration = "next_line";
        this.brace_position_for_switch = "next_line";
        this.indent_statements_compare_to_block = true;
        this.indent_statements_compare_to_body = true;
        this.indent_body_declarations_compare_to_namespace_header = false;
        this.indent_body_declarations_compare_to_access_specifier = true;
        this.indent_breaks_compare_to_cases = true;
        this.indent_empty_lines = false;
        this.indent_switchstatements_compare_to_cases = true;
        this.indent_switchstatements_compare_to_switch = false;
        this.indentation_size = 4;
        this.insert_new_line_after_opening_brace_in_array_initializer = false;
        this.insert_new_line_at_end_of_file_if_missing = false;
        this.insert_new_line_before_closing_brace_in_array_initializer = false;
        this.insert_new_line_before_else_in_if_statement = true;
        this.insert_new_line_before_while_in_do_statement = false;
        this.insert_new_line_in_empty_block = true;
        this.compact_else_if = true;
        this.keep_guardian_clause_on_one_line = false;
        this.keep_else_statement_on_same_line = false;
        this.keep_empty_array_initializer_on_one_line = false;
        this.keep_simple_if_on_one_line = false;
        this.keep_then_statement_on_same_line = false;
        this.number_of_empty_lines_to_preserve = 1;
        this.put_empty_statement_on_new_line = true;
        this.tab_size = 4;
        this.page_width = 80;
        this.tab_char = 1;
        this.use_tabs_only_for_leading_indentations = false;
    }

    public void setGNUSettings() {
        this.setDefaultSettings();
        this.brace_position_for_array_initializer = "next_line_shifted";
        this.brace_position_for_block = "next_line_shifted";
        this.brace_position_for_block_in_case = "next_line_shifted";
        this.brace_position_for_method_declaration = "next_line_shifted";
        this.brace_position_for_type_declaration = "next_line_shifted";
        this.brace_position_for_namespace_declaration = "next_line_shifted";
        this.brace_position_for_switch = "next_line_shifted";
        this.indent_statements_compare_to_block = true;
        this.indent_statements_compare_to_body = true;
        this.indent_body_declarations_compare_to_namespace_header = true;
        this.indent_body_declarations_compare_to_access_specifier = true;
        this.indent_breaks_compare_to_cases = true;
        this.indent_empty_lines = false;
        this.indent_switchstatements_compare_to_cases = true;
        this.indent_switchstatements_compare_to_switch = false;
        this.indentation_size = 8;
        this.insert_new_line_after_opening_brace_in_array_initializer = false;
        this.insert_new_line_at_end_of_file_if_missing = false;
        this.insert_new_line_before_closing_brace_in_array_initializer = false;
        this.insert_new_line_before_else_in_if_statement = true;
        this.insert_new_line_before_while_in_do_statement = false;
        this.insert_new_line_in_empty_block = true;
        this.compact_else_if = true;
        this.keep_guardian_clause_on_one_line = false;
        this.keep_else_statement_on_same_line = false;
        this.keep_empty_array_initializer_on_one_line = false;
        this.keep_simple_if_on_one_line = false;
        this.keep_then_statement_on_same_line = false;
        this.number_of_empty_lines_to_preserve = 1;
        this.put_empty_statement_on_new_line = true;
        this.tab_size = 2;
        this.page_width = 80;
        this.tab_char = 2;
        this.use_tabs_only_for_leading_indentations = false;
    }

    public void setWhitesmitsSettings() {
        this.setDefaultSettings();
        this.alignment_for_expressions_in_array_initializer = 48;
        this.brace_position_for_array_initializer = "next_line_shifted";
        this.brace_position_for_block = "next_line_shifted";
        this.brace_position_for_block_in_case = "next_line_shifted";
        this.brace_position_for_method_declaration = "next_line_shifted";
        this.brace_position_for_type_declaration = "next_line_shifted";
        this.brace_position_for_namespace_declaration = "next_line_shifted";
        this.brace_position_for_switch = "next_line_shifted";
        this.indent_statements_compare_to_block = false;
        this.indent_statements_compare_to_body = false;
        this.indent_body_declarations_compare_to_namespace_header = false;
        this.indent_body_declarations_compare_to_access_specifier = false;
        this.indent_breaks_compare_to_cases = true;
        this.indent_empty_lines = false;
        this.indent_switchstatements_compare_to_cases = true;
        this.indent_switchstatements_compare_to_switch = false;
        this.indentation_size = 4;
        this.insert_new_line_after_opening_brace_in_array_initializer = true;
        this.insert_new_line_at_end_of_file_if_missing = false;
        this.insert_new_line_before_closing_brace_in_array_initializer = true;
        this.insert_new_line_before_else_in_if_statement = true;
        this.insert_new_line_before_while_in_do_statement = true;
        this.insert_new_line_in_empty_block = true;
        this.compact_else_if = false;
        this.keep_guardian_clause_on_one_line = false;
        this.keep_else_statement_on_same_line = false;
        this.keep_empty_array_initializer_on_one_line = false;
        this.keep_simple_if_on_one_line = false;
        this.keep_then_statement_on_same_line = false;
        this.number_of_empty_lines_to_preserve = 1;
        this.put_empty_statement_on_new_line = true;
        this.tab_size = 8;
        this.page_width = 80;
        this.tab_char = 4;
        this.use_tabs_only_for_leading_indentations = false;
    }
}

