/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.formatter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.formatter.AbortFormatting;
import org.eclipse.cdt.internal.formatter.CodeFormatterVisitor;
import org.eclipse.cdt.internal.formatter.Location;
import org.eclipse.cdt.internal.formatter.OptimizedReplaceEdit;
import org.eclipse.cdt.internal.formatter.align.Alignment;
import org.eclipse.cdt.internal.formatter.align.AlignmentException;
import org.eclipse.cdt.internal.formatter.scanner.Scanner;
import org.eclipse.cdt.internal.formatter.scanner.Token;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class Scribe {
    public static final String EMPTY_STRING = "";
    private static final int INITIAL_SIZE = 100;
    private boolean checkLineWrapping;
    public int column = 1;
    public Alignment currentAlignment;
    public Token currentToken;
    private OptimizedReplaceEdit[] edits;
    public int editsIndex;
    public CodeFormatterVisitor formatter;
    public int indentationLevel;
    public int lastNumberOfNewLines;
    public int line;
    private String lineSeparator;
    public Alignment memberAlignment;
    public boolean needSpace = false;
    public int pageWidth;
    public boolean pendingSpace = false;
    public Scanner scanner;
    public int scannerEndPosition;
    public int tabLength;
    public int indentationSize;
    private int textRegionEnd;
    private int textRegionStart;
    public int tabChar;
    public int numberOfIndentations;
    private boolean useTabsOnlyForLeadingIndents;
    private final boolean indentEmptyLines;
    private boolean preserveNewlines;
    private List fSkipPositions = Collections.EMPTY_LIST;
    private boolean skipOverInactive;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.formatter.Scribe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    Scribe(CodeFormatterVisitor formatter, int offset, int length) {
        this.scanner = new Scanner();
        this.formatter = formatter;
        this.pageWidth = formatter.preferences.page_width;
        this.tabLength = formatter.preferences.tab_size;
        this.indentationLevel = 0;
        this.numberOfIndentations = 0;
        this.useTabsOnlyForLeadingIndents = formatter.preferences.use_tabs_only_for_leading_indentations;
        this.indentEmptyLines = formatter.preferences.indent_empty_lines;
        this.tabChar = formatter.preferences.tab_char;
        this.indentationSize = this.tabChar == 4 ? formatter.preferences.indentation_size : this.tabLength;
        this.lineSeparator = formatter.preferences.line_separator;
        this.indentationLevel = formatter.preferences.initial_indentation_level * this.indentationSize;
        this.textRegionStart = offset;
        this.textRegionEnd = offset + length - 1;
        this.reset();
    }

    private final void addDeleteEdit(int start, int end) {
        if (this.edits.length == this.editsIndex) {
            this.resize();
        }
        this.addOptimizedReplaceEdit(start, end - start + 1, EMPTY_STRING);
    }

    public final void addInsertEdit(int insertPosition, String insertedString) {
        if (this.edits.length == this.editsIndex) {
            this.resize();
        }
        this.addOptimizedReplaceEdit(insertPosition, 0, insertedString);
    }

    private final void addOptimizedReplaceEdit(int offset, int length, String replacement) {
        if (this.editsIndex > 0) {
            OptimizedReplaceEdit previous = this.edits[this.editsIndex - 1];
            int previousOffset = previous.offset;
            int previousLength = previous.length;
            int endOffsetOfPreviousEdit = previousOffset + previousLength;
            int replacementLength = replacement.length();
            String previousReplacement = previous.replacement;
            int previousReplacementLength = previousReplacement.length();
            if (previousOffset == offset && previousLength == length && (replacementLength == 0 || previousReplacementLength == 0)) {
                if (this.currentAlignment != null) {
                    Location location = this.currentAlignment.location;
                    if (location.editsIndex == this.editsIndex) {
                        --location.editsIndex;
                        location.textEdit = previous;
                    }
                }
                --this.editsIndex;
                return;
            }
            if (endOffsetOfPreviousEdit == offset) {
                if (length != 0) {
                    if (replacementLength != 0) {
                        this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(previousOffset, previousLength + length, String.valueOf(previousReplacement) + replacement);
                    } else if (previousLength + length == previousReplacementLength) {
                        boolean canBeRemoved = true;
                        int i = previousOffset;
                        while (i < previousOffset + previousReplacementLength) {
                            if (this.scanner.source[i] != previousReplacement.charAt(i - previousOffset)) {
                                this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(previousOffset, previousReplacementLength, previousReplacement);
                                canBeRemoved = false;
                                break;
                            }
                            ++i;
                        }
                        if (canBeRemoved) {
                            if (this.currentAlignment != null) {
                                Location location = this.currentAlignment.location;
                                if (location.editsIndex == this.editsIndex) {
                                    --location.editsIndex;
                                    location.textEdit = previous;
                                }
                            }
                            --this.editsIndex;
                        }
                    } else {
                        this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(previousOffset, previousLength + length, previousReplacement);
                    }
                } else if (replacementLength != 0) {
                    this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(previousOffset, previousLength, String.valueOf(previousReplacement) + replacement);
                }
            } else {
                if (!$assertionsDisabled && endOffsetOfPreviousEdit >= offset) {
                    throw new AssertionError();
                }
                this.edits[this.editsIndex++] = new OptimizedReplaceEdit(offset, length, replacement);
            }
        } else {
            this.edits[this.editsIndex++] = new OptimizedReplaceEdit(offset, length, replacement);
        }
    }

    public final void addReplaceEdit(int start, int end, String replacement) {
        if (this.edits.length == this.editsIndex) {
            this.resize();
        }
        this.addOptimizedReplaceEdit(start, end - start + 1, replacement);
    }

    public void alignFragment(Alignment alignment, int fragmentIndex) {
        alignment.fragmentIndex = fragmentIndex;
        alignment.checkColumn();
        alignment.performFragmentEffect();
    }

    public void consumeNextToken() {
        this.printComment();
        this.currentToken = this.scanner.nextToken();
        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
    }

    public Alignment createAlignment(String name, int mode, int count, int sourceRestart) {
        return this.createAlignment(name, mode, 2, count, sourceRestart);
    }

    public Alignment createAlignment(String name, int mode, int count, int sourceRestart, boolean adjust) {
        return this.createAlignment(name, mode, 2, count, sourceRestart, adjust);
    }

    public Alignment createAlignment(String name, int mode, int tieBreakRule, int count, int sourceRestart) {
        return this.createAlignment(name, mode, tieBreakRule, count, sourceRestart, this.formatter.preferences.continuation_indentation, false);
    }

    public Alignment createAlignment(String name, int mode, int count, int sourceRestart, int continuationIndent, boolean adjust) {
        return this.createAlignment(name, mode, 2, count, sourceRestart, continuationIndent, adjust);
    }

    public Alignment createAlignment(String name, int mode, int tieBreakRule, int count, int sourceRestart, int continuationIndent, boolean adjust) {
        Alignment alignment = new Alignment(name, mode, tieBreakRule, this, count, sourceRestart, continuationIndent);
        if (adjust && this.memberAlignment != null) {
            Alignment current = this.memberAlignment;
            while (current.enclosing != null) {
                current = current.enclosing;
            }
            if ((current.mode & 0x100) != 0) {
                int indentSize = this.indentationSize;
                switch (current.chunkKind) {
                    case 2: 
                    case 3: {
                        alignment.breakIndentationLevel = (mode & 4) != 0 ? this.indentationLevel + indentSize : this.indentationLevel + continuationIndent * indentSize;
                        alignment.update();
                        break;
                    }
                    case 1: {
                        alignment.breakIndentationLevel = (mode & 4) != 0 ? current.originalIndentationLevel + indentSize : current.originalIndentationLevel + continuationIndent * indentSize;
                        alignment.update();
                    }
                }
            } else {
                block4 : switch (current.mode & 0x70) {
                    case 16: 
                    case 32: 
                    case 48: 
                    case 64: 
                    case 80: {
                        int indentSize = this.indentationSize;
                        switch (current.chunkKind) {
                            case 2: 
                            case 3: {
                                alignment.breakIndentationLevel = (mode & 4) != 0 ? this.indentationLevel + indentSize : this.indentationLevel + continuationIndent * indentSize;
                                alignment.update();
                                break block4;
                            }
                            case 1: {
                                alignment.breakIndentationLevel = (mode & 4) != 0 ? current.originalIndentationLevel + indentSize : current.originalIndentationLevel + continuationIndent * indentSize;
                                alignment.update();
                            }
                        }
                    }
                }
            }
        }
        return alignment;
    }

    public Alignment createMemberAlignment(String name, int mode, int count, int sourceRestart) {
        Alignment mAlignment = this.createAlignment(name, mode, 2, count, sourceRestart);
        mAlignment.breakIndentationLevel = this.indentationLevel;
        return mAlignment;
    }

    public void enterAlignment(Alignment alignment) {
        alignment.enclosing = this.currentAlignment;
        this.currentAlignment = alignment;
    }

    public void enterMemberAlignment(Alignment alignment) {
        alignment.enclosing = this.memberAlignment;
        this.memberAlignment = alignment;
    }

    public void exitAlignment(Alignment alignment, boolean discardAlignment) {
        Alignment current = this.currentAlignment;
        while (current != null) {
            if (current == alignment) break;
            current = current.enclosing;
        }
        if (current == null) {
            throw new AbortFormatting("could not find matching alignment: " + alignment);
        }
        this.indentationLevel = alignment.location.outputIndentationLevel;
        this.numberOfIndentations = alignment.location.numberOfIndentations;
        if (discardAlignment) {
            this.currentAlignment = alignment.enclosing;
        }
    }

    public void exitMemberAlignment(Alignment alignment) {
        Alignment current = this.memberAlignment;
        while (current != null) {
            if (current == alignment) break;
            current = current.enclosing;
        }
        if (current == null) {
            throw new AbortFormatting("could not find matching alignment: " + alignment);
        }
        this.indentationLevel = current.location.outputIndentationLevel;
        this.numberOfIndentations = current.location.numberOfIndentations;
        this.memberAlignment = current.enclosing;
    }

    public Alignment getAlignment(String name) {
        if (this.currentAlignment != null) {
            return this.currentAlignment.getAlignment(name);
        }
        return null;
    }

    public int getColumnIndentationLevel() {
        return this.column - 1;
    }

    public String getEmptyLines(int linesNumber) {
        StringBuffer buffer = new StringBuffer();
        if (this.lastNumberOfNewLines == 0) {
            ++linesNumber;
            int i = 0;
            while (i < linesNumber) {
                if (this.indentEmptyLines) {
                    this.printIndentationIfNecessary(buffer);
                }
                buffer.append(this.lineSeparator);
                ++i;
            }
            this.lastNumberOfNewLines += linesNumber;
            this.line += linesNumber;
            this.column = 1;
            this.needSpace = false;
            this.pendingSpace = false;
        } else if (this.lastNumberOfNewLines == 1) {
            int i = 0;
            while (i < linesNumber) {
                if (this.indentEmptyLines) {
                    this.printIndentationIfNecessary(buffer);
                }
                buffer.append(this.lineSeparator);
                ++i;
            }
            this.lastNumberOfNewLines += linesNumber;
            this.line += linesNumber;
            this.column = 1;
            this.needSpace = false;
            this.pendingSpace = false;
        } else {
            if (this.lastNumberOfNewLines - 1 >= linesNumber) {
                return EMPTY_STRING;
            }
            int realNewLineNumber = linesNumber - this.lastNumberOfNewLines + 1;
            int i = 0;
            while (i < realNewLineNumber) {
                if (this.indentEmptyLines) {
                    this.printIndentationIfNecessary(buffer);
                }
                buffer.append(this.lineSeparator);
                ++i;
            }
            this.lastNumberOfNewLines += realNewLineNumber;
            this.line += realNewLineNumber;
            this.column = 1;
            this.needSpace = false;
            this.pendingSpace = false;
        }
        return String.valueOf(buffer);
    }

    public OptimizedReplaceEdit getLastEdit() {
        if (this.editsIndex > 0) {
            return this.edits[this.editsIndex - 1];
        }
        return null;
    }

    Alignment getMemberAlignment() {
        return this.memberAlignment;
    }

    public String getNewLine() {
        if (this.lastNumberOfNewLines >= 1) {
            this.column = 1;
            return EMPTY_STRING;
        }
        ++this.line;
        this.lastNumberOfNewLines = 1;
        this.column = 1;
        this.needSpace = false;
        this.pendingSpace = false;
        return this.lineSeparator;
    }

    public int getNextIndentationLevel(int someColumn) {
        int indent = someColumn - 1;
        if (indent == 0) {
            return this.indentationLevel;
        }
        if (this.tabChar == 1) {
            if (this.useTabsOnlyForLeadingIndents) {
                return indent;
            }
            int rem = indent % this.indentationSize;
            int addition = rem == 0 ? 0 : this.indentationSize - rem;
            return indent + addition;
        }
        return indent;
    }

    private String getPreserveEmptyLines(int count) {
        if (count > 0) {
            if (this.formatter.preferences.number_of_empty_lines_to_preserve != 0) {
                int linesToPreserve = Math.min(count, this.formatter.preferences.number_of_empty_lines_to_preserve);
                return this.getEmptyLines(linesToPreserve);
            }
            return this.getNewLine();
        }
        if (this.preserveNewlines) {
            return this.getNewLine();
        }
        return EMPTY_STRING;
    }

    public TextEdit getRootEdit() {
        MultiTextEdit edit = null;
        int length = this.textRegionEnd - this.textRegionStart + 1;
        edit = this.textRegionStart <= 0 ? (length <= 0 ? new MultiTextEdit(0, 0) : new MultiTextEdit(0, this.textRegionEnd + 1)) : new MultiTextEdit(this.textRegionStart, this.textRegionEnd - this.textRegionStart + 1);
        int i = 0;
        int max = this.editsIndex;
        while (i < max) {
            OptimizedReplaceEdit currentEdit = this.edits[i];
            if (this.isValidEdit(currentEdit)) {
                edit.addChild((TextEdit)new ReplaceEdit(currentEdit.offset, currentEdit.length, currentEdit.replacement));
            }
            ++i;
        }
        this.edits = null;
        return edit;
    }

    public void handleLineTooLong() {
        int relativeDepth = 0;
        int outerMostDepth = -1;
        Alignment targetAlignment = this.currentAlignment;
        while (targetAlignment != null) {
            if (targetAlignment.tieBreakRule == 1 && targetAlignment.couldBreak()) {
                outerMostDepth = relativeDepth;
            }
            targetAlignment = targetAlignment.enclosing;
            ++relativeDepth;
        }
        if (outerMostDepth >= 0) {
            throw new AlignmentException(1, outerMostDepth);
        }
        relativeDepth = 0;
        targetAlignment = this.currentAlignment;
        while (targetAlignment != null) {
            if (targetAlignment.couldBreak()) {
                throw new AlignmentException(1, relativeDepth);
            }
            targetAlignment = targetAlignment.enclosing;
            ++relativeDepth;
        }
    }

    public void indent() {
        this.indentationLevel += this.indentationSize;
        ++this.numberOfIndentations;
    }

    public void initializeScanner(char[] translationUnitSource) {
        this.scanner.setSource(translationUnitSource);
        this.scannerEndPosition = translationUnitSource.length;
        this.scanner.resetTo(0, this.scannerEndPosition);
        this.edits = new OptimizedReplaceEdit[100];
    }

    public void setSkipPositions(List list) {
        this.fSkipPositions = list;
        this.skipOverInactive = !list.isEmpty();
    }

    private boolean isValidEdit(OptimizedReplaceEdit edit) {
        int editLength = edit.length;
        int editReplacementLength = edit.replacement.length();
        int editOffset = edit.offset;
        if (editLength != 0) {
            if (this.textRegionStart <= editOffset && editOffset + editLength - 1 <= this.textRegionEnd) {
                if (editReplacementLength != 0 && editLength == editReplacementLength) {
                    int i = editOffset;
                    int max = editOffset + editLength;
                    while (i < max) {
                        if (this.scanner.source[i] != edit.replacement.charAt(i - editOffset)) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
                return true;
            }
            if (editOffset + editLength == this.textRegionStart) {
                int i = editOffset;
                int max = editOffset + editLength;
                while (i < max) {
                    int replacementStringIndex = i - editOffset;
                    if (replacementStringIndex >= editReplacementLength || this.scanner.source[i] != edit.replacement.charAt(replacementStringIndex)) break;
                    ++i;
                }
                if (i - editOffset != editReplacementLength && i != editOffset + editLength - 1) {
                    edit.offset = this.textRegionStart;
                    edit.length = 0;
                    edit.replacement = edit.replacement.substring(i - editOffset);
                    return true;
                }
            }
        } else {
            if (this.textRegionStart <= editOffset && editOffset <= this.textRegionEnd) {
                return true;
            }
            if (editOffset == this.scannerEndPosition && editOffset == this.textRegionEnd + 1) {
                return true;
            }
        }
        return false;
    }

    private void preserveEmptyLines(int count, int insertPosition) {
        if (count > 0) {
            if (this.formatter.preferences.number_of_empty_lines_to_preserve != 0) {
                int linesToPreserve = Math.min(count, this.formatter.preferences.number_of_empty_lines_to_preserve);
                this.printEmptyLines(linesToPreserve, insertPosition);
            } else {
                this.printNewLine(insertPosition);
            }
        } else {
            this.printNewLine(insertPosition);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void printRaw(int startOffset, int length) {
        if (length <= 0) {
            return;
        }
        if (startOffset > this.scanner.getCurrentPosition()) {
            this.printComment();
        }
        if (this.pendingSpace) {
            this.addInsertEdit(this.scanner.getCurrentPosition(), " ");
            this.pendingSpace = false;
            this.needSpace = false;
        }
        if (startOffset + length < this.scanner.getCurrentPosition()) {
            return;
        }
        boolean savedPreserveNL = this.preserveNewlines;
        boolean savedSkipOverInactive = this.skipOverInactive;
        int savedScannerEndPos = this.scannerEndPosition;
        this.preserveNewlines = true;
        this.skipOverInactive = false;
        this.scannerEndPosition = startOffset + length;
        try {
            this.scanner.resetTo(Math.max(startOffset, this.scanner.getCurrentPosition()), startOffset + length - 1);
            int parenLevel = 0;
            while (true) {
                boolean hasWhitespace;
                block28: {
                    hasWhitespace = this.printComment();
                    this.currentToken = this.scanner.nextToken();
                    if (this.currentToken != null) break block28;
                    if (hasWhitespace) {
                        this.space();
                    }
                    break;
                }
                if (this.pendingSpace) {
                    this.addInsertEdit(this.scanner.getCurrentTokenStartPosition(), " ");
                    this.pendingSpace = false;
                    this.needSpace = false;
                }
                block2 : switch (this.currentToken.type) {
                    case 12: {
                        this.scanner.resetTo(this.scanner.getCurrentTokenStartPosition(), this.scannerEndPosition - 1);
                        this.formatOpeningBrace(this.formatter.preferences.brace_position_for_block, this.formatter.preferences.insert_space_before_opening_brace_in_block);
                        if (!this.formatter.preferences.indent_statements_compare_to_block) break;
                        this.indent();
                        break;
                    }
                    case 13: {
                        this.scanner.resetTo(this.scanner.getCurrentTokenStartPosition(), this.scannerEndPosition - 1);
                        if (this.formatter.preferences.indent_statements_compare_to_block) {
                            this.unIndent();
                        }
                        this.formatClosingBrace(this.formatter.preferences.brace_position_for_block);
                        break;
                    }
                    case 8: {
                        this.print(this.currentToken.getLength(), hasWhitespace);
                        if (++parenLevel <= 0) break;
                        int i = 0;
                        while (true) {
                            if (i >= this.formatter.preferences.continuation_indentation) {
                                this.column = this.indentationLevel + 1;
                                break block2;
                            }
                            this.indent();
                            ++i;
                        }
                    }
                    case 9: {
                        int i;
                        if (--parenLevel >= 0) {
                            i = 0;
                            while (i < this.formatter.preferences.continuation_indentation) {
                                this.unIndent();
                                ++i;
                            }
                        }
                        this.print(this.currentToken.getLength(), hasWhitespace);
                        break;
                    }
                    case 5: {
                        this.print(this.currentToken.getLength(), this.formatter.preferences.insert_space_before_semicolon);
                        break;
                    }
                    case 63: 
                    case 76: {
                        if (this.formatter.preferences.insert_new_line_before_else_in_if_statement) {
                            this.printNewLine(this.currentToken.offset);
                        } else {
                            hasWhitespace = true;
                        }
                        this.print(this.currentToken.getLength(), hasWhitespace);
                        break;
                    }
                    default: {
                        if (this.currentToken.isVisibilityModifier() && !this.formatter.preferences.indent_access_specifier_compare_to_type_header) {
                            int indentLevel = this.indentationLevel;
                            if (this.indentationLevel > 0) {
                                this.unIndent();
                            }
                            this.print(this.currentToken.getLength(), hasWhitespace);
                            while (this.indentationLevel < indentLevel) {
                                this.indent();
                            }
                            break;
                        }
                        this.print(this.currentToken.getLength(), hasWhitespace);
                    }
                }
                hasWhitespace = false;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.scannerEndPosition = savedScannerEndPos;
            this.scanner.resetTo(startOffset + length, this.scannerEndPosition - 1);
            this.skipOverInactive = savedSkipOverInactive;
            this.preserveNewlines = savedPreserveNL;
            throw throwable;
        }
        {
            Object var9_11 = null;
            this.scannerEndPosition = savedScannerEndPos;
            this.scanner.resetTo(startOffset + length, this.scannerEndPosition - 1);
            this.skipOverInactive = savedSkipOverInactive;
            this.preserveNewlines = savedPreserveNL;
            return;
        }
    }

    private void formatOpeningBrace(String bracePosition, boolean insertSpaceBeforeBrace) {
        if ("next_line".equals(bracePosition)) {
            this.printNewLine();
        } else if ("next_line_shifted".equals(bracePosition)) {
            this.printNewLine();
            this.indent();
        }
        this.printNextToken(12, insertSpaceBeforeBrace);
        this.printTrailingComment();
    }

    private void formatClosingBrace(String block_brace_position) {
        this.printNextToken(13);
        this.printTrailingComment();
        if ("next_line_shifted".equals(block_brace_position)) {
            this.unIndent();
        }
    }

    private void print(int length, boolean considerSpaceIfAny) {
        if (this.checkLineWrapping && length + this.column > this.pageWidth) {
            this.handleLineTooLong();
        }
        this.lastNumberOfNewLines = 0;
        this.printIndentationIfNecessary();
        if (considerSpaceIfAny) {
            if (this.currentAlignment != null && this.currentAlignment.isIndentOnColumn(this.column)) {
                this.needSpace = true;
            }
            this.space();
        }
        if (this.pendingSpace) {
            this.addInsertEdit(this.scanner.getCurrentTokenStartPosition(), " ");
        }
        this.pendingSpace = false;
        this.column += length;
        this.needSpace = true;
    }

    private void printBlockComment(boolean forceNewLine) {
        int currentCharacter;
        int currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
        int currentTokenEndPosition = this.scanner.getCurrentTokenEndPosition() + 1;
        this.scanner.resetTo(currentTokenStartPosition, currentTokenEndPosition - 1);
        boolean isNewLine = false;
        int start = currentTokenStartPosition;
        int nextCharacterStart = currentTokenStartPosition;
        this.printIndentationIfNecessary();
        if (this.pendingSpace) {
            this.addInsertEdit(currentTokenStartPosition, " ");
        }
        this.needSpace = false;
        this.pendingSpace = false;
        int previousStart = currentTokenStartPosition;
        while (nextCharacterStart <= currentTokenEndPosition && (currentCharacter = this.scanner.getNextChar()) != -1) {
            nextCharacterStart = this.scanner.getCurrentPosition();
            switch (currentCharacter) {
                case 13: {
                    if (isNewLine) {
                        ++this.line;
                    }
                    start = previousStart;
                    isNewLine = true;
                    if (!this.scanner.getNextChar('\n')) break;
                    currentCharacter = 10;
                    nextCharacterStart = this.scanner.getCurrentPosition();
                    break;
                }
                case 10: {
                    if (isNewLine) {
                        ++this.line;
                    }
                    start = previousStart;
                    isNewLine = true;
                    break;
                }
                default: {
                    if (isNewLine) {
                        if (Character.isWhitespace((char)currentCharacter)) {
                            int previousStartPosition = this.scanner.getCurrentPosition();
                            while (currentCharacter != -1 && currentCharacter != 13 && currentCharacter != 10 && Character.isWhitespace((char)currentCharacter)) {
                                previousStart = nextCharacterStart;
                                previousStartPosition = this.scanner.getCurrentPosition();
                                currentCharacter = this.scanner.getNextChar();
                                nextCharacterStart = this.scanner.getCurrentPosition();
                            }
                            if (currentCharacter == 13 || currentCharacter == 10) {
                                nextCharacterStart = previousStartPosition;
                            }
                        }
                        this.column = 1;
                        ++this.line;
                        StringBuffer buffer = new StringBuffer();
                        buffer.append(this.lineSeparator);
                        this.printIndentationIfNecessary(buffer);
                        buffer.append(' ');
                        this.addReplaceEdit(start, previousStart - 1, String.valueOf(buffer));
                    } else {
                        this.column += nextCharacterStart - previousStart;
                    }
                    isNewLine = false;
                }
            }
            previousStart = nextCharacterStart;
            this.scanner.setCurrentPosition(nextCharacterStart);
        }
        this.lastNumberOfNewLines = 0;
        this.needSpace = false;
        this.scanner.resetTo(currentTokenEndPosition, this.scannerEndPosition - 1);
        if (forceNewLine) {
            this.startNewLine();
        }
    }

    private void printPreprocessorDirective() {
        int currentCharacter;
        int currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
        int currentTokenEndPosition = this.scanner.getCurrentTokenEndPosition() + 1;
        this.scanner.resetTo(currentTokenStartPosition, currentTokenEndPosition - 1);
        boolean isNewLine = false;
        int nextCharacterStart = currentTokenStartPosition;
        this.needSpace = false;
        this.pendingSpace = false;
        int previousStart = currentTokenStartPosition;
        while (nextCharacterStart <= currentTokenEndPosition && (currentCharacter = this.scanner.getNextChar()) != -1) {
            nextCharacterStart = this.scanner.getCurrentPosition();
            switch (currentCharacter) {
                case 13: {
                    isNewLine = true;
                    if (!this.scanner.getNextChar('\n')) break;
                    currentCharacter = 10;
                    nextCharacterStart = this.scanner.getCurrentPosition();
                    break;
                }
                case 10: {
                    isNewLine = true;
                    break;
                }
                default: {
                    if (isNewLine) {
                        this.column = 1;
                        ++this.line;
                    } else {
                        this.column += nextCharacterStart - previousStart;
                    }
                    isNewLine = false;
                }
            }
            previousStart = nextCharacterStart;
            this.scanner.setCurrentPosition(nextCharacterStart);
        }
        this.lastNumberOfNewLines = isNewLine ? 1 : 0;
        this.needSpace = false;
        if (this.currentAlignment != null) {
            this.indentationLevel = this.currentAlignment.breakIndentationLevel;
        }
        this.scanner.resetTo(currentTokenEndPosition, this.scannerEndPosition - 1);
    }

    public void printEndOfTranslationUnit() {
        int currentTokenStartPosition = this.scanner.getCurrentPosition();
        if (currentTokenStartPosition <= this.scannerEndPosition) {
            this.printRaw(currentTokenStartPosition, this.scannerEndPosition - currentTokenStartPosition + 1);
        }
    }

    public boolean printComment() {
        int currentTokenStartPosition = this.scanner.getCurrentPosition();
        boolean hasComment = false;
        boolean hasLineComment = false;
        boolean hasWhitespace = false;
        int count = 0;
        while ((this.currentToken = this.scanner.nextToken()) != null) {
            int endOffset;
            int startOffset;
            Position inactivePos = null;
            if (this.skipOverInactive && (inactivePos = this.getInactivePosAt(this.scanner.getCurrentTokenStartPosition())) != null && (startOffset = Math.min(this.scanner.getCurrentTokenStartPosition(), inactivePos.getOffset())) < (endOffset = Math.min(this.scannerEndPosition, inactivePos.getOffset() + inactivePos.getLength()))) {
                int savedIndentLevel = this.indentationLevel;
                this.scanner.resetTo(this.scanner.getCurrentTokenStartPosition(), this.scanner.eofPosition - 1);
                this.printRaw(startOffset, endOffset - startOffset);
                while (this.indentationLevel > savedIndentLevel) {
                    this.unIndent();
                }
                while (this.indentationLevel < savedIndentLevel) {
                    this.indent();
                }
                this.scanner.resetTo(endOffset, this.scanner.eofPosition - 1);
                continue;
            }
            switch (this.currentToken.type) {
                case 1000: {
                    char[] whiteSpaces = this.scanner.getCurrentTokenSource();
                    count = 0;
                    int i = 0;
                    int max = whiteSpaces.length;
                    while (i < max) {
                        switch (whiteSpaces[i]) {
                            case '\r': {
                                if (i + 1 < max && whiteSpaces[i + 1] == '\n') {
                                    ++i;
                                }
                                ++count;
                                break;
                            }
                            case '\n': {
                                ++count;
                            }
                        }
                        ++i;
                    }
                    if (count == 0) {
                        hasWhitespace = true;
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                    } else if (hasComment) {
                        if (count == 1) {
                            this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                        } else {
                            this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                        }
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                    } else if (hasLineComment) {
                        this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                    } else if (count != 0 && this.formatter.preferences.number_of_empty_lines_to_preserve != 0) {
                        String preservedEmptyLines = this.getPreserveEmptyLines(count - 1);
                        this.addReplaceEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition(), preservedEmptyLines);
                        hasWhitespace = preservedEmptyLines.length() == 0;
                    } else {
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        hasWhitespace = true;
                    }
                    currentTokenStartPosition = this.scanner.getCurrentPosition();
                    break;
                }
                case 1001: {
                    if (count >= 1) {
                        if (count > 1) {
                            this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                        } else if (count == 1) {
                            this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                        }
                    } else if (hasWhitespace) {
                        this.space();
                    }
                    hasWhitespace = false;
                    this.printCommentLine();
                    currentTokenStartPosition = this.scanner.getCurrentPosition();
                    hasLineComment = true;
                    count = 0;
                    break;
                }
                case 1002: {
                    if (count >= 1) {
                        if (count > 1) {
                            this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                        } else if (count == 1) {
                            this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                        }
                    } else if (hasWhitespace) {
                        this.space();
                    }
                    hasWhitespace = false;
                    this.printBlockComment(false);
                    currentTokenStartPosition = this.scanner.getCurrentPosition();
                    hasLineComment = false;
                    hasComment = true;
                    count = 0;
                    break;
                }
                case 1003: 
                case 1004: 
                case 1005: {
                    if (this.column != 1) {
                        this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                    }
                    if (count >= 1 && count > 1) {
                        this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                    }
                    hasWhitespace = false;
                    this.printPreprocessorDirective();
                    this.printNewLine();
                    currentTokenStartPosition = this.scanner.getCurrentPosition();
                    hasLineComment = false;
                    hasComment = false;
                    count = 0;
                    break;
                }
                default: {
                    this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                    return hasWhitespace;
                }
            }
        }
        return hasWhitespace;
    }

    private Position getInactivePosAt(int offset) {
        Iterator iter = this.fSkipPositions.iterator();
        while (iter.hasNext()) {
            Position pos = (Position)iter.next();
            if (!pos.includes(offset)) continue;
            return pos;
        }
        return null;
    }

    private void printCommentLine() {
        int currentCharacter;
        int currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
        int currentTokenEndPosition = this.scanner.getCurrentTokenEndPosition() + 1;
        this.scanner.resetTo(currentTokenStartPosition, currentTokenEndPosition - 1);
        int start = currentTokenStartPosition;
        int nextCharacterStart = currentTokenStartPosition;
        this.printIndentationIfNecessary();
        if (this.pendingSpace) {
            this.addInsertEdit(currentTokenStartPosition, " ");
        }
        this.needSpace = false;
        this.pendingSpace = false;
        int previousStart = currentTokenStartPosition;
        block4: while (nextCharacterStart <= currentTokenEndPosition && (currentCharacter = this.scanner.getNextChar()) != -1) {
            nextCharacterStart = this.scanner.getCurrentPosition();
            switch (currentCharacter) {
                case 13: {
                    start = previousStart;
                    break block4;
                }
                case 10: {
                    start = previousStart;
                    break block4;
                }
                default: {
                    previousStart = nextCharacterStart;
                }
            }
        }
        if (start != currentTokenStartPosition) {
            this.addReplaceEdit(start, currentTokenEndPosition - 1, this.lineSeparator);
        }
        ++this.line;
        this.column = 1;
        this.needSpace = false;
        this.pendingSpace = false;
        this.lastNumberOfNewLines = 0;
        this.scanner.resetTo(currentTokenEndPosition, this.scannerEndPosition - 1);
        if (this.currentAlignment != null) {
            if (this.memberAlignment != null) {
                if (this.currentAlignment.location.inputOffset > this.memberAlignment.location.inputOffset) {
                    if (this.currentAlignment.couldBreak() && this.currentAlignment.wasSplit) {
                        this.currentAlignment.performFragmentEffect();
                    }
                } else {
                    this.indentationLevel = Math.max(this.indentationLevel, this.memberAlignment.breakIndentationLevel);
                }
            } else if (this.currentAlignment.couldBreak() && this.currentAlignment.wasSplit) {
                this.currentAlignment.performFragmentEffect();
            }
        }
    }

    public void printEmptyLines(int linesNumber) {
        this.printEmptyLines(linesNumber, this.scanner.getCurrentTokenEndPosition() + 1);
    }

    private void printEmptyLines(int linesNumber, int insertPosition) {
        String buffer = this.getEmptyLines(linesNumber);
        if (EMPTY_STRING == buffer) {
            return;
        }
        this.addInsertEdit(insertPosition, buffer);
    }

    void printIndentationIfNecessary() {
        StringBuffer buffer = new StringBuffer();
        this.printIndentationIfNecessary(buffer);
        if (buffer.length() > 0) {
            this.addInsertEdit(this.scanner.getCurrentTokenStartPosition(), buffer.toString());
            this.pendingSpace = false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void printIndentationIfNecessary(StringBuffer buffer) {
        switch (this.tabChar) {
            case 1: {
                useTabsForLeadingIndents = this.useTabsOnlyForLeadingIndents;
                numberOfLeadingIndents = this.numberOfIndentations;
                indentationsAsTab = 0;
                if (!useTabsForLeadingIndents) ** GOTO lbl29
                while (this.column <= this.indentationLevel) {
                    if (indentationsAsTab < numberOfLeadingIndents) {
                        buffer.append('\t');
                        ++indentationsAsTab;
                        this.lastNumberOfNewLines = 0;
                        complement = this.tabLength - (this.column - 1) % this.tabLength;
                        this.column += complement;
                        this.needSpace = false;
                        continue;
                    }
                    buffer.append(' ');
                    ++this.column;
                    this.needSpace = false;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    buffer.append('\t');
                    this.lastNumberOfNewLines = 0;
                    complement = this.tabLength - (this.column - 1) % this.tabLength;
                    this.column += complement;
                    this.needSpace = false;
lbl29:
                    // 2 sources

                    ** while (this.column <= this.indentationLevel)
                }
lbl30:
                // 1 sources

                break;
            }
            case 2: {
                while (this.column <= this.indentationLevel) {
                    buffer.append(' ');
                    ++this.column;
                    this.needSpace = false;
                }
                break;
            }
            case 4: {
                useTabsForLeadingIndents = this.useTabsOnlyForLeadingIndents;
                numberOfLeadingIndents = this.numberOfIndentations;
                indentationsAsTab = false;
                if (!useTabsForLeadingIndents) ** GOTO lbl96
                columnForLeadingIndents = numberOfLeadingIndents * this.indentationSize;
                while (this.column <= this.indentationLevel) {
                    if (this.column <= columnForLeadingIndents) {
                        if (this.column - 1 + this.tabLength <= this.indentationLevel) {
                            buffer.append('\t');
                            this.column += this.tabLength;
                        } else if (this.column - 1 + this.indentationSize <= this.indentationLevel) {
                            i = 0;
                            max = this.indentationSize;
                            while (i < max) {
                                buffer.append(' ');
                                ++this.column;
                                ++i;
                            }
                        } else {
                            buffer.append(' ');
                            ++this.column;
                        }
                    } else {
                        i = this.column;
                        max = this.indentationLevel;
                        while (i <= max) {
                            buffer.append(' ');
                            ++this.column;
                            ++i;
                        }
                    }
                    this.needSpace = false;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    if (this.column - 1 + this.tabLength <= this.indentationLevel) {
                        buffer.append('\t');
                        this.column += this.tabLength;
                    } else if (this.column - 1 + this.indentationSize <= this.indentationLevel) {
                        i = 0;
                        max = this.indentationSize;
                        while (i < max) {
                            buffer.append(' ');
                            ++this.column;
                            ++i;
                        }
                    } else {
                        buffer.append(' ');
                        ++this.column;
                    }
                    this.needSpace = false;
lbl96:
                    // 2 sources

                    ** while (this.column <= this.indentationLevel)
                }
            }
        }
lbl97:
        // 6 sources

    }

    public void startNewLine() {
        if (this.column > 1) {
            this.printNewLine();
        }
    }

    public void printNewLine() {
        if (this.lastNumberOfNewLines >= 1) {
            this.column = 1;
            return;
        }
        this.addInsertEdit(this.scanner.getCurrentTokenEndPosition() + 1, this.lineSeparator);
        ++this.line;
        this.lastNumberOfNewLines = 1;
        this.column = 1;
        this.needSpace = false;
        this.pendingSpace = false;
    }

    public void printNewLine(int insertPosition) {
        if (this.lastNumberOfNewLines >= 1) {
            this.column = 1;
            return;
        }
        this.addInsertEdit(insertPosition, this.lineSeparator);
        ++this.line;
        this.lastNumberOfNewLines = 1;
        this.column = 1;
        this.needSpace = false;
        this.pendingSpace = false;
    }

    public void printNextToken(int expectedTokenType) {
        this.printNextToken(expectedTokenType, false);
    }

    public void printNextToken(int expectedTokenType, boolean considerSpaceIfAny) {
        this.printComment();
        this.currentToken = this.scanner.nextToken();
        if (this.currentToken == null || expectedTokenType != this.currentToken.type) {
            throw new AbortFormatting("[" + (this.line + 1) + "/" + this.column + "] unexpected token type, expecting:" + expectedTokenType + ", actual:" + this.currentToken);
        }
        this.print(this.currentToken.getLength(), considerSpaceIfAny);
    }

    public void printNextToken(int[] expectedTokenTypes) {
        this.printNextToken(expectedTokenTypes, false);
    }

    public void printNextToken(int[] expectedTokenTypes, boolean considerSpaceIfAny) {
        this.printComment();
        this.currentToken = this.scanner.nextToken();
        if (Arrays.binarySearch(expectedTokenTypes, this.currentToken.type) < 0) {
            StringBuffer expectations = new StringBuffer(5);
            int i = 0;
            while (i < expectedTokenTypes.length) {
                if (i > 0) {
                    expectations.append(',');
                }
                expectations.append(expectedTokenTypes[i]);
                ++i;
            }
            throw new AbortFormatting("[" + (this.line + 1) + "/" + this.column + "] unexpected token type, expecting:[" + expectations.toString() + "], actual:" + this.currentToken);
        }
        this.print(this.currentToken.getLength(), considerSpaceIfAny);
    }

    private void printRule(StringBuffer stringBuffer) {
        int i = 0;
        while (i < this.pageWidth) {
            if (i % this.tabLength == 0) {
                stringBuffer.append('+');
            } else {
                stringBuffer.append('-');
            }
            ++i;
        }
        stringBuffer.append(this.lineSeparator);
        i = 0;
        while (i < this.pageWidth / this.tabLength) {
            stringBuffer.append(i);
            stringBuffer.append('\t');
            ++i;
        }
    }

    public void printTrailingComment() {
        int currentTokenStartPosition = this.scanner.getCurrentPosition();
        boolean hasWhitespaces = false;
        boolean hasComment = false;
        boolean hasLineComment = false;
        int count = 0;
        while ((this.currentToken = this.scanner.nextToken()) != null) {
            switch (this.currentToken.type) {
                case 1000: {
                    char[] whiteSpaces = this.scanner.getCurrentTokenSource();
                    int i = 0;
                    int max = whiteSpaces.length;
                    while (i < max) {
                        switch (whiteSpaces[i]) {
                            case '\r': {
                                if (i + 1 < max && whiteSpaces[i + 1] == '\n') {
                                    ++i;
                                }
                                ++count;
                                break;
                            }
                            case '\n': {
                                ++count;
                            }
                        }
                        ++i;
                    }
                    if (hasLineComment) {
                        if (count >= 1) {
                            currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
                            this.preserveEmptyLines(count - 1, currentTokenStartPosition);
                            this.addDeleteEdit(currentTokenStartPosition, this.scanner.getCurrentTokenEndPosition());
                            this.scanner.resetTo(this.scanner.getCurrentPosition(), this.scannerEndPosition - 1);
                            return;
                        }
                        this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                        return;
                    }
                    if (count >= 1) {
                        if (hasComment) {
                            this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                        }
                        this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                        return;
                    }
                    hasWhitespaces = true;
                    currentTokenStartPosition = this.scanner.getCurrentPosition();
                    this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                    break;
                }
                case 1001: {
                    if (hasWhitespaces) {
                        this.space();
                    }
                    this.printCommentLine();
                    currentTokenStartPosition = this.scanner.getCurrentPosition();
                    hasLineComment = true;
                    break;
                }
                case 1002: {
                    if (hasWhitespaces) {
                        this.space();
                    }
                    this.printBlockComment(false);
                    currentTokenStartPosition = this.scanner.getCurrentPosition();
                    hasComment = true;
                    break;
                }
                case 1003: 
                case 1004: 
                case 1005: {
                    if (this.column != 1) {
                        this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                    }
                    hasWhitespaces = false;
                    this.printPreprocessorDirective();
                    this.startNewLine();
                    currentTokenStartPosition = this.scanner.getCurrentPosition();
                    hasLineComment = false;
                    hasComment = false;
                    count = 0;
                    break;
                }
                default: {
                    this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                    return;
                }
            }
        }
    }

    void redoAlignment(AlignmentException e) {
        if (e.relativeDepth > 0) {
            --e.relativeDepth;
            this.currentAlignment = this.currentAlignment.enclosing;
            throw e;
        }
        this.resetAt(this.currentAlignment.location);
        this.scanner.resetTo(this.currentAlignment.location.inputOffset, this.scanner.eofPosition - 1);
        this.currentAlignment.chunkKind = 0;
    }

    void redoMemberAlignment(AlignmentException e) {
        this.resetAt(this.memberAlignment.location);
        this.scanner.resetTo(this.memberAlignment.location.inputOffset, this.scanner.eofPosition - 1);
        this.memberAlignment.chunkKind = 0;
    }

    public void reset() {
        this.checkLineWrapping = true;
        this.line = 0;
        this.column = 1;
        this.editsIndex = 0;
    }

    private void resetAt(Location location) {
        this.line = location.outputLine;
        this.column = location.outputColumn;
        this.indentationLevel = location.outputIndentationLevel;
        this.numberOfIndentations = location.numberOfIndentations;
        this.lastNumberOfNewLines = location.lastNumberOfNewLines;
        this.needSpace = location.needSpace;
        this.pendingSpace = location.pendingSpace;
        this.editsIndex = location.editsIndex;
        if (this.editsIndex > 0) {
            this.edits[this.editsIndex - 1] = location.textEdit;
        }
    }

    private void resize() {
        this.edits = new OptimizedReplaceEdit[this.editsIndex * 2];
        System.arraycopy(this.edits, 0, this.edits, 0, this.editsIndex);
    }

    public void space() {
        if (!this.needSpace) {
            return;
        }
        this.lastNumberOfNewLines = 0;
        this.pendingSpace = true;
        ++this.column;
        this.needSpace = false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(page width = " + this.pageWidth + ") - (tabChar = ");
        switch (this.tabChar) {
            case 1: {
                stringBuffer.append("TAB");
                break;
            }
            case 2: {
                stringBuffer.append("SPACE");
                break;
            }
            default: {
                stringBuffer.append("MIXED");
            }
        }
        stringBuffer.append(") - (tabSize = " + this.tabLength + ")").append(this.lineSeparator).append("(line = " + this.line + ") - (column = " + this.column + ") - (identationLevel = " + this.indentationLevel + ")").append(this.lineSeparator).append("(needSpace = " + this.needSpace + ") - (lastNumberOfNewLines = " + this.lastNumberOfNewLines + ") - (checkLineWrapping = " + this.checkLineWrapping + ")").append(this.lineSeparator).append("==================================================================================").append(this.lineSeparator);
        this.printRule(stringBuffer);
        return stringBuffer.toString();
    }

    public void unIndent() {
        this.indentationLevel -= this.indentationSize;
        --this.numberOfIndentations;
    }

    public void printModifiers() {
        boolean isFirstModifier = true;
        int currentTokenStartPosition = this.scanner.getCurrentPosition();
        boolean hasComment = false;
        block11: while ((this.currentToken = this.scanner.nextToken()) != null) {
            switch (this.currentToken.type) {
                case 57: 
                case 67: 
                case 78: 
                case 80: 
                case 84: 
                case 87: 
                case 90: 
                case 101: 
                case 106: 
                case 108: 
                case 116: 
                case 120: 
                case 122: 
                case 124: 
                case 136: {
                    this.print(this.currentToken.getLength(), !isFirstModifier);
                    isFirstModifier = false;
                    currentTokenStartPosition = this.scanner.getCurrentPosition();
                    break;
                }
                case 1002: {
                    this.printBlockComment(false);
                    currentTokenStartPosition = this.scanner.getCurrentPosition();
                    hasComment = true;
                    break;
                }
                case 1001: {
                    this.printCommentLine();
                    currentTokenStartPosition = this.scanner.getCurrentPosition();
                    break;
                }
                case 1000: {
                    this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                    int count = 0;
                    char[] whiteSpaces = this.scanner.getCurrentTokenSource();
                    int i = 0;
                    int max = whiteSpaces.length;
                    while (i < max) {
                        switch (whiteSpaces[i]) {
                            case '\r': {
                                if (i + 1 < max && whiteSpaces[i + 1] == '\n') {
                                    ++i;
                                }
                                ++count;
                                break;
                            }
                            case '\n': {
                                ++count;
                            }
                        }
                        ++i;
                    }
                    if (count >= 1 && hasComment) {
                        this.printNewLine();
                    }
                    currentTokenStartPosition = this.scanner.getCurrentPosition();
                    hasComment = false;
                    break;
                }
                case 1003: 
                case 1004: 
                case 1005: {
                    if (this.column != 1) {
                        this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                    }
                    this.printPreprocessorDirective();
                    this.printNewLine();
                    currentTokenStartPosition = this.scanner.getCurrentPosition();
                    hasComment = false;
                    break;
                }
                default: {
                    if (this.currentToken.getType() == 1 && this.currentToken.getText().startsWith("__")) {
                        this.print(this.currentToken.getLength(), !isFirstModifier);
                        isFirstModifier = false;
                        currentTokenStartPosition = this.scanner.getCurrentPosition();
                        this.currentToken = this.scanner.nextToken();
                        if (this.currentToken == null || this.currentToken.getType() != 8 || !this.skipToToken(9)) continue block11;
                        this.currentToken = this.scanner.nextToken();
                        this.currentToken = this.scanner.nextToken();
                        currentTokenStartPosition = this.scanner.getCurrentPosition();
                        break;
                    }
                    this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean skipToToken(int expectedTokenType) {
        int skipStart = this.scanner.getCurrentPosition();
        int braceLevel = 0;
        int parenLevel = 0;
        block7: while ((this.currentToken = this.scanner.nextToken()) != null) {
            switch (this.currentToken.type) {
                case 12: {
                    if (expectedTokenType == 12) break;
                    ++braceLevel;
                    break;
                }
                case 13: {
                    --braceLevel;
                    break;
                }
                case 8: {
                    if (expectedTokenType == 8) break;
                    ++parenLevel;
                    break;
                }
                case 9: {
                    --parenLevel;
                    break;
                }
                case 1000: 
                case 1001: 
                case 1002: 
                case 1003: 
                case 1004: 
                case 1005: {
                    continue block7;
                }
            }
            if (braceLevel <= 0 && parenLevel <= 0 && this.currentToken.type == expectedTokenType) {
                int tokenStart = this.scanner.getCurrentTokenStartPosition();
                this.printRaw(skipStart, tokenStart - skipStart);
                this.scanner.resetTo(tokenStart, this.scannerEndPosition - 1);
                return true;
            }
            if (braceLevel < 0 || parenLevel < 0) break;
        }
        this.scanner.resetTo(skipStart, this.scannerEndPosition - 1);
        return false;
    }

    public boolean printCommentPreservingNewLines() {
        boolean savedPreserveNL = this.preserveNewlines;
        this.preserveNewlines = true;
        try {
            boolean bl = this.printComment();
            Object var2_3 = null;
            this.preserveNewlines = savedPreserveNL;
            return bl;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.preserveNewlines = savedPreserveNL;
            throw throwable;
        }
    }
}

