/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.envvar;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.envvar.EnvirinmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;

public class EnvVarOperationProcessor {
    public static IEnvironmentVariable performOperation(IEnvironmentVariable initial, IEnvironmentVariable added) {
        if (initial == null) {
            return added;
        }
        if (added == null) {
            return initial;
        }
        String name = added.getName();
        switch (added.getOperation()) {
            case 2: {
                return new EnvirinmentVariable(name, null, 2, null);
            }
            case 4: {
                String delimiter = added.getDelimiter();
                return new EnvirinmentVariable(name, EnvVarOperationProcessor.performAppend(initial.getValue(), added.getValue(), delimiter), delimiter);
            }
            case 3: {
                String delimiter = added.getDelimiter();
                return new EnvirinmentVariable(name, EnvVarOperationProcessor.performPrepend(initial.getValue(), added.getValue(), delimiter), delimiter);
            }
        }
        return new EnvirinmentVariable(added.getName(), added.getValue(), added.getDelimiter());
    }

    public static String performAppendPrepend(String initialValue, String addValue, String delimiter, boolean prepend) {
        if (initialValue == null) {
            return addValue;
        }
        if (addValue == null) {
            return initialValue;
        }
        if (delimiter == null || "".equals(delimiter)) {
            return prepend ? String.valueOf(addValue) + initialValue : String.valueOf(initialValue) + addValue;
        }
        List value = EnvVarOperationProcessor.convertToList(initialValue, delimiter);
        List added = EnvVarOperationProcessor.convertToList(addValue, delimiter);
        value = EnvVarOperationProcessor.removeDuplicates(value, added);
        if (prepend) {
            value.addAll(0, added);
        } else {
            value.addAll(added);
        }
        return EnvVarOperationProcessor.convertToString(value, delimiter);
    }

    public static String performAppend(String initialValue, String addValue, String delimiter) {
        return EnvVarOperationProcessor.performAppendPrepend(initialValue, addValue, delimiter, false);
    }

    public static String performPrepend(String initialValue, String addValue, String delimiter) {
        return EnvVarOperationProcessor.performAppendPrepend(initialValue, addValue, delimiter, true);
    }

    public static String performOperation(String initialValue, String newValue, String delimiter, int op) {
        switch (op) {
            case 2: {
                return null;
            }
            case 3: {
                return EnvVarOperationProcessor.performPrepend(initialValue, newValue, delimiter);
            }
            case 4: {
                return EnvVarOperationProcessor.performAppend(initialValue, newValue, delimiter);
            }
        }
        return initialValue;
    }

    public static List convertToList(String value, String delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        int delLength = delimiter.length();
        int valLength = value.length();
        if (delLength == 0) {
            list.add(value);
        } else {
            int start = 0;
            while (start < valLength) {
                int stop = value.indexOf(delimiter, start);
                if (stop == -1) {
                    stop = valLength;
                }
                String subst = value.substring(start, stop);
                list.add(subst);
                start = stop + delLength;
            }
        }
        return list;
    }

    public static List removeDuplicates(List value, List duplicates) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator valueIter = value.iterator();
        while (valueIter.hasNext()) {
            String curVal = (String)valueIter.next();
            boolean duplFound = false;
            Iterator duplicatesIter = duplicates.iterator();
            while (duplicatesIter.hasNext()) {
                String curDupl = (String)duplicatesIter.next();
                if (!curVal.equals(curDupl)) continue;
                duplFound = true;
                break;
            }
            if (duplFound) continue;
            list.add(curVal);
        }
        return list;
    }

    public static String convertToString(List list, String delimiter) {
        Iterator iter = list.iterator();
        StringBuffer buffer = new StringBuffer();
        while (iter.hasNext()) {
            buffer.append((String)iter.next());
            if (!iter.hasNext()) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    private static String concatenateStrings(String str1, String str2, String delimiter) {
        if (str1 == null || "".equals(str1)) {
            return str2;
        }
        if (str2 == null || "".equals(str2)) {
            return str1;
        }
        return String.valueOf(str1) + delimiter + str2;
    }

    public static String normalizeName(String name) {
        if (name == null) {
            return null;
        }
        if ("".equals(name = name.trim())) {
            return null;
        }
        if (!EnvironmentVariableManager.getDefault().isVariableCaseSensitive()) {
            name = name.toUpperCase();
        }
        return name;
    }

    public static IEnvironmentVariable[] filterVariables(IEnvironmentVariable[] variables, String[] remove) {
        if (variables == null || variables.length == 0) {
            return variables;
        }
        IEnvironmentVariable[] filtered = new IEnvironmentVariable[variables.length];
        int filteredNum = 0;
        int i = 0;
        while (i < variables.length) {
            IEnvironmentVariable var = variables[i];
            String name = null;
            if (var != null && (name = EnvVarOperationProcessor.normalizeName(var.getName())) != null) {
                boolean skip = false;
                if (remove != null && remove.length > 0) {
                    int j = 0;
                    while (j < remove.length) {
                        if (remove[j] != null && remove[j].equals(name)) {
                            skip = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (!skip) {
                    filtered[filteredNum++] = var;
                }
            }
            ++i;
        }
        if (filteredNum != filtered.length) {
            IEnvironmentVariable[] vars = new IEnvironmentVariable[filteredNum];
            int i2 = 0;
            while (i2 < filteredNum) {
                vars[i2] = filtered[i2];
                ++i2;
            }
            filtered = vars;
        }
        return filtered;
    }
}

