/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.IFunctionInfo;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.core.browser.IndexTypeReference;
import org.eclipse.cdt.internal.core.browser.util.IndexModelUtil;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class IndexTypeInfo
implements ITypeInfo,
IFunctionInfo {
    private final String[] fqn;
    private final int elementType;
    private final IIndex index;
    private final String[] params;
    private final String returnType;
    private ITypeReference reference;

    private static int hashCode(String[] array) {
        int prime = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        int index = 0;
        while (index < array.length) {
            result = prime * result + (array[index] == null ? 0 : array[index].hashCode());
            ++index;
        }
        return result;
    }

    public static IndexTypeInfo create(IIndex index, IIndexBinding binding) {
        String[] fqn;
        int elementType;
        try {
            elementType = IndexModelUtil.getElementType(binding);
            if (binding instanceof ICPPBinding) {
                fqn = ((ICPPBinding)((Object)binding)).getQualifiedName();
            } else if (binding instanceof IField) {
                IField field = (IField)((Object)binding);
                ICompositeType owner = field.getCompositeTypeOwner();
                fqn = new String[]{owner.getName(), field.getName()};
            } else {
                fqn = new String[]{binding.getName()};
            }
            if (binding instanceof IFunction) {
                IFunction function = (IFunction)((Object)binding);
                String[] paramTypes = IndexModelUtil.extractParameterTypes(function);
                String returnType = IndexModelUtil.extractReturnType(function);
                return new IndexTypeInfo(fqn, elementType, paramTypes, returnType, index);
            }
        }
        catch (DOMException dOMException) {
            throw new AssertionError();
        }
        return new IndexTypeInfo(fqn, elementType, index);
    }

    public static IndexTypeInfo create(IIndex index, IIndexMacro macro) {
        char[] name = macro.getName();
        return new IndexTypeInfo(new String[]{new String(name)}, 79, index);
    }

    private IndexTypeInfo(String[] fqn, int elementType, IIndex index, String[] params, String returnType, ITypeReference reference) {
        Assert.isTrue((index != null ? 1 : 0) != 0);
        this.fqn = fqn;
        this.elementType = elementType;
        this.index = index;
        this.params = params;
        this.returnType = returnType;
        this.reference = reference;
    }

    public IndexTypeInfo(String[] fqn, int elementType, IIndex index) {
        this(fqn, elementType, index, null, null, null);
    }

    public IndexTypeInfo(String[] fqn, int elementType, String[] params, String returnType, IIndex index) {
        this(fqn, elementType, index, params, returnType, null);
    }

    public IndexTypeInfo(IndexTypeInfo rhs, ITypeReference ref) {
        this(rhs.fqn, rhs.elementType, rhs.index, rhs.params, rhs.returnType, ref);
    }

    public void addDerivedReference(ITypeReference location) {
        throw new PDOMNotImplementedError();
    }

    public void addReference(ITypeReference location) {
        throw new PDOMNotImplementedError();
    }

    public boolean canSubstituteFor(ITypeInfo info) {
        throw new PDOMNotImplementedError();
    }

    public boolean encloses(ITypeInfo info) {
        throw new PDOMNotImplementedError();
    }

    public boolean exists() {
        throw new PDOMNotImplementedError();
    }

    public int getCElementType() {
        return this.elementType;
    }

    public ITypeReference[] getDerivedReferences() {
        throw new PDOMNotImplementedError();
    }

    public ITypeInfo[] getEnclosedTypes() {
        throw new PDOMNotImplementedError();
    }

    public ITypeInfo[] getEnclosedTypes(int[] kinds) {
        throw new PDOMNotImplementedError();
    }

    public ITypeInfo getEnclosingNamespace(boolean includeGlobalNamespace) {
        throw new PDOMNotImplementedError();
    }

    public ICProject getEnclosingProject() {
        IProject project;
        if (this.getResolvedReference() != null && (project = this.reference.getProject()) != null) {
            return CCorePlugin.getDefault().getCoreModel().getCModel().getCProject(project.getName());
        }
        return null;
    }

    public ITypeInfo getEnclosingType() {
        return null;
    }

    public ITypeInfo getEnclosingType(int[] kinds) {
        throw new PDOMNotImplementedError();
    }

    public String getName() {
        return this.fqn[this.fqn.length - 1];
    }

    public IQualifiedTypeName getQualifiedTypeName() {
        return new QualifiedTypeName(this.fqn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ITypeReference getResolvedReference() {
        if (this.reference != null) return this.reference;
        if (this.elementType == 79) {
            return this.createMacroReference();
        }
        try {
            block11: {
                try {
                    this.index.acquireReadLock();
                    char[][] cfqn = new char[this.fqn.length][];
                    int i = 0;
                    while (i < this.fqn.length) {
                        cfqn[i] = this.fqn[i].toCharArray();
                        ++i;
                    }
                    IIndexBinding[] ibs = this.index.findBindings(cfqn, new IndexFilter(){

                        public boolean acceptBinding(IBinding binding) {
                            boolean sameType = IndexModelUtil.bindingHasCElementType(binding, new int[]{IndexTypeInfo.this.elementType});
                            if (sameType && binding instanceof IFunction && IndexTypeInfo.this.params != null) {
                                try {
                                    Object[] otherParams = IndexModelUtil.extractParameterTypes((IFunction)binding);
                                    return Arrays.equals(IndexTypeInfo.this.params, otherParams);
                                }
                                catch (DOMException exc) {
                                    CCorePlugin.log(exc);
                                }
                            }
                            return sameType;
                        }
                    }, (IProgressMonitor)new NullProgressMonitor());
                    if (ibs.length <= 0) break block11;
                    IIndexName[] names = this.index.findNames(ibs[0], 2);
                    if (names.length == 0) {
                        names = this.index.findNames(ibs[0], 1);
                    }
                    int i2 = 0;
                    while (i2 < names.length) {
                        this.reference = this.createReference(ibs[0], names[i2]);
                        if (this.reference == null) {
                            ++i2;
                            continue;
                        }
                        break;
                    }
                }
                catch (CoreException ce) {
                    CCorePlugin.log(ce);
                }
                catch (InterruptedException ie) {
                    CCorePlugin.log(ie);
                }
            }
            Object var5_10 = null;
            this.index.releaseReadLock();
            return this.reference;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.index.releaseReadLock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ITypeReference createMacroReference() {
        try {
            block8: {
                try {
                    this.index.acquireReadLock();
                    IIndexMacro[] macros = this.index.findMacros(this.fqn[0].toCharArray(), IndexFilter.ALL_DECLARED, (IProgressMonitor)new NullProgressMonitor());
                    if (macros.length <= 0) break block8;
                    int i = 0;
                    while (i < macros.length) {
                        this.reference = this.createReference(macros[i]);
                        if (this.reference == null) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
                catch (CoreException ce) {
                    CCorePlugin.log(ce);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            Object var3_6 = null;
            this.index.releaseReadLock();
            return this.reference;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.index.releaseReadLock();
            throw throwable;
        }
    }

    private IndexTypeReference createReference(IIndexBinding binding, IIndexName indexName) throws CoreException {
        IIndexFileLocation ifl = indexName.getFile().getLocation();
        String fullPath = ifl.getFullPath();
        if (fullPath != null) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fullPath));
            if (file != null) {
                return new IndexTypeReference((IBinding)binding, (IResource)file, file.getProject(), indexName.getNodeOffset(), indexName.getNodeLength());
            }
        } else {
            IPath path = URIUtil.toPath((URI)ifl.getURI());
            if (path != null) {
                return new IndexTypeReference((IBinding)binding, path, null, indexName.getNodeOffset(), indexName.getNodeLength());
            }
        }
        return null;
    }

    private IndexTypeReference createReference(IIndexMacro macro) throws CoreException {
        IIndexFileLocation ifl = macro.getFile().getLocation();
        String fullPath = ifl.getFullPath();
        if (fullPath != null) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fullPath));
            if (file != null) {
                return new IndexTypeReference(macro, (IResource)file, file.getProject(), macro.getNodeOffset(), macro.getNodeLength());
            }
        } else {
            IPath path = URIUtil.toPath((URI)ifl.getURI());
            if (path != null) {
                return new IndexTypeReference(macro, path, null, macro.getNodeOffset(), macro.getNodeLength());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ITypeReference[] getReferences() {
        if (this.elementType == 79) {
            return this.getMacroReferences();
        }
        ArrayList<IndexTypeReference> references = new ArrayList<IndexTypeReference>();
        try {
            try {
                int i;
                HashMap iflMap;
                IIndexBinding[] ibs;
                this.index.acquireReadLock();
                char[][] cfqn = new char[this.fqn.length][];
                int i2 = 0;
                while (true) {
                    if (i2 >= this.fqn.length) {
                        ibs = this.index.findBindings(cfqn, new IndexFilter(){

                            public boolean acceptBinding(IBinding binding) {
                                boolean sameType = IndexModelUtil.bindingHasCElementType(binding, new int[]{IndexTypeInfo.this.elementType});
                                if (sameType && binding instanceof IFunction && IndexTypeInfo.this.params != null) {
                                    try {
                                        Object[] otherParams = IndexModelUtil.extractParameterTypes((IFunction)binding);
                                        return Arrays.equals(IndexTypeInfo.this.params, otherParams);
                                    }
                                    catch (DOMException exc) {
                                        CCorePlugin.log(exc);
                                    }
                                }
                                return sameType;
                            }
                        }, (IProgressMonitor)new NullProgressMonitor());
                        iflMap = new HashMap();
                        i = 0;
                        break;
                    }
                    cfqn[i2] = this.fqn[i2].toCharArray();
                    ++i2;
                }
                block7: while (i < ibs.length) {
                    IIndexBinding binding = ibs[i];
                    IIndexName[] names = this.index.findNames(binding, 2);
                    if (names.length == 0) {
                        names = this.index.findNames(binding, 1);
                    }
                    int j = 0;
                    while (true) {
                        IndexTypeReference ref;
                        if (j >= names.length) {
                            ++i;
                            continue block7;
                        }
                        IIndexName indexName = names[j];
                        if (this.checkFile(iflMap, indexName.getFile()) && (ref = this.createReference(binding, indexName)) != null) {
                            references.add(ref);
                        }
                        ++j;
                    }
                }
            }
            catch (CoreException ce) {
                CCorePlugin.log(ce);
            }
            catch (InterruptedException ie) {
                CCorePlugin.log(ie);
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            this.index.releaseReadLock();
            throw throwable;
        }
        {
            Object var11_16 = null;
            this.index.releaseReadLock();
            return references.toArray(new IndexTypeReference[references.size()]);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ITypeReference[] getMacroReferences() {
        ArrayList<IndexTypeReference> references = new ArrayList<IndexTypeReference>();
        try {
            try {
                this.index.acquireReadLock();
                char[] cfn = this.fqn[0].toCharArray();
                IIndexMacro[] ibs = this.index.findMacros(cfn, IndexFilter.ALL_DECLARED, (IProgressMonitor)new NullProgressMonitor());
                HashMap iflMap = new HashMap();
                int i = 0;
                while (i < ibs.length) {
                    IndexTypeReference ref;
                    IIndexMacro macro = ibs[i];
                    if (this.checkFile(iflMap, macro.getFile()) && (ref = this.createReference(macro)) != null) {
                        references.add(ref);
                    }
                    ++i;
                }
            }
            catch (CoreException ce) {
                CCorePlugin.log(ce);
            }
            catch (InterruptedException ie) {
                CCorePlugin.log(ie);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.index.releaseReadLock();
            throw throwable;
        }
        {
            Object var8_12 = null;
            this.index.releaseReadLock();
            return references.toArray(new IndexTypeReference[references.size()]);
        }
    }

    private boolean checkFile(HashMap iflMap, IIndexFile file) throws CoreException {
        IIndexFileLocation ifl = file.getLocation();
        IIndexFile otherFile = (IIndexFile)iflMap.get(ifl);
        if (otherFile == null) {
            iflMap.put(ifl, file);
            return true;
        }
        return otherFile.equals(file);
    }

    public ITypeInfo getRootNamespace(boolean includeGlobalNamespace) {
        throw new PDOMNotImplementedError();
    }

    public ITypeInfo[] getSubTypes() {
        throw new PDOMNotImplementedError();
    }

    public ASTAccessVisibility getSuperTypeAccess(ITypeInfo subType) {
        throw new PDOMNotImplementedError();
    }

    public ITypeInfo[] getSuperTypes() {
        throw new PDOMNotImplementedError();
    }

    public boolean hasEnclosedTypes() {
        throw new PDOMNotImplementedError();
    }

    public boolean hasSubTypes() {
        throw new PDOMNotImplementedError();
    }

    public boolean hasSuperTypes() {
        throw new PDOMNotImplementedError();
    }

    public boolean isClass() {
        throw new PDOMNotImplementedError();
    }

    public boolean isEnclosed(ITypeInfo info) {
        throw new PDOMNotImplementedError();
    }

    public boolean isEnclosed(ITypeSearchScope scope) {
        throw new PDOMNotImplementedError();
    }

    public boolean isEnclosedType() {
        throw new PDOMNotImplementedError();
    }

    public boolean isEnclosingType() {
        throw new PDOMNotImplementedError();
    }

    public boolean isReferenced(ITypeSearchScope scope) {
        throw new PDOMNotImplementedError();
    }

    public boolean isUndefinedType() {
        throw new PDOMNotImplementedError();
    }

    public void setCElementType(int type) {
        throw new PDOMNotImplementedError();
    }

    public int compareTo(Object arg0) {
        throw new PDOMNotImplementedError();
    }

    public String[] getParameters() {
        return this.params;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.elementType;
        result = 31 * result + IndexTypeInfo.hashCode(this.fqn);
        result = 31 * result + IndexTypeInfo.hashCode(this.params);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexTypeInfo other = (IndexTypeInfo)obj;
        if (this.elementType != other.elementType) {
            return false;
        }
        if (!Arrays.equals(this.fqn, other.fqn)) {
            return false;
        }
        return Arrays.equals(this.params, other.params);
    }
}

