/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.index;

import java.net.URI;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.index.IndexFileLocation;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class IndexLocationFactory {
    public static IPath getPath(IIndexFileLocation location) {
        String fp = location.getFullPath();
        if (fp != null) {
            return new Path(fp);
        }
        return IndexLocationFactory.getAbsolutePath(location);
    }

    public static IPath getAbsolutePath(IIndexFileLocation location) {
        return URIUtil.toPath((URI)location.getURI());
    }

    public static IIndexFileLocation getIFLExpensive(String absolutePath) {
        return IndexLocationFactory.getIFLExpensive(null, absolutePath);
    }

    public static IIndexFileLocation getIFLExpensive(ICProject cproject, String absolutePath) {
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(absolutePath));
        if (files.length == 1) {
            return IndexLocationFactory.getWorkspaceIFL(files[0]);
        }
        if (cproject != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].getProject().equals((Object)cproject.getProject())) {
                    return IndexLocationFactory.getWorkspaceIFL(files[i]);
                }
                ++i;
            }
        }
        return new IndexFileLocation(URIUtil.toURI((String)absolutePath), null);
    }

    public static IIndexFileLocation getExternalIFL(String absolutePath) {
        return IndexLocationFactory.getExternalIFL((IPath)new Path(absolutePath));
    }

    public static IIndexFileLocation getExternalIFL(IPath absolutePath) {
        return new IndexFileLocation(URIUtil.toURI((IPath)absolutePath), null);
    }

    public static IIndexFileLocation getWorkspaceIFL(IFile file) {
        return new IndexFileLocation(file.getLocationURI(), file.getFullPath().toString());
    }

    public static IIndexFileLocation getIFL(ITranslationUnit tu) {
        IResource res = tu.getResource();
        if (res instanceof IFile) {
            return IndexLocationFactory.getWorkspaceIFL((IFile)res);
        }
        IPath location = tu.getLocation();
        if (location != null) {
            return IndexLocationFactory.getExternalIFL(location);
        }
        return null;
    }
}

