/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.cdtvariables;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.cdtvariables.CdtVariableManager;
import org.eclipse.cdt.internal.core.cdtvariables.EclipseVariablesVariableSupplier;
import org.eclipse.cdt.internal.core.cdtvariables.StorableCdtVariable;
import org.eclipse.cdt.internal.core.cdtvariables.UserDefinedVariableSupplier;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;

public class StorableCdtVariables {
    public static final String MACROS_ELEMENT_NAME = "macros";
    private HashMap fMacros;
    private boolean fIsDirty = false;
    private boolean fIsChanged = false;
    private boolean fIsReadOnly;

    private HashMap getMap() {
        if (this.fMacros == null) {
            this.fMacros = new HashMap();
        }
        return this.fMacros;
    }

    public StorableCdtVariables(boolean readOnly) {
        this.fIsReadOnly = readOnly;
    }

    public StorableCdtVariables(StorableCdtVariables base, boolean readOnly) {
        this.fMacros = (HashMap)base.getMap().clone();
        this.fIsReadOnly = readOnly;
    }

    public StorableCdtVariables(ICdtVariable[] vars, boolean readOnly) {
        this.fMacros = new HashMap(vars.length);
        int i = 0;
        while (i < vars.length) {
            this.addMacro(vars[i]);
            ++i;
        }
        this.fIsReadOnly = readOnly;
    }

    public StorableCdtVariables(ICStorageElement element, boolean readOnly) {
        this.load(element);
        this.fIsReadOnly = readOnly;
    }

    private void load(ICStorageElement element) {
        ICStorageElement[] nodeList = element.getChildren();
        int i = 0;
        while (i < nodeList.length) {
            ICStorageElement node = nodeList[i];
            String name = node.getName();
            if ("stringMacro".equals(name)) {
                this.addMacro(new StorableCdtVariable(node));
            } else if ("stringListMacro".equals(name)) {
                this.addMacro(new StorableCdtVariable(node));
            }
            ++i;
        }
        this.fIsDirty = false;
        this.fIsChanged = false;
    }

    public void serialize(ICStorageElement element) {
        if (this.fMacros != null) {
            Iterator iter = this.fMacros.values().iterator();
            while (iter.hasNext()) {
                StorableCdtVariable macro = (StorableCdtVariable)iter.next();
                ICStorageElement macroEl = CdtVariableResolver.isStringListVariable(macro.getValueType()) ? element.createChild("stringListMacro") : element.createChild("stringMacro");
                macro.serialize(macroEl);
            }
        }
        this.fIsDirty = false;
    }

    private void addMacro(ICdtVariable macro) {
        String name = macro.getName();
        if (name == null) {
            return;
        }
        this.getMap().put(name, macro);
    }

    public ICdtVariable createMacro(String name, int type, String value) {
        if (name == null || "".equals(name = name.trim()) || CdtVariableResolver.isStringListVariable(type)) {
            return null;
        }
        ICdtVariable macro = this.checkMacro(name, type, value);
        if (macro == null) {
            macro = new StorableCdtVariable(name, type, value);
            this.addMacro(macro);
            this.fIsDirty = true;
            this.fIsChanged = true;
        }
        return macro;
    }

    public ICdtVariable checkMacro(String name, int type, String value) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        ICdtVariable macro = this.getMacro(name);
        if (macro != null && macro.getName().equals(name) && macro.getValueType() == type) {
            try {
                String val = macro.getStringValue();
                if (val != null && val.equals(value) || val == value) {
                    return macro;
                }
            }
            catch (CdtVariableException cdtVariableException) {}
        }
        return null;
    }

    public ICdtVariable checkMacro(String name, int type, String[] value) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        ICdtVariable macro = this.getMacro(name);
        if (macro != null && macro.getName().equals(name) && macro.getValueType() == type) {
            try {
                String[] val = macro.getStringListValue();
                if (val != null) {
                    if (value != null && value.length == val.length) {
                        int i = 0;
                        while (i < val.length) {
                            if (!value[i].equals(val[i])) break;
                            ++i;
                        }
                        if (i == value.length) {
                            return macro;
                        }
                    }
                } else if (value == val) {
                    return macro;
                }
            }
            catch (CdtVariableException cdtVariableException) {}
        }
        return null;
    }

    public void setMacros(ICdtVariable[] macros) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        if (macros == null || macros.length == 0) {
            this.deleteAll();
        } else {
            if (this.getMap().size() != 0) {
                Iterator iter = this.getMap().values().iterator();
                while (iter.hasNext()) {
                    ICdtVariable m = (ICdtVariable)iter.next();
                    int i = 0;
                    while (i < macros.length) {
                        if (m.getName().equals(macros[i].getName())) break;
                        ++i;
                    }
                    if (i != macros.length) continue;
                    this.deleteMacro(m.getName());
                }
            }
            this.createMacros(macros);
        }
    }

    public void createMacros(ICdtVariable[] macros) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        int i = 0;
        while (i < macros.length) {
            this.createMacro(macros[i]);
            ++i;
        }
    }

    public boolean isEmpty() {
        return this.fMacros == null || this.fMacros.isEmpty();
    }

    public ICdtVariable createMacro(ICdtVariable copy) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        String name = copy.getName();
        if (name == null || "".equals(name = name.trim())) {
            return null;
        }
        int type = copy.getValueType();
        ICdtVariable macro = null;
        try {
            if (CdtVariableResolver.isStringListVariable(type)) {
                String[] value = copy.getStringListValue();
                macro = this.checkMacro(name, type, value);
                if (macro == null) {
                    macro = new StorableCdtVariable(name, type, value);
                    this.addMacro(macro);
                    this.fIsDirty = true;
                    this.fIsChanged = true;
                }
            } else {
                String value = copy.getStringValue();
                macro = this.checkMacro(name, type, value);
                if (macro == null) {
                    macro = new StorableCdtVariable(name, type, value);
                    this.addMacro(macro);
                    this.fIsDirty = true;
                    this.fIsChanged = true;
                }
            }
        }
        catch (CdtVariableException cdtVariableException) {}
        return macro;
    }

    public ICdtVariable createMacro(String name, int type, String[] value) {
        if (name == null || "".equals(name = name.trim()) || !CdtVariableResolver.isStringListVariable(type)) {
            return null;
        }
        ICdtVariable macro = this.checkMacro(name, type, value);
        if (macro == null) {
            macro = new StorableCdtVariable(name, type, value);
            this.addMacro(macro);
            this.fIsDirty = true;
            this.fIsChanged = true;
        }
        return macro;
    }

    public boolean isDirty() {
        return this.fIsDirty;
    }

    public void setDirty(boolean dirty) {
        this.fIsDirty = dirty;
    }

    public boolean isChanged() {
        return this.fIsChanged;
    }

    public void setChanged(boolean changed) {
        this.fIsChanged = changed;
    }

    public ICdtVariable getMacro(String name) {
        int indx;
        if (name == null || "".equals(name = name.trim())) {
            return null;
        }
        ICdtVariable var = (ICdtVariable)this.getMap().get(name);
        if (var == null && (indx = name.indexOf(58)) != -1) {
            String baseName = name.substring(0, indx);
            ICdtVariable tmp = (ICdtVariable)this.getMap().get(baseName);
            if (tmp != null && CdtVariableManager.getDefault().toEclipseVariable(tmp, null) != null) {
                var = EclipseVariablesVariableSupplier.getInstance().getVariable(name);
            }
        }
        return var;
    }

    public ICdtVariable[] getMacros() {
        Collection macros = this.getMap().values();
        return macros.toArray(new ICdtVariable[macros.size()]);
    }

    public ICdtVariable deleteMacro(String name) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        if (name == null || "".equals(name = name.trim())) {
            return null;
        }
        ICdtVariable macro = (ICdtVariable)this.getMap().remove(name);
        if (macro != null) {
            this.fIsDirty = true;
            this.fIsChanged = true;
        }
        return macro;
    }

    public boolean deleteAll() {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        HashMap map = this.getMap();
        if (map.size() > 0) {
            this.fIsDirty = true;
            this.fIsChanged = true;
            map.clear();
            return true;
        }
        return false;
    }

    public boolean contains(ICdtVariable var) {
        ICdtVariable curVar = this.getMacro(var.getName());
        if (curVar == null) {
            return false;
        }
        return new UserDefinedVariableSupplier.VarKey(curVar, false).equals(new UserDefinedVariableSupplier.VarKey(var, false));
    }
}

