/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisiblityLabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;

public class CPPField
extends CPPVariable
implements ICPPField,
ICPPInternalBinding {
    public CPPField(IASTName name) {
        super(name);
    }

    public IASTDeclaration getPrimaryDeclaration() throws DOMException {
        IASTName[] declarations = (IASTName[])this.getDeclarations();
        if (declarations != null || this.getDefinition() != null) {
            int len = declarations != null ? declarations.length : 0;
            int i = -1;
            while (i < len) {
                IASTNode node;
                IASTNode iASTNode = node = i == -1 ? this.getDefinition() : declarations[i];
                if (node != null) {
                    while (!(node instanceof IASTDeclaration)) {
                        node = node.getParent();
                    }
                    if (node.getParent() instanceof ICPPASTCompositeTypeSpecifier) {
                        return (IASTDeclaration)node;
                    }
                }
                ++i;
            }
        }
        char[] myName = this.getNameCharArray();
        ICPPClassScope scope = (ICPPClassScope)this.getScope();
        ICPPASTCompositeTypeSpecifier compSpec = (ICPPASTCompositeTypeSpecifier)ASTInternal.getPhysicalNodeOfScope(scope);
        IASTDeclaration[] members = compSpec.getMembers();
        int i = 0;
        while (i < members.length) {
            if (members[i] instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] dtors = ((IASTSimpleDeclaration)members[i]).getDeclarators();
                int j = 0;
                while (j < dtors.length) {
                    IASTName name = dtors[j].getName();
                    if (CharArrayUtils.equals(name.toCharArray(), myName) && name.resolveBinding() == this) {
                        return members[i];
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public int getVisibility() throws DOMException {
        ICPPASTVisiblityLabel vis = null;
        IASTDeclaration decl = this.getPrimaryDeclaration();
        if (decl != null) {
            IASTCompositeTypeSpecifier cls = (IASTCompositeTypeSpecifier)decl.getParent();
            IASTDeclaration[] members = cls.getMembers();
            int i = 0;
            while (i < members.length) {
                if (members[i] instanceof ICPPASTVisiblityLabel) {
                    vis = (ICPPASTVisiblityLabel)members[i];
                } else if (members[i] == decl) break;
                ++i;
            }
            if (vis != null) {
                return vis.getVisibility();
            }
            if (cls.getKey() == 3) {
                return 3;
            }
        }
        return 1;
    }

    public ICPPClassType getClassOwner() throws DOMException {
        ICPPClassScope scope = (ICPPClassScope)this.getScope();
        return scope.getClassType();
    }

    public boolean isStatic() {
        IASTNode def;
        if (this.getDeclarations() == null && (def = this.getDefinition()) instanceof ICPPASTQualifiedName) {
            return true;
        }
        return super.isStatic();
    }

    public boolean isMutable() {
        return this.hasStorageClass(6);
    }

    public boolean isExtern() {
        return false;
    }

    public ICPPDelegate createDelegate(IASTName name) {
        return new CPPFieldDelegate(name, this);
    }

    public ICompositeType getCompositeTypeOwner() throws DOMException {
        return this.getClassOwner();
    }

    public static class CPPFieldDelegate
    extends CPPVariable.CPPVariableDelegate
    implements ICPPField {
        public CPPFieldDelegate(IASTName name, ICPPField binding) {
            super(name, binding);
        }

        public int getVisibility() throws DOMException {
            return ((ICPPField)this.getBinding()).getVisibility();
        }

        public ICPPClassType getClassOwner() throws DOMException {
            return ((ICPPField)this.getBinding()).getClassOwner();
        }

        public ICompositeType getCompositeTypeOwner() throws DOMException {
            return this.getClassOwner();
        }
    }

    public static class CPPFieldProblem
    extends CPPVariable.CPPVariableProblem
    implements ICPPField {
        public CPPFieldProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        public int getVisibility() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPClassType getClassOwner() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isStatic() throws DOMException {
            throw new DOMException(this);
        }

        public ICompositeType getCompositeTypeOwner() throws DOMException {
            return this.getClassOwner();
        }
    }
}

