/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisiblityLabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateScope;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionTemplate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;

public class CPPMethodTemplate
extends CPPFunctionTemplate
implements ICPPMethod {
    public CPPMethodTemplate(IASTName name) {
        super(name);
    }

    public IASTDeclaration getPrimaryDeclaration() throws DOMException {
        if (this.declarations != null) {
            int i = 0;
            while (i < this.declarations.length) {
                IASTNode parent = this.declarations[i].getParent();
                while (!(parent instanceof IASTDeclaration)) {
                    parent = parent.getParent();
                }
                IASTDeclaration decl = (IASTDeclaration)parent.getParent();
                if (decl instanceof ICPPASTCompositeTypeSpecifier) {
                    return decl;
                }
                ++i;
            }
        }
        char[] myName = this.getNameCharArray();
        IScope scope = this.getScope();
        if (scope instanceof ICPPTemplateScope) {
            scope = scope.getParent();
        }
        ICPPClassScope clsScope = (ICPPClassScope)scope;
        ICPPASTCompositeTypeSpecifier compSpec = (ICPPASTCompositeTypeSpecifier)ASTInternal.getPhysicalNodeOfScope(clsScope);
        IASTDeclaration[] members = compSpec.getMembers();
        int i = 0;
        while (i < members.length) {
            if (members[i] instanceof ICPPASTTemplateDeclaration) {
                IASTName name;
                IASTDeclaration decl = ((ICPPASTTemplateDeclaration)members[i]).getDeclaration();
                if (decl instanceof IASTSimpleDeclaration) {
                    IASTDeclarator[] dtors = ((IASTSimpleDeclaration)decl).getDeclarators();
                    int j = 0;
                    while (j < dtors.length) {
                        IASTName name2 = CPPVisitor.getMostNestedDeclarator(dtors[j]).getName();
                        if (CharArrayUtils.equals(name2.toCharArray(), myName) && name2.resolveBinding() == this) {
                            return members[i];
                        }
                        ++j;
                    }
                } else if (decl instanceof IASTFunctionDefinition && CharArrayUtils.equals((name = CPPVisitor.getMostNestedDeclarator(((IASTFunctionDefinition)decl).getDeclarator()).getName()).toCharArray(), myName) && name.resolveBinding() == this) {
                    return members[i];
                }
            }
            ++i;
        }
        return null;
    }

    public int getVisibility() throws DOMException {
        IASTDeclaration decl = this.getPrimaryDeclaration();
        if (decl == null) {
            ICPPClassType cls;
            IScope scope = this.getScope();
            if (scope instanceof ICPPTemplateScope) {
                scope = scope.getParent();
            }
            if (scope instanceof ICPPClassScope && (cls = ((ICPPClassScope)scope).getClassType()) != null) {
                return cls.getKey() == 3 ? 3 : 1;
            }
            return 3;
        }
        IASTCompositeTypeSpecifier cls = (IASTCompositeTypeSpecifier)decl.getParent();
        IASTDeclaration[] members = cls.getMembers();
        ICPPASTVisiblityLabel vis = null;
        int i = 0;
        while (i < members.length) {
            if (members[i] instanceof ICPPASTVisiblityLabel) {
                vis = (ICPPASTVisiblityLabel)members[i];
            } else if (members[i] == decl) break;
            ++i;
        }
        if (vis != null) {
            return vis.getVisibility();
        }
        if (cls.getKey() == 3) {
            return 3;
        }
        return 1;
    }

    public ICPPClassType getClassOwner() throws DOMException {
        ICPPClassScope scope = (ICPPClassScope)this.getScope();
        return scope.getClassType();
    }

    public boolean isVirtual() {
        return false;
    }

    public boolean isInline() throws DOMException {
        IASTDeclaration decl = this.getPrimaryDeclaration();
        if (decl instanceof ICPPASTTemplateDeclaration && ((ICPPASTTemplateDeclaration)decl).getDeclaration() instanceof IASTFunctionDefinition) {
            return true;
        }
        return super.isInline();
    }

    public boolean isDestructor() {
        char[] name = this.getNameCharArray();
        return name.length > 1 && name[0] == '~';
    }

    public boolean isImplicit() {
        return false;
    }
}

