/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.core.runtime.CoreException;

public class DeclaredBindingsFilter
extends IndexFilter {
    private final String fLinkageID;
    private final boolean fAcceptImplicit;

    public DeclaredBindingsFilter() {
        this(null, false);
    }

    public DeclaredBindingsFilter(String linkageID, boolean acceptImplicit) {
        this.fLinkageID = linkageID;
        this.fAcceptImplicit = acceptImplicit;
    }

    public boolean acceptLinkage(ILinkage linkage) {
        return this.fLinkageID == null || this.fLinkageID.equals(linkage.getID());
    }

    public boolean acceptBinding(IBinding binding) throws CoreException {
        if (binding instanceof IIndexFragmentBinding) {
            return ((IIndexFragmentBinding)binding).hasDeclaration() || this.fAcceptImplicit && this.isImplicit(binding);
        }
        return this.fAcceptImplicit || !this.isImplicit(binding);
    }

    private boolean isImplicit(IBinding binding) {
        if (binding instanceof ICPPMethod) {
            return ((ICPPMethod)binding).isImplicit();
        }
        return false;
    }
}

