/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.provider;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.provider.IIndexProvider;
import org.eclipse.cdt.core.index.provider.IReadOnlyPDOMProvider;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.provider.IIndexFragmentProvider;
import org.eclipse.cdt.internal.core.index.provider.Messages;
import org.eclipse.cdt.internal.core.index.provider.ReadOnlyPDOMProviderBridge;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public final class IndexProviderManager
implements IElementChangedListener {
    private static final String ELEMENT_RO_PDOMPROVIDER = "ReadOnlyPDOMProvider";
    private static final String ATTRIBUTE_CLASS = "class";
    private IIndexFragmentProvider[] allProviders;
    private Map provisionMap;
    private Set compatibleFragmentUnavailable;
    private VersionRange pdomVersionRange;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.index.provider.IndexProviderManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public IndexProviderManager() {
        this.reset();
    }

    public void reset() {
        this.reset(new VersionRange("[36,39]"));
    }

    public void reset(VersionRange pdomVersionRange) {
        this.allProviders = new IIndexFragmentProvider[0];
        this.provisionMap = new HashMap();
        this.pdomVersionRange = pdomVersionRange;
        this.compatibleFragmentUnavailable = new HashSet();
    }

    public void startup() {
        ArrayList<IIndexProvider> providers = new ArrayList<IIndexProvider>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint indexProviders = registry.getExtensionPoint("org.eclipse.cdt.core.CIndex");
        IExtension[] extensions = indexProviders.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            try {
                IConfigurationElement[] ce = extension.getConfigurationElements();
                int j = 0;
                while (j < ce.length) {
                    if (ce[j].getName().equals(ELEMENT_RO_PDOMPROVIDER)) {
                        IIndexProvider provider = (IIndexProvider)ce[j].createExecutableExtension(ATTRIBUTE_CLASS);
                        if (provider instanceof IReadOnlyPDOMProvider) {
                            provider = new ReadOnlyPDOMProviderBridge((IReadOnlyPDOMProvider)provider);
                            providers.add(provider);
                        } else {
                            CCorePlugin.log(MessageFormat.format(Messages.IndexProviderManager_0, extension.getContributor().getName()));
                        }
                    }
                    ++j;
                }
            }
            catch (CoreException ce) {
                CCorePlugin.log(ce);
            }
            ++i;
        }
        CoreModel.getDefault().addElementChangedListener(this);
        this.allProviders = providers.toArray(new IIndexFragmentProvider[providers.size()]);
    }

    public IIndexFragment[] getProvidedIndexFragments(ICConfigurationDescription config) throws CoreException {
        HashMap id2fragment = new HashMap();
        if (config != null) {
            int i = 0;
            while (i < this.allProviders.length) {
                block10: {
                    IProject project = config.getProjectDescription().getProject();
                    try {
                        if (!this.providesForProject(this.allProviders[i], project)) break block10;
                        IIndexFragment[] fragments = this.allProviders[i].getIndexFragments(config);
                        int j = 0;
                        while (j < fragments.length) {
                            try {
                                this.processCandidate(id2fragment, fragments[j]);
                            }
                            catch (InterruptedException ie) {
                                CCorePlugin.log(ie);
                            }
                            catch (CoreException ce) {
                                CCorePlugin.log(ce);
                            }
                            ++j;
                        }
                    }
                    catch (CoreException ce) {
                        CCorePlugin.log(ce);
                    }
                }
                ++i;
            }
        }
        ArrayList preresult = new ArrayList();
        Iterator i = id2fragment.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (entry.getValue() == null) {
                String key = (String)entry.getKey();
                if (this.compatibleFragmentUnavailable.contains(key)) continue;
                String msg = MessageFormat.format(Messages.IndexProviderManager_NoCompatibleFragmentsAvailable, key);
                Status status = new Status(2, "org.eclipse.cdt.core", 2, msg, null);
                CCorePlugin.log((IStatus)status);
                this.compatibleFragmentUnavailable.add(key);
                continue;
            }
            preresult.add(entry.getValue());
        }
        return preresult.toArray(new IIndexFragment[preresult.size()]);
    }

    private VersionRange getCurrentlySupportedVersionRangeForFormat(String formatID) {
        if (!"org.eclipse.cdt.internal.core.pdom.PDOM".equals(formatID)) {
            throw new IllegalArgumentException("Non-PDOM formats are currently unsupported");
        }
        return this.pdomVersionRange;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processCandidate(Map id2fragment, IIndexFragment candidate) throws InterruptedException, CoreException {
        String cformatID;
        String csver;
        String cid;
        block8: {
            cid = null;
            csver = null;
            cformatID = null;
            try {
                candidate.acquireReadLock();
                cid = candidate.getProperty("org.eclipse.cdt.internal.core.index.fragment.id");
                csver = candidate.getProperty("org.eclipse.cdt.internal.core.index.fragment.format.version");
                cformatID = candidate.getProperty("org.eclipse.cdt.internal.core.index.fragment.format.id");
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                candidate.releaseReadLock();
                throw throwable;
            }
            {
                Object var6_9 = null;
                candidate.releaseReadLock();
                if ($assertionsDisabled) break block8;
                if (cid == null) throw new AssertionError();
                if (csver == null) throw new AssertionError();
                if (cformatID != null) break block8;
            }
            throw new AssertionError();
        }
        Version cver = Version.parseVersion((String)csver);
        IIndexFragment existing = (IIndexFragment)id2fragment.get(cid);
        if (!this.getCurrentlySupportedVersionRangeForFormat(cformatID).isIncluded(cver)) {
            if (existing != null) return;
            id2fragment.put(cid, null);
            return;
        }
        if (existing == null) {
            id2fragment.put(cid, candidate);
            return;
        }
        String esver = null;
        String eformatID = null;
        try {
            existing.acquireReadLock();
            esver = existing.getProperty("org.eclipse.cdt.internal.core.index.fragment.format.version");
            eformatID = existing.getProperty("org.eclipse.cdt.internal.core.index.fragment.format.id");
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            existing.releaseReadLock();
            throw throwable;
        }
        {
            Object var10_14 = null;
            existing.releaseReadLock();
            if (!eformatID.equals(cformatID)) return;
        }
        Version ever = Version.parseVersion((String)esver);
        if (ever.compareTo((Object)cver) >= 0) return;
        id2fragment.put(cid, candidate);
    }

    public void addIndexProvider(IIndexProvider provider) {
        if (!(provider instanceof IIndexFragmentProvider)) {
            CCorePlugin.log("An unknown index provider implementation was plugged in to the CIndex extension point");
            return;
        }
        IIndexFragmentProvider[] newAllProviders = new IIndexFragmentProvider[this.allProviders.length + 1];
        System.arraycopy(this.allProviders, 0, newAllProviders, 0, this.allProviders.length);
        newAllProviders[this.allProviders.length] = (IIndexFragmentProvider)provider;
        this.allProviders = newAllProviders;
    }

    public void removeIndexProvider(IIndexProvider provider) {
        ArrayUtil.remove(this.allProviders, provider);
        if (this.allProviders[this.allProviders.length - 1] == null) {
            IIndexFragmentProvider[] newAllProviders = new IIndexFragmentProvider[this.allProviders.length - 1];
            System.arraycopy(this.allProviders, 0, newAllProviders, 0, this.allProviders.length - 1);
            this.allProviders = newAllProviders;
        }
    }

    private boolean providesForProject(IIndexProvider provider, IProject project) {
        ArrayList<IIndexProvider> key = new ArrayList<IIndexProvider>();
        key.add(provider);
        key.add((IIndexProvider)project);
        if (!this.provisionMap.containsKey(key)) {
            try {
                ICProject cproject = CoreModel.getDefault().create(project);
                this.provisionMap.put(key, new Boolean(provider.providesFor(cproject)));
            }
            catch (CoreException ce) {
                CCorePlugin.log(ce);
                this.provisionMap.put(key, Boolean.FALSE);
            }
        }
        return (Boolean)this.provisionMap.get(key);
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            if (event.getType() == 1) {
                this.processDelta(event.getDelta());
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    private void processDelta(ICElementDelta delta) throws CoreException {
        int type = delta.getElement().getElementType();
        switch (type) {
            case 10: {
                ICElementDelta[] children = delta.getAffectedChildren();
                int i = 0;
                while (i < children.length) {
                    this.processDelta(children[i]);
                    ++i;
                }
                break;
            }
            case 11: {
                ICProject cproject = (ICProject)delta.getElement();
                switch (delta.getKind()) {
                    case 2: {
                        ArrayList<List> toRemove = new ArrayList<List>();
                        Iterator<Object> i = this.provisionMap.keySet().iterator();
                        while (i.hasNext()) {
                            List key = (List)i.next();
                            if (!key.contains(cproject.getProject())) continue;
                            toRemove.add(key);
                        }
                        i = toRemove.iterator();
                        while (i.hasNext()) {
                            this.provisionMap.remove(i.next());
                        }
                        break block0;
                    }
                }
            }
        }
    }
}

