/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.net.URI;
import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionStyleMacroParameter;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorFunctionStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.parser.IMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.FunctionStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectStyleMacro;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroParameter;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.runtime.CoreException;

public class PDOMMacro
implements IIndexMacro,
IASTFileLocation {
    private final PDOM pdom;
    private final int record;
    private IMacro macro;
    private static final byte MACROSTYLE_UNKNOWN = 0;
    private static final byte MACROSTYLE_OBJECT = 1;
    private static final byte MACROSTYLE_FUNCTION = 2;
    private static final int NAME = 0;
    private static final int FILE = 4;
    private static final int NAME_OFFSET = 8;
    private static final int NAME_LENGTH = 12;
    private static final int FIRST_PARAMETER = 14;
    private static final int EXPANSION = 18;
    private static final int NEXT_MACRO = 22;
    private static final int MACRO_STYLE = 26;
    private static final int RECORD_SIZE = 27;

    public PDOMMacro(PDOM pdom, int record) {
        this.pdom = pdom;
        this.record = record;
    }

    public PDOMMacro(PDOM pdom, IASTPreprocessorMacroDefinition macro, PDOMFile file) throws CoreException {
        this.pdom = pdom;
        Database db = pdom.getDB();
        this.record = db.malloc(27);
        IASTName name = macro.getName();
        db.putInt(this.record + 0, db.newString(name.toCharArray()).getRecord());
        db.putInt(this.record + 4, file.getRecord());
        IASTFileLocation fileloc = name.getFileLocation();
        db.putInt(this.record + 8, fileloc.getNodeOffset());
        db.putShort(this.record + 12, (short)fileloc.getNodeLength());
        db.putInt(this.record + 18, db.newString(macro.getExpansion()).getRecord());
        this.setNextMacro(0);
        byte macroStyle = 1;
        PDOMMacroParameter last = null;
        if (macro instanceof IASTPreprocessorFunctionStyleMacroDefinition) {
            macroStyle = 2;
            IASTPreprocessorFunctionStyleMacroDefinition func = (IASTPreprocessorFunctionStyleMacroDefinition)macro;
            IASTFunctionStyleMacroParameter[] params = func.getParameters();
            int i = params.length - 1;
            while (i >= 0) {
                IASTFunctionStyleMacroParameter param = params[i];
                PDOMMacroParameter pdomParam = new PDOMMacroParameter(pdom, param.getParameter());
                if (last != null) {
                    pdomParam.setNextParameter(last);
                }
                last = pdomParam;
                --i;
            }
        }
        db.putInt(this.record + 14, last != null ? last.getRecord() : 0);
        db.putByte(this.record + 26, macroStyle);
    }

    public int getRecord() {
        return this.record;
    }

    public void delete() throws CoreException {
        PDOMMacro.getNameInDB(this.pdom, this.record).delete();
        this.getExpansionInDB().delete();
        PDOMMacroParameter param = this.getFirstParameter();
        if (param != null) {
            param.delete();
        }
        this.pdom.getDB().free(this.record);
    }

    public static IString getNameInDB(PDOM pdom, int record) throws CoreException {
        Database db = pdom.getDB();
        int rec = db.getInt(record + 0);
        return db.getString(rec);
    }

    private IString getExpansionInDB() throws CoreException {
        Database db = this.pdom.getDB();
        int rec = db.getInt(this.record + 18);
        return db.getString(rec);
    }

    public PDOMMacro getNextMacro() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 22);
        return rec != 0 ? new PDOMMacro(this.pdom, rec) : null;
    }

    public void setNextMacro(PDOMMacro macro) throws CoreException {
        this.setNextMacro(macro != null ? macro.getRecord() : 0);
    }

    private void setNextMacro(int rec) throws CoreException {
        this.pdom.getDB().putInt(this.record + 22, rec);
    }

    private PDOMMacroParameter getFirstParameter() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 14);
        return rec != 0 ? new PDOMMacroParameter(this.pdom, rec) : null;
    }

    private char[] getMacroExpansion() {
        try {
            return this.getExpansionInDB().getChars();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new char[]{' '};
        }
    }

    public IMacro getMacro() throws CoreException {
        this.rebuildMacro();
        return this.macro;
    }

    private void rebuildMacro() throws CoreException {
        char[] name = PDOMMacro.getNameInDB(this.pdom, this.record).getChars();
        PDOMMacroParameter param = this.getFirstParameter();
        int style = this.pdom.getDB().getByte(this.record + 26);
        if (style == 0) {
            style = param != null ? 2 : 1;
        }
        switch (style) {
            case 1: {
                this.macro = new ObjectStylePDOMMacro(name);
                break;
            }
            case 2: {
                ArrayList<char[]> paramList = new ArrayList<char[]>();
                while (param != null) {
                    paramList.add(param.getName().getChars());
                    param = param.getNextParameter();
                }
                char[][] params = (char[][])paramList.toArray((T[])new char[paramList.size()][]);
                this.macro = new FunctionStylePDOMMacro(name, params);
                break;
            }
            default: {
                throw new PDOMNotImplementedError();
            }
        }
    }

    public char[] getSignature() {
        try {
            this.rebuildMacro();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new char[]{' '};
        }
        return this.macro.getSignature();
    }

    public char[] getExpansion() {
        try {
            this.rebuildMacro();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new char[]{' '};
        }
        return this.macro.getExpansion();
    }

    public char[] getName() {
        try {
            return PDOMMacro.getNameInDB(this.pdom, this.record).getChars();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new char[]{' '};
        }
    }

    public IIndexFile getFile() throws CoreException {
        int filerec = this.pdom.getDB().getInt(this.record + 4);
        return filerec != 0 ? new PDOMFile(this.pdom, filerec) : null;
    }

    public int getEndingLineNumber() {
        return 0;
    }

    public String getFileName() {
        try {
            URI uri;
            PDOMFile file = (PDOMFile)this.getFile();
            if (file != null && "file".equals((uri = file.getLocation().getURI()).getScheme())) {
                return uri.getSchemeSpecificPart();
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    public int getStartingLineNumber() {
        return 0;
    }

    public IASTFileLocation asFileLocation() {
        return this;
    }

    public IASTFileLocation getFileLocation() {
        return this;
    }

    public int getNodeLength() {
        try {
            return this.pdom.getDB().getShort(this.record + 12);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    public int getNodeOffset() {
        try {
            return this.pdom.getDB().getInt(this.record + 8);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    private class FunctionStylePDOMMacro
    extends FunctionStyleMacro
    implements IIndexMacro {
        public FunctionStylePDOMMacro(char[] name, char[][] arglist) {
            super(name, null, arglist);
        }

        public char[] getExpansion() {
            return PDOMMacro.this.getMacroExpansion();
        }

        public IASTFileLocation getFileLocation() {
            return PDOMMacro.this;
        }

        public IIndexFile getFile() throws CoreException {
            return PDOMMacro.this.getFile();
        }

        public int getNodeOffset() {
            return PDOMMacro.this.getNodeOffset();
        }

        public int getNodeLength() {
            return PDOMMacro.this.getNodeLength();
        }
    }

    private class ObjectStylePDOMMacro
    extends ObjectStyleMacro
    implements IIndexMacro {
        public ObjectStylePDOMMacro(char[] name) {
            super(name, null);
        }

        public char[] getExpansion() {
            return PDOMMacro.this.getMacroExpansion();
        }

        public IASTFileLocation getFileLocation() {
            return PDOMMacro.this;
        }

        public IIndexFile getFile() throws CoreException {
            return PDOMMacro.this.getFile();
        }

        public int getNodeOffset() {
            return PDOMMacro.this.getNodeOffset();
        }

        public int getNodeLength() {
            return PDOMMacro.this.getNodeLength();
        }
    }
}

