/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPBasicType
extends PDOMNode
implements ICPPBasicType,
IIndexType {
    public static final int TYPE_ID = 8;
    public static final int FLAGS = 10;
    public static final int RECORD_SIZE = 12;

    public PDOMCPPBasicType(PDOM pdom, int record) {
        super(pdom, record);
    }

    public PDOMCPPBasicType(PDOM pdom, PDOMNode parent, ICPPBasicType type) throws CoreException {
        super(pdom, parent);
        Database db = pdom.getDB();
        try {
            db.putChar(this.record + 8, (char)type.getType());
            char flags = '\u0000';
            if (type.isLong()) {
                flags = (char)(flags | 1);
            }
            if (type.isShort()) {
                flags = (char)(flags | 2);
            }
            if (type.isSigned()) {
                flags = (char)(flags | 4);
            }
            if (type.isUnsigned()) {
                flags = (char)(flags | 8);
            }
            db.putChar(this.record + 10, flags);
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    protected int getRecordSize() {
        return 12;
    }

    public int getNodeType() {
        return 12;
    }

    public int getType() {
        try {
            return this.pdom.getDB().getChar(this.record + 8);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    public IASTExpression getValue() throws DOMException {
        return null;
    }

    private char getFlags() throws CoreException {
        return this.pdom.getDB().getChar(this.record + 10);
    }

    public boolean isLong() throws DOMException {
        try {
            return (this.getFlags() & '\u0001') != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public boolean isShort() throws DOMException {
        try {
            return (this.getFlags() & 2) != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public boolean isSigned() throws DOMException {
        try {
            return (this.getFlags() & 4) != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public boolean isUnsigned() throws DOMException {
        try {
            return (this.getFlags() & 8) != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public boolean isSameType(IType rhs) {
        int type;
        ICPPBasicType rhs1;
        block6: {
            if (rhs instanceof ITypedef) {
                return rhs.isSameType(this);
            }
            if (!(rhs instanceof ICPPBasicType)) {
                return false;
            }
            rhs1 = (ICPPBasicType)rhs;
            try {
                type = this.getType();
                if (type != -1 && type == rhs1.getType()) break block6;
                return false;
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        if (type == 3) {
            return (this.getQualifierBits() & 0xFFFFFFFB) == (rhs1.getQualifierBits() & 0xFFFFFFFB);
        }
        return this.getQualifierBits() == rhs1.getQualifierBits();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int getQualifierBits() {
        try {
            return this.getFlags();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }
}

