/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDelegateCreator;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPParameter
extends PDOMNamedNode
implements ICPPParameter,
IIndexFragmentBinding,
ICPPDelegateCreator {
    private static final int NEXT_PARAM = 12;
    private static final int TYPE = 16;
    private static final int FLAGS = 20;
    protected static final int RECORD_SIZE = 21;
    private static final byte FLAG_DEFAULT_VALUE = 1;

    public PDOMCPPParameter(PDOM pdom, int record) {
        super(pdom, record);
    }

    public PDOMCPPParameter(PDOM pdom, PDOMNode parent, IParameter param, IType type) throws CoreException {
        super(pdom, parent, param.getNameCharArray());
        Database db = pdom.getDB();
        db.putInt(this.record + 12, 0);
        byte flags = this.encodeFlags(param);
        db.putByte(this.record + 20, flags);
        try {
            if (type == null) {
                type = param.getType();
            }
            if (type != null) {
                PDOMNode typeNode = this.getLinkageImpl().addType(this, type);
                db.putInt(this.record + 16, typeNode != null ? typeNode.getRecord() : 0);
            }
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    public PDOMCPPParameter(PDOM pdom, PDOMNode parent, IParameter param, int typeRecord) throws CoreException {
        super(pdom, parent, param.getNameCharArray());
        Database db = pdom.getDB();
        db.putInt(this.record + 12, 0);
        byte flags = this.encodeFlags(param);
        db.putByte(this.record + 20, flags);
        db.putInt(this.record + 16, typeRecord);
    }

    private byte encodeFlags(IParameter param) {
        byte flags = 0;
        if (param instanceof ICPPParameter && ((ICPPParameter)param).hasDefaultValue()) {
            flags = (byte)(flags | 1);
        }
        return flags;
    }

    protected int getRecordSize() {
        return 21;
    }

    public int getNodeType() {
        return 13;
    }

    public void setNextParameter(PDOMCPPParameter nextParam) throws CoreException {
        int rec = nextParam != null ? nextParam.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 12, rec);
    }

    public PDOMCPPParameter getNextParameter() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 12);
        return rec != 0 ? new PDOMCPPParameter(this.pdom, rec) : null;
    }

    public String[] getQualifiedName() {
        throw new PDOMNotImplementedError();
    }

    public char[][] getQualifiedNameCharArray() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isGloballyQualified() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isMutable() throws DOMException {
        return false;
    }

    public IType getType() {
        try {
            PDOMNode node = this.getLinkageImpl().getNode(this.pdom.getDB().getInt(this.record + 16));
            return node instanceof IType ? (IType)((Object)node) : null;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public boolean isAuto() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isExtern() throws DOMException {
        return false;
    }

    public boolean isRegister() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isStatic() throws DOMException {
        return false;
    }

    public String getName() {
        return new String(this.getNameCharArray());
    }

    public IScope getScope() throws DOMException {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public char[] getNameCharArray() {
        try {
            return super.getNameCharArray();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new char[0];
        }
    }

    public boolean hasDefaultValue() {
        return this.hasFlag((byte)1, false);
    }

    private boolean hasFlag(byte flag, boolean defValue) {
        try {
            byte myflags = this.pdom.getDB().getByte(this.record + 20);
            return (myflags & flag) == flag;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return defValue;
        }
    }

    public IIndexFragment getFragment() {
        return this.pdom;
    }

    public boolean hasDefinition() throws CoreException {
        return true;
    }

    public boolean hasDeclaration() throws CoreException {
        return true;
    }

    public int compareTo(Object arg0) {
        throw new PDOMNotImplementedError();
    }

    public boolean isFileLocal() throws CoreException {
        return true;
    }

    public int getBindingConstant() {
        return this.getNodeType();
    }

    public ICPPDelegate createDelegate(IASTName name) {
        return new CPPParameter.CPPParameterDelegate(name, this);
    }

    public void delete(PDOMLinkage linkage) throws CoreException {
        linkage.deleteType(this.getType(), this.record);
        PDOMCPPParameter next = this.getNextParameter();
        if (next != null) {
            next.delete(linkage);
        }
        super.delete(linkage);
    }
}

