/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.internal.core.pdom.ITodoTaskUpdater;
import org.eclipse.cdt.internal.core.pdom.indexer.Messages;
import org.eclipse.cdt.internal.core.pdom.indexer.TodoTaskParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class TodoTaskUpdater
implements ITodoTaskUpdater {
    private static final String SOURCE_ID = "CDT";
    private static final String[] TASK_MARKER_ATTRIBUTE_NAMES = new String[]{"message", "priority", "charStart", "charEnd", "lineNumber", "userEditable", "sourceId"};
    private final TodoTaskParser taskParser;

    public TodoTaskUpdater() {
        String value = CCorePlugin.getOption("org.eclipse.cdt.core.taskTags");
        if (value == null) {
            value = "TODO";
        }
        String[] tags = this.split(value, ",");
        char[][] taskTags = new char[tags.length][];
        int i = 0;
        while (i < tags.length) {
            taskTags[i] = tags[i].toCharArray();
            ++i;
        }
        value = CCorePlugin.getOption("org.eclipse.cdt.core.taskPriorities");
        if (value == null) {
            value = "normal";
        }
        String[] priorities = this.split(value, ",");
        int[] taskPriorities = new int[taskTags.length];
        int i2 = 0;
        while (i2 < taskPriorities.length) {
            String priority;
            String string = priority = i2 < priorities.length ? priorities[i2] : "normal";
            taskPriorities[i2] = "high".equals(priority) ? 2 : ("low".equals(priority) ? 0 : 1);
            ++i2;
        }
        value = CCorePlugin.getOption("org.eclipse.cdt.core.taskCaseSensitive");
        if (value == null) {
            value = "false";
        }
        boolean isTaskCaseSensitive = Boolean.valueOf(value);
        this.taskParser = new TodoTaskParser(taskTags, taskPriorities, isTaskCaseSensitive);
    }

    public void updateTasks(IASTComment[] comments, IIndexFileLocation[] filesToUpdate) {
        IFile file;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        HashMap<IPath, IFile> locationToFile = new HashMap<IPath, IFile>();
        int i = 0;
        while (i < filesToUpdate.length) {
            IIndexFileLocation indexFileLocation = filesToUpdate[i];
            String filepath = indexFileLocation.getFullPath();
            if (filepath != null && (file = workspaceRoot.getFile((IPath)new Path(filepath))).exists()) {
                locationToFile.put(IndexLocationFactory.getAbsolutePath(indexFileLocation), file);
                TodoTaskUpdater.removeTasksFor((IResource)file);
            }
            ++i;
        }
        if (comments.length == 0) {
            return;
        }
        TodoTaskParser.Task[] tasks = this.taskParser.parse(comments);
        int i2 = 0;
        while (i2 < tasks.length) {
            TodoTaskParser.Task task = tasks[i2];
            file = (IFile)locationToFile.get(new Path(task.getFileLocation()));
            if (file != null) {
                try {
                    this.applyTask(task, (IResource)file);
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            }
            ++i2;
        }
    }

    private void applyTask(TodoTaskParser.Task task, IResource resource) throws CoreException {
        IMarker marker = resource.createMarker("org.eclipse.cdt.core.task");
        String description = NLS.bind((String)Messages.TodoTaskUpdater_taskFormat, (Object)task.getTag(), (Object)task.getMessage());
        marker.setAttributes(TASK_MARKER_ATTRIBUTE_NAMES, new Object[]{description, new Integer(task.getPriority()), new Integer(task.getStart()), new Integer(task.getEnd()), new Integer(task.getLineNumber()), Boolean.FALSE, SOURCE_ID});
    }

    public static void removeTasksFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.eclipse.cdt.core.task", false, 2);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    private String[] split(String value, String delimiters) {
        StringTokenizer tokenizer = new StringTokenizer(value, delimiters);
        int size = tokenizer.countTokens();
        String[] tokens = new String[size];
        int i = 0;
        while (i < size) {
            tokens[i] = tokenizer.nextToken();
            ++i;
        }
        return tokens;
    }
}

