/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer.fast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexManager;
import org.eclipse.cdt.internal.core.index.IndexBasedCodeReaderFactory;
import org.eclipse.cdt.internal.core.pdom.indexer.PDOMIndexerTask;
import org.eclipse.cdt.internal.core.pdom.indexer.fast.PDOMFastIndexer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

class PDOMFastIndexerTask
extends PDOMIndexerTask
implements IndexBasedCodeReaderFactory.CallbackHandler {
    private List fChanged = new LinkedList();
    private List fRemoved = new ArrayList();
    private IWritableIndex fIndex;
    private IndexBasedCodeReaderFactory fCodeReaderFactory;
    private Map fIflCache;
    private int fCurrentConfigHash = 0;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.pdom.indexer.fast.PDOMFastIndexerTask");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public PDOMFastIndexerTask(PDOMFastIndexer indexer, ITranslationUnit[] added, ITranslationUnit[] changed, ITranslationUnit[] removed) {
        super(indexer);
        this.fChanged.addAll(Arrays.asList(added));
        this.fChanged.addAll(Arrays.asList(changed));
        this.fRemoved.addAll(Arrays.asList(removed));
        this.updateInfo(0, 0, this.fChanged.size() + this.fRemoved.size());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        try {
            block13: {
                boolean filterFiles = !this.getIndexAllFiles() && this.getAllFilesProvided();
                ArrayList<ITranslationUnit> headers = new ArrayList<ITranslationUnit>();
                List sources = this.fChanged;
                Iterator iter = this.fChanged.iterator();
                block6: while (true) {
                    ITranslationUnit tu;
                    block15: {
                        if (iter.hasNext()) break block15;
                        this.setupIndexAndReaderFactory();
                        this.fIndex.acquireReadLock();
                        try {
                            this.registerTUsInReaderFactory(sources);
                            this.registerTUsInReaderFactory(headers);
                            Iterator i = this.fRemoved.iterator();
                            while (true) {
                                block18: {
                                    block17: {
                                        block16: {
                                            if (i.hasNext()) break block16;
                                            this.parseTUs(this.fIndex, 1, sources, headers, monitor);
                                            if (!monitor.isCanceled()) break block13;
                                            break block17;
                                        }
                                        if (!monitor.isCanceled()) break block18;
                                    }
                                    Object var9_9 = null;
                                    break block6;
                                }
                                tu = (ITranslationUnit)i.next();
                                this.removeTU(this.fIndex, tu, 1);
                                if (tu.isSourceUnit()) {
                                    this.updateInfo(1, 0, 0);
                                    continue;
                                }
                                this.updateInfo(0, 1, -1);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_10 = null;
                            this.fIndex.releaseReadLock();
                            throw throwable;
                        }
                    }
                    tu = (ITranslationUnit)iter.next();
                    if (tu.isSourceUnit()) {
                        if (!filterFiles || !CoreModel.isScannerInformationEmpty(tu.getResource())) continue;
                        iter.remove();
                        this.updateInfo(0, 0, -1);
                        continue;
                    }
                    headers.add(tu);
                    iter.remove();
                }
                this.fIndex.releaseReadLock();
                return;
            }
            Object var9_11 = null;
            this.fIndex.releaseReadLock();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
        this.traceEnd(start, this.fIndex);
    }

    private void setupIndexAndReaderFactory() throws CoreException {
        this.fIndex = ((IWritableIndexManager)CCorePlugin.getIndexManager()).getWritableIndex(this.getProject());
        this.fIndex.resetCacheCounters();
        this.fIflCache = new HashMap();
        this.fCodeReaderFactory = new IndexBasedCodeReaderFactory(this.getCProject(), (IIndex)this.fIndex, this.fIflCache);
        this.fCodeReaderFactory.setCallbackHandler(this);
    }

    private void registerTUsInReaderFactory(Collection tus) throws CoreException {
        int removed = 0;
        Iterator iter = tus.iterator();
        while (iter.hasNext()) {
            ITranslationUnit tu = (ITranslationUnit)iter.next();
            IIndexFileLocation ifl = IndexLocationFactory.getIFL(tu);
            IndexBasedCodeReaderFactory.IndexFileInfo info = this.fCodeReaderFactory.createFileInfo(ifl);
            if (this.updateAll()) {
                info.fRequested = 2;
                continue;
            }
            if (this.updateChangedTimestamps() && this.isOutdated(tu, info.fFile)) {
                info.fRequested = 2;
                continue;
            }
            if (this.updateChangedConfiguration()) {
                info.fRequested = 1;
                continue;
            }
            iter.remove();
            ++removed;
        }
        this.updateInfo(0, 0, -removed);
    }

    protected IIndexFileLocation findLocation(String absolutePath) {
        IIndexFileLocation result = (IIndexFileLocation)this.fIflCache.get(absolutePath);
        if (result == null) {
            result = IndexLocationFactory.getIFLExpensive(this.getCProject(), absolutePath);
            this.fIflCache.put(absolutePath, result);
        }
        return result;
    }

    protected IASTTranslationUnit createAST(AbstractLanguage lang, CodeReader codeReader, IScannerInfo scanInfo, int options, IProgressMonitor pm) throws CoreException {
        IASTTranslationUnit ast = lang.getASTTranslationUnit(codeReader, scanInfo, this.fCodeReaderFactory, this.fIndex, options, ParserUtil.getParserLogService());
        if (pm.isCanceled()) {
            return null;
        }
        this.fCodeReaderFactory.clearMacroAttachements();
        return ast;
    }

    protected boolean needToUpdate(IIndexFileLocation location, int confighash) throws CoreException {
        if (super.needToUpdate(location, confighash)) {
            IndexBasedCodeReaderFactory.IndexFileInfo info = this.fCodeReaderFactory.createFileInfo(location);
            return this.needToUpdate(info, confighash);
        }
        return false;
    }

    public boolean needToUpdate(IndexBasedCodeReaderFactory.IndexFileInfo info) throws CoreException {
        return this.needToUpdate(info, this.fCurrentConfigHash);
    }

    private boolean needToUpdate(IndexBasedCodeReaderFactory.IndexFileInfo info, int confighash) throws CoreException {
        if (info.fFile == null) {
            return true;
        }
        if (confighash != 0 && info.fRequested == 1) {
            int oldhash = info.fFile.getScannerConfigurationHashcode();
            if (oldhash == 0 || oldhash == confighash) {
                info.fRequested = 0;
                this.updateInfo(0, 0, -1);
            } else {
                info.fRequested = 2;
            }
        }
        return info.fRequested != 0;
    }

    protected boolean postAddToIndex(IIndexFileLocation path, IIndexFile file) throws CoreException {
        IndexBasedCodeReaderFactory.IndexFileInfo info = this.fCodeReaderFactory.createFileInfo(path);
        info.fFile = file;
        if (!$assertionsDisabled && info.hasCachedMacros()) {
            throw new AssertionError();
        }
        if (info.fRequested != 0) {
            info.fRequested = 0;
            return true;
        }
        return false;
    }
}

