/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.CExternalSetting;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICDescriptionDelta;
import org.eclipse.cdt.core.settings.model.ICFileDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionWorkspacePreferences;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICSettingObject;
import org.eclipse.cdt.core.settings.model.ICSettingsStorage;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.ICTargetPlatformSetting;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationDataProvider;
import org.eclipse.cdt.core.settings.model.extension.CFileData;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.core.settings.model.extension.ICProjectConverter;
import org.eclipse.cdt.core.settings.model.extension.impl.CDataFacroty;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.CSettingEntryFactory;
import org.eclipse.cdt.core.settings.model.util.KindBasedStore;
import org.eclipse.cdt.core.settings.model.util.ListComparator;
import org.eclipse.cdt.core.settings.model.util.PathSettingsContainer;
import org.eclipse.cdt.core.settings.model.util.PatternNameMap;
import org.eclipse.cdt.internal.core.CConfigBasedDescriptorManager;
import org.eclipse.cdt.internal.core.envvar.ContributedEnvironment;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.settings.model.CConfigExtensionReference;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDataProviderDescriptor;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescription;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescriptionCache;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationSpecSettings;
import org.eclipse.cdt.internal.core.settings.model.CDataProxy;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsManager;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettinsDeltaCalculator;
import org.eclipse.cdt.internal.core.settings.model.CProjectConverterDesciptor;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescription;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionDelta;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionWorkspacePreferences;
import org.eclipse.cdt.internal.core.settings.model.CStorage;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.ExtensionContainerFactory;
import org.eclipse.cdt.internal.core.settings.model.ICDataProxyContainer;
import org.eclipse.cdt.internal.core.settings.model.IInternalCCfgInfo;
import org.eclipse.cdt.internal.core.settings.model.InternalXmlStorageElement;
import org.eclipse.cdt.internal.core.settings.model.PathEntryConfigurationDataProvider;
import org.eclipse.cdt.internal.core.settings.model.ResourceChangeHandler;
import org.eclipse.cdt.internal.core.settings.model.ScannerInfoProviderProxy;
import org.eclipse.cdt.internal.core.settings.model.SetCProjectDescriptionOperation;
import org.eclipse.cdt.internal.core.settings.model.SettingsContext;
import org.eclipse.cdt.internal.core.settings.model.SettingsModelMessages;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public class CProjectDescriptionManager
implements ICProjectDescriptionManager {
    public static final int INTERNAL_GET_IGNORE_CLOSE = Integer.MIN_VALUE;
    private static final String OLD_PROJECT_DESCRIPTION = "cdtproject";
    private static final String OLD_CDTPROJECT_FILE_NAME = ".cdtproject";
    private static final String OLD_PROJECT_OWNER_ID = "id";
    private static final String CONVERTED_CFG_NAME = "convertedConfig";
    private static final String CONVERTED_CFG_ID_PREFIX = "converted.config";
    static final String STORAGE_FILE_NAME = ".cproject";
    private static final String ROOT_ELEMENT_NAME = "cproject";
    private static final String VERSION_ELEMENT_NAME = "fileVersion";
    public static final Version DESCRIPTION_VERSION = new Version("4.0");
    static final String MODULE_ID = "org.eclipse.cdt.core.settings";
    static final String CONFIGURATION = "cconfiguration";
    private static final ICLanguageSettingEntry[] EMPTY_LANGUAGE_SETTINGS_ENTRIES_ARRAY = new ICLanguageSettingEntry[0];
    private static final ICElementDelta[] EMPTY_CELEMENT_DELTA = new ICElementDelta[0];
    private static final ICLanguageSetting[] EMPTY_LANGUAGE_SETTINGS_ARRAY = new ICLanguageSetting[0];
    private static final String PREFERENCES_STORAGE = "preferences";
    private static final String PREFERENCE_BUILD_SYSTEM_ELEMENT = "buildSystem";
    private static final String PREFERENCES_ELEMENT = "preferences";
    private static final String ID = "id";
    private static final String PREFERENCE_CFG_ID_PREFIX = "preference.";
    private static final String PREFERENCE_CFG_NAME = SettingsModelMessages.getString("CProjectDescriptionManager.15");
    private static final String ROOT_PREFERENCE_ELEMENT = "preferences";
    private static final String DEFAULT_CFG_ID_PREFIX = "org.eclipse.cdt.core.default.config";
    private static final String DEFAULT_CFG_NAME = "Configuration";
    private static final QualifiedName SCANNER_INFO_PROVIDER_PROPERTY = new QualifiedName("org.eclipse.cdt.core", "scannerInfoProvider");
    private static final QualifiedName LOAD_FLAG = new QualifiedName("org.eclipse.cdt.core", "descriptionLoadded");
    private Map fProviderMap;
    private CProjectConverterDesciptor[] fConverters;
    private List fListeners = new ArrayList();
    private Map fPreferenceMap = new HashMap();
    private CConfigBasedDescriptorManager fDescriptorManager;
    private ThreadLocal fThreadInfo = new ThreadLocal();
    private Map fDescriptionMap = new HashMap();
    private ResourceChangeHandler fRcChangeHandler;
    private CProjectDescriptionWorkspacePreferences fPreferences;
    private boolean fAllowEmptyCreatingDescription = true;
    private ICDataProxyContainer fPrefUpdater = new ICDataProxyContainer(){

        public void updateChild(CDataProxy child, boolean write) {
            if (write) {
                try {
                    ((CConfigurationDescription)child).doWritable();
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            }
        }

        public ICSettingObject[] getChildSettings() {
            return CProjectDescriptionManager.this.fPreferenceMap.values().toArray(new CConfigurationDescriptionCache[CProjectDescriptionManager.this.fPreferenceMap.size()]);
        }
    };
    private static CProjectDescriptionManager fInstance;

    private CProjectDescriptionManager() {
    }

    public static CProjectDescriptionManager getInstance() {
        if (fInstance == null) {
            fInstance = CProjectDescriptionManager.getInstanceSynch();
        }
        return fInstance;
    }

    private static synchronized CProjectDescriptionManager getInstanceSynch() {
        if (fInstance == null) {
            fInstance = new CProjectDescriptionManager();
        }
        return fInstance;
    }

    public Job startup() {
        if (this.fRcChangeHandler == null) {
            this.fRcChangeHandler = new ResourceChangeHandler();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fRcChangeHandler, 7);
            if (this.fDescriptorManager == null) {
                this.fDescriptorManager = CConfigBasedDescriptorManager.getInstance();
                this.fDescriptorManager.startup();
            }
            CExternalSettingsManager.getInstance().startup();
        }
        return this.createPostStartupJob();
    }

    private Job createPostStartupJob() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Job rcJob = new Job(SettingsModelMessages.getString("CProjectDescriptionManager.0")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    CProjectDescriptionManager.this.startSaveParticipant();
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                    return e.getStatus();
                }
                return new Status(0, "org.eclipse.cdt.core", 0, new String(), null);
            }
        };
        rcJob.setRule((ISchedulingRule)root);
        rcJob.setPriority(10);
        rcJob.setSystem(true);
        return rcJob;
    }

    private void startSaveParticipant() throws CoreException {
        ISavedState lastState = ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)CCorePlugin.getDefault(), (ISaveParticipant)this.fRcChangeHandler);
        if (lastState != null) {
            lastState.processResourceChangeEvents((IResourceChangeListener)this.fRcChangeHandler);
        }
    }

    public void shutdown() {
        CExternalSettingsManager.getInstance().shutdown();
        if (this.fDescriptorManager != null) {
            this.fDescriptorManager.shutdown();
        }
        if (this.fRcChangeHandler != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fRcChangeHandler);
        }
    }

    private ICProjectDescription getDescriptionLoadding(IProject project) {
        Map map = this.getDescriptionLoaddingMap(false);
        if (map != null) {
            return (ICProjectDescription)map.get(project);
        }
        return null;
    }

    private void setDescriptionLoadding(IProject project, ICProjectDescription des) {
        if (des == null) {
            this.clearDescriptionLoadding(project);
        } else {
            Map map = this.getDescriptionLoaddingMap(true);
            map.put(project, des);
        }
    }

    private CProjectDescription clearDescriptionLoadding(IProject project) {
        Map map = this.getDescriptionLoaddingMap(false);
        if (map != null) {
            return (CProjectDescription)map.remove(project);
        }
        return null;
    }

    private Map getDescriptionLoaddingMap(boolean create) {
        ThreadInfo info = this.getThreadInfo(create);
        if (info != null) {
            return info.getDescriptionLoaddingMap(create);
        }
        return null;
    }

    private Map getDescriptionApplyingMap(boolean create) {
        ThreadInfo info = this.getThreadInfo(create);
        if (info != null) {
            return info.getDescriptionApplyingMap(create);
        }
        return null;
    }

    private Map getProjectFileSerializationMap(boolean create) {
        ThreadInfo info = this.getThreadInfo(create);
        if (info != null) {
            return info.getProjectFileSerializationMap(create);
        }
        return null;
    }

    private void aboutToSaveProjectFile(IProject project) {
        this.getProjectFileSerializationMap(true).put(project, Boolean.TRUE);
    }

    private void doneSaveProjectFile(IProject project) {
    }

    private boolean streamsMatch(InputStream stream1, InputStream stream2) throws IOException {
        int i1;
        do {
            int i2;
            if ((i1 = stream1.read()) == (i2 = stream2.read())) continue;
            return false;
        } while (i1 != -1);
        return true;
    }

    CProjectDescription checkExternalProjectFileModification(IResource rc) throws CoreException {
        Map map = this.getProjectFileSerializationMap(false);
        IProject project = rc.getProject();
        if (map != null && map.remove(project) != null) {
            return null;
        }
        CProjectDescription des = (CProjectDescription)this.getProjectDescription(project, 8);
        if (des == null || des.isLoadding()) {
            return null;
        }
        try {
            ByteArrayOutputStream oldOut;
            ByteArrayInputStream oldContents;
            InputStream newContents;
            ICStorageElement oldEl = des.doGetCachedRootStorageElement();
            if (oldEl != null && this.streamsMatch(newContents = this.getSharedProperty(project, STORAGE_FILE_NAME), oldContents = new ByteArrayInputStream((oldOut = this.write(oldEl)).toByteArray()))) {
                return null;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        catch (IOException e) {
            CCorePlugin.log(e);
        }
        des = (CProjectDescription)this.loadProjectDescription(project);
        des = this.createWritableDescription(des);
        des.touch();
        return des;
    }

    private ThreadInfo getThreadInfo(boolean create) {
        ThreadInfo info = (ThreadInfo)this.fThreadInfo.get();
        if (info == null && create) {
            info = new ThreadInfo();
            this.fThreadInfo.set(info);
        }
        return info;
    }

    public ICProjectDescription getProjectDescription(IProject project, boolean write) {
        return this.getProjectDescription(project, true, write);
    }

    public ICProjectDescription getProjectDescription(IProject project, boolean load, boolean write) {
        int flags;
        int n = flags = load ? 0 : 8;
        if (write) {
            flags |= 4;
        }
        return this.getProjectDescription(project, flags);
    }

    public ICProjectDescription getProjectDescription(IProject project, int flags) {
        ICProjectDescription des = null;
        boolean write = CProjectDescriptionManager.checkFlags(flags, 4);
        boolean load = !CProjectDescriptionManager.checkFlags(flags, 8);
        boolean ignoreClose = CProjectDescriptionManager.checkFlags(flags, Integer.MIN_VALUE);
        SettingsContext context = null;
        des = this.getDescriptionApplying(project);
        if (des == null) {
            des = this.getDescriptionLoadding(project);
        }
        if (des == null && (ignoreClose || project.isOpen())) {
            des = this.getLoaddedDescription(project);
        }
        if (des == null && load && project.isOpen()) {
            try {
                des = this.loadProjectDescription(project);
            }
            catch (CoreException coreException) {}
            if (des == null) {
                try {
                    context = new SettingsContext(project);
                    des = this.getConvertedDescription(project, context);
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            }
            if (des != null && this.setLoaddedDescriptionOnLoad(project, des)) {
                if (context != null) {
                    this.saveConversion(project, context, (CProjectDescription)des, (IProgressMonitor)new NullProgressMonitor());
                }
                CProjectDescriptionEvent event = this.createLoaddedEvent(des);
                this.notifyListeners(event);
                des = this.getLoaddedDescription(project);
            }
        }
        if (des != null && write) {
            des = this.createWritableDescription((CProjectDescription)des);
        }
        return des;
    }

    private CProjectDescription createWritableDescription(CProjectDescription cache) {
        ICStorageElement el = null;
        try {
            el = cache.getRootStorageElement();
            el = this.copyElement((InternalXmlStorageElement)el, false);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        CProjectDescription des = new CProjectDescription(cache, false, el, cache.isCdtProjectCreating());
        CProjectDescriptionEvent event = this.createCopyCreatedEvent(des, cache);
        this.notifyListeners(event);
        return des;
    }

    private synchronized boolean setLoaddedDescriptionOnLoad(IProject project, ICProjectDescription des) {
        des.setSessionProperty(LOAD_FLAG, Boolean.TRUE);
        ICProjectDescription oldDes = this.getLoaddedDescription(project);
        this.setLoaddedDescription(project, des, true);
        if (oldDes == null) {
            return true;
        }
        return oldDes.getSessionProperty(LOAD_FLAG) == null;
    }

    private CProjectDescriptionEvent createLoaddedEvent(ICProjectDescription des) {
        return new CProjectDescriptionEvent(1, null, des, null, null);
    }

    private CProjectDescriptionEvent createCopyCreatedEvent(ICProjectDescription newDes, ICProjectDescription oldDes) {
        return new CProjectDescriptionEvent(8, null, newDes, oldDes, null);
    }

    CProjectDescriptionEvent createAboutToApplyEvent(ICProjectDescription newDes, ICProjectDescription oldDes) {
        return new CProjectDescriptionEvent(2, null, newDes, oldDes, null);
    }

    CProjectDescriptionEvent createAppliedEvent(ICProjectDescription newDes, ICProjectDescription oldDes, ICProjectDescription appliedDes, ICDescriptionDelta delta) {
        return new CProjectDescriptionEvent(4, delta, newDes, oldDes, appliedDes);
    }

    CProjectDescriptionEvent createDataAppliedEvent(ICProjectDescription newDes, ICProjectDescription oldDes, ICProjectDescription appliedDes, ICDescriptionDelta delta) {
        return new CProjectDescriptionEvent(16, delta, newDes, oldDes, appliedDes);
    }

    private Object[] loadProjectDescriptionFromOldstyleStorage(IProject project) throws CoreException {
        ICStorageElement rootEl = this.readOldCDTProjectFile(project);
        if (rootEl != null) {
            String ownerId = rootEl.getAttribute("id");
            CProjectDescription des = (CProjectDescription)this.createProjectDescription(project, false);
            String id = CDataUtil.genId(CONVERTED_CFG_ID_PREFIX);
            des.createConvertedConfiguration(id, CONVERTED_CFG_NAME, rootEl);
            return new Object[]{ownerId, des};
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ICProjectDescription getConvertedDescription(IProject project, SettingsContext context) throws CoreException {
        Object[] info = this.loadProjectDescriptionFromOldstyleStorage(project);
        CProjectDescription des = null;
        try {
            CProjectDescription convertedDes;
            String ownerId;
            if (info != null) {
                ownerId = (String)info[0];
                des = (CProjectDescription)info[1];
                this.setDescriptionLoadding(project, des);
                des.setLoadding(true);
            } else {
                ownerId = null;
                des = null;
            }
            IProjectDescription eDes = context.getEclipseProjectDescription();
            ICProjectConverter converter = this.getConverter(project, ownerId, des);
            if (converter != null && (convertedDes = (CProjectDescription)converter.convertProject(project, eDes, ownerId, des)) != null) {
                this.checkHandleActiveCfgChange(convertedDes, null, eDes, (IProgressMonitor)new NullProgressMonitor());
                des = convertedDes;
            }
            if (des != null && des.isValid()) {
                InternalXmlStorageElement el = null;
                context.setEclipseProjectDescription(eDes);
                try {
                    el = this.copyElement((InternalXmlStorageElement)des.getRootStorageElement(), false);
                }
                catch (CoreException coreException) {}
                des = new CProjectDescription(des, true, el, des.isCdtProjectCreating());
                try {
                    this.setDescriptionApplying(project, des);
                    des.applyDatas(context);
                    des.doneApplying();
                    Object var9_11 = null;
                    this.clearDescriptionApplying(project);
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    this.clearDescriptionApplying(project);
                    throw throwable;
                }
            }
            Object var11_14 = null;
            CProjectDescription d = this.clearDescriptionLoadding(project);
            if (d != null) {
                d.setLoadding(false);
            }
            if (des == null) return des;
            des.setLoadding(false);
            return des;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            CProjectDescription d = this.clearDescriptionLoadding(project);
            if (d != null) {
                d.setLoadding(false);
            }
            if (des == null) throw throwable;
            des.setLoadding(false);
            throw throwable;
        }
    }

    private void saveConversion(IProject proj, SettingsContext context, CProjectDescription des, IProgressMonitor monitor) {
        try {
            context.addWorkspaceRunnable(this.createDesSerializationRunnable(des));
        }
        catch (CoreException e1) {
            CCorePlugin.log(e1);
        }
        IWorkspaceRunnable toRun = context.createOperationRunnable();
        if (toRun != null) {
            this.runWspModification(toRun, monitor);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Job runWspModification(final IWorkspaceRunnable runnable, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IWorkspace wsp = ResourcesPlugin.getWorkspace();
        boolean scheduleRule = true;
        if (!wsp.isTreeLocked()) {
            IJobManager mngr;
            IWorkspaceRoot rule;
            block10: {
                rule = wsp.getRoot();
                mngr = Job.getJobManager();
                try {
                    try {
                        mngr.beginRule((ISchedulingRule)rule, monitor);
                        scheduleRule = false;
                        this.runAtomic(runnable, monitor);
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                    catch (Exception exception) {}
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (!scheduleRule) {
                        monitor.done();
                    }
                    mngr.endRule((ISchedulingRule)rule);
                    throw throwable;
                }
                {
                    Object var8_10 = null;
                    if (scheduleRule) break block10;
                }
                monitor.done();
            }
            mngr.endRule((ISchedulingRule)rule);
        }
        if (scheduleRule) {
            Job job = new Job(SettingsModelMessages.getString("CProjectDescriptionManager.12")){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            CProjectDescriptionManager.this.runAtomic(runnable, monitor);
                        }
                        catch (CoreException e) {
                            CCorePlugin.log(e);
                            IStatus iStatus = e.getStatus();
                            Object var3_4 = null;
                            monitor.done();
                            return iStatus;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_5 = null;
                        monitor.done();
                        throw throwable;
                    }
                    {
                        Object var3_6 = null;
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)wsp.getRoot());
            job.setSystem(true);
            job.schedule();
            return job;
        }
        return null;
    }

    private void runAtomic(final IWorkspaceRunnable r, IProgressMonitor monitor) throws CoreException {
        IWorkspace wsp = ResourcesPlugin.getWorkspace();
        wsp.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    r.run(monitor);
                }
                catch (Exception e) {
                    CCorePlugin.log(e);
                }
            }
        }, (ISchedulingRule)wsp.getRoot(), 1, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateProjectDescriptions(IProject[] projects, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IWorkspace wsp = ResourcesPlugin.getWorkspace();
            if (projects == null) {
                projects = wsp.getRoot().getProjects();
            }
            final ICProjectDescription[] dess = new ICProjectDescription[projects.length];
            int num = 0;
            int i = 0;
            while (true) {
                block8: {
                    if (i < projects.length) break block8;
                    if (num != 0) {
                        final int[] fi = new int[]{num};
                        this.runWspModification(new IWorkspaceRunnable(){

                            /*
                             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public void run(IProgressMonitor monitor) throws CoreException {
                                monitor.beginTask(SettingsModelMessages.getString("CProjectDescriptionManager.13"), fi[0]);
                                int i = 0;
                                while (i < dess.length) {
                                    Object var6_6;
                                    ICProjectDescription des = dess[i];
                                    if (des == null) {
                                        return;
                                    }
                                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                                    try {
                                        try {
                                            CProjectDescriptionManager.this.setProjectDescription(des.getProject(), des, true, (IProgressMonitor)subMonitor);
                                        }
                                        catch (CoreException e) {
                                            CCorePlugin.log(e);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        var6_6 = null;
                                        subMonitor.done();
                                        throw throwable;
                                    }
                                    {
                                        var6_6 = null;
                                    }
                                    subMonitor.done();
                                    ++i;
                                }
                                return;
                            }
                        }, monitor);
                    }
                    break;
                }
                ICProjectDescription des = this.getProjectDescription(projects[i], false, true);
                if (des != null) {
                    dess[num++] = des;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        monitor.done();
    }

    private ICProjectConverter getConverter(IProject project, String oldOwnerId, ICProjectDescription des) {
        CProjectConverterDesciptor[] converterDess = this.getConverterDescriptors();
        ICProjectConverter converter = null;
        int i = 0;
        while (i < converterDess.length) {
            if (converterDess[i].canConvertProject(project, oldOwnerId, des)) {
                try {
                    converter = converterDess[i].getConverter();
                }
                catch (CoreException coreException) {}
                if (converter != null) break;
            }
            ++i;
        }
        return converter;
    }

    private CProjectConverterDesciptor[] getConverterDescriptors() {
        if (this.fConverters == null) {
            this.initConverterInfoSynch();
        }
        return this.fConverters;
    }

    private synchronized void initConverterInfoSynch() {
        if (this.fConverters != null) {
            return;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core.projectConverter");
        IExtension[] exts = extensionPoint.getExtensions();
        CProjectConverterDesciptor[] dess = new CProjectConverterDesciptor[exts.length];
        int i = 0;
        while (i < exts.length) {
            dess[i] = new CProjectConverterDesciptor(exts[i]);
            ++i;
        }
        this.fConverters = dess;
    }

    public ICProjectDescription createProjectDescription(IProject project, boolean loadIfExists) throws CoreException {
        return this.createProjectDescription(project, loadIfExists, false);
    }

    public ICProjectDescription createProjectDescription(IProject project, boolean loadIfExists, boolean creating) throws CoreException {
        ICProjectDescription des = this.getProjectDescription(project, loadIfExists, true);
        if (des == null || !loadIfExists) {
            if (creating && des != null) {
                creating = des.isCdtProjectCreating();
            }
            ICStorageElement element = this.createStorage(project, false, true, false);
            des = new CProjectDescription(project, element, false, creating);
        }
        return des;
    }

    public synchronized ICProjectDescription getLoaddedDescription(IProject project) {
        CProjectDescription des = (CProjectDescription)this.fDescriptionMap.get(project);
        if (des != null) {
            des.updateProject(project);
        }
        return des;
    }

    public synchronized ScannerInfoProviderProxy getScannerInfoProviderProxy(IProject project) {
        ICProjectDescription des = this.getProjectDescription(project, false);
        if (des == null) {
            return new ScannerInfoProviderProxy(project);
        }
        ScannerInfoProviderProxy provider = (ScannerInfoProviderProxy)des.getSessionProperty(SCANNER_INFO_PROVIDER_PROPERTY);
        if (provider == null) {
            provider = new ScannerInfoProviderProxy(project);
            des.setSessionProperty(SCANNER_INFO_PROVIDER_PROPERTY, provider);
        } else {
            provider.updateProject(project);
        }
        return provider;
    }

    synchronized boolean setLoaddedDescription(IProject project, ICProjectDescription des, boolean overwriteIfExists) {
        if (!overwriteIfExists && this.fDescriptionMap.get(project) != null) {
            return false;
        }
        if (des != null) {
            if (project.exists() && project.isOpen()) {
                this.fDescriptionMap.put(project, des);
            } else {
                CCorePlugin.log(SettingsModelMessages.getString("CProjectDescriptionManager.16"));
            }
        } else {
            this.fDescriptionMap.remove(project);
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ICProjectDescription loadProjectDescription(IProject project) throws CoreException {
        ICStorageElement storage = CProjectDescriptionManager.getInstance().createStorage(project, true, false, false);
        CProjectDescription des = new CProjectDescription(project, storage, true, false);
        if (des == null) return des;
        try {
            this.setDescriptionLoadding(project, des);
            des.loadDatas();
            des.doneLoadding();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.clearDescriptionLoadding(project);
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.clearDescriptionLoadding(project);
        }
        return des;
    }

    public ICProjectDescription getProjectDescription(IProject project) {
        return this.getProjectDescription(project, true);
    }

    boolean checkHandleActiveCfgChange(CProjectDescription newDes, CProjectDescription oldDes, IProjectDescription eDes, IProgressMonitor monitor) {
        if (newDes == null) {
            return false;
        }
        ICConfigurationDescription newCfg = newDes.getActiveConfiguration();
        if (newCfg == null) {
            return false;
        }
        ICConfigurationDescription oldCfg = oldDes != null ? oldDes.getActiveConfiguration() : null;
        this.checkActiveCfgChange(newDes, oldDes);
        this.checkSettingCfgChange(newDes, oldDes);
        boolean modified = false;
        try {
            if (this.checkBuildSystemChange(eDes, newCfg, oldCfg, monitor)) {
                modified = true;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        try {
            if (this.checkProjectRefChange(eDes, newCfg, oldCfg, monitor)) {
                modified = true;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return modified;
    }

    private Set projSetFromProjNameSet(Set projNameSet) {
        if (projNameSet.size() == 0) {
            return new HashSet(0);
        }
        HashSet<IProject> set = new HashSet<IProject>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Iterator iter = projNameSet.iterator();
        while (iter.hasNext()) {
            IProject proj = root.getProject((String)iter.next());
            set.add(proj);
        }
        return set;
    }

    private boolean checkProjectRefChange(IProjectDescription des, ICConfigurationDescription newCfg, ICConfigurationDescription oldCfg, IProgressMonitor monitor) throws CoreException {
        if (newCfg == null) {
            return false;
        }
        Map oldMap = oldCfg != null ? oldCfg.getReferenceInfo() : null;
        Map newMap = newCfg != null ? newCfg.getReferenceInfo() : null;
        Set oldProjSet = oldMap != null ? this.projSetFromProjNameSet(oldMap.keySet()) : new HashSet(0);
        Set newProjSet = newMap != null ? this.projSetFromProjNameSet(newMap.keySet()) : new HashSet(0);
        HashSet tmp = new HashSet(newProjSet);
        newProjSet.removeAll(oldProjSet);
        oldProjSet.removeAll(tmp);
        if (oldProjSet.size() != 0 || newProjSet.size() != 0) {
            IProject[] refs = des.getReferencedProjects();
            HashSet<IProject> set = new HashSet<IProject>(Arrays.asList(refs));
            set.removeAll(oldProjSet);
            set.addAll(newProjSet);
            des.setReferencedProjects(set.toArray(new IProject[set.size()]));
            return true;
        }
        return false;
    }

    private boolean checkActiveCfgChange(CProjectDescription des, CProjectDescription oldDes) {
        ICConfigurationDescription oldCfg = oldDes != null ? oldDes.getActiveConfiguration() : null;
        String oldId = oldCfg != null ? oldCfg.getId() : null;
        return des.checkPersistActiveCfg(oldId, false);
    }

    private boolean checkSettingCfgChange(CProjectDescription des, CProjectDescription oldDes) {
        ICConfigurationDescription oldCfg = oldDes != null ? oldDes.getDefaultSettingConfiguration() : null;
        String oldId = oldCfg != null ? oldCfg.getId() : null;
        return des.checkPersistSettingCfg(oldId, false);
    }

    private boolean checkBuildSystemChange(IProjectDescription des, ICConfigurationDescription newCfg, ICConfigurationDescription oldCfg, IProgressMonitor monitor) throws CoreException {
        String newBsId = newCfg != null ? newCfg.getBuildSystemId() : null;
        String oldBsId = oldCfg != null ? oldCfg.getBuildSystemId() : null;
        CConfigurationDataProviderDescriptor newDr = newBsId != null ? this.getCfgProviderDescriptor(newBsId) : null;
        CConfigurationDataProviderDescriptor oldDr = oldBsId != null ? this.getCfgProviderDescriptor(oldBsId) : null;
        String[] newNatures = newDr != null ? newDr.getNatureIds() : new String[]{};
        String[] oldNatures = oldDr != null ? oldDr.getNatureIds() : new String[]{};
        String[] conflictingNatures = newDr != null ? newDr.getConflictingNatureIds() : new String[]{};
        String[] natureIds = des.getNatureIds();
        HashSet<String> curSet = new HashSet<String>(Arrays.asList(natureIds));
        HashSet<String> newCurSet = new HashSet<String>(curSet);
        newCurSet.removeAll(Arrays.asList(oldNatures));
        newCurSet.addAll(Arrays.asList(newNatures));
        newCurSet.removeAll(Arrays.asList(conflictingNatures));
        if (!newCurSet.equals(curSet)) {
            des.setNatureIds(newCurSet.toArray(new String[newCurSet.size()]));
            return true;
        }
        return false;
    }

    public void setProjectDescription(IProject project, ICProjectDescription des) throws CoreException {
        this.setProjectDescription(project, des, false, null);
    }

    public void setProjectDescription(IProject project, ICProjectDescription des, boolean force, IProgressMonitor monitor) throws CoreException {
        int flags = 0;
        if (force) {
            flags |= 1;
        }
        this.setProjectDescription(project, des, flags, monitor);
    }

    static boolean checkFlags(int flags, int check) {
        return (flags & check) == check;
    }

    public void setProjectDescription(IProject project, ICProjectDescription des, int flags, IProgressMonitor monitor) throws CoreException {
        if (des != null) {
            if (!(des.isValid() || this.fAllowEmptyCreatingDescription && des.isCdtProjectCreating())) {
                throw ExceptionFactory.createCoreException(String.valueOf(SettingsModelMessages.getString("CProjectDescriptionManager.17")) + project.getName());
            }
            if (!CProjectDescriptionManager.checkFlags(flags, 1) && !des.isModified()) {
                return;
            }
            if (((CProjectDescription)des).isLoadding()) {
                return;
            }
            if (((CProjectDescription)des).isApplying()) {
                return;
            }
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        CModelManager manager = CModelManager.getDefault();
        ICProject cproject = manager.create(project);
        SetCProjectDescriptionOperation op = new SetCProjectDescriptionOperation(cproject, (CProjectDescription)des, flags);
        try {
            op.runOperation(monitor);
        }
        catch (IllegalArgumentException e) {
            throw ExceptionFactory.createCoreException(e);
        }
    }

    IWorkspaceRunnable createDesSerializationRunnable(CProjectDescription des) throws CoreException {
        ICStorageElement element = des.getRootStorageElement();
        DesSerializationRunnable r = new DesSerializationRunnable(des, element);
        return r;
    }

    void serialize(CProjectDescription des) throws CoreException {
        IWorkspaceRunnable r = this.createDesSerializationRunnable(des);
        this.runWspModification(r, (IProgressMonitor)new NullProgressMonitor());
    }

    private void serializePreference(String key, ICStorageElement element) throws CoreException {
        Document doc = this.getDocument(element);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        FileOutputStream fileStream = null;
        try {
            byte[] bytes;
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
            File file = this.getPreferenceFile(key);
            String utfString = stream.toString("UTF-8");
            if (!file.exists()) {
                file.createNewFile();
            }
            fileStream = new FileOutputStream(file);
            try {
                bytes = utfString.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bytes = utfString.getBytes();
            }
            fileStream.write(bytes);
            fileStream.close();
            stream.close();
        }
        catch (TransformerConfigurationException e) {
            throw ExceptionFactory.createCoreException(e);
        }
        catch (TransformerException e) {
            throw ExceptionFactory.createCoreException(e);
        }
        catch (IOException e) {
            throw ExceptionFactory.createCoreException(e);
        }
    }

    private ByteArrayOutputStream write(ICStorageElement element) throws CoreException {
        Document doc = this.getDocument(element);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
            return stream;
        }
        catch (TransformerConfigurationException e) {
            throw ExceptionFactory.createCoreException(e);
        }
        catch (TransformerException e) {
            throw ExceptionFactory.createCoreException(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void serialize(IProject project, String file, ICStorageElement element) throws CoreException {
        try {
            IFile projectFile = project.getFile(file);
            ByteArrayOutputStream stream = this.write(element);
            String utfString = stream.toString("UTF-8");
            this.aboutToSaveProjectFile(project);
            try {
                if (projectFile.exists()) {
                    projectFile.isReadOnly();
                    try {
                        projectFile.setContents((InputStream)new ByteArrayInputStream(utfString.getBytes("UTF-8")), 1, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        if (!projectFile.getLocation().toFile().isHidden()) throw e;
                        String os = System.getProperty("os.name");
                        if (os == null) throw e;
                        if (!os.startsWith("Win")) throw e;
                        projectFile.delete(true, null);
                        projectFile.create((InputStream)new ByteArrayInputStream(utfString.getBytes("UTF-8")), 1, (IProgressMonitor)new NullProgressMonitor());
                        CCorePlugin.log(String.valueOf(e.getLocalizedMessage()) + "\n** Error occured because of file status <hidden>." + "\n** This status is disabled now, to allow writing.");
                    }
                } else {
                    projectFile.create((InputStream)new ByteArrayInputStream(utfString.getBytes("UTF-8")), 1, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.doneSaveProjectFile(project);
                stream.close();
                throw throwable;
            }
            {
                Object var9_12 = null;
                this.doneSaveProjectFile(project);
                stream.close();
                return;
            }
        }
        catch (IOException e) {
            throw ExceptionFactory.createCoreException(e);
        }
    }

    private Document getDocument(ICStorageElement element) {
        return ((InternalXmlStorageElement)element).fElement.getOwnerDocument();
    }

    Map createCfgStorages(ICProjectDescription des) throws CoreException {
        LinkedHashMap<String, ICStorageElement> map = new LinkedHashMap<String, ICStorageElement>();
        ICStorageElement rootElement = des.getStorage(MODULE_ID, false);
        if (rootElement != null) {
            ICStorageElement[] children = rootElement.getChildren();
            int i = 0;
            while (i < children.length) {
                String id;
                ICStorageElement el = children[i];
                if (CONFIGURATION.equals(el.getName()) && (id = el.getAttribute("id")) != null) {
                    map.put(id, el);
                }
                ++i;
            }
        }
        return map;
    }

    ICLanguageSetting findLanguagSettingForFile(String fileName, IProject project, ICLanguageSetting[] settings) {
        String ext;
        ICLanguageSetting setting = null;
        int index = fileName.lastIndexOf(46);
        if (index > 0 && (ext = fileName.substring(index + 1).trim()).length() > 0) {
            setting = this.findLanguageSettingForExtension(ext, settings);
        }
        return setting;
    }

    public ICLanguageSetting findLanguageSettingForContentTypeId(String id, ICLanguageSetting[] settings) {
        int i = 0;
        while (i < settings.length) {
            Object[] ids = settings[i].getSourceContentTypeIds();
            if (ListComparator.indexOf(id, ids) != -1) {
                return settings[i];
            }
            ++i;
        }
        return null;
    }

    public ICLanguageSetting[] findCompatibleSettingsForContentTypeId(String id, ICLanguageSetting[] settings) {
        String[] exts;
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType cType = manager.getContentType(id);
        if (cType != null && (exts = cType.getFileSpecs(8)) != null && exts.length != 0) {
            ArrayList<ICLanguageSetting> list = new ArrayList<ICLanguageSetting>();
            int i = 0;
            while (i < exts.length) {
                ICLanguageSetting setting = this.findLanguageSettingForExtension(exts[i], settings);
                if (setting != null) {
                    list.add(setting);
                }
                ++i;
            }
            return list.toArray(new ICLanguageSetting[list.size()]);
        }
        return EMPTY_LANGUAGE_SETTINGS_ARRAY;
    }

    public ICLanguageSetting findLanguageSettingForExtension(String ext, ICLanguageSetting[] settings) {
        int i = 0;
        while (i < settings.length) {
            ICLanguageSetting setting = settings[i];
            String[] exts = setting.getSourceExtensions();
            if (exts != null && exts.length != 0) {
                int j = 0;
                while (j < exts.length) {
                    if (ext.equals(exts[j])) {
                        return setting;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    ICStorageElement createStorage(ICSettingsStorage storage, String cfgId) throws CoreException {
        ICStorageElement rootElement = storage.getStorage(MODULE_ID, true);
        ICStorageElement[] children = rootElement.getChildren();
        ICStorageElement element = null;
        int i = 0;
        while (i < children.length) {
            if (CONFIGURATION.equals(children[i].getName()) && cfgId.equals(children[i].getAttribute("id"))) {
                element = children[i];
                break;
            }
            ++i;
        }
        if (element == null) {
            element = rootElement.createChild(CONFIGURATION);
            element.setAttribute("id", cfgId);
        }
        return element;
    }

    void removeStorage(ICSettingsStorage storage, String cfgId) throws CoreException {
        ICStorageElement rootElement = storage.getStorage(MODULE_ID, false);
        if (rootElement != null) {
            ICStorageElement[] children = rootElement.getChildren();
            int i = 0;
            while (i < children.length) {
                if (CONFIGURATION.equals(children[i].getName()) && cfgId.equals(children[i].getAttribute("id"))) {
                    rootElement.removeChild(children[i]);
                    break;
                }
                ++i;
            }
        }
    }

    CConfigurationData loadData(ICConfigurationDescription des, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        CConfigurationDataProvider provider = this.getProvider(des);
        return provider.loadConfiguration(des, monitor);
    }

    CConfigurationData applyData(CConfigurationDescriptionCache des, ICConfigurationDescription baseDescription, CConfigurationData base, SettingsContext context, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        CConfigurationDataProvider provider = this.getProvider(des);
        context.init(des);
        return provider.applyConfiguration(des, baseDescription, base, context, monitor);
    }

    void notifyCached(ICConfigurationDescription des, CConfigurationData data, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            CConfigurationDataProvider provider = this.getProvider(des);
            provider.dataCached(des, data, monitor);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    void removeData(ICConfigurationDescription des, CConfigurationData data, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        CConfigurationDataProvider provider = this.getProvider(des);
        provider.removeConfiguration(des, data, monitor);
    }

    CConfigurationData createData(ICConfigurationDescription des, ICConfigurationDescription baseDescription, CConfigurationData base, boolean clone, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        CConfigurationDataProvider provider = this.getProvider(des);
        return provider.createConfiguration(des, baseDescription, base, clone, monitor);
    }

    private CConfigurationDataProvider getProvider(ICConfigurationDescription des) throws CoreException {
        CConfigurationDataProviderDescriptor providerDes = this.getCfgProviderDescriptor(des);
        if (providerDes == null) {
            throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.1"));
        }
        return providerDes.getProvider();
    }

    private CConfigurationDataProviderDescriptor getCfgProviderDescriptor(ICConfigurationDescription des) {
        return this.getCfgProviderDescriptor(des.getBuildSystemId());
    }

    private CConfigurationDataProviderDescriptor getCfgProviderDescriptor(String id) {
        this.initProviderInfo();
        return (CConfigurationDataProviderDescriptor)this.fProviderMap.get(id);
    }

    private synchronized void initProviderInfo() {
        if (this.fProviderMap != null) {
            return;
        }
        this.initProviderInfoSynch();
    }

    private synchronized void initProviderInfoSynch() {
        if (this.fProviderMap != null) {
            return;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core.CConfigurationDataProvider");
        IExtension[] exts = extensionPoint.getExtensions();
        this.fProviderMap = new HashMap(exts.length);
        int i = 0;
        while (i < exts.length) {
            CConfigurationDataProviderDescriptor des = new CConfigurationDataProviderDescriptor(exts[i]);
            this.fProviderMap.put(des.getId(), des);
            ++i;
        }
    }

    private ICStorageElement readOldCDTProjectFile(IProject project) throws CoreException {
        InternalXmlStorageElement storage = null;
        try {
            NodeList nodeList;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = null;
            InputStream stream = this.getSharedProperty(project, OLD_CDTPROJECT_FILE_NAME);
            if (stream != null && (nodeList = (doc = builder.parse(stream)).getElementsByTagName(OLD_PROJECT_DESCRIPTION)) != null && nodeList.getLength() > 0) {
                Node node = nodeList.item(0);
                storage = new InternalXmlStorageElement((Element)node, false);
            }
        }
        catch (ParserConfigurationException e) {
            throw ExceptionFactory.createCoreException(e);
        }
        catch (SAXException e) {
            throw ExceptionFactory.createCoreException(e);
        }
        catch (IOException e) {
            throw ExceptionFactory.createCoreException(e);
        }
        return storage;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICStorageElement createPreferenceStorage(String key, boolean createEmptyIfNotFound, boolean readOnly) throws CoreException {
        try {
            Element element;
            Document doc;
            DocumentBuilder builder;
            block22: {
                builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                doc = null;
                element = null;
                InputStream stream = null;
                try {
                    try {
                        stream = this.getPreferenceProperty(key);
                        if (stream != null) {
                            doc = builder.parse(stream);
                            Node rootElement = doc.getFirstChild();
                            if (rootElement.getNodeType() != 7) {
                                throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.2"));
                            }
                            String fileVersion = rootElement.getNodeValue();
                            Version version = new Version(fileVersion);
                            if (DESCRIPTION_VERSION.compareTo((Object)version) != 0) {
                                throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.3"));
                            }
                            NodeList nodes = doc.getElementsByTagName("preferences");
                            if (nodes.getLength() == 0) {
                                throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.4"));
                            }
                            Node node = nodes.item(0);
                            if (node.getNodeType() != 1) {
                                throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.5"));
                            }
                            element = (Element)node;
                        } else if (!createEmptyIfNotFound) {
                            throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.6"));
                        }
                    }
                    catch (FactoryConfigurationError e) {
                        if (!createEmptyIfNotFound) {
                            throw ExceptionFactory.createCoreException(e.getLocalizedMessage());
                        }
                    }
                    catch (SAXException e) {
                        if (!createEmptyIfNotFound) {
                            throw ExceptionFactory.createCoreException(e);
                        }
                    }
                    catch (IOException e) {
                        if (!createEmptyIfNotFound) {
                            throw ExceptionFactory.createCoreException(e);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    if (stream == null) throw throwable;
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    Object var11_17 = null;
                    if (stream == null) break block22;
                }
                try {}
                catch (IOException iOException) {}
                stream.close();
            }
            if (element != null) return new InternalXmlStorageElement(element, null, false, readOnly);
            doc = builder.newDocument();
            ProcessingInstruction instruction = doc.createProcessingInstruction(VERSION_ELEMENT_NAME, DESCRIPTION_VERSION.toString());
            doc.appendChild(instruction);
            element = doc.createElement("preferences");
            doc.appendChild(element);
            return new InternalXmlStorageElement(element, null, false, readOnly);
        }
        catch (ParserConfigurationException e) {
            throw ExceptionFactory.createCoreException(e);
        }
    }

    private InputStream getPreferenceProperty(String key) {
        FileInputStream stream = null;
        File file = this.getPreferenceFile(key);
        if (file.exists()) {
            try {
                stream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                CCorePlugin.log(e);
            }
        }
        return stream;
    }

    private File getPreferenceFile(String key) {
        IPath path = CCorePlugin.getDefault().getStateLocation();
        path = path.append(key);
        return path.toFile();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ICStorageElement createStorage(IProject project, boolean reCreate, boolean createEmptyIfNotFound, boolean readOnly) throws CoreException {
        try {
            Element element;
            Document doc;
            DocumentBuilder builder;
            block22: {
                builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                doc = null;
                element = null;
                InputStream stream = null;
                if (!reCreate) break block22;
                try {
                    try {
                        stream = this.getSharedProperty(project, STORAGE_FILE_NAME);
                        if (stream != null) {
                            doc = builder.parse(stream);
                            Node rootElement = doc.getFirstChild();
                            if (rootElement.getNodeType() != 7) {
                                throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.7"));
                            }
                            String fileVersion = rootElement.getNodeValue();
                            Version version = new Version(fileVersion);
                            if (DESCRIPTION_VERSION.compareTo((Object)version) != 0) {
                                throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.8"));
                            }
                            NodeList nodes = doc.getElementsByTagName(ROOT_ELEMENT_NAME);
                            if (nodes.getLength() == 0) {
                                throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.9"));
                            }
                            Node node = nodes.item(0);
                            if (node.getNodeType() != 1) {
                                throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.10"));
                            }
                            element = (Element)node;
                        } else if (!createEmptyIfNotFound) {
                            throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.11"));
                        }
                    }
                    catch (FactoryConfigurationError e) {
                        if (!createEmptyIfNotFound) {
                            throw ExceptionFactory.createCoreException(e.getLocalizedMessage());
                        }
                    }
                    catch (SAXException e) {
                        if (!createEmptyIfNotFound) {
                            throw ExceptionFactory.createCoreException(e);
                        }
                    }
                    catch (IOException e) {
                        if (!createEmptyIfNotFound) {
                            throw ExceptionFactory.createCoreException(e);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var12_17 = null;
                    if (stream == null) throw throwable;
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    Object var12_18 = null;
                    if (stream == null) break block22;
                }
                try {}
                catch (IOException iOException) {}
                stream.close();
            }
            if (element != null) return new InternalXmlStorageElement(element, null, false, readOnly);
            doc = builder.newDocument();
            ProcessingInstruction instruction = doc.createProcessingInstruction(VERSION_ELEMENT_NAME, DESCRIPTION_VERSION.toString());
            doc.appendChild(instruction);
            element = doc.createElement(ROOT_ELEMENT_NAME);
            doc.appendChild(element);
            return new InternalXmlStorageElement(element, null, false, readOnly);
        }
        catch (ParserConfigurationException e) {
            throw ExceptionFactory.createCoreException(e);
        }
    }

    public static File toLocalFile(URI uri, IProgressMonitor monitor) throws CoreException {
        IFileStore fileStore = EFS.getStore((URI)uri);
        File localFile = fileStore.toLocalFile(0, monitor);
        if (localFile == null) {
            localFile = fileStore.toLocalFile(4096, monitor);
        }
        return localFile;
    }

    public InputStream getSharedProperty(IProject project, String key) throws CoreException {
        InputStream stream = null;
        final IFile rscFile = project.getFile(key);
        if (rscFile.exists()) {
            try {
                stream = rscFile.getContents();
            }
            catch (CoreException e) {
                final Throwable[] t = new Throwable[1];
                Job job = this.runWspModification(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            rscFile.refreshLocal(0, null);
                        }
                        catch (Exception e) {
                            t[0] = e;
                        }
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
                if (job == null) {
                    if (t[0] == null) {
                        stream = rscFile.getContents();
                    }
                    if (t[0] instanceof CoreException) {
                        throw (CoreException)t[0];
                    }
                    throw e;
                }
                throw e;
            }
        } else {
            File file;
            URI location = rscFile.getLocationURI();
            if (location != null && (file = CProjectDescriptionManager.toLocalFile(location, null)) != null && file.exists()) {
                try {
                    stream = new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    throw ExceptionFactory.createCoreException(e);
                }
            }
        }
        return stream;
    }

    ICDescriptionDelta createDelta(ICProjectDescription newDescription, ICProjectDescription oldDescription) {
        CProjectDescriptionDelta delta = new CProjectDescriptionDelta(newDescription, oldDescription);
        if (delta.getDeltaKind() == 3) {
            ICConfigurationDescription[] cfgs = newDescription.getConfigurations();
            int i = 0;
            while (i < cfgs.length) {
                ICConfigurationDescription oldCfg = oldDescription.getConfigurationById(cfgs[i].getId());
                CProjectDescriptionDelta cfgDelta = this.createDelta(cfgs[i], oldCfg);
                if (cfgDelta != null) {
                    delta.addChild(cfgDelta);
                }
                ++i;
            }
            cfgs = oldDescription.getConfigurations();
            i = 0;
            while (i < cfgs.length) {
                ICConfigurationDescription newCfg = newDescription.getConfigurationById(cfgs[i].getId());
                if (newCfg == null) {
                    delta.addChild(this.createDelta(null, cfgs[i]));
                }
                ++i;
            }
            if (this.checkCfgChange(newDescription, oldDescription, true)) {
                delta.addChangeFlags(1);
            }
            if (this.checkCfgChange(newDescription, oldDescription, false)) {
                delta.addChangeFlags(0x200000);
            }
            if (oldDescription.isCdtProjectCreating() && !newDescription.isCdtProjectCreating()) {
                delta.addChangeFlags(0x400000);
            }
        }
        return delta.isEmpty() ? null : delta;
    }

    private boolean checkCfgChange(ICProjectDescription newDes, ICProjectDescription oldDes, boolean active) {
        ICConfigurationDescription oldCfg;
        ICConfigurationDescription newCfg;
        if (active) {
            newCfg = newDes.getActiveConfiguration();
            oldCfg = oldDes.getActiveConfiguration();
        } else {
            newCfg = newDes.getDefaultSettingConfiguration();
            oldCfg = oldDes.getDefaultSettingConfiguration();
        }
        if (newCfg == null) {
            return oldCfg != null;
        }
        if (oldCfg == null) {
            return true;
        }
        return !newCfg.getId().equals(oldCfg.getId());
    }

    private ICDescriptionDelta findDelta(String id, ICDescriptionDelta delta) {
        ICDescriptionDelta[] children = delta.getChildren();
        int i = 0;
        while (i < children.length) {
            ICSettingObject obj = children[i].getSetting();
            if (obj.getId().equals(id)) {
                return children[i];
            }
            ++i;
        }
        return null;
    }

    public int calculateDescriptorFlags(ICConfigurationDescription newCfg, ICConfigurationDescription oldCfg) {
        try {
            int flags = 0;
            CConfigurationSpecSettings newSettings = ((IInternalCCfgInfo)((Object)newCfg)).getSpecSettings();
            CConfigurationSpecSettings oldSettings = ((IInternalCCfgInfo)((Object)oldCfg)).getSpecSettings();
            String newId = newSettings.getCOwnerId();
            String oldId = oldSettings.getCOwnerId();
            if (!CDataUtil.objectsEqual(newId, oldId)) {
                flags |= 0x100000;
            }
            Map newMap = newSettings.getExtensionMapCopy();
            Map oldMap = oldSettings.getExtensionMapCopy();
            Iterator iter = newMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                iter.remove();
                CConfigExtensionReference[] oldRefs = (CConfigExtensionReference[])oldMap.remove(entry.getKey());
                if (oldRefs == null) {
                    flags |= 0x80000;
                    break;
                }
                CConfigExtensionReference[] newRefs = (CConfigExtensionReference[])entry.getValue();
                if (newRefs.length != oldRefs.length) {
                    flags |= 0x80000;
                    break;
                }
                HashSet<CConfigExtensionReference> newSet = new HashSet<CConfigExtensionReference>(Arrays.asList(newRefs));
                HashSet<CConfigExtensionReference> oldSet = new HashSet<CConfigExtensionReference>(Arrays.asList(oldRefs));
                if (newSet.size() != oldSet.size()) {
                    flags |= 0x80000;
                    break;
                }
                newSet.removeAll(oldSet);
                if (newSet.size() == 0) continue;
                flags |= 0x80000;
                break;
            }
            return flags;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    public CProjectDescriptionDelta createDelta(ICConfigurationDescription newCfg, ICConfigurationDescription oldCfg) {
        CProjectDescriptionDelta delta = new CProjectDescriptionDelta(newCfg, oldCfg);
        IInternalCCfgInfo newInfo = (IInternalCCfgInfo)((Object)newCfg);
        IInternalCCfgInfo oldInfo = (IInternalCCfgInfo)((Object)oldCfg);
        if (delta.getDeltaKind() == 3) {
            int j;
            boolean found;
            int i;
            ICSourceEntry[] oldEntries;
            ICSourceEntry[] newEntries;
            ICFolderDescription[] foDess = newCfg.getFolderDescriptions();
            int i2 = 0;
            while (i2 < foDess.length) {
                ICResourceDescription oldDes = oldCfg.getResourceDescription(foDess[i2].getPath(), true);
                if (oldDes != null && oldDes.getType() == 4) {
                    CProjectDescriptionDelta foDelta = this.createDelta(foDess[i2], (ICFolderDescription)oldDes);
                    if (foDelta != null) {
                        delta.addChild(foDelta);
                    }
                } else {
                    delta.addChild(this.createDelta(foDess[i2], null));
                }
                ++i2;
            }
            foDess = oldCfg.getFolderDescriptions();
            i2 = 0;
            while (i2 < foDess.length) {
                ICResourceDescription newDes = newCfg.getResourceDescription(foDess[i2].getPath(), true);
                if (newDes == null || newDes.getType() != 4) {
                    delta.addChild(this.createDelta(null, foDess[i2]));
                }
                ++i2;
            }
            ICFileDescription[] fiDess = newCfg.getFileDescriptions();
            int i3 = 0;
            while (i3 < fiDess.length) {
                ICResourceDescription oldDes = oldCfg.getResourceDescription(fiDess[i3].getPath(), true);
                if (oldDes != null && oldDes.getType() == 8) {
                    CProjectDescriptionDelta fiDelta = this.createDelta(fiDess[i3], (ICFileDescription)oldDes);
                    if (fiDelta != null) {
                        delta.addChild(fiDelta);
                    }
                } else {
                    delta.addChild(this.createDelta(fiDess[i3], null));
                }
                ++i3;
            }
            fiDess = oldCfg.getFileDescriptions();
            i3 = 0;
            while (i3 < fiDess.length) {
                ICResourceDescription newDes = newCfg.getResourceDescription(fiDess[i3].getPath(), true);
                if (newDes == null || newDes.getType() != 8) {
                    delta.addChild(this.createDelta(null, fiDess[i3]));
                }
                ++i3;
            }
            CProjectDescriptionDelta tpsDelta = this.createDelta(newCfg.getTargetPlatformSetting(), oldCfg.getTargetPlatformSetting());
            if (tpsDelta != null) {
                delta.addChild(tpsDelta);
            }
            if (!newCfg.getName().equals(oldCfg.getName())) {
                delta.addChangeFlags(2);
            }
            if ((newEntries = newCfg.getSourceEntries()).length > (oldEntries = oldCfg.getSourceEntries()).length) {
                delta.addChangeFlags(8192);
            } else {
                i = 0;
                while (i < newEntries.length) {
                    found = false;
                    ICSourceEntry newEntry = newEntries[i];
                    j = 0;
                    while (j < oldEntries.length) {
                        if (newEntry.equals(oldEntries[j])) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        delta.addChangeFlags(8192);
                        break;
                    }
                    ++i;
                }
            }
            if (oldEntries.length > newEntries.length) {
                delta.addChangeFlags(16384);
            } else {
                i = 0;
                while (i < oldEntries.length) {
                    found = false;
                    ICSourceEntry oldEntry = oldEntries[i];
                    j = 0;
                    while (j < newEntries.length) {
                        if (oldEntry.equals(newEntries[j])) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        delta.addChangeFlags(16384);
                        break;
                    }
                    ++i;
                }
            }
            try {
                CConfigurationSpecSettings newSettings = newInfo.getSpecSettings();
                CConfigurationSpecSettings oldSettings = oldInfo.getSpecSettings();
                if (!newSettings.extRefSettingsEqual(oldSettings)) {
                    delta.addChangeFlags(524288);
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
            this.calculateCfgExtSettingsDelta(delta);
            int drFlags = this.calculateDescriptorFlags(newCfg, oldCfg);
            if (drFlags != 0) {
                delta.addChangeFlags(drFlags);
            }
        }
        return delta.isEmpty() ? null : delta;
    }

    private void calculateCfgExtSettingsDelta(CProjectDescriptionDelta delta) {
        int cfgRefFlags;
        ICConfigurationDescription newDes = (ICConfigurationDescription)delta.getNewSetting();
        ICConfigurationDescription oldDes = (ICConfigurationDescription)delta.getOldSetting();
        CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas = this.getSettingChange(newDes, oldDes);
        int flags = 0;
        int addedRemoved = 98304;
        if (deltas != null) {
            int i = 0;
            while (i < deltas.length) {
                ICSettingEntry[][] d = deltas[i].getEntriesDelta();
                if (d[0] != null) {
                    flags |= 0x8000;
                }
                if (d[1] != null) {
                    flags |= 0x10000;
                }
                if ((flags & addedRemoved) == addedRemoved) break;
                ++i;
            }
            if (flags != 0) {
                delta.addChangeFlags(flags);
            }
        }
        if ((cfgRefFlags = this.calcRefChangeFlags(newDes, oldDes)) != 0) {
            delta.addChangeFlags(cfgRefFlags);
        }
    }

    private int calcRefChangeFlags(ICConfigurationDescription newDes, ICConfigurationDescription oldDes) {
        Map newMap = newDes != null ? newDes.getReferenceInfo() : null;
        Map oldMap = oldDes != null ? oldDes.getReferenceInfo() : null;
        int flags = 0;
        if (newMap == null || newMap.size() == 0) {
            if (oldMap != null && oldMap.size() != 0) {
                flags = 262144;
            }
        } else if (oldMap == null || oldMap.size() == 0) {
            flags = 131072;
        } else {
            boolean stop = false;
            Iterator iter = newMap.entrySet().iterator();
            while (iter.hasNext()) {
                Object oldCfg;
                Map.Entry newEntry = iter.next();
                Object newProj = newEntry.getKey();
                Object newCfg = newEntry.getValue();
                if (newCfg.equals(oldCfg = oldMap.remove(newProj))) continue;
                flags |= 0x20000;
                if (oldCfg != null) {
                    flags |= 0x40000;
                    stop = true;
                }
                if (stop) break;
            }
            if (!oldMap.isEmpty()) {
                flags |= 0x40000;
            }
        }
        return flags;
    }

    private CExternalSettinsDeltaCalculator.ExtSettingsDelta[] getSettingChange(ICConfigurationDescription newDes, ICConfigurationDescription oldDes) {
        CExternalSetting[] newSettings = newDes != null ? (CExternalSetting[])newDes.getExternalSettings() : null;
        CExternalSetting[] oldSettings = oldDes != null ? (CExternalSetting[])oldDes.getExternalSettings() : null;
        return CExternalSettinsDeltaCalculator.getInstance().getSettingChange(newSettings, oldSettings);
    }

    private CProjectDescriptionDelta createDelta(ICFolderDescription newFo, ICFolderDescription oldFo) {
        CProjectDescriptionDelta delta = new CProjectDescriptionDelta(newFo, oldFo);
        if (delta.getDeltaKind() == 3) {
            ICLanguageSetting[] newLss = newFo.getLanguageSettings();
            ICLanguageSetting[] oldLss = oldFo.getLanguageSettings();
            ArrayList<ICLanguageSetting> newList = new ArrayList<ICLanguageSetting>(Arrays.asList(newLss));
            ArrayList<ICLanguageSetting> oldList = new ArrayList<ICLanguageSetting>(Arrays.asList(oldLss));
            List matched = this.sortSettings(newList, oldList);
            Iterator iter = matched.iterator();
            while (iter.hasNext()) {
                ICLanguageSetting[] match = (ICLanguageSetting[])iter.next();
                CProjectDescriptionDelta lsDelta = this.createDelta(match[0], match[1]);
                if (lsDelta == null) continue;
                delta.addChild(lsDelta);
            }
            iter = newList.iterator();
            while (iter.hasNext()) {
                ICLanguageSetting added = (ICLanguageSetting)iter.next();
                delta.addChild(this.createDelta(added, null));
            }
            iter = oldList.iterator();
            while (iter.hasNext()) {
                ICLanguageSetting removed = (ICLanguageSetting)iter.next();
                delta.addChild(this.createDelta(null, removed));
            }
            if (newFo.isExcluded() != oldFo.isExcluded()) {
                delta.addChangeFlags(4096);
            }
        }
        return delta.isEmpty() ? null : delta;
    }

    private List sortSettings(List settings1, List settings2) {
        ICLanguageSetting[] match;
        Iterator iter2;
        ICLanguageSetting setting2;
        ICLanguageSetting setting1;
        ArrayList<ICLanguageSetting[]> result = new ArrayList<ICLanguageSetting[]>();
        Iterator iter1 = settings1.iterator();
        block0: while (iter1.hasNext()) {
            setting1 = (ICLanguageSetting)iter1.next();
            Iterator iter22 = settings2.iterator();
            while (iter22.hasNext()) {
                setting2 = (ICLanguageSetting)iter22.next();
                if (!setting2.getId().equals(setting1.getId())) continue;
                iter1.remove();
                iter22.remove();
                ICLanguageSetting[] match2 = new ICLanguageSetting[]{setting1, setting2};
                result.add(match2);
                continue block0;
            }
        }
        iter1 = settings1.iterator();
        block2: while (iter1.hasNext()) {
            setting1 = (ICLanguageSetting)iter1.next();
            String lId = setting1.getLanguageId();
            if (lId == null) continue;
            iter2 = settings2.iterator();
            while (iter2.hasNext()) {
                setting2 = (ICLanguageSetting)iter2.next();
                if (!lId.equals(setting2.getLanguageId())) continue;
                iter1.remove();
                iter2.remove();
                match = new ICLanguageSetting[]{setting1, setting2};
                result.add(match);
                continue block2;
            }
        }
        iter1 = settings1.iterator();
        block4: while (iter1.hasNext()) {
            setting1 = (ICLanguageSetting)iter1.next();
            Object[] cTypeIds1 = setting1.getSourceContentTypeIds();
            if (cTypeIds1.length == 0) continue;
            iter2 = settings2.iterator();
            while (iter2.hasNext()) {
                setting2 = (ICLanguageSetting)iter2.next();
                if (!Arrays.equals(cTypeIds1, setting2.getSourceContentTypeIds())) continue;
                iter1.remove();
                iter2.remove();
                match = new ICLanguageSetting[]{setting1, setting2};
                result.add(match);
                continue block4;
            }
        }
        iter1 = settings1.iterator();
        block6: while (iter1.hasNext()) {
            Object[] srcExts;
            setting1 = (ICLanguageSetting)iter1.next();
            if (setting1.getSourceContentTypeIds().length != 0 || (srcExts = setting1.getSourceExtensions()).length == 0) continue;
            iter2 = settings2.iterator();
            while (iter2.hasNext()) {
                setting2 = (ICLanguageSetting)iter2.next();
                if (setting2.getSourceContentTypeIds().length != 0 || !Arrays.equals(srcExts, setting2.getSourceExtensions())) continue;
                iter1.remove();
                iter2.remove();
                match = new ICLanguageSetting[]{setting1, setting2};
                result.add(match);
                continue block6;
            }
        }
        return result;
    }

    private CProjectDescriptionDelta createDelta(ICFileDescription newFi, ICFileDescription oldFi) {
        CProjectDescriptionDelta delta = new CProjectDescriptionDelta(newFi, oldFi);
        if (delta.getDeltaKind() == 3) {
            CProjectDescriptionDelta lsDelta = this.createDelta(newFi.getLanguageSetting(), oldFi.getLanguageSetting());
            if (lsDelta != null) {
                delta.addChild(lsDelta);
            }
            if (newFi.isExcluded() != oldFi.isExcluded()) {
                delta.addChangeFlags(4096);
            }
        }
        return delta.isEmpty() ? null : delta;
    }

    private CProjectDescriptionDelta createDelta(ICLanguageSetting newLs, ICLanguageSetting oldLs) {
        CProjectDescriptionDelta delta = new CProjectDescriptionDelta(newLs, oldLs);
        if (delta.getDeltaKind() == 3) {
            Object[] oldExts;
            Object[] newExts;
            int[] kinds = KindBasedStore.getLanguageEntryKinds();
            int addedKinds = 0;
            int removedKinds = 0;
            int reorderedKinds = 0;
            int i = 0;
            while (i < kinds.length) {
                ICLanguageSettingEntry[] oldEntries;
                int kind = kinds[i];
                ICLanguageSettingEntry[] newEntries = newLs.getSettingEntries(kind);
                boolean[] change = this.calculateSettingsChanges(newEntries, oldEntries = oldLs.getSettingEntries(kind));
                if (change[0]) {
                    addedKinds |= kind;
                }
                if (change[1]) {
                    removedKinds |= kind;
                }
                if (change[2]) {
                    reorderedKinds |= kind;
                }
                ++i;
            }
            delta.setAddedLanguageEntriesKinds(addedKinds);
            delta.setRemovedLanguageEntriesKinds(removedKinds);
            delta.setReorderedLanguageEntriesKinds(reorderedKinds);
            Object[] newCtIds = newLs.getSourceContentTypeIds();
            Object[] oldCtIds = oldLs.getSourceContentTypeIds();
            if (!Arrays.equals(newCtIds, oldCtIds)) {
                delta.addChangeFlags(32);
            }
            if (!Arrays.equals(newExts = newLs.getSourceExtensions(), oldExts = oldLs.getSourceExtensions())) {
                delta.addChangeFlags(64);
            }
        }
        return delta.isEmpty() ? null : delta;
    }

    private boolean[] calculateSettingsChanges(ICLanguageSettingEntry[] newEntries, ICLanguageSettingEntry[] oldEntries) {
        int j;
        boolean found;
        boolean[] result = new boolean[3];
        if (oldEntries == null) {
            return result;
        }
        if (newEntries == null) {
            newEntries = EMPTY_LANGUAGE_SETTINGS_ENTRIES_ARRAY;
        }
        int i = 0;
        while (i < oldEntries.length) {
            found = false;
            j = 0;
            while (j < newEntries.length) {
                if (oldEntries[i].equals(newEntries[j])) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                result[1] = true;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < newEntries.length) {
            found = false;
            j = 0;
            while (j < oldEntries.length) {
                if (newEntries[i].equals(oldEntries[j])) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                result[0] = true;
                break;
            }
            ++i;
        }
        if (!result[0] && !result[1] && oldEntries.length == newEntries.length) {
            i = 0;
            while (i < newEntries.length) {
                if (!newEntries[i].equals(oldEntries[i])) {
                    result[2] = true;
                    break;
                }
                ++i;
            }
        }
        if (!result[0] && !result[1] && oldEntries.length != newEntries.length) {
            result[2] = true;
        }
        return result;
    }

    private CProjectDescriptionDelta createDelta(ICTargetPlatformSetting newTPS, ICTargetPlatformSetting oldTPS) {
        CProjectDescriptionDelta delta = new CProjectDescriptionDelta(newTPS, oldTPS);
        if (!Arrays.equals(newTPS.getBinaryParserIds(), oldTPS.getBinaryParserIds())) {
            delta.addChangeFlags(1024);
        }
        return delta.isEmpty() ? null : delta;
    }

    ICElementDelta[] generateCElementDeltas(ICProject cProject, ICDescriptionDelta projDesDelta) {
        if (projDesDelta == null) {
            return EMPTY_CELEMENT_DELTA;
        }
        int kind = projDesDelta.getDeltaKind();
        switch (kind) {
            case 3: {
                ICProjectDescription newDes = (ICProjectDescription)projDesDelta.getNewSetting();
                ICProjectDescription oldDes = (ICProjectDescription)projDesDelta.getOldSetting();
                ICConfigurationDescription indexCfg = newDes.getDefaultSettingConfiguration();
                ICConfigurationDescription oldIndexCfg = oldDes.getDefaultSettingConfiguration();
                ICDescriptionDelta indexDelta = oldIndexCfg != null && oldIndexCfg.getId().equals(indexCfg.getId()) ? this.findDelta(indexCfg.getId(), projDesDelta) : this.createDelta(indexCfg, oldIndexCfg);
                if (indexDelta != null) {
                    ArrayList list = new ArrayList();
                    this.generateCElementDeltasFromCfgDelta(cProject, indexDelta, list);
                    return list.toArray(new ICElementDelta[list.size()]);
                }
                return EMPTY_CELEMENT_DELTA;
            }
        }
        return EMPTY_CELEMENT_DELTA;
    }

    private List generateCElementDeltasFromCfgDelta(ICProject cProject, ICDescriptionDelta cfgDelta, List list) {
        int kind = cfgDelta.getDeltaKind();
        switch (kind) {
            case 3: {
                int descriptionFlags = cfgDelta.getChangeFlags();
                int celementFlags = 0;
                if ((descriptionFlags & 0x2000) != 0) {
                    celementFlags |= 0x100;
                }
                if ((descriptionFlags & 0x4000) != 0) {
                    celementFlags |= 0x200;
                }
                if (celementFlags != 0) {
                    CElementDelta cElDelta = new CElementDelta(cProject.getCModel());
                    cElDelta.changed(cProject, celementFlags);
                    list.add(cElDelta);
                }
                ICDescriptionDelta[] children = cfgDelta.getChildren();
                int i = 0;
                while (i < children.length) {
                    ICDescriptionDelta child = children[i];
                    int type = child.getSettingType();
                    if (type == 8 || type == 4) {
                        this.generateCElementDeltasFromResourceDelta(cProject, child, list);
                    }
                    ++i;
                }
                break;
            }
        }
        return list;
    }

    private List generateCElementDeltasFromResourceDelta(ICProject cProject, ICDescriptionDelta delta, List list) {
        ICResourceDescription newRcDes;
        IPath path;
        ICResourceDescription oldRcDes;
        int kind = delta.getDeltaKind();
        ICDescriptionDelta parentDelta = delta.getParent();
        IResource rc = null;
        switch (kind) {
            case 1: {
                oldRcDes = (ICResourceDescription)delta.getOldSetting();
                path = oldRcDes.getPath();
                newRcDes = ((ICConfigurationDescription)parentDelta.getNewSetting()).getResourceDescription(path, false);
                break;
            }
            case 3: {
                newRcDes = (ICResourceDescription)delta.getNewSetting();
                path = newRcDes.getPath();
                oldRcDes = (ICResourceDescription)delta.getOldSetting();
                break;
            }
            default: {
                newRcDes = (ICResourceDescription)delta.getNewSetting();
                path = newRcDes.getPath();
                oldRcDes = ((ICConfigurationDescription)parentDelta.getOldSetting()).getResourceDescription(path, false);
            }
        }
        path = path.makeRelative();
        ICElement el = null;
        try {
            el = cProject.findElement(path);
            rc = el.getResource();
        }
        catch (CModelException cModelException) {}
        if (rc != null) {
            ICFolderDescription oldFoDes;
            CProjectDescriptionDelta folderDelta;
            if (rc.getType() == 1) {
                String fileName = path.lastSegment();
                ICLanguageSetting newLS = this.getLanguageSetting(newRcDes, fileName);
                ICLanguageSetting oldLS = this.getLanguageSetting(oldRcDes, fileName);
                CProjectDescriptionDelta ld = this.createDelta(newLS, oldLS);
                this.generateCElementDeltasFromLanguageDelta(el, ld, list);
            } else if (newRcDes.getType() == 4 && (folderDelta = this.createDelta((ICFolderDescription)newRcDes, oldFoDes = oldRcDes.getType() == 4 ? (ICFolderDescription)oldRcDes : null)) != null) {
                ICDescriptionDelta[] children = folderDelta.getChildren();
                int i = 0;
                while (i < children.length) {
                    ICDescriptionDelta child = children[i];
                    if (child.getSettingType() == 16) {
                        this.generateCElementDeltasFromLanguageDelta(el, child, list);
                    }
                    ++i;
                }
            }
        }
        return list;
    }

    private ICLanguageSetting getLanguageSetting(ICResourceDescription rcDes, String fileName) {
        if (rcDes.getType() == 8) {
            return ((ICFileDescription)rcDes).getLanguageSetting();
        }
        return ((ICFolderDescription)rcDes).getLanguageSettingForFile(fileName);
    }

    private List generateCElementDeltasFromLanguageDelta(ICElement el, ICDescriptionDelta delta, List list) {
        if (delta == null) {
            return list;
        }
        int flags = 0;
        flags |= this.calculateEntriesFlags(delta.getAddedEntriesKinds(), true);
        flags |= this.calculateEntriesFlags(delta.getRemovedEntriesKinds(), false);
        if ((flags |= this.calculateEntriesFlags(delta.getReorderedEntriesKinds(), true)) != 0) {
            CElementDelta cElDelta = new CElementDelta(el.getCModel());
            cElDelta.changed(el, flags);
            list.add(cElDelta);
        }
        return list;
    }

    private int calculateEntriesFlags(int languageDeltaKinds, boolean added) {
        int flags = 0;
        int[] kindsArray = this.kindsToArray(languageDeltaKinds);
        int i = 0;
        while (i < kindsArray.length) {
            switch (kindsArray[i]) {
                case 1: {
                    flags |= 0x800;
                    break;
                }
                case 2: {
                    flags |= 0x800;
                    break;
                }
                case 4: {
                    flags |= 0x400;
                    break;
                }
                case 8: {
                    flags |= 0x400;
                    break;
                }
                case 16: {
                    flags |= added ? 4096 : 8192;
                    break;
                }
                case 32: {
                    flags |= added ? 4096 : 8192;
                }
            }
            ++i;
        }
        return flags;
    }

    int[] kindsToArray(int kinds) {
        int[] allKinds = KindBasedStore.getLanguageEntryKinds();
        int[] kindsArray = new int[allKinds.length];
        int num = 0;
        int i = 0;
        while (i < allKinds.length) {
            if ((allKinds[i] & kinds) != 0) {
                kindsArray[num++] = allKinds[i];
            }
            ++i;
        }
        if (num < allKinds.length) {
            int[] tmp = new int[num];
            if (num > 0) {
                System.arraycopy(kindsArray, 0, tmp, 0, num);
            }
            kindsArray = tmp;
        }
        return kindsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCProjectDescriptionListener(ICProjectDescriptionListener listener, int eventTypes) {
        List list = this.fListeners;
        synchronized (list) {
            this.fListeners.add(new ListenerDescriptor(listener, eventTypes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCProjectDescriptionListener(ICProjectDescriptionListener listener) {
        List list = this.fListeners;
        synchronized (list) {
            int size = this.fListeners.size();
            int i = 0;
            while (i < size) {
                ListenerDescriptor des = (ListenerDescriptor)this.fListeners.get(i);
                if (des.fListener == listener) {
                    this.fListeners.remove(des);
                    break;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenerDescriptor[] getListeners() {
        List list = this.fListeners;
        synchronized (list) {
            return this.fListeners.toArray(new ListenerDescriptor[this.fListeners.size()]);
        }
    }

    void notifyListeners(CProjectDescriptionEvent event) {
        ListenerDescriptor[] listeners = this.getListeners();
        int eventType = event.getEventType();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i].handlesEvent(eventType)) {
                listeners[i].fListener.handleEvent(event);
            }
            ++i;
        }
    }

    public Element createXmlElementCopy(InternalXmlStorageElement el) throws CoreException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element newXmlEl = null;
            if (el.fElement.getParentNode().getNodeType() == 9) {
                Document baseDoc = el.fElement.getOwnerDocument();
                NodeList list = baseDoc.getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    Node node = list.item(i);
                    if ((node = this.importAddNode(doc, node)).getNodeType() == 1 && newXmlEl == null) {
                        newXmlEl = (Element)node;
                    }
                    ++i;
                }
            } else {
                newXmlEl = (Element)this.importAddNode(doc, el.fElement);
            }
            return newXmlEl;
        }
        catch (ParserConfigurationException e) {
            throw ExceptionFactory.createCoreException(e);
        }
        catch (FactoryConfigurationError e) {
            throw ExceptionFactory.createCoreException(e);
        }
    }

    InternalXmlStorageElement copyConfigurationElement(InternalXmlStorageElement el, String newId, boolean readOnly) throws CoreException {
        el = this.copyElement(el, readOnly);
        el.setAttribute("id", newId);
        return el;
    }

    InternalXmlStorageElement copyElement(InternalXmlStorageElement el, boolean readOnly) throws CoreException {
        Element newXmlEl = this.createXmlElementCopy(el);
        return new InternalXmlStorageElement(newXmlEl, el.getParent(), el.isParentRefAlowed(), el.getAttributeFilters(), el.getChildFilters(), readOnly);
    }

    private Node importAddNode(Document doc, Node node) {
        node = node.getOwnerDocument().equals(doc) ? node.cloneNode(true) : doc.importNode(node, true);
        return doc.appendChild(node);
    }

    CStorage copyStorage(CStorage el, boolean readOnly) throws CoreException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element newXmlEl = (Element)doc.importNode(el.fElement, true);
            doc.appendChild(newXmlEl);
            return new CStorage(newXmlEl, readOnly);
        }
        catch (ParserConfigurationException e) {
            throw ExceptionFactory.createCoreException(e);
        }
        catch (FactoryConfigurationError e) {
            throw ExceptionFactory.createCoreException(e);
        }
    }

    void checkRemovedConfigurations(ICDescriptionDelta delta) {
        if (delta == null) {
            return;
        }
        ICDescriptionDelta[] cfgDeltas = delta.getChildren();
        int i = 0;
        while (i < cfgDeltas.length) {
            if (cfgDeltas[i].getDeltaKind() == 1) {
                CConfigurationDescriptionCache des = (CConfigurationDescriptionCache)cfgDeltas[i].getOldSetting();
                CConfigurationData data = des.getConfigurationData();
                try {
                    this.removeData(des, data, null);
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
    }

    public ICConfigurationDescription getPreferenceConfiguration(String buildSystemId) throws CoreException {
        return this.getPreferenceConfiguration(buildSystemId, true);
    }

    private void runContextOperations(SettingsContext context, IProgressMonitor monitor) {
        IWorkspaceRunnable toRun = context.createOperationRunnable();
        if (toRun != null) {
            this.runWspModification(toRun, monitor);
        } else if (monitor != null) {
            monitor.done();
        }
    }

    public ICConfigurationDescription getPreferenceConfiguration(String buildSystemId, boolean write) throws CoreException {
        ICConfigurationDescription des = this.getLoaddedPreference(buildSystemId);
        if (des == null) {
            try {
                des = this.loadPreference(buildSystemId);
            }
            catch (CoreException coreException) {}
            if (des == null) {
                try {
                    des = this.createNewPreference(buildSystemId);
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            }
            this.setLoaddedPreference(buildSystemId, (CConfigurationDescriptionCache)des);
        }
        if (des != null && write) {
            try {
                des = this.createWritablePreference((CConfigurationDescriptionCache)des);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return des;
    }

    public void setPreferenceConfiguration(String buildSystemId, ICConfigurationDescription des) throws CoreException {
        if (!this.needSavePreference(buildSystemId, des)) {
            return;
        }
        CConfigurationDescriptionCache cache = this.createPreferenceCache(des);
        this.savePreferenceConfiguration(buildSystemId, cache);
        this.setLoaddedPreference(buildSystemId, cache);
    }

    private void savePreferenceConfiguration(String buildStystemId, CConfigurationDescriptionCache cache) throws CoreException {
        ICStorageElement el = cache.getSpecSettings().getRootStorageElement();
        this.saveBuildSystemConfigPreferenceStorage(buildStystemId, el);
    }

    private void saveBuildSystemConfigPreferenceStorage(String buildSystemId, ICStorageElement el) throws CoreException {
        ICStorageElement cur = this.getBuildSystemConfigPreferenceStorage(buildSystemId);
        ICStorageElement parent = cur.getParent();
        parent.removeChild(cur);
        parent.importChild(el);
        this.savePreferenceStorage("preferences", MODULE_ID, parent);
    }

    private boolean needSavePreference(String buildSystemId, ICConfigurationDescription des) {
        return des.isModified() || !des.isPreferenceConfiguration() || !des.getBuildSystemId().equals(buildSystemId);
    }

    private ICConfigurationDescription createWritablePreference(CConfigurationDescriptionCache cache) throws CoreException {
        return new CConfigurationDescription(cache, this.fPrefUpdater);
    }

    private CConfigurationDescriptionCache createPreferenceCache(ICConfigurationDescription des) throws CoreException {
        IInternalCCfgInfo cfgDes = (IInternalCCfgInfo)((Object)des);
        CConfigurationData baseData = cfgDes.getConfigurationData(false);
        CConfigurationDescriptionCache baseCache = null;
        if (baseData instanceof CConfigurationDescriptionCache) {
            baseCache = (CConfigurationDescriptionCache)baseData;
            baseData = baseCache.getConfigurationData();
        }
        CConfigurationSpecSettings settings = cfgDes.getSpecSettings();
        ICStorageElement rootEl = this.getBuildSystemConfigPreferenceStorage(des.getBuildSystemId(), true, false);
        ICStorageElement rootParent = rootEl.getParent();
        rootParent.removeChild(rootEl);
        ICStorageElement baseRootEl = settings.getRootStorageElement();
        rootEl = rootParent.importChild(baseRootEl);
        CConfigurationDescriptionCache cache = new CConfigurationDescriptionCache(des, baseData, baseCache, cfgDes.getSpecSettings(), null, rootEl);
        CSettingEntryFactory factory = new CSettingEntryFactory();
        SettingsContext context = new SettingsContext(null);
        cache.applyData(factory, context);
        cache.doneInitialization();
        factory.clear();
        this.runContextOperations(context, null);
        return cache;
    }

    private ICConfigurationDescription createNewPreference(String buildSystemId) throws CoreException {
        ICStorageElement cfgEl = this.getBuildSystemConfigPreferenceStorage(buildSystemId, true, false);
        String id = PREFERENCE_CFG_ID_PREFIX + buildSystemId;
        CConfigurationDescription des = new CConfigurationDescription(id, PREFERENCE_CFG_NAME, buildSystemId, cfgEl, this.fPrefUpdater);
        return this.createPreferenceCache(des);
    }

    ICStorageElement getBuildSystemConfigPreferenceStorage(String buildSystemId) throws CoreException {
        return this.getBuildSystemConfigPreferenceStorage(buildSystemId, true, false);
    }

    private ICStorageElement getBuildSystemConfigPreferenceStorage(String buildSystemId, boolean createIfNotDound, boolean readOnly) throws CoreException {
        ICStorageElement el = this.getPreferenceStorage("preferences", MODULE_ID, createIfNotDound, readOnly);
        ICStorageElement cfgEl = null;
        if (el != null) {
            ICStorageElement[] children = el.getChildren();
            int i = 0;
            while (i < children.length) {
                ICStorageElement child = children[i];
                if (PREFERENCE_BUILD_SYSTEM_ELEMENT.equals(child.getName()) && buildSystemId.equals(child.getAttribute("id"))) {
                    cfgEl = child;
                    break;
                }
                ++i;
            }
            if (cfgEl == null) {
                cfgEl = el.createChild(PREFERENCE_BUILD_SYSTEM_ELEMENT);
                cfgEl.setAttribute("id", buildSystemId);
            }
        }
        return cfgEl;
    }

    private ICConfigurationDescription loadPreference(String buildSystemId) throws CoreException {
        ICStorageElement el = this.getPreferenceStorage("preferences", MODULE_ID, false, false);
        ICStorageElement[] children = el.getChildren();
        ICStorageElement cfgEl = null;
        int i = 0;
        while (i < children.length) {
            ICStorageElement child = children[i];
            if (PREFERENCE_BUILD_SYSTEM_ELEMENT.equals(child.getName()) && buildSystemId.equals(child.getAttribute("id"))) {
                cfgEl = child;
                break;
            }
            ++i;
        }
        CConfigurationDescriptionCache cache = new CConfigurationDescriptionCache(cfgEl, null);
        CSettingEntryFactory factory = new CSettingEntryFactory();
        cache.loadData(factory);
        cache.doneInitialization();
        factory.clear();
        return cache;
    }

    public ICStorageElement getPreferenceStorage(String prefKey, String storageId, boolean createIfNotDound, boolean readOnly) throws CoreException {
        CStorage store = this.getPreferenceStore(prefKey, createIfNotDound, readOnly);
        return store.getStorage(storageId, createIfNotDound);
    }

    private CStorage getPreferenceStore(String prefKey, boolean createIfNotDound, boolean readOnly) throws CoreException {
        ICStorageElement el = this.createPreferenceStorage(prefKey, createIfNotDound, readOnly);
        CStorage store = new CStorage((InternalXmlStorageElement)el);
        return store;
    }

    public void savePreferenceStorage(String prefKey, String storageId, ICStorageElement el) throws CoreException {
        CStorage store = this.getPreferenceStore(prefKey, true, false);
        store.importStorage(storageId, el);
        InternalXmlStorageElement rootEl = new InternalXmlStorageElement(store.fElement, store.isReadOnly());
        this.serializePreference(prefKey, rootEl);
    }

    private CConfigurationDescriptionCache getLoaddedPreference(String buildSystemId) {
        return (CConfigurationDescriptionCache)this.fPreferenceMap.get(buildSystemId);
    }

    private void setLoaddedPreference(String buildSystemId, CConfigurationDescriptionCache des) {
        this.fPreferenceMap.put(buildSystemId, des);
    }

    public CConfigBasedDescriptorManager getDescriptorManager() {
        return this.fDescriptorManager;
    }

    public CConfigurationData createDefaultConfigData(IProject project, CDataFacroty factory) throws CoreException {
        return this.createDefaultConfigData(project, CDataUtil.genId(DEFAULT_CFG_ID_PREFIX), DEFAULT_CFG_NAME, factory);
    }

    public CConfigurationData createDefaultConfigData(IProject project, String id, String name, CDataFacroty factory) throws CoreException {
        if (factory == null) {
            factory = new CDataFacroty();
        }
        CConfigurationData data = CDataUtil.createEmptyData(id, name, factory, true);
        factory.setModified(data, false);
        return data;
    }

    public boolean isNewStyleIndexCfg(IProject project) {
        ICProjectDescription des = this.getProjectDescription(project, false);
        if (des != null) {
            return this.isNewStyleIndexCfg(des);
        }
        return false;
    }

    public boolean isNewStyleIndexCfg(ICProjectDescription des) {
        ICConfigurationDescription cfgDes = des.getDefaultSettingConfiguration();
        if (cfgDes != null) {
            return this.isNewStyleCfg(cfgDes);
        }
        return false;
    }

    public boolean isNewStyleProject(IProject project) {
        return this.isNewStyleProject(this.getProjectDescription(project, false));
    }

    public boolean isNewStyleProject(ICProjectDescription des) {
        if (des == null) {
            return false;
        }
        return this.isNewStyleIndexCfg(des);
    }

    public boolean isNewStyleCfg(ICConfigurationDescription cfgDes) {
        if (cfgDes == null) {
            return false;
        }
        CConfigurationData data = ((IInternalCCfgInfo)((Object)cfgDes)).getConfigurationData(false);
        if (data instanceof CConfigurationDescriptionCache) {
            data = ((CConfigurationDescriptionCache)data).getConfigurationData();
        }
        return data != null && !PathEntryConfigurationDataProvider.isPathEntryData(data);
    }

    ICProjectDescription getDescriptionApplying(IProject project) {
        Map map = this.getDescriptionApplyingMap(false);
        if (map != null) {
            return (ICProjectDescription)map.get(project);
        }
        return null;
    }

    void setDescriptionApplying(IProject project, ICProjectDescription des) {
        if (des == null) {
            this.clearDescriptionApplying(project);
        } else {
            Map map = this.getDescriptionApplyingMap(true);
            map.put(project, des);
        }
    }

    void clearDescriptionApplying(IProject project) {
        Map map = this.getDescriptionApplyingMap(false);
        if (map != null) {
            map.remove(project);
        }
    }

    static ICLanguageSetting getLanguageSettingForFile(ICConfigurationDescription cfgDes, IPath path, boolean ignoreExcludeStatus) {
        int segCount = path.segmentCount();
        if (segCount == 0) {
            return null;
        }
        ICResourceDescription rcDes = cfgDes.getResourceDescription(path, false);
        if (!ignoreExcludeStatus && rcDes.isExcluded()) {
            return null;
        }
        if (rcDes.getType() == 4) {
            return ((ICFolderDescription)rcDes).getLanguageSettingForFile(path.lastSegment());
        }
        return ((ICFileDescription)rcDes).getLanguageSetting();
    }

    private static HashMap createExtSetToLDataMap(IProject project, CLanguageData[] lDatas) {
        HashMap<HashSet<String>, CLanguageData> map = new HashMap<HashSet<String>, CLanguageData>();
        int i = 0;
        while (i < lDatas.length) {
            CLanguageData lData = lDatas[i];
            String[] exts = CDataUtil.getSourceExtensions(project, lData);
            HashSet<String> set = new HashSet<String>(Arrays.asList(exts));
            map.put(set, lData);
            ++i;
        }
        return map;
    }

    static boolean removeNonCustomSettings(IProject project, CConfigurationData data) {
        PathSettingsContainer cr = CDataUtil.createRcDataHolder(data);
        PathSettingsContainer[] crs = cr.getChildren(false);
        boolean modified = false;
        int i = 0;
        while (i < crs.length) {
            PathSettingsContainer parent;
            PathSettingsContainer child = crs[i];
            CResourceData childRcData = (CResourceData)child.getValue();
            if (childRcData.getType() == 4) {
                CResourceData parentRcData = null;
                parent = child.getParentContainer();
                while ((parentRcData = (CResourceData)parent.getValue()).getType() != 4) {
                    parent = parent.getParentContainer();
                }
                if (!CProjectDescriptionManager.settingsCustomized(project, (CFolderData)parentRcData, (CFolderData)childRcData)) {
                    try {
                        data.removeResourceData(childRcData);
                        child.remove();
                        modified = true;
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                }
            } else {
                parent = child.getParentContainer();
                if (!CProjectDescriptionManager.settingsCustomized(project, (CResourceData)parent.getValue(), (CFileData)childRcData)) {
                    try {
                        data.removeResourceData(childRcData);
                        child.remove();
                        modified = true;
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                }
            }
            ++i;
        }
        return modified;
    }

    static boolean settingsCustomized(IProject project, CFolderData parent, CFolderData child) {
        CLanguageData[] parentLDatas;
        if (CProjectDescriptionManager.baseSettingsCustomized(parent, child)) {
            return true;
        }
        CLanguageData[] childLDatas = child.getLanguageDatas();
        if (childLDatas.length != (parentLDatas = parent.getLanguageDatas()).length) {
            return true;
        }
        if (childLDatas.length != 0) {
            HashMap parentMap = CProjectDescriptionManager.createExtSetToLDataMap(project, parentLDatas);
            HashMap childMap = CProjectDescriptionManager.createExtSetToLDataMap(project, childLDatas);
            Iterator iter = parentMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                CLanguageData childLData = (CLanguageData)childMap.get(entry.getKey());
                if (childLData == null) {
                    return true;
                }
                CLanguageData parentLData = (CLanguageData)entry.getValue();
                if (CProjectDescriptionManager.langDatasEqual(parentLData, childLData)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean settingsCustomized(IProject project, CResourceData parent, CFileData child) {
        if (CProjectDescriptionManager.baseSettingsCustomized(parent, child)) {
            return true;
        }
        CLanguageData lData = child.getLanguageData();
        if (parent.getType() == 4) {
            CFolderData foParent = (CFolderData)parent;
            IPath childPath = child.getPath();
            String fileName = childPath.lastSegment();
            if (PatternNameMap.isPatternName(fileName)) {
                return true;
            }
            CLanguageData parentLangData = CDataUtil.findLanguagDataForFile(fileName, project, foParent);
            return !CProjectDescriptionManager.langDatasEqual(lData, parentLangData);
        }
        CFileData fiParent = (CFileData)parent;
        CLanguageData parentLangData = fiParent.getLanguageData();
        return !CProjectDescriptionManager.langDatasEqual(lData, parentLangData);
    }

    static boolean langDatasEqual(CLanguageData lData1, CLanguageData lData2) {
        if (lData1 == null) {
            return lData2 == null;
        }
        if (lData2 == null) {
            return false;
        }
        int[] kinds = KindBasedStore.getLanguageEntryKinds();
        int i = 0;
        while (i < kinds.length) {
            Object[] entries2;
            int kind = kinds[i];
            Object[] entries1 = lData1.getEntries(kind);
            if (!Arrays.equals(entries1, entries2 = lData2.getEntries(kind))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean baseSettingsCustomized(CResourceData parent, CResourceData child) {
        return child.hasCustomSettings();
    }

    public ICProjectDescriptionWorkspacePreferences getProjectDescriptionWorkspacePreferences(boolean write) {
        if (this.fPreferences == null) {
            try {
                this.fPreferences = this.loadPreferences();
            }
            catch (CoreException coreException) {}
            if (this.fPreferences == null) {
                this.fPreferences = new CProjectDescriptionWorkspacePreferences(null, null, true);
            }
        }
        CProjectDescriptionWorkspacePreferences prefs = this.fPreferences;
        if (write) {
            prefs = new CProjectDescriptionWorkspacePreferences(prefs, false);
        }
        return prefs;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setProjectDescriptionWorkspacePreferences(ICProjectDescriptionWorkspacePreferences prefs, boolean updateProjects, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        boolean changed = false;
        ICProjectDescriptionWorkspacePreferences oldPrefs = this.getProjectDescriptionWorkspacePreferences(false);
        try {
            try {
                if (oldPrefs != prefs && prefs.getConfigurationReltations() != oldPrefs.getConfigurationReltations()) {
                    changed = true;
                }
                if (changed) {
                    if (!(prefs instanceof CProjectDescriptionWorkspacePreferences)) throw new IllegalArgumentException();
                    CProjectDescriptionWorkspacePreferences basePrefs = (CProjectDescriptionWorkspacePreferences)prefs;
                    this.fPreferences = new CProjectDescriptionWorkspacePreferences(basePrefs, null, true);
                    this.storePreferences(this.fPreferences);
                    if (updateProjects) {
                        this.updateProjectDescriptions(null, monitor);
                    }
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        monitor.done();
        return changed;
    }

    private void storePreferences(CProjectDescriptionWorkspacePreferences prefs) throws CoreException {
        ICStorageElement el = this.getCProjectDescriptionPreferencesElement(true, false);
        prefs.serialize(el);
        this.saveCProjectDescriptionPreferencesElement(el);
    }

    private void saveCProjectDescriptionPreferencesElement(ICStorageElement el) throws CoreException {
        ICStorageElement cur = this.getCProjectDescriptionPreferencesElement(true, false);
        ICStorageElement parent = cur.getParent();
        parent.removeChild(cur);
        parent.importChild(el);
        this.savePreferenceStorage("preferences", MODULE_ID, parent);
    }

    private CProjectDescriptionWorkspacePreferences loadPreferences() throws CoreException {
        ICStorageElement el = this.getCProjectDescriptionPreferencesElement(false, true);
        return new CProjectDescriptionWorkspacePreferences(el, null, true);
    }

    private ICStorageElement getCProjectDescriptionPreferencesElement(boolean createIfNotFound, boolean readOnly) throws CoreException {
        ICStorageElement el = this.getPreferenceStorage("preferences", MODULE_ID, createIfNotFound, readOnly);
        ICStorageElement[] children = el.getChildren();
        int i = 0;
        while (i < children.length) {
            if ("preferences".equals(children[i].getName())) {
                return children[i];
            }
            ++i;
        }
        if (createIfNotFound) {
            return el.createChild("preferences");
        }
        throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.14"));
    }

    public void updateExternalSettingsProviders(String[] ids, IProgressMonitor monitor) {
        ExtensionContainerFactory.updateReferencedProviderIds(ids, monitor);
    }

    boolean isEmptyCreatingDescriptionAllowed() {
        return this.fAllowEmptyCreatingDescription;
    }

    void setEmptyCreatingDescriptionAllowed(boolean allow) {
        this.fAllowEmptyCreatingDescription = allow;
    }

    static class CompositeWorkspaceRunnable
    implements IWorkspaceRunnable {
        private List fRunnables = new ArrayList();
        private String fName;
        private boolean fStopOnErr;

        CompositeWorkspaceRunnable(String name) {
            if (name == null) {
                name = "";
            }
            this.fName = name;
        }

        public void add(IWorkspaceRunnable runnable) {
            this.fRunnables.add(runnable);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run(IProgressMonitor monitor) throws CoreException {
            try {
                monitor.beginTask(this.fName, this.fRunnables.size());
                Iterator iter = this.fRunnables.iterator();
                while (iter.hasNext()) {
                    Object var6_8;
                    IWorkspaceRunnable r = (IWorkspaceRunnable)iter.next();
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                    try {
                        try {
                            r.run((IProgressMonitor)subMonitor);
                        }
                        catch (CoreException e) {
                            if (this.fStopOnErr) {
                                throw e;
                            }
                        }
                        catch (RuntimeException e) {
                            if (this.fStopOnErr) {
                                throw e;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        var6_8 = null;
                        subMonitor.done();
                        throw throwable;
                    }
                    {
                        var6_8 = null;
                    }
                    subMonitor.done();
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var8_12 = null;
            }
            monitor.done();
        }

        public boolean isEmpty() {
            return this.fRunnables.isEmpty();
        }
    }

    private class DesSerializationRunnable
    implements IWorkspaceRunnable {
        private ICProjectDescription fDes;
        private ICStorageElement fElement;

        public DesSerializationRunnable(ICProjectDescription des, ICStorageElement el) {
            this.fDes = des;
            this.fElement = el;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            CProjectDescriptionManager.this.serialize(this.fDes.getProject(), CProjectDescriptionManager.STORAGE_FILE_NAME, this.fElement);
            ((ContributedEnvironment)CCorePlugin.getDefault().getBuildEnvironmentManager().getContributedEnvironment()).serialize(this.fDes);
        }
    }

    private class ListenerDescriptor {
        ICProjectDescriptionListener fListener;
        int fEventTypes;

        public ListenerDescriptor(ICProjectDescriptionListener listener, int eventTypes) {
            this.fListener = listener;
            this.fEventTypes = eventTypes;
        }

        public boolean handlesEvent(int eventType) {
            return (eventType & this.fEventTypes) != 0;
        }
    }

    private static class ThreadInfo {
        Map fDescriptionLoaddingMap;
        Map fDescriptionApplyingMap;
        Map fProjectFileSerializationMap;

        private ThreadInfo() {
        }

        public Map getDescriptionLoaddingMap(boolean create) {
            if (this.fDescriptionLoaddingMap == null && create) {
                this.fDescriptionLoaddingMap = new HashMap();
            }
            return this.fDescriptionLoaddingMap;
        }

        public Map getDescriptionApplyingMap(boolean create) {
            if (this.fDescriptionApplyingMap == null && create) {
                this.fDescriptionApplyingMap = new HashMap();
            }
            return this.fDescriptionApplyingMap;
        }

        public Map getProjectFileSerializationMap(boolean create) {
            if (this.fProjectFileSerializationMap == null && create) {
                this.fProjectFileSerializationMap = new HashMap();
            }
            return this.fProjectFileSerializationMap;
        }
    }
}

