/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICExclusionPatternPathEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.ResourceChangeHandlerBase;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescription;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ResourceChangeHandler
extends ResourceChangeHandlerBase
implements ISaveParticipant {
    CProjectDescriptionManager fMngr = CProjectDescriptionManager.getInstance();

    protected ResourceChangeHandlerBase.IResourceMoveHandler createResourceMoveHandler(IResourceChangeEvent event) {
        return new RcMoveHandler();
    }

    public void saving(ISaveContext context) throws CoreException {
        context.needDelta();
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    protected void doHahdleResourceMove(IResourceChangeEvent event, ResourceChangeHandlerBase.IResourceMoveHandler handler) {
        switch (event.getType()) {
            case 1: {
                IResourceDelta delta = event.getDelta();
                if (delta == null) break;
                IResourceDelta[] projs = delta.getAffectedChildren();
                int i = 0;
                while (i < projs.length) {
                    IResourceDelta projDelta = projs[i];
                    if (this.shouldVisit((IProject)projDelta.getResource()) && (projDelta.getFlags() & 2) != 2) {
                        IResourceDelta[] children = projDelta.getAffectedChildren();
                        int k = 0;
                        while (k < children.length) {
                            IResourceDelta child = children[k];
                            IResource rc = child.getResource();
                            if (rc.getType() == 1 && ".cproject".equals(rc.getName())) {
                                if ((child.getFlags() & 2) == 2) {
                                    ((RcMoveHandler)handler).setProjectDescription(rc.getProject(), null);
                                }
                                try {
                                    CProjectDescription des = CProjectDescriptionManager.getInstance().checkExternalProjectFileModification(rc);
                                    if (des != null) {
                                        ((RcMoveHandler)handler).setProjectDescription(rc.getProject(), des);
                                    }
                                }
                                catch (CoreException e) {
                                    CCorePlugin.log(e);
                                    ((RcMoveHandler)handler).setProjectDescription(rc.getProject(), null);
                                }
                            }
                            ++k;
                        }
                    }
                    ++i;
                }
                break;
            }
        }
        super.doHahdleResourceMove(event, handler);
    }

    class RcMoveHandler
    implements ResourceChangeHandlerBase.IResourceMoveHandler {
        Map fProjDesMap = new HashMap();
        Set fRemovedProjSet = new HashSet();

        RcMoveHandler() {
        }

        public void handleProjectClose(IProject project) {
            ResourceChangeHandler.this.fMngr.setLoaddedDescription(project, null, true);
        }

        private ICExclusionPatternPathEntry[] checkMove(IPath fromFullPath, IPath toFullPath, ICExclusionPatternPathEntry[] entries) {
            boolean modified = false;
            int k = 0;
            while (k < entries.length) {
                if (entries[k].getFullPath().equals((Object)fromFullPath)) {
                    ICExclusionPatternPathEntry entry = entries[k];
                    entries[k] = (ICExclusionPatternPathEntry)CDataUtil.createEntry(entry.getKind(), toFullPath.toString(), null, entry.getExclusionPatterns(), entry.getFlags());
                    modified = true;
                }
                ++k;
            }
            return modified ? entries : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleResourceMove(IResource fromRc, IResource toRc) {
            boolean proceed = true;
            IProject fromProject = fromRc.getProject();
            IProject toProject = toRc.getProject();
            switch (toRc.getType()) {
                case 4: {
                    ICProjectDescription des = this.getProjectDescription((IResource)fromProject, false);
                    this.fRemovedProjSet.add(fromProject);
                    if (des == null) break;
                    ((CProjectDescription)des).updateProject(toProject);
                    CProjectDescriptionManager cProjectDescriptionManager = ResourceChangeHandler.this.fMngr;
                    synchronized (cProjectDescriptionManager) {
                        ResourceChangeHandler.this.fMngr.setLoaddedDescription(fromProject, null, true);
                        ResourceChangeHandler.this.fMngr.setLoaddedDescription(toProject, des, true);
                    }
                    this.fProjDesMap.put(toProject, des);
                    ICConfigurationDescription[] cfgs = des.getConfigurations();
                    int i = 0;
                    while (i < cfgs.length) {
                        cfgs[i].getConfigurationData();
                        ++i;
                    }
                    break;
                }
                case 2: {
                    int i;
                    ICConfigurationDescription[] cfgDess;
                    IPath fromFullPath = fromRc.getFullPath();
                    IPath toFullPath = toRc.getFullPath();
                    if (toFullPath.equals((Object)fromFullPath) || !toProject.equals((Object)fromProject)) break;
                    ICProjectDescription des = this.getProjectDescription((IResource)toProject, true);
                    if (des != null) {
                        cfgDess = des.getConfigurations();
                        i = 0;
                        while (i < cfgDess.length) {
                            ICConfigurationDescription cfg = cfgDess[i];
                            ICExclusionPatternPathEntry[] entries = cfg.getSourceEntries();
                            if ((entries = this.checkMove(fromFullPath, toFullPath, entries)) != null) {
                                try {
                                    cfg.setSourceEntries((ICSourceEntry[])entries);
                                }
                                catch (WriteAccessException e) {
                                    CCorePlugin.log(e);
                                }
                                catch (CoreException e) {
                                    CCorePlugin.log(e);
                                }
                            }
                            ++i;
                        }
                    }
                }
                case 1: {
                    ICProjectDescription des;
                    IPath fromRcProjPath = fromRc.getProjectRelativePath();
                    IPath toRcProjPath = toRc.getProjectRelativePath();
                    if (toRcProjPath.equals((Object)fromRcProjPath) || !toProject.equals((Object)fromProject) || (des = this.getProjectDescription((IResource)toProject, true)) == null) break;
                    ICConfigurationDescription[] cfgDess = des.getConfigurations();
                    int i = 0;
                    while (i < cfgDess.length) {
                        ICResourceDescription rcDescription = cfgDess[i].getResourceDescription(fromRcProjPath, true);
                        if (rcDescription != null) {
                            try {
                                rcDescription.setPath(toRcProjPath);
                            }
                            catch (WriteAccessException writeAccessException) {}
                        }
                        ++i;
                    }
                    break;
                }
            }
            return proceed;
        }

        private ICProjectDescription getProjectDescription(IResource rc, boolean load) {
            IProject project = rc.getProject();
            ICProjectDescription des = (ICProjectDescription)this.fProjDesMap.get(project);
            if (des == null && !this.fProjDesMap.containsKey(project)) {
                int flags = load ? 0 : 8;
                flags |= Integer.MIN_VALUE;
                des = ResourceChangeHandler.this.fMngr.getProjectDescription(project, flags |= 4);
                if (des != null) {
                    this.fProjDesMap.put(project, des);
                }
            }
            return des;
        }

        private void setProjectDescription(IProject project, ICProjectDescription des) {
            this.fProjDesMap.put(project, des);
        }

        private List checkRemove(IPath rcFullPath, ICExclusionPatternPathEntry[] entries) {
            ArrayList<ICExclusionPatternPathEntry> updatedList = null;
            int num = 0;
            int k = 0;
            while (k < entries.length) {
                if (entries[k].getFullPath().equals((Object)rcFullPath)) {
                    if (updatedList == null) {
                        updatedList = new ArrayList<ICExclusionPatternPathEntry>(Arrays.asList(entries));
                    }
                    updatedList.remove(num);
                } else {
                    ++num;
                }
                ++k;
            }
            return updatedList;
        }

        public boolean handleResourceRemove(IResource rc) {
            boolean proceed = true;
            IProject project = rc.getProject();
            switch (rc.getType()) {
                case 4: {
                    ResourceChangeHandler.this.fMngr.setLoaddedDescription(project, null, true);
                    this.fRemovedProjSet.add(project);
                    proceed = false;
                    break;
                }
                case 2: {
                    int i;
                    ICConfigurationDescription[] cfgDess;
                    ICProjectDescription des;
                    if (project.exists() && (des = this.getProjectDescription((IResource)project, true)) != null) {
                        IPath rcFullPath = rc.getFullPath();
                        cfgDess = des.getConfigurations();
                        i = 0;
                        while (i < cfgDess.length) {
                            ICConfigurationDescription cfg = cfgDess[i];
                            ICExclusionPatternPathEntry[] entries = cfg.getSourceEntries();
                            List updatedList = this.checkRemove(rcFullPath, entries);
                            if (updatedList != null) {
                                try {
                                    cfg.setSourceEntries(updatedList.toArray(new ICSourceEntry[updatedList.size()]));
                                }
                                catch (WriteAccessException e) {
                                    CCorePlugin.log(e);
                                }
                                catch (CoreException e) {
                                    CCorePlugin.log(e);
                                }
                            }
                            ++i;
                        }
                    }
                }
                case 1: {
                    ICProjectDescription des;
                    if (!project.exists() || (des = this.getProjectDescription((IResource)project, true)) == null) break;
                    IPath rcProjPath = rc.getProjectRelativePath();
                    ICConfigurationDescription[] cfgDess = des.getConfigurations();
                    int i = 0;
                    while (i < cfgDess.length) {
                        ICResourceDescription rcDescription = cfgDess[i].getResourceDescription(rcProjPath, true);
                        if (rcDescription != null) {
                            try {
                                cfgDess[i].removeResourceDescription(rcDescription);
                            }
                            catch (WriteAccessException writeAccessException) {
                            }
                            catch (CoreException coreException) {}
                        }
                        ++i;
                    }
                    break;
                }
            }
            return proceed;
        }

        public void done() {
            Iterator iter = this.fProjDesMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (this.fRemovedProjSet.contains(entry.getKey())) {
                    iter.remove();
                    continue;
                }
                ICProjectDescription des = (ICProjectDescription)entry.getValue();
                if (des == null || des.isModified()) continue;
                iter.remove();
            }
            if (this.fProjDesMap.size() != 0) {
                ResourceChangeHandler.this.fMngr.runWspModification(new IWorkspaceRunnable(this){
                    final /* synthetic */ RcMoveHandler this$1;
                    {
                        this.this$1 = rcMoveHandler;
                    }

                    public void run(IProgressMonitor monitor) throws CoreException {
                        Iterator<Map.Entry<K, V>> iter = this.this$1.fProjDesMap.entrySet().iterator();
                        while (iter.hasNext()) {
                            Map.Entry<K, V> entry = iter.next();
                            IProject project = (IProject)entry.getKey();
                            if (!project.isOpen()) continue;
                            ICProjectDescription des = (ICProjectDescription)entry.getValue();
                            try {
                                RcMoveHandler.access$1((RcMoveHandler)this.this$1).fMngr.setProjectDescription(project, des);
                            }
                            catch (CoreException e) {
                                CCorePlugin.log(e);
                            }
                        }
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
        }

        static /* synthetic */ ResourceChangeHandler access$1(RcMoveHandler rcMoveHandler) {
            return rcMoveHandler.ResourceChangeHandler.this;
        }
    }
}

