/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICDescriptionDelta;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationSpecSettings;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescription;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.IInternalCCfgInfo;
import org.eclipse.cdt.internal.core.settings.model.InternalXmlStorageElement;
import org.eclipse.cdt.internal.core.settings.model.SettingsContext;
import org.eclipse.cdt.internal.core.settings.model.SettingsModelMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class SetCProjectDescriptionOperation
extends CModelOperation {
    private CProjectDescription fSetDescription;
    private int fFlags;

    SetCProjectDescriptionOperation(ICProject cProject, CProjectDescription description, int flags) {
        super(cProject);
        this.fFlags = flags;
        this.fSetDescription = description;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws CModelException {
        boolean modified;
        SettingsContext context;
        CProjectDescription fNewDescriptionCache;
        CProjectDescriptionEvent event;
        CProjectDescription fOldDescriptionCache;
        IProject project;
        ICProject cProject;
        CProjectDescriptionManager mngr;
        block19: {
            mngr = CProjectDescriptionManager.getInstance();
            cProject = (ICProject)this.getElementToProcess();
            project = cProject.getProject();
            fOldDescriptionCache = (CProjectDescription)mngr.getProjectDescription(project, false);
            event = mngr.createAboutToApplyEvent(this.fSetDescription, fOldDescriptionCache);
            mngr.notifyListeners(event);
            fNewDescriptionCache = null;
            context = new SettingsContext(project);
            modified = false;
            if (this.fSetDescription != null) {
                boolean creating;
                InternalXmlStorageElement el = null;
                try {
                    InternalXmlStorageElement base = (InternalXmlStorageElement)this.fSetDescription.getRootStorageElement();
                    modified = base.isDirty();
                    el = mngr.copyElement(base, false);
                }
                catch (CoreException coreException) {}
                boolean bl = creating = fOldDescriptionCache != null ? fOldDescriptionCache.isCdtProjectCreating() : true;
                if (creating) {
                    creating = this.fSetDescription.isCdtProjectCreating();
                }
                if (!this.fSetDescription.isValid()) {
                    if (!mngr.isEmptyCreatingDescriptionAllowed()) throw new CModelException(ExceptionFactory.createCoreException(String.valueOf(SettingsModelMessages.getString("CProjectDescriptionManager.17")) + project.getName()));
                    if (!creating) {
                        throw new CModelException(ExceptionFactory.createCoreException(String.valueOf(SettingsModelMessages.getString("CProjectDescriptionManager.17")) + project.getName()));
                    }
                }
                fNewDescriptionCache = new CProjectDescription(this.fSetDescription, true, el, creating);
                boolean[] envStates = this.getEnvStates(fNewDescriptionCache);
                try {
                    mngr.setDescriptionApplying(project, fNewDescriptionCache);
                    modified |= fNewDescriptionCache.applyDatas(context);
                }
                catch (Throwable throwable) {
                    Object var12_19 = null;
                    mngr.clearDescriptionApplying(project);
                    this.setEnvStates(fNewDescriptionCache, envStates);
                    throw throwable;
                }
                {
                    Object var12_20 = null;
                    mngr.clearDescriptionApplying(project);
                    this.setEnvStates(fNewDescriptionCache, envStates);
                    break block19;
                }
            }
            modified = fOldDescriptionCache != null;
        }
        ICDescriptionDelta delta = mngr.createDelta(fNewDescriptionCache, fOldDescriptionCache);
        mngr.checkRemovedConfigurations(delta);
        ICElementDelta[] cElementDeltas = mngr.generateCElementDeltas(cProject, delta);
        if (cElementDeltas.length > 0) {
            int i = 0;
            while (i < cElementDeltas.length) {
                this.addDelta(cElementDeltas[i]);
                ++i;
            }
        }
        mngr.setLoaddedDescription(project, fNewDescriptionCache, true);
        if (this.fSetDescription != null) {
            this.fSetDescription.switchToCachedAppliedData(fNewDescriptionCache);
        }
        try {
            IProjectDescription eDes = context.getEclipseProjectDescription();
            if (mngr.checkHandleActiveCfgChange(fNewDescriptionCache, fOldDescriptionCache, eDes, (IProgressMonitor)new NullProgressMonitor())) {
                context.setEclipseProjectDescription(eDes);
            }
        }
        catch (CoreException e2) {
            CCorePlugin.log(e2);
        }
        event = mngr.createDataAppliedEvent(fNewDescriptionCache, fOldDescriptionCache, this.fSetDescription, delta);
        mngr.notifyListeners(event);
        cProject.close();
        if (fNewDescriptionCache != null) {
            fNewDescriptionCache.doneApplying();
        }
        event = mngr.createAppliedEvent(fNewDescriptionCache, fOldDescriptionCache, this.fSetDescription, delta);
        mngr.notifyListeners(event);
        try {
            IWorkspaceRunnable toRun;
            if (fNewDescriptionCache != null && !CProjectDescriptionManager.checkFlags(this.fFlags, 2) && (modified || SetCProjectDescriptionOperation.isPersistentCoreSettingChanged(event))) {
                context.addWorkspaceRunnable(mngr.createDesSerializationRunnable(fNewDescriptionCache));
            }
            if ((toRun = context.createOperationRunnable()) == null) return;
            mngr.runWspModification(toRun, (IProgressMonitor)new NullProgressMonitor());
            return;
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
    }

    private static boolean isPersistentCoreSettingChanged(CProjectDescriptionEvent event) {
        ICDescriptionDelta delta = event.getProjectDelta();
        if (delta == null) {
            return false;
        }
        if (delta.getDeltaKind() != 3) {
            return true;
        }
        if (delta.getChildren().length != 0) {
            return true;
        }
        int flags = delta.getChangeFlags();
        return flags != 0 && flags != 1;
    }

    public boolean isReadOnly() {
        return false;
    }

    private boolean[] getEnvStates(CProjectDescription pd) {
        ICConfigurationDescription[] cfs = pd.getConfigurations();
        boolean[] result = new boolean[cfs.length];
        int i = 0;
        while (i < cfs.length) {
            if (cfs[i] instanceof IInternalCCfgInfo) {
                try {
                    CConfigurationSpecSettings ss = ((IInternalCCfgInfo)((Object)cfs[i])).getSpecSettings();
                    if (ss != null && ss.getEnvironment() != null) {
                        result[i] = ss.getEnvironment().isDirty();
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return result;
    }

    private void setEnvStates(CProjectDescription pd, boolean[] data) {
        ICConfigurationDescription[] cfs = pd.getConfigurations();
        if (cfs == null || data == null) {
            return;
        }
        int i = 0;
        while (i < cfs.length) {
            if (data.length <= i) break;
            if (data[i] && cfs[i] instanceof IInternalCCfgInfo) {
                try {
                    CConfigurationSpecSettings ss = ((IInternalCCfgInfo)((Object)cfs[i])).getSpecSettings();
                    if (ss != null && ss.getEnvironment() != null) {
                        ss.getEnvironment().setDirty(true);
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
    }
}

