/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.debug.dwarf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.debug.DebugUnknownType;
import org.eclipse.cdt.utils.debug.IDebugEntryRequestor;
import org.eclipse.cdt.utils.debug.tools.DebugSym;
import org.eclipse.cdt.utils.debug.tools.DebugSymsRequestor;
import org.eclipse.cdt.utils.elf.Elf;

public class Dwarf {
    static final String DWARF_DEBUG_INFO = ".debug_info";
    static final String DWARF_DEBUG_ABBREV = ".debug_abbrev";
    static final String DWARF_DEBUG_ARANGES = ".debug_aranges";
    static final String DWARF_DEBUG_LINE = ".debug_line";
    static final String DWARF_DEBUG_FRAME = ".debug_frame";
    static final String DWARF_EH_FRAME = ".eh_frame";
    static final String DWARF_DEBUG_LOC = ".debug_loc";
    static final String DWARF_DEBUG_PUBNAMES = ".debug_pubnames";
    static final String DWARF_DEBUG_STR = ".debug_str";
    static final String DWARF_DEBUG_FUNCNAMES = ".debug_funcnames";
    static final String DWARF_DEBUG_TYPENAMES = ".debug_typenames";
    static final String DWARF_DEBUG_VARNAMES = ".debug_varnames";
    static final String DWARF_DEBUG_WEAKNAMES = ".debug_weaknames";
    static final String DWARF_DEBUG_MACINFO = ".debug_macinfo";
    static final String[] DWARF_SCNNAMES = new String[]{".debug_info", ".debug_abbrev", ".debug_aranges", ".debug_line", ".debug_frame", ".eh_frame", ".debug_loc", ".debug_pubnames", ".debug_str", ".debug_funcnames", ".debug_typenames", ".debug_varnames", ".debug_weaknames", ".debug_macinfo"};
    Map dwarfSections = new HashMap();
    Map abbreviationMaps = new HashMap();
    boolean isLE;
    CompileUnit currentCU;
    boolean printEnabled = true;
    private int num_leb128_read;

    public Dwarf(String file) throws IOException {
        Elf exe = new Elf(file);
        this.init(exe);
        exe.dispose();
    }

    public Dwarf(Elf exe) throws IOException {
        this.init(exe);
    }

    public void init(Elf exe) throws IOException {
        Elf.ELFhdr header = exe.getELFhdr();
        this.isLE = header.e_ident[5] == 1;
        Elf.Section[] sections = exe.getSections();
        int i = 0;
        while (i < sections.length) {
            String name = sections[i].toString();
            int j = 0;
            while (j < DWARF_SCNNAMES.length) {
                if (name.equals(DWARF_SCNNAMES[j])) {
                    this.dwarfSections.put(DWARF_SCNNAMES[j], sections[i].loadSectionData());
                }
                ++j;
            }
            ++i;
        }
    }

    int read_4_bytes(InputStream in) throws IOException {
        try {
            byte[] bytes = new byte[4];
            int n = in.read(bytes, 0, bytes.length);
            if (n != 4) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.missingBytes"));
            }
            return this.read_4_bytes(bytes, 0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException(CCorePlugin.getResourceString("Util.exception.missingBytes"));
        }
    }

    int read_4_bytes(byte[] bytes, int offset) throws IndexOutOfBoundsException {
        if (this.isLE) {
            return (bytes[offset + 3] & 0xFF) << 24 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 1] & 0xFF) << 8 | bytes[offset] & 0xFF;
        }
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    long read_8_bytes(InputStream in) throws IOException {
        try {
            byte[] bytes = new byte[8];
            int n = in.read(bytes, 0, bytes.length);
            if (n != 8) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.missingBytes"));
            }
            return this.read_8_bytes(bytes, 0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException(CCorePlugin.getResourceString("Util.exception.missingBytes"));
        }
    }

    long read_8_bytes(byte[] bytes, int offset) throws IndexOutOfBoundsException {
        if (this.isLE) {
            return (bytes[offset + 7] & 0xFF) << 56 | (bytes[offset + 6] & 0xFF) << 48 | (bytes[offset + 5] & 0xFF) << 40 | (bytes[offset + 4] & 0xFF) << 32 | (bytes[offset + 3] & 0xFF) << 24 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 1] & 0xFF) << 8 | bytes[offset] & 0xFF;
        }
        return (bytes[offset] & 0xFF) << 56 | (bytes[offset + 1] & 0xFF) << 48 | (bytes[offset + 2] & 0xFF) << 40 | (bytes[offset + 3] & 0xFF) << 32 | (bytes[offset + 4] & 0xFF) << 24 | (bytes[offset + 5] & 0xFF) << 16 | (bytes[offset + 6] & 0xFF) << 8 | bytes[offset] & 0xFF;
    }

    short read_2_bytes(InputStream in) throws IOException {
        try {
            byte[] bytes = new byte[2];
            int n = in.read(bytes, 0, bytes.length);
            if (n != 2) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.missingBytes"));
            }
            return this.read_2_bytes(bytes, 0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException(CCorePlugin.getResourceString("Util.exception.missingBytes"));
        }
    }

    short read_2_bytes(byte[] bytes, int offset) throws IndexOutOfBoundsException {
        if (this.isLE) {
            return (short)(((bytes[offset + 1] & 0xFF) << 8) + (bytes[offset] & 0xFF));
        }
        return (short)(((bytes[offset] & 0xFF) << 8) + (bytes[offset + 1] & 0xFF));
    }

    long read_unsigned_leb128(InputStream in) throws IOException {
        short b;
        long result = 0L;
        this.num_leb128_read = 0;
        int shift = 0;
        while ((b = (short)in.read()) != -1) {
            ++this.num_leb128_read;
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return result;
    }

    long read_signed_leb128(InputStream in) throws IOException {
        short b;
        long result = 0L;
        int shift = 0;
        int size = 32;
        this.num_leb128_read = 0;
        do {
            if ((b = (short)in.read()) == -1) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.noData"));
            }
            ++this.num_leb128_read;
            result |= (long)(b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        if (shift < size && (b & 0x40) != 0) {
            result |= (long)(-(1 << shift));
        }
        return result;
    }

    public void parse(IDebugEntryRequestor requestor) {
        this.parseDebugInfo(requestor);
    }

    void parseDebugInfo(IDebugEntryRequestor requestor) {
        byte[] data = (byte[])this.dwarfSections.get(DWARF_DEBUG_INFO);
        if (data != null) {
            try {
                int length = 0;
                int offset = 0;
                while (offset < data.length) {
                    CompilationUnitHeader header = new CompilationUnitHeader();
                    header.length = length = this.read_4_bytes(data, offset);
                    header.version = this.read_2_bytes(data, offset + 4);
                    header.abbreviationOffset = this.read_4_bytes(data, offset + 6);
                    header.addressSize = data[offset + 10];
                    if (this.printEnabled) {
                        System.out.println("Compilation Unit @ " + Long.toHexString(offset));
                        System.out.println(header);
                    }
                    ByteArrayInputStream in = new ByteArrayInputStream(data, offset + 11, length + 4 - 11);
                    Map abbrevs = this.parseDebugAbbreviation(header);
                    this.parseDebugInfoEntry(requestor, in, abbrevs, header);
                    if (this.printEnabled) {
                        System.out.println();
                    }
                    offset += length + 4;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    Map parseDebugAbbreviation(CompilationUnitHeader header) throws IOException {
        int offset = header.abbreviationOffset;
        Integer key = new Integer(offset);
        HashMap<Long, AbbreviationEntry> abbrevs = (HashMap<Long, AbbreviationEntry>)this.abbreviationMaps.get(key);
        if (abbrevs == null) {
            abbrevs = new HashMap<Long, AbbreviationEntry>();
            this.abbreviationMaps.put(key, abbrevs);
            byte[] data = (byte[])this.dwarfSections.get(DWARF_DEBUG_ABBREV);
            if (data != null) {
                ByteArrayInputStream in = new ByteArrayInputStream(data);
                ((InputStream)in).skip(offset);
                while (((InputStream)in).available() > 0) {
                    long code = this.read_unsigned_leb128(in);
                    if (code == 0L) break;
                    long tag = this.read_unsigned_leb128(in);
                    byte hasChildren = (byte)((InputStream)in).read();
                    AbbreviationEntry entry = new AbbreviationEntry(code, tag, hasChildren);
                    long name = 0L;
                    long form = 0L;
                    do {
                        name = this.read_unsigned_leb128(in);
                        form = this.read_unsigned_leb128(in);
                        if (name == 0L) continue;
                        entry.attributes.add(new Attribute(name, form));
                    } while (name != 0L && form != 0L);
                    abbrevs.put(new Long(code), entry);
                }
            }
        }
        return abbrevs;
    }

    void parseDebugInfoEntry(IDebugEntryRequestor requestor, InputStream in, Map abbrevs, CompilationUnitHeader header) throws IOException {
        while (in.available() > 0) {
            long code = this.read_unsigned_leb128(in);
            AbbreviationEntry entry = (AbbreviationEntry)abbrevs.get(new Long(code));
            if (entry == null) continue;
            int len = entry.attributes.size();
            ArrayList<AttributeValue> list = new ArrayList<AttributeValue>(len);
            try {
                int i = 0;
                while (i < len) {
                    Attribute attr = (Attribute)entry.attributes.get(i);
                    Object obj = this.readAttribute((int)attr.form, in, header);
                    list.add(new AttributeValue(attr, obj));
                    ++i;
                }
            }
            catch (IOException iOException) {}
            this.processDebugInfoEntry(requestor, entry, list);
        }
    }

    Object readAttribute(int form, InputStream in, CompilationUnitHeader header) throws IOException {
        Object obj = null;
        switch (form) {
            case 1: 
            case 16: {
                obj = this.readAddress(in, header);
                break;
            }
            case 9: {
                int size = (int)this.read_unsigned_leb128(in);
                byte[] bytes = new byte[size];
                in.read(bytes, 0, size);
                obj = bytes;
                break;
            }
            case 10: {
                int size = in.read();
                byte[] bytes = new byte[size];
                in.read(bytes, 0, size);
                obj = bytes;
                break;
            }
            case 3: {
                short size = this.read_2_bytes(in);
                byte[] bytes = new byte[size];
                in.read(bytes, 0, size);
                obj = bytes;
                break;
            }
            case 4: {
                int size = this.read_4_bytes(in);
                byte[] bytes = new byte[size];
                in.read(bytes, 0, size);
                obj = bytes;
                break;
            }
            case 11: {
                obj = new Byte((byte)in.read());
                break;
            }
            case 5: {
                obj = new Short(this.read_2_bytes(in));
                break;
            }
            case 6: {
                obj = new Integer(this.read_4_bytes(in));
                break;
            }
            case 7: {
                obj = new Long(this.read_8_bytes(in));
                break;
            }
            case 13: {
                obj = new Long(this.read_signed_leb128(in));
                break;
            }
            case 15: {
                obj = new Long(this.read_unsigned_leb128(in));
                break;
            }
            case 8: {
                int c;
                StringBuffer sb = new StringBuffer();
                while ((c = in.read()) != -1) {
                    if (c == 0) break;
                    sb.append((char)c);
                }
                obj = sb.toString();
                break;
            }
            case 12: {
                obj = new Byte((byte)in.read());
                break;
            }
            case 14: {
                int offset = this.read_4_bytes(in);
                byte[] data = (byte[])this.dwarfSections.get(DWARF_DEBUG_STR);
                if (data == null) {
                    obj = new String();
                    break;
                }
                if (offset < 0 || offset > data.length) {
                    obj = new String();
                    break;
                }
                StringBuffer sb = new StringBuffer();
                while (offset < data.length) {
                    byte c = data[offset];
                    if (c == 0) break;
                    sb.append((char)c);
                    ++offset;
                }
                obj = sb.toString();
                break;
            }
            case 17: {
                obj = new Byte((byte)in.read());
                break;
            }
            case 18: {
                obj = new Short(this.read_2_bytes(in));
                break;
            }
            case 19: {
                obj = new Integer(this.read_4_bytes(in));
                break;
            }
            case 20: {
                obj = new Long(this.read_8_bytes(in));
                break;
            }
            case 21: {
                obj = new Long(this.read_unsigned_leb128(in));
                break;
            }
            case 22: {
                int f = (int)this.read_unsigned_leb128(in);
                return this.readAttribute(f, in, header);
            }
        }
        return obj;
    }

    void processDebugInfoEntry(IDebugEntryRequestor requestor, AbbreviationEntry entry, List list) {
        int len = list.size();
        int tag = (int)entry.tag;
        if (this.printEnabled) {
            System.out.println("Abbrev Number " + entry.code);
        }
        int i = 0;
        while (i < len) {
            AttributeValue av = (AttributeValue)list.get(i);
            if (this.printEnabled) {
                System.out.println(av);
            }
            switch (tag) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 11: {
                    break;
                }
                case 13: {
                    break;
                }
                case 15: {
                    break;
                }
                case 16: {
                    break;
                }
                case 17: {
                    this.processCompileUnit(requestor, list);
                    break;
                }
                case 19: {
                    break;
                }
                case 21: {
                    break;
                }
                case 22: {
                    break;
                }
                case 23: {
                    break;
                }
                case 24: {
                    break;
                }
                case 28: {
                    break;
                }
                case 31: {
                    break;
                }
                case 34: {
                    break;
                }
                case 36: {
                    break;
                }
                case 37: {
                    break;
                }
                case 38: {
                    break;
                }
                case 40: {
                    break;
                }
                case 41: {
                    break;
                }
                case 42: {
                    break;
                }
                case 46: {
                    this.processSubProgram(requestor, list);
                    break;
                }
                case 47: {
                    break;
                }
                case 48: {
                    break;
                }
                case 49: {
                    break;
                }
                case 50: {
                    break;
                }
                case 52: {
                    break;
                }
            }
            ++i;
        }
    }

    Long readAddress(InputStream in, CompilationUnitHeader header) throws IOException {
        long value = 0L;
        switch (header.addressSize) {
            case 2: {
                value = this.read_2_bytes(in);
                break;
            }
            case 4: {
                value = this.read_4_bytes(in);
                break;
            }
            case 8: {
                value = this.read_8_bytes(in);
            }
        }
        return new Long(value);
    }

    void processSubProgram(IDebugEntryRequestor requestor, List list) {
        long lowPC = 0L;
        long highPC = 0L;
        String funcName = "";
        boolean isExtern = false;
        int i = 0;
        while (i < list.size()) {
            AttributeValue av = (AttributeValue)list.get(i);
            try {
                int name = (int)av.attribute.name;
                switch (name) {
                    case 17: {
                        lowPC = ((Number)av.value).longValue();
                        break;
                    }
                    case 18: {
                        highPC = ((Number)av.value).longValue();
                        break;
                    }
                    case 3: {
                        funcName = (String)av.value;
                        break;
                    }
                    case 63: {
                        isExtern = ((Number)av.value).intValue() > 0;
                    }
                }
            }
            catch (ClassCastException classCastException) {}
            ++i;
        }
        requestor.enterFunction(funcName, new DebugUnknownType(""), isExtern, lowPC);
        requestor.exitFunction(highPC);
    }

    void processCompileUnit(IDebugEntryRequestor requestor, List list) {
        if (this.currentCU != null) {
            requestor.exitCompilationUnit(this.currentCU.highPC);
        }
        this.currentCU = new CompileUnit();
        int i = 0;
        while (i < list.size()) {
            AttributeValue av = (AttributeValue)list.get(i);
            try {
                int name = (int)av.attribute.name;
                switch (name) {
                    case 17: {
                        this.currentCU.lowPC = ((Number)av.value).longValue();
                        break;
                    }
                    case 18: {
                        this.currentCU.highPC = ((Number)av.value).longValue();
                        break;
                    }
                    case 3: {
                        this.currentCU.name = (String)av.value;
                        break;
                    }
                    case 19: {
                        this.currentCU.language = ((Number)av.value).intValue();
                        break;
                    }
                    case 16: {
                        this.currentCU.stmtList = ((Number)av.value).intValue();
                        break;
                    }
                    case 67: {
                        this.currentCU.macroInfo = ((Number)av.value).intValue();
                        break;
                    }
                    case 27: {
                        this.currentCU.compDir = (String)av.value;
                        break;
                    }
                    case 37: {
                        this.currentCU.producer = (String)av.value;
                    }
                }
            }
            catch (ClassCastException classCastException) {}
            ++i;
        }
        requestor.enterCompilationUnit(this.currentCU.name, this.currentCU.lowPC);
    }

    public static void main(String[] args) {
        try {
            DebugSymsRequestor symreq = new DebugSymsRequestor();
            Dwarf dwarf = new Dwarf(args[0]);
            dwarf.parse(symreq);
            DebugSym[] entries = symreq.getEntries();
            int i = 0;
            while (i < entries.length) {
                DebugSym entry = entries[i];
                System.out.println(entry);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class AbbreviationEntry {
        long code;
        long tag;
        byte hasChildren;
        List attributes;

        AbbreviationEntry(long c, long t, byte h) {
            this.code = c;
            this.tag = t;
            this.hasChildren = h;
            this.attributes = new ArrayList();
        }
    }

    class Attribute {
        long name;
        long form;

        Attribute(long n, long f) {
            this.name = n;
            this.form = f;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("name: " + Long.toHexString(this.name));
            sb.append(" value: " + Long.toHexString(this.form));
            return sb.toString();
        }
    }

    class AttributeValue {
        Attribute attribute;
        Object value;

        AttributeValue(Attribute a, Object o) {
            this.attribute = a;
            this.value = o;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.attribute.toString()).append(' ');
            if (this.value != null) {
                Class<?> clazz = this.value.getClass();
                if (clazz.isArray()) {
                    int len = Array.getLength(this.value);
                    sb.append(len).append(' ');
                    sb.append(clazz.getComponentType().toString());
                    sb.append(':');
                    int i = 0;
                    while (i < len) {
                        byte b = Array.getByte(this.value, i);
                        sb.append(' ').append(Integer.toHexString(b));
                        ++i;
                    }
                } else if (this.value instanceof Number) {
                    Number n = (Number)this.value;
                    sb.append(Long.toHexString(n.longValue()));
                } else if (this.value instanceof String) {
                    sb.append(this.value);
                } else {
                    sb.append(this.value);
                }
            }
            return sb.toString();
        }
    }

    class CompilationUnitHeader {
        int length;
        short version;
        int abbreviationOffset;
        byte addressSize;

        CompilationUnitHeader() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Length: " + this.length).append("\n");
            sb.append("Version: " + this.version).append("\n");
            sb.append("Abbreviation: " + this.abbreviationOffset).append("\n");
            sb.append("Address size: " + this.addressSize).append("\n");
            return sb.toString();
        }
    }

    class CompileUnit {
        long lowPC;
        long highPC;
        int stmtList;
        String name;
        int language;
        int macroInfo;
        String compDir;
        String producer;
        int identifierCase;

        CompileUnit() {
        }
    }
}

